package com.ptteng.course.home.controller;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;


import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.common.util.TimeUtil;
//import com.oracle.deploy.update.UpdateCheck;
import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.common.util.notice.NoticeUtil;
import com.ptteng.course.constant.WxConstantConfig;
import com.ptteng.course.util.ConstantPropertiesUtil;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.course.util.mailUtil;
import com.ptteng.course.util.userNameUtil;
import com.ptteng.learn.admin.model.Constant;
import com.ptteng.learn.admin.model.Version;
import com.ptteng.learn.admin.service.ConstantService;
import com.ptteng.learn.common.model.Message;
import com.ptteng.learn.common.model.Sms;
import com.ptteng.learn.common.model.UserMessageRelation;
import com.ptteng.learn.common.service.MessageService;
import com.ptteng.learn.common.service.SmsService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.PasswordUtils;
import com.gemantic.common.util.StringUtil;
import com.ptteng.learn.common.service.UserMessageRelationService;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import com.qding.common.util.DataUtils;
import com.qding.common.util.FileUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.http.cookie.IdentityUtil;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;


/**
 * User  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class UserController {

    private static final Log userLog = LogFactory.getLog("user");

    private static final Log registerLog = LogFactory.getLog("register");

    private static final Log favoriteLog = LogFactory.getLog("favorite");


    @Resource(name = "accountConfig")
    private Map<String, String> accountConfig;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private UserService userService;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private ImgStorageUtil imgStorageUtil;
    @Autowired
    private UserOpenidRelationService userOpenidRelationService;
    @Autowired
    private UserFavoriteRelationService userFavoriteRelationService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private UserOrderService userOrderService;
    @Autowired
    private PaperService paperService;
    @Autowired
    private ProgressService progressService;
    @Autowired
    private UserMessageRelationService userMessageRelationService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private LocksService locksService;
    @Autowired
    private BookService bookService;
    @Autowired
    private GradeClassRelationService gradeClassRelationService;
    @Autowired
    private RecommendStatisticsService recommendStatisticsService;
    @Autowired
    private UserMemberRelationService userMemberRelationService;
    @Autowired
    private UserRecommendService userRecommendService;
    @Autowired
    private CollaborateService collaborateService;
    @Autowired
    private ConstantService constantService;
    @Autowired
    private SignService signService;
    @Autowired
    private LoginRecordService loginRecordService;
    @Autowired
    private NoticeUtil androidPushServiceImpl;
    @Autowired
    private NoticeUtil iosPushServiceImpl;
    @Autowired
    private GameScoreRankService gameScoreRankService;

    // 1、验证码发送
    @RequestMapping(value = "/a/code/send", method = RequestMethod.POST)
    public String sendVerify(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, String mobile,
                             String type, String areaCode) throws ServiceException, ServiceDaoException {
        userLog.info(areaCode + mobile + " want send sms of type " + type);

        if (StringUtils.isBlank(areaCode)) {
            areaCode = "+86";
        }

        if (StringUtils.isBlank(mobile)) {
            userLog.info(mobile + " want send sms of type " + type + " null mobile ");
            model.addAttribute("code", -2001);
            return "/common/success";
        }

        if (StringUtils.isBlank(type)) {
            type = "password";
        }

        String realMobile = areaCode + mobile;
        userLog.info("final mobile is : " + realMobile);

        userLog.info("=====================" + type);
        if ("register".equals(type)) {
            Long uid = this.userService.getUserIdByMobile(mobile);
            if (uid != null) {
                userLog.info(type + " is already exist  " + mobile);

                model.addAttribute("code", -2007);
                return "/common/success";
            }

        } else {
            Long uid = this.userService.getUserIdByMobile(mobile);
            if (uid == null) {

                userLog.info(type + " is not already exist  " + mobile);

                model.addAttribute("code", -2000);
                return "/common/success";
            }
        }

        int code = 0;

        try {
            String result = this.smsService.sendMsg(realMobile, type);
//            smsService.getSmsIdByMobileAndType(mobile,type);

            switch (result) {
                case SmsService.ErrorCode_SMS_InvalidType:
                    code = -2003;
                    break;
                case SmsService.ErrorCode_SMS_smsMoreThan5:
                    code = -2008;
                    break;
                case SmsService.ErrorCode_sendError:
                    code = -2015;
                    break;
                default:

            }

            model.addAttribute("code", code);

        } catch (Exception t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error(mobile + " send message error of type " + type);
            model.addAttribute("code", -1);

        }
        return "/common/success";

    }


    // 1、邮箱验证码发送
    @RequestMapping(value = "/a/mail/code/send", method = RequestMethod.POST)
    public String sendMailVerify(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mail,
                                 String type) throws ServiceException, ServiceDaoException {
        userLog.info(mail + " want send mail sms of type " + type);


        if (StringUtils.isBlank(mail)) {
            userLog.info(mail + " want send sms of type " + type + " null mobile ");
            model.addAttribute("code", -2001);
            return "/common/success";
        }

        if (StringUtils.isBlank(type)) {
            type = "password";
        }
        userLog.info("=====================" + type);
        if ("register".equals(type)) {
            Long uid = this.userService.getUserIdByMail(mail);
            if (uid != null) {
                userLog.info(type + " is already exist  " + mail);

                model.addAttribute("code", -2019);
                return "/common/success";
            }

        } else {
            Long uid = this.userService.getUserIdByMail(mail);
            if (uid == null) {

                userLog.info(type + " is not already exist  " + mail);

                model.addAttribute("code", -2000);
                return "/common/success";
            }
        }

        int code = 0;

        try {
            String result = "";
            sendMailMsg(mail, type);

            switch (result) {
                case SmsService.ErrorCode_SMS_InvalidType:
                    code = -2003;
                    break;
                case SmsService.ErrorCode_SMS_smsMoreThan5:
                    code = -2008;
                    break;
                case SmsService.ErrorCode_sendError:
                    code = -2015;
                    break;
                default:

            }

            model.addAttribute("code", code);

        } catch (Exception t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error(mail + " send message error of type " + type);
            model.addAttribute("code", -1);

        }
        return "/common/success";

    }


    // 语音验证码
    @RequestMapping(value = "/a/code/voice", method = RequestMethod.POST)
    public String sendVoice(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                            String mobile, String type, String areaCode) throws ServiceException, ServiceDaoException {
        userLog.info(mobile + " want send voice of type " + type);

        if (StringUtils.isBlank(areaCode)) {
            areaCode = "+86";
        }

        if (StringUtils.isBlank(mobile)) {
            userLog.info(mobile + " want send sms of type " + type + " null mobile ");
            model.addAttribute("code", -2001);
            return "/common/success";
        }
        if (StringUtils.isBlank(type)) {
            type = "password";
        }

        if ("register".equals(type)) {
            Long uid = this.userService.getUserIdByMobile(mobile);
            if (uid != null) {
                userLog.info(type + " is already exist  " + mobile);
                model.addAttribute("code", -2007);
                return "/common/success";
            }
        } else {
            Long uid = this.userService.getUserIdByMobile(mobile);
            if (uid == null) {
                userLog.info(type + " is not already exist  " + mobile);
                model.addAttribute("code", -2000);
                return "/common/success";
            }
        }

        String realMobile = mobile;
        userLog.info("final mobile is : " + realMobile);

        int code = 0;

        try {
            String result = this.smsService.sendVoice(realMobile, type);
            switch (result) {
                case SmsService.ErrorCode_SMS_InvalidType:
                    code = -2003;
                    break;
                case SmsService.ErrorCode_SMS_smsMoreThan5:
                    code = -2008;
                    break;
                case SmsService.ErrorCode_sendError:
                    code = -2015;
                    break;
                default:

            }

            model.addAttribute("code", code);
        } catch (Exception t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error(mobile + " send voice error of type " + type);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    /**
     * 用户注册
     *
     * @param request
     * @param response
     * @param model
     * @param mobile   手机号
     * @param verify   验证码
     * @param password 密码
     * @return
     * @throws Exception
     */
    //2、注册账号
    @RequestMapping(value = "/a/register", method = RequestMethod.POST)
    public String addUserJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
                              String verify, String password, String openid, String type, Long uid, String img, String nick,
                              String invitationCode, String areaCode, String account) throws Exception {

        registerLog.info(" user register : mobile= " + mobile + " verify =  " + verify + "  password = " + password
                + " openid = " + openid + " type = " + type + " uid " + uid + " img " + img + " nick " + nick
                + " invitationCode = " + invitationCode + " areaCode" + areaCode + " account " + account);
        String verify_type = "register";
        try {
            registerLog.info("==========1、校验参数是否为空==========");

            if (UserOpenidRelation.TYPE_EDUCLOUD.equals(type)||UserOpenidRelation.TYPE_SCHOOL.equals(type)) {
                if (StringUtil.isEmpty(openid)) {
                    registerLog.info("mobile is null");
                    model.addAttribute("code", -3010);

                    return "/common/success";
                }

            } else {
                if (StringUtil.isEmpty(mobile) && StringUtil.isEmpty(account)) {
                    registerLog.info("mobile is null");
                    model.addAttribute("code", -3002);

                    return "/common/success";
                } else if (StringUtil.isNotEmpty(mobile)) {
                    account = mobile;
                }
            }

            if (UserOpenidRelation.TYPE_EDUCLOUD.equals(type)||UserOpenidRelation.TYPE_SCHOOL.equals(type)) {

            } else {
                if (StringUtil.isEmpty(verify)) {
                    registerLog.info("verify is null");
                    model.addAttribute("code", -3004);

                    return "/common/success";
                }
            }
            if (UserOpenidRelation.TYPE_EDUCLOUD.equals(type)||UserOpenidRelation.TYPE_SCHOOL.equals(type)) {

            } else {
                if (StringUtil.isEmpty(password)) {
                    registerLog.info("password is null");
                    model.addAttribute("code", -3003);

                    return "/common/success";
                }
            }

            if ("mobile".equals(type)) {
                registerLog.info("type is mobile");
                model.addAttribute("code", -2011);

                return "/common/success";
            }

            registerLog.info("==========2、校验account类型==========");
            String accountType = "";
            if(UserOpenidRelation.TYPE_SCHOOL.equals(type)){
                registerLog.info("==========和校园账号==========");
            }else {
                Pattern p = Pattern.compile("^([a-zA-Z0-9_-])+@([a-zA-Z0-9_-])+(\\.([a-zA-Z0-9_-])+)+$");
                Matcher m = p.matcher(account);
                boolean result = m.matches();
                userLog.info("mail address verify result : " + result);
                if (result) {
                    accountType = "mail";

                    if (StringUtils.isBlank(areaCode)) {
                        areaCode = "";
                    }

                } else {
                    accountType = "mobile";

                    if (StringUtils.isBlank(areaCode)) {
                        areaCode = "+86";
                    }
                }
            }



            registerLog.info("==========3、校验openid是否绑定过用户==========");
            Boolean bound = !(StringUtil.isEmpty(openid)) && !(StringUtil.isEmpty(type));
            if (bound) {
                Long userOpenId = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndType(openid, type);
                if (null != userOpenId) {
                    //教育云：已经注册过,返回token
                    if (UserOpenidRelation.TYPE_EDUCLOUD.equals(type)||UserOpenidRelation.TYPE_SCHOOL.equals(type)) {
                        model.addAttribute("code", 0);
                        UserOpenidRelation userOpenidRelation = userOpenidRelationService.getObjectById(userOpenId);
                        Long userId = userOpenidRelation.getUid();
                        registerLog.info(" userId = " + userId);
                        String token = IdentityUtil.encodeCookie("phone", userId);
                        model.addAttribute("token", token);
                        model.addAttribute("uid", userId);
                        return "/learn-course-service/user/json/userRegister";
                    } else {
                        registerLog.info("openid is used");
                        model.addAttribute("code", -3005);

                        return "/common/success";
                    }
                }


            }

            registerLog.info("==========4、校验用户是否注册==========");
            Long oldUserOpenId = null;
            if (UserOpenidRelation.TYPE_EDUCLOUD.equals(type)||UserOpenidRelation.TYPE_SCHOOL.equals(type)) {
                oldUserOpenId = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndType(openid, UserOpenidRelation.TYPE_EDUCLOUD);

            } else {

                if ("mail".equals(accountType)) {
                    oldUserOpenId = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndType(account, UserOpenidRelation.TYPE_MAIL);
                } else {
                    oldUserOpenId = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndType(account, UserOpenidRelation.TYPE_MOBILE);
                }

            }


            if (oldUserOpenId != null) {
                registerLog.info(account + " is already exist  " + oldUserOpenId);

                //教育云：已经注册过
                if (UserOpenidRelation.TYPE_EDUCLOUD.equals(type)||UserOpenidRelation.TYPE_SCHOOL.equals(type)) {
                    model.addAttribute("code", 0);
                    UserOpenidRelation userOpenidRelation = userOpenidRelationService.getObjectById(oldUserOpenId);
                    Long userId = userOpenidRelation.getUid();
                    registerLog.info(" userId = " + userId);
                    String token = IdentityUtil.encodeCookie("phone", userId);
                    model.addAttribute("token", token);
                    model.addAttribute("uid", userId);
                    return "/learn-course-service/user/json/userRegister";
                } else {
                    model.addAttribute("code", -2007);
                    return "/common/success";

                }


            } else {
                registerLog.info(account + " not exist ,so can register ");
            }

            boolean verifyResult = false;

            registerLog.info("==========5、校验验证码==========");
            //如果是教育云用户，不需要验证码
            if (UserOpenidRelation.TYPE_EDUCLOUD.equals(type)||UserOpenidRelation.TYPE_SCHOOL.equals(type)) {

            } else {
                if (verifyModel()) {
                    registerLog.info("is test model ");
                    if ("555555".equals(verify)) {
                        registerLog.info("test ,so not verify account ");
                        verifyResult = true;
                    } else {
                        registerLog.info("log1: account is " + account + ",type = " + verify_type + ",verify" + verify);
                        verifyResult = verifyMobileCode(model, areaCode + account, verify_type, verify);
                    }
                } else {
                    registerLog.info("log1: account is " + account + ",type = " + verify_type + ",verify" + verify);
                    verifyResult = verifyMobileCode(model, areaCode + account, verify_type, verify);
                }
                if (verifyResult) {
                    registerLog.info("right verify code");

                } else {
                    registerLog.error("wrong verify code");
                    model.addAttribute("code", -2005);

                    return "/common/success";
                }
            }


            registerLog.info("==========6、获取后台默认年级==========");
            Integer grade = 3;
            String gradeStr = constantService.getValue("grade", "default");
            if ("".equals(gradeStr)) {
                registerLog.info("no default grade");
            } else {
                try {
                    grade = Integer.valueOf(gradeStr);
                } catch (Exception e) {
                    registerLog.error(e.getMessage());
                    registerLog.info("default grade not number");
                }
            }
            registerLog.info("get default grade " + grade + " success ");

            registerLog.info("==========7、注册用户==========");
            Long now = System.currentTimeMillis();
            Long userId = null;
            User user = new User();
            user.setRecommendFlag(User.IS_NOT_MEMBER);
            user.setGrade(grade);
            user.setLastLoginAt(now);
            user.setRegisterAt(now);
            user.setFreeMember(User.no_member);
            user.setStatus(User.STATUS_ON);
            userNameUtil userNameUtill = new userNameUtil();
            user.setNick(userNameUtill.getRandomName());


            if (DataUtils.isNotNullOrEmpty(img)) {
                user.setImg(img);
            }

            registerLog.info("==========8、若是分享注册用户则为分享人增加积分==========");
            Boolean recommendStatus = false;
            if (DataUtils.isNotNullOrEmpty(uid) || StringUtil.isNotEmpty(invitationCode)) {

                Long recommendId = null;

                if (DataUtils.isNotNullOrEmpty(uid)) {
                    User Shareuser = userService.getObjectById(uid);

                    if (null == Shareuser) {
                        registerLog.info("recommend user not exist");
                        model.addAttribute("code", -6007);
                        return "/common/success";
                    } else {
                        Integer oldScore = Shareuser.getScore();
                        Shareuser.setScore(oldScore + 30);
                        userService.update(Shareuser);
                        registerLog.info("introduce user score : " + oldScore + " >>>>>>>>>> " + Shareuser.getScore());

                        //这是一个垃圾的单发短信。。。。
                        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        String date = dateFormat.format(new Date(System.currentTimeMillis()));
                        String title = "获得学习星通知";
                        String content = "您于" + date + "成功邀请" + account + "用户注册回家学习，获得30颗学习星奖励。";

                        Message message = new Message();
                        message.setType(Message.Type_pesson);
                        message.setName(title);
                        message.setContent(content);
                        message.setUserId(uid);
                        message.setPublishAt(System.currentTimeMillis());
                        message.setSort(1);
                        Long mid = messageService.insert(message);

                        UserMessageRelation userMessageRelation = new UserMessageRelation();
                        userMessageRelation.setUserRead(UserMessageRelation.notRead);
                        userMessageRelation.setTargetId(mid);
                        userMessageRelation.setUserId(uid);
                        userMessageRelationService.insert(userMessageRelation);
                        //。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。
                    }

                    UserRecommend userRecommend = userRecommendService.getObjectById(uid);
                    if (userRecommend == null) {
                        userLog.info("user not recommend");
                        if (StringUtil.isNotEmpty(invitationCode)) {
                            recommendStatus = true;
                            recommendId = userService.getUserIdByInvitationCode(invitationCode);
                        } else {
                            recommendStatus = false;
                        }
                    } else {
                        if (UserRecommend.Recommend_forbidden.equals(userRecommend.getRecommendStatus())) {
                            recommendStatus = false;
                        } else {
                            recommendId = uid;
                            recommendStatus = true;
                        }
                    }

                } else {
                    recommendStatus = true;
                    recommendId = userService.getUserIdByInvitationCode(invitationCode);
                    if (recommendId == null) {
                        recommendId = userService.getUserIdByMobile(invitationCode);
                    }
                }

                if (recommendStatus) {
                    if (null != recommendId) {
                        registerLog.info("recommend id : " + recommendId);
                        UserRecommend recommendUser = userRecommendService.getObjectById(recommendId);
                        if (null == recommendUser) {
                            registerLog.info("recommend user not exist");
                            model.addAttribute("code", -6007);
                            return "/common/success";
                        } else {
                            if (UserRecommend.Recommend_forbidden.equals(recommendUser.getRecommendStatus())) {
                                registerLog.info("recommend user forbidden");
                                model.addAttribute("code", -10004);
                                return "/common/success";
                            } else {
                                user.setRecommendId(recommendId);
                            }
                        }
                    } else {
                        registerLog.info("recommend user not exist");
                        model.addAttribute("code", -6007);
                        return "/common/success";
                    }
                    Long staticAt = MyTimeUtil.getTodayZeroTimeMillions();
                    registerLog.info(" today is = " + getDate(staticAt));
                    List<Long> recommendStatisticsIds = recommendStatisticsService.getIdsByUserId(recommendId, 0, 1);
                    registerLog.info(" recommendStatisticsIds size = " + recommendStatisticsIds.size());
                    if (recommendStatisticsIds.size() > 0) {
                        RecommendStatistics recommendStatistics = recommendStatisticsService.getObjectById(recommendStatisticsIds.get(0));
                        if (staticAt.equals(recommendStatistics.getStaticAt())) {
                            registerLog.info(" add 1 ");
                            recommendStatistics.setRegisters(recommendStatistics.getRegisters().add(new BigDecimal("1")));
                            recommendStatisticsService.update(recommendStatistics);
                        } else {
                            registerLog.info(" new  recommendStatistics  ");
                            recommendStatistics = new RecommendStatistics();
                            recommendStatistics.setStaticAt(staticAt);
                            recommendStatistics.setUid(recommendId);
                            recommendStatistics.setRegisters(new BigDecimal("1"));
                            recommendStatisticsService.insert(recommendStatistics);
                        }

                    } else {
                        registerLog.info(" new  recommendStatistics  ");
                        RecommendStatistics recommendStatistics = new RecommendStatistics();
                        recommendStatistics.setStaticAt(staticAt);
                        recommendStatistics.setUid(recommendId);
                        recommendStatistics.setRegisters(new BigDecimal("1"));
                        recommendStatisticsService.insert(recommendStatistics);
                    }

                    UserRecommend userRecommend = userRecommendService.getObjectById(recommendId);
                    if (null == userRecommend) {
                        //推荐用户是推广人有邀请码但是无userRecommend数据（可能是老版本数据，补充userRecommend数据）
                        UserRecommend newUserRecommend = new UserRecommend();
                        newUserRecommend.setId(recommendId);
                        registerLog.info("insert newUserRecommend : " + newUserRecommend);
                        userRecommendService.insert(newUserRecommend);

                        userRecommend = userRecommendService.getObjectById(recommendId);
                        registerLog.info("user recommend info not exist , create and insert data : " + userRecommend);
                    } else {
                        registerLog.info("user recommend info : " + userRecommend);
                    }

                    Integer recommendNum = userRecommend.getRecommendNum();
                    userRecommend.setRecommendNum(recommendNum + 1);
                    registerLog.info("user : " + recommendId + " recommendNum " + recommendNum + " >>>>>>>>>> " + userRecommend.getRecommendNum());
                    userRecommendService.update(userRecommend);
                } else {
                    registerLog.info("there are no recommend user");
                }


            } else {

                registerLog.info("there are no recommend user");

            }

            String token = "";
            if (UserOpenidRelation.TYPE_EDUCLOUD.equals(type)||UserOpenidRelation.TYPE_SCHOOL.equals(type)) {

                //教育云不需要密码
                userId = userService.insert(user);
                token = IdentityUtil.encodeCookie("phone", userId);

                user = userService.getObjectById(userId);
                user.setToken(token);
                StringBuilder userOnlyId = getUserId(userId);
                registerLog.info(" userId = " + userId);
                String userOnly;
                userOnly = userOnlyId.toString();
                user.setUserId(userOnly);

                userService.update(user);
                //用户积分统计
                GameScoreRank gameScoreRank = new GameScoreRank();
                gameScoreRank.setUserId(userId);
                gameScoreRank.setGameScore(0L);
                gameScoreRank.setCreateBy(userId);
                gameScoreRank.setCreateBy(userId);

                gameScoreRankService.insert(gameScoreRank);






            } else {
                if (verifyResult) {
                    if ("mail".equals(accountType)) {
                        user.setRegisterMail(account);
                        user.setMail(account);
                    } else {
                        user.setAreaCode(areaCode);
                        user.setMobile(account);
                    }

                    String encodePass = PasswordUtils.encode(password);
                    user.setPwd(encodePass);
                    userId = userService.insert(user);
                    token = IdentityUtil.encodeCookie("phone", userId);

                    user = userService.getObjectById(userId);
                    user.setToken(token);
                    StringBuilder userOnlyId = getUserId(userId);
                    registerLog.info(" userId = " + userId);
                    String userOnly;
                    userOnly = userOnlyId.toString();
                    user.setUserId(userOnly);

                    userService.update(user);
                    //用户积分统计
                    GameScoreRank gameScoreRank = new GameScoreRank();
                    gameScoreRank.setUserId(userId);
                    gameScoreRank.setGameScore(0L);
                    gameScoreRank.setCreateBy(userId);
                    gameScoreRank.setCreateBy(userId);

                    gameScoreRankService.insert(gameScoreRank);


                } else {
                    registerLog.error("wrong verifycode");
                    model.addAttribute("code", -2005);

                    return "/common/success";
                }
            }


            registerLog.info("==========9、保存手机邮箱penid==========");
            if (!UserOpenidRelation.TYPE_EDUCLOUD.equals(type)&&!UserOpenidRelation.TYPE_SCHOOL.equals(type)) {
                UserOpenidRelation userMobileRelation = new UserOpenidRelation();
                userMobileRelation.setUid(userId);
                userMobileRelation.setOpenid(account);
                if ("mail".equals(accountType)) {
                    userMobileRelation.setType(UserOpenidRelation.TYPE_MAIL);
                } else {
                    userMobileRelation.setType(UserOpenidRelation.TYPE_MOBILE);
                }

                Long userMobileId = userOpenidRelationService.insert(userMobileRelation);
                registerLog.info(" userMobileId = " + userMobileId);
            }


            registerLog.info("==========10、若三方openid存在则保存==========");
            if (bound) {
                UserOpenidRelation userOpenidRelation = new UserOpenidRelation();
                userOpenidRelation.setUid(userId);
                userOpenidRelation.setOpenid(openid);
                userOpenidRelation.setType(type);
                Long userOpenId = userOpenidRelationService.insert(userOpenidRelation);
                registerLog.info(" userOpenId = " + userOpenId);
            }
            registerLog.info("bound status is " + bound);


            Map<String, String> maps = new HashMap();
            maps.put(CookieUtil.USER_ID, userId + "");
            cookieUtil.setIdentity(request, response, maps, userId);


            model.addAttribute("code", 0);
            model.addAttribute("token", token);
            model.addAttribute("uid", userId);

        } catch (Throwable t) {
            t.printStackTrace();
            registerLog.error(t.getMessage());
            registerLog.error("add user error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/user/json/userRegister";
    }

    public static String getDate(Long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
        String date = "";
        if (null != time) {
            date = dateFormat.format(new Date(time));
        }
        return date;
    }

    //3、用户登陆
    @RequestMapping(value = "/a/login", method = RequestMethod.POST)
    public String aLogin(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
                         String pwd, String openid, String type, String account, String os) throws Exception {

        registerLog.info("mobile is " + mobile + "pwd is " + pwd + " openid= " + openid + " type =  " + type + " account is " + account + " os is " + os);

        Long startTime = System.currentTimeMillis();
        registerLog.info("==========1、校验参数是否为空==========" + (System.currentTimeMillis() - startTime));
        if (mobile == null && StringUtil.isEmpty(account)) {
            model.addAttribute("code", -1000);
            return "/common/success";
        } else if (StringUtil.isNotEmpty(mobile)) {
            account = mobile;
        }

        if (Version.os_android.equals(os) || Version.os_ios.equals(os) || Version.os_web.equals(os)) {
            registerLog.info("os verify is ok");
        } else {
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if ("mobile".equals(type)) {
            registerLog.info("type is mobile");
            model.addAttribute("code", -2011);
            return "/common/success";
        }

        registerLog.info("==========2、校验account类型==========" + (System.currentTimeMillis() - startTime));
        String accountType = "";
        Pattern p = Pattern.compile("^([a-zA-Z0-9_-])+@([a-zA-Z0-9_-])+(\\.([a-zA-Z0-9_-])+)+$");
        Matcher m = p.matcher(account);
        boolean result = m.matches();
        registerLog.info("mail address verify result : " + result);
        if (result) {
            accountType = "mail";
        } else {
            accountType = "mobile";
        }

        registerLog.info("==========3、校验用户是否注册==========" + (System.currentTimeMillis() - startTime));
        Long uid = 0L;
        if ("mail".equals(accountType)) {
            uid = userService.getUserIdByMail(account);
        } else {
            uid = userService.getUserIdByMobile(account);
        }
        registerLog.info("通过邮箱或手机获取用户id完成，耗时：" + (System.currentTimeMillis() - startTime));
        if (uid == null) {
            registerLog.info("user : " + uid + " not exist ");
            model.addAttribute("code", -2000);
            return "/common/success";

        } else {
            registerLog.info("user : " + uid + " exist ,so can bound");
        }
        registerLog.info(" uid is " + uid);


        registerLog.info("==========4、校验openid是否绑定过用户==========" + (System.currentTimeMillis() - startTime));
        Boolean bound = !(StringUtil.isEmpty(openid)) && !(StringUtil.isEmpty(type));
        if (bound) {
            Long userOpenId = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndType(openid, type);
            if (null != userOpenId) {
                registerLog.info("openid is used");
                model.addAttribute("code", -3005);

                return "/common/success";
            } else {
                registerLog.info("openid " + openid + " not used");
            }

            Long uorid = userOpenidRelationService.getUserOpenidRelationIdByUidAndType(uid, type);
            if (uorid != null) {
                registerLog.info("user " + uid + " type : " + type + " openid : " + uorid + " exist");
                model.addAttribute("code", -2020);
                return "/common/success";
            } else {
                registerLog.info("user have no : " + type + " openid");
            }
        }

        User user = this.userService.getObjectById(uid);

        if (User.STATUS_OFF.equals(user.getStatus())) {
            registerLog.info(" status off ");
            model.addAttribute("code", -2009);
            return "/common/success";
        } else {
            registerLog.info("获取用户对象完成，耗时：" + (System.currentTimeMillis() - startTime));
        }

        registerLog.info("==========5、校验密码登陆==========" + (System.currentTimeMillis() - startTime));
        String pass = PasswordUtils.encode(pwd);
        Boolean verify = user.getPwd().equals(pass);
        if (verify) {
            registerLog.info(uid + " login ");
            Map<String, String> maps = new HashMap();
            maps.put(CookieUtil.USER_ID, uid + "");
            cookieUtil.setIdentity(request, response, maps, uid);
            String token = IdentityUtil.encodeCookie("phone", uid);
            user.setToken(token);
            user.setPlatform(os);
            user.setLastLoginAt(System.currentTimeMillis());
            userService.update(user);

            String loginRecordOs = "";
            switch (os) {
                case Version.os_android:
                    loginRecordOs = "安卓端";
                    break;
                case Version.os_ios:
                    loginRecordOs = "iOS端";
                    break;
                case Version.os_web:
                    loginRecordOs = "微信端";
                    break;
            }
            LoginRecord loginRecord = new LoginRecord();
            loginRecord.setUid(uid);
            loginRecord.setOs(loginRecordOs);
            loginRecord.setLoginAt(System.currentTimeMillis());
            loginRecordService.insert(loginRecord);
            registerLog.info("更新用户token完成，耗时：" + (System.currentTimeMillis() - startTime));
            registerLog.info("==========6、若三方openid存在则保存==========" + (System.currentTimeMillis() - startTime));
            if (bound) {
                UserOpenidRelation userOpenidRelation = new UserOpenidRelation();
                userOpenidRelation.setUid(uid);
                userOpenidRelation.setOpenid(openid);
                userOpenidRelation.setType(type);
                Long userOpenId = userOpenidRelationService.insert(userOpenidRelation);
                registerLog.info(" userOpenId = " + userOpenId);
            }
            registerLog.info("bound status is " + bound);
            List<Long> bookids = bookService.getBookIdsByGradeOrderBySort(user.getGrade(), 0, 3);
            Boolean book = false;
            if (bookids.size() > 0) {
                book = true;
            }
            registerLog.info("获取用户教材完成，耗时：" + (System.currentTimeMillis() - startTime));
            model.addAttribute("book", book);
            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            model.addAttribute("token", token);

            registerLog.info("==========7、over==========" + (System.currentTimeMillis() - startTime));
        } else {
            registerLog.info(mobile + " wrong pwd " + pwd);
            model.put("code", -2006);
            return "/common/success";
        }

        return "/learn-course-service/user/json/userLogin";
    }


    @RequestMapping(value = "/a/wrong/{token}", method = RequestMethod.GET)
    public String wrong(HttpServletRequest request,
                        HttpServletResponse response, ModelMap model, @PathVariable String token) throws Exception {

        registerLog.info(" wrong user " + token);

        model.addAttribute("code", -2);
        model.addAttribute("token", token);

        return "/common/wrongUser";

    }

    @RequestMapping(value = "/a/failure/{uid}", method = RequestMethod.GET)
    public String failureToken(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, @PathVariable Long uid) throws Exception {

        registerLog.info(" failure token, user " + uid);
        User user = userService.getObjectById(uid);
        model.addAttribute("loginAt", user.getLastLoginAt());
        model.addAttribute("code", -3);

        return "/common/failureToken";

    }

    //4、退出登录
    @RequestMapping(value = "/a/u/logout", method = RequestMethod.POST)
    public String logout(HttpServletRequest request,
                         HttpServletResponse response, ModelMap model) {
        registerLog.info(" welcome to manager logout ");

        try {

            User user = (User) request.getAttribute("user");
            Long uid = user.getId();

            cookieUtil.clearCookie(response);

            user.setDeviceToken(null);
            user.setPlatform(null);
            userService.update(user);

            model.addAttribute("code", 0);

            return "/common/success";
        } catch (Throwable t) {
            registerLog.error("user logout error  ");
            t.printStackTrace();

            return "/common/success";

        }


    }


    //5、查询是否注册
    @RequestMapping(value = "/a/verify/mobile", method = RequestMethod.GET)
    public String verifyMobile(HttpServletRequest request, HttpServletResponse response, ModelMap model, String openid, String type) {
        registerLog.info(" verify mobile if register ==========");

        Boolean result = false;
        try {
            if (StringUtils.isEmpty(openid)) {
                registerLog.info(" openId is null");
                model.addAttribute("code", -3002);
                return "/common/success";
            }

            Long relationId = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndType(openid, type);
            if (null != relationId) {
                result = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("register", result);

        } catch (Throwable t) {
            registerLog.error("user logout error  ");
            t.printStackTrace();

        }
        return "/common/boolResult";
    }

    /**
     * 修改用户友盟推送号
     *
     * @param request
     * @param response
     * @param model
     * @param deviceToken
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/user/{deviceToken}/{platform}", method = RequestMethod.PUT)
    public String resetPassword(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                @PathVariable String deviceToken, @PathVariable String platform) throws Exception {
        userLog.info(" update user deviceToken  = " + deviceToken);

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();

        try {

            if(deviceToken.equals(user.getDeviceToken())){
                model.addAttribute("code", 0);
                return "/common/success";
            }else {

                if(DataUtils.isNullOrEmpty(user.getDeviceToken())){
                    userLog.info("user no device before");
                }else {
                    Long startAt = null;
                    Long endAt = System.currentTimeMillis() + (7 * 24 * 60 * 60 * 1000);
                    userLog.info(" startAt = " + startAt);

                    String result = "";
                    String message = "您的账号已于" + dateTime() +
                            "在其他设备登录。如不是本人操作,则您的密码已经泄漏,请尽快登录修改密码,或联系客服400-001-6698冻结账号";
                    userLog.info("message : " + message);
                    if ("android".equals(user.getPlatform())) {
                        userLog.info(" android ");
                        result = androidPushServiceImpl.pushMessaeForList("android", "notification", "unicast",
                                user.getDeviceToken().toString(), "下线通知", "下线通知", message, "go_app", "", "", "",
                                "", startAt, "", "true", endAt, "回家学习通知");
                        userLog.info(" anResult = " + result);
                    } else if ("ios".equals(user.getPlatform())) {
                        userLog.info(" ios ");
                        result = iosPushServiceImpl.pushMessaeForList("ios", "notification", "unicast",
                                user.getDeviceToken().toString(), "下线通知", "下线通知", message, "go_app", "", "", "",
                                "", startAt, "", "false", endAt, "回家学习通知");
                        userLog.info(" iosResult = " + result);
                    } else {
                        userLog.info("user platform : " + user.getPlatform());
                    }

                    if (DataUtils.isNotNullOrEmpty(result)) {
                        JSONObject jsonObject = JSONObject.fromObject(result);
                        if ("SUCCESS".equals((String) jsonObject.get("ret"))) {
                            userLog.info(" push success ");
                        } else {
                            userLog.info("fail" + jsonObject.get("data"));
                            JSONObject data = JSONObject.fromObject(jsonObject.get("data").toString());
                            userLog.info(" data = " + data);
                            userLog.info(" errorCode = " + data.get("error_code"));
                        }
                    } else {
                        userLog.info("user no device before");
                    }
                }

                user.setDeviceToken(deviceToken);
                user.setPlatform(platform);
                userService.update(user);

                model.addAttribute("code", 0);
            }

        } catch (Throwable t) {
            registerLog.error("user logout error  ");
            t.printStackTrace();

        }

        return "/common/success";
    }

//    // 语音验证码
//    @RequestMapping(value = "/a/code/voice", method = RequestMethod.POST)
//    public String sendVoice(HttpServletRequest request, HttpServletResponse response, ModelMap model,
//                            String mobile, String type) throws ServiceException, ServiceDaoException {
//        registerLog.info(mobile + " want send voice of type " + type);
//
//        if (StringUtils.isBlank(mobile)) {
//            registerLog.info(mobile + " want send sms of type " + type + " null mobile ");
//            model.addAttribute("code", -2001);
//            return "/common/success";
//        }
//        if (StringUtils.isBlank(type)) {
//            type = "password";
//        }
//
//        if ("register".equals(type)) {
//            Long uid = this.userService.getUserIdByMobile(mobile);
//            if (uid != null) {
//                registerLog.info(type + " is already exist  " + mobile);
//                model.addAttribute("code", -2007);
//                return "/common/success";
//            }
//        } else {
//            Long uid = this.userService.getUserIdByMobile(mobile);
//            if (uid == null) {
//                registerLog.info(type + " is not already exist  " + mobile);
//                model.addAttribute("code", -2000);
//                return "/common/success";
//            }
//        }
//
//        int code = 0;
//
//        try {
//            String result = this.smsService.sendVoice(mobile, type);
//            switch (result) {
//                case SmsService.ErrorCode_SMS_InvalidType:
//                    code = -2003;
//                    break;
//                case SmsService.ErrorCode_SMS_smsMoreThan5:
//                    code = -2008;
//                    break;
//                case SmsService.ErrorCode_sendError:
//                    code = -2010;
//                    break;
//                default:
//
//            }
//
//            model.addAttribute("code", code);
//        } catch (Exception t) {
//            t.printStackTrace();
//            registerLog.error(t.getMessage());
//            registerLog.error(mobile + " send voice error of type " + type);
//            model.addAttribute("code", -1);
//        }
//
//        return "/common/success";
//    }

    // 6、忘记密码
    @RequestMapping(value = "/a/password/forget", method = RequestMethod.PUT)
    public String resetPassword(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
                                String verify, String newpwd, String account) throws Exception {
        try {

            registerLog.info(" mobile = " + mobile + " verify  = " + verify + " pwd = " + newpwd + " account = " + account);

            if (StringUtil.isEmpty(mobile) && StringUtil.isEmpty(account)) {
                registerLog.info("params is null");
                model.addAttribute("code", -3002);
                return "/common/success";
            } else if (StringUtil.isNotEmpty(mobile)) {
                account = mobile;
            }
            if (StringUtil.isEmpty(verify)) {
                registerLog.info("params is null");
                model.addAttribute("code", -3004);

                return "/common/success";
            }
            if (StringUtil.isEmpty(newpwd)) {
                registerLog.info("params is null");
                model.addAttribute("code", -3003);

                return "/common/success";
            }

            registerLog.info("==========2、校验account类型==========");
            String accountType = "";
            Pattern p = Pattern.compile("^([a-zA-Z0-9_-])+@([a-zA-Z0-9_-])+(\\.([a-zA-Z0-9_-])+)+$");
            Matcher m = p.matcher(account);
            boolean mailCheckResult = m.matches();
            userLog.info("mail address verify result : " + mailCheckResult);
            if (mailCheckResult) {
                accountType = "mail";
            } else {
                accountType = "mobile";
            }

            // 是否已注册
            Long uid = 0L;
            if ("mail".equals(accountType)) {
                uid = userService.getUserIdByMail(account);
            } else {
                uid = userService.getUserIdByMobile(account);
            }

            // 用户不存在
            if (uid == null) {
                registerLog.info(mobile + " not exist ");
                model.addAttribute("code", -2000);
                return "/common/success";
            } else {
                registerLog.info(mobile + " exist and uid is " + uid);
            }

            User user = userService.getObjectById(uid);

            if (null == user) {
                registerLog.info("user not exist ");
                model.addAttribute("code", -2000);
                return "/common/success";
            } else {
                if (null == user.getAreaCode()) {
                    userLog.info("user area code null , set +86");
                    user.setAreaCode("+86");
                }
            }

            if ("mail".equals(accountType)) {
                userLog.info("send mail message to : " + account);
            } else {
                account = user.getAreaCode() + user.getMobile();
                userLog.info("send message to : " + account);
            }

            boolean verifyResult = false;

            String type = "password";

            // 测试模式
            if (verifyModel()) {
                if ("555555".equals(verify)) {
                    registerLog.info("test ,so not verify mobile ");
                    verifyResult = true;
                } else {
                    verifyResult = verifyMobileCode(model, account, type, verify);
                }
            } else {
                verifyResult = verifyMobileCode(model, account, type, verify);
            }

            if (verifyResult) {

                String encodePass = PasswordUtils.encode(newpwd);
                user.setPwd(encodePass);
                boolean result = userService.update(user);

                registerLog.info(mobile + " change password," + newpwd + "result is " + result);
                registerLog.info("rewrite password success! ");

                model.addAttribute("code", 0);
            } else {
                registerLog.error("rewritepwd verifycode");
                model.addAttribute("code", -2005);

                return "/common/success";
            }

        } catch (Throwable t) {
            t.printStackTrace();
            registerLog.error(t.getMessage());
            registerLog.error("add user error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";

    }

    //7、三方登陆
    @RequestMapping(value = "/a/open/login", method = RequestMethod.POST)
    public String openidLogin(HttpServletRequest request, HttpServletResponse response, ModelMap model, String openid, String type,
                              String os)
            throws Exception {

        registerLog.info("openid is " + openid + "type is " + type + "os is " +os);

        if (openid == null || type == null) {
            model.addAttribute("code", -1000);

            return "/common/success";
        }

        if (Version.os_android.equals(os) || Version.os_ios.equals(os) || Version.os_web.equals(os)|| Version.os_school.equals(os)) {
            registerLog.info("os verify is ok");
        } else {
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        Long realtionId = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndType(openid, type);

        registerLog.info(" relationId is " + realtionId);
        if (realtionId == null) {
            model.addAttribute("code", -2000);
            return "/common/success";
        }

        UserOpenidRelation userOpenidRelation = userOpenidRelationService.getObjectById(realtionId);
        Long uid = userOpenidRelation.getUid();

        registerLog.info(" uid is " + uid);
        if (uid == null) {
            model.addAttribute("code", -2000);
            return "/common/success";
        }


        User user = this.userService.getObjectById(uid);

        if (user == null) {
            model.addAttribute("code", -2000);
            return "/common/success";
        }

        if (User.STATUS_OFF.equals(user.getStatus())) {
            registerLog.info(" status off ");
            model.addAttribute("code", -2009);
            return "/common/success";
        }

        registerLog.info(uid + " login ");
        Map<String, String> maps = new HashMap();
        maps.put(CookieUtil.USER_ID, uid + "");
        cookieUtil.setIdentity(request, response, maps, uid);
        String token = IdentityUtil.encodeCookie("phone", uid);
        user.setLastLoginAt(System.currentTimeMillis());
        user.setToken(token);
        user.setPlatform(os);
        userService.update(user);

        String loginRecordOs = "";
        switch (os) {
            case Version.os_android:
                loginRecordOs = "安卓端";
                break;
            case Version.os_ios:
                loginRecordOs = "iOS端";
                break;
            case Version.os_web:
                loginRecordOs = "微信端";
                break;
            case Version.os_school:
                loginRecordOs = "和校园";
                break;
        }
        LoginRecord loginRecord = new LoginRecord();
        loginRecord.setUid(uid);
        loginRecord.setOs(loginRecordOs);
        loginRecord.setLoginAt(System.currentTimeMillis());
        loginRecordService.insert(loginRecord);

        List<Long> bookids = bookService.getBookIdsByGradeOrderBySort(user.getGrade(), 0, 3);
        Boolean book = false;
        if (bookids.size() > 0) {
            book = true;
        }
        model.addAttribute("book", book);
        model.addAttribute("code", 0);
        model.addAttribute("user", user);
        model.addAttribute("token", token);

        return "/learn-course-service/user/json/userLogin";
    }


    //9、用户信息
    @RequestMapping(value = "/a/u/user/detail", method = RequestMethod.GET)
    public String userDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

        userLog.info("get user detail");

        User user = (User) request.getAttribute("user");
        userLog.info("get uid " + user.getId());

        try {

            userLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            if (7 == user.getGrade()) {
                userLog.info("user have no grade , set default grade ");
                Long defaultGradeId = constantService.getConstantIdByKeyAndType("grade", "default");
                if (null == defaultGradeId) {
                    userLog.info("there are no default grade ");
                } else {
                    Integer grade = 0;
                    String defaultGrade = constantService.getValue("grade", "default");
                    userLog.info("default grade : " + defaultGrade);
                    if (StringUtil.isNotEmpty(defaultGrade)) {
                        grade = Integer.valueOf(defaultGrade);
                    } else {
                        userLog.info("there are no default grade ");
                    }
                    user.setGrade(grade);
                    userService.update(user);
                    userLog.info("update user grade : " + grade + " success");
                }
            }

            //未读消息数量
//            List<Long> countUnRead = new LinkedList<>();
//            Map<String, Object> param = DynamicUtil.getUserMessageList(null, user.getId(), UserMessageRelation.notRead);
//            countUnRead = userMessageRelationService.getIdsByDynamicCondition(UserMessageRelation.class, param, 0, Integer.MAX_VALUE);
//            user.setUnRead(countUnRead.size());
            if (user.getLearnScore() == 0) {
                user.setDefeat(0);
            } else {
                List<Long> userIds = userService.getUserIdsByStudyList(0, Integer.MAX_VALUE);
                Float index = Float.valueOf(userIds.indexOf(user.getId()));
                DecimalFormat df = new DecimalFormat("#.0000");
                Float all = Float.valueOf(userIds.size());
                Float defeat = Float.valueOf(df.format(index / all));
                defeat = 1 - defeat;
                if (defeat.equals(1)) {
                    defeat = 0.9999F;
                }
                user.setDefeat(defeat);
            }

            Long endAt = 0L;
            List<Long> memeberIds = userMemberRelationService.getUserMemberRelationIdsByUidAndStatus(user.getId(), User.IS_MEMBER, 0, Integer.MAX_VALUE);
            if(CollectionUtils.isNotEmpty(memeberIds) && user.getFreeMember().equals(User.no_member)){
                user.setFreeMember(User.status_member);
                userService.update(user);
            }
            if (CollectionUtils.isEmpty(memeberIds)) {
                userLog.info(" user " + user.getId() + " is not a member ");

            } else {
                List<UserMemberRelation> userMemberRelations = userMemberRelationService.getObjectsByIds(memeberIds);
                for (UserMemberRelation userMemberRelation : userMemberRelations) {
                    userLog.info(" user member endAt is " + getDate(userMemberRelation.getEndAt()));
                    if (userMemberRelation.getEndAt().longValue() >= endAt) {
                        userLog.info(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is more than " + endAt);
                        endAt = userMemberRelation.getEndAt().longValue();
                    } else {
                        userLog.info(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is less than " + endAt);
                    }
                }
                userLog.info("final end at member time is : " + endAt);
                model.addAttribute("vipLine", endAt);
            }

            UserRecommend userRecommend = userRecommendService.getObjectById(user.getId());
            if (userRecommend == null) {
                userLog.info("user not recommend");
            } else {
                Integer recommendStatus = 0;
                Integer statsDisplay = UserRecommend.Stats_Show;

                userLog.info("user recommend info : " + userRecommend);
                recommendStatus = userRecommend.getRecommendStatus();
                statsDisplay = userRecommend.getStatsDisplay();

                model.addAttribute("recommendStatus", recommendStatus);
                model.addAttribute("statsDisplay", statsDisplay);
            }

            model.addAttribute("code", 0);
            model.addAttribute("user", user);

            List<Long> bookids = bookService.getBookIdsByGradeOrderBySort(user.getGrade(), 0, 3);
            userLog.info(" bookids size : " + bookids.size());

            Boolean book = false;
            if (User.allGrade.equals(user.getGrade())) {
                userLog.info("user " + user.getId() + " have no grade");
                book = true;
            }
            if (bookids.size() > 0) {
                book = true;
            }

            userLog.info(" book status : " + book);
            model.addAttribute("book", book);
        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("get userInfo error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/user/json/userDetail";
    }

    /**
     * @Description 我的推广
     * @Author: PeiyuFeng
     * @Time 2017/2/13 14:18
     */
    @RequestMapping(value = "/a/u/recommend/detail", method = RequestMethod.GET)
    public String recommendDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

        User user = (User) request.getAttribute("user");

        Long uid = 0L;
        //确认用户是否存在
        if (null == user) {
            model.addAttribute("code", -2000);
            userLog.info("user not exist");
            return "/common/success";
        } else {
            uid = user.getId();
            userLog.info("user exist : " + user);
        }
        userLog.info("get uid " + uid);

        userLog.info("get recommend detail : id = " + uid);

        UserRecommend userRecommend = new UserRecommend();
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal settlement = BigDecimal.ZERO;

        try {
            //确定用户是否是推广人
            if (User.IS_NOT_MEMBER == user.getRecommendFlag()) {
                //用户不是推广人且无userRecommend数据（错误）
                model.addAttribute("code", -10000);
                userLog.info("user not recommend");
                return "/common/success";
            } else {

                userRecommend = userRecommendService.getObjectById(uid);
                if (null == userRecommend) {
                    //用户是推广人有邀请码但是无userRecommend数据（可能是老版本数据，补充userRecommend数据）
                    UserRecommend newUserRecommend = new UserRecommend();
                    newUserRecommend.setId(uid);
                    userLog.info("insert newUserRecommend : " + newUserRecommend);
                    userRecommendService.insert(newUserRecommend);

                    userRecommend = userRecommendService.getObjectById(uid);
                    userLog.info("user recommend info not exist , create and insert data : " + userRecommend);
                } else {
                    userLog.info("user recommend info : " + userRecommend);
                    amount = userRecommend.getAndroidAmount().add(userRecommend.getIosAmount());
                    settlement = userRecommend.getAndroidSettlement().add(userRecommend.getIosSettlement());
                    userLog.info("amount = " + amount + " settlement = " + settlement);
                }
            }

            userLog.info("get user " + uid + " recommend info success");

            model.addAttribute("code", 0);
            model.addAttribute("amount", amount);
            model.addAttribute("settlement", settlement);
            model.addAttribute("userRecommend", userRecommend);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("get recommend detail error,id is  " + uid);
            model.addAttribute("code", -1);

        }

        return "/learn-course-service/user/json/recommendDetail";
    }


    //10、修改用户信息
    @RequestMapping(value = "/a/u/user/detail", method = RequestMethod.PUT)
    public String updateUser(HttpServletRequest request, HttpServletResponse response, ModelMap model, String nick,
                             Integer grade, String mail, String img) throws Exception {

        userLog.info("update user detail");

        User user = (User) request.getAttribute("user");
        userLog.info("get uid " + user.getId());

        try {
            userLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            if (DataUtils.isNotNullOrEmpty(nick)) {
                userLog.info("nick : " + user.getNick() + " >>>>>>>>>> " + nick);
                user.setNick(nick);
            }
            if (DataUtils.isNotNullOrEmpty(grade)) {
                userLog.info("grade : " + user.getGrade() + " >>>>>>>>>> " + grade);
                user.setGrade(grade);
            }
            if (DataUtils.isNotNullOrEmpty(mail)) {
                userLog.info("mail : " + user.getMail() + " >>>>>>>>>> " + mail);
                user.setMail(mail);
            }
            if (DataUtils.isNotNullOrEmpty(img)) {
                userLog.info("img : " + user.getImg() + " >>>>>>>>>> " + img);
                user.setImg(img);
            }
            userService.update(user);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("update" +
                    " user error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    //10、修改用户密码
    @RequestMapping(value = "/a/u/password", method = RequestMethod.PUT)
    public String updateUser(HttpServletRequest request, HttpServletResponse response, ModelMap model, String pwd, String newpwd) throws Exception {

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        userLog.info("get uid " + uid);

        try {
            userLog.info(" user : " + uid + " want update pwd");

            if (StringUtil.isEmpty(newpwd) || StringUtils.isEmpty(pwd)) {
                userLog.info("params is null");
                model.addAttribute("code", -3003);
                return "/common/success";
            }

            String pass = PasswordUtils.encode(pwd);
            Boolean verify = user.getPwd().equals(pass);
            if (verify) {
                userLog.info(uid + " have right pwd ");

                String encodePass = PasswordUtils.encode(newpwd);
                user.setPwd(encodePass);
                boolean result = userService.update(user);

            } else {
                userLog.info(uid + " wrong pwd " + pwd);
                model.put("code", -2006);
                return "/common/success";
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("user " + uid + " update pwd error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    //11、收藏课程/课时
    @RequestMapping(value = "/a/u/favorite/{id}", method = RequestMethod.PUT)
    public String like(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id,
                       Integer status, Integer type) throws Exception {
        Long relationId = 0L;
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        favoriteLog.info("get uid " + uid);

        favoriteLog.info("user : " + user.getId() + " set favorite : type = " + type + " id = " + id + " status = " + status);

        try {
            if (DataUtils.isNullOrEmpty(status) || DataUtils.isNullOrEmpty(type)) {
                favoriteLog.info("params is null");
                model.addAttribute("code", -4015);
                return "/common/success";
            }

            //收藏类型是否非法
            if (!(UserFavoriteRelation.TYPE_LESSON.equals(type) || UserFavoriteRelation.TYPE_PERIOD.equals(type))) {
                favoriteLog.info("type illegal");
                model.addAttribute("code", -4001);
                return "/common/success";
            }

            if (UserFavoriteRelation.STATUS_DISLIKE.equals(status)) {
                favoriteLog.info("==========取消收藏==========");
                relationId = userFavoriteRelationService.getUserFavoriteRelationIdByUserIDAndTypeAndTargetID(uid, type, id);
                if (null == relationId) {
                    favoriteLog.info("favorite relation not exist");
                    model.addAttribute("code", -4003);
                    return "/common/success";
                } else {
                    userFavoriteRelationService.delete(relationId);
                }
            }

            if (UserFavoriteRelation.STATUS_LIKE.equals(status)) {
                favoriteLog.info("==========收藏==========");
                relationId = userFavoriteRelationService.getUserFavoriteRelationIdByUserIDAndTypeAndTargetID(uid, type, id);
                if (null != relationId) {
                    favoriteLog.info("favorite relation already exist");
                    model.addAttribute("code", -4004);
                    return "/common/success";
                } else {
                    UserFavoriteRelation userFavoriteRelation = new UserFavoriteRelation();
                    userFavoriteRelation.setUserID(uid);
                    userFavoriteRelation.setType(type);
                    userFavoriteRelation.setTargetID(id);
                    userFavoriteRelationService.insert(userFavoriteRelation);
                }
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            favoriteLog.error(t.getMessage());
            favoriteLog.error("update" + " user error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    //12、用户收藏课程列表
    @RequestMapping(value = "/a/u/lesson/favorite/list", method = RequestMethod.GET)
    public String getFavoriteLesson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {

        List<Long> lessonIds = new ArrayList<>();
        List<Lesson> lessons = new ArrayList<>();
        List<Long> totalIds = new ArrayList<>();
        Long relationId = 0L;
        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }
        int firstNmuber = (page - 1) * size;
        Boolean next = false;

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        favoriteLog.info("get uid " + uid);

        favoriteLog.info("user : " + uid + " get favorite list");

        try {
            favoriteLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            favoriteLog.info("=====获取收藏课程列表id=====");
            List<Long> relationIds = userFavoriteRelationService.getUserFavoriteRelationIdsByUserIDAndType(uid, UserFavoriteRelation.TYPE_LESSON, firstNmuber, size);
            if (CollectionUtils.isNotEmpty(relationIds)) {
                List<UserFavoriteRelation> userFavoriteRelations = userFavoriteRelationService.getObjectsByIds(relationIds);
                for (UserFavoriteRelation userFavoriteRelation : userFavoriteRelations) {
                    lessonIds.add(userFavoriteRelation.getTargetID());
                }
            }
            favoriteLog.info("favorite lessonIds : " + lessonIds);

            if (lessonIds != null && lessonIds.size() > 0) {
                if (size.equals(lessonIds.size())) {
                    next = true;
                    lessonIds = lessonIds.subList(0, size);
                }
            }
            favoriteLog.info("favorite lessonIds : " + lessonIds);

            lessons = lessonService.getObjectsByIds(new ArrayList(Arrays.asList(lessonIds.toArray())));
            if (CollectionUtils.isNotEmpty(lessons)) {
                favoriteLog.info("lessons size : " + lessons.size());
            } else {
                favoriteLog.info("lessons is null ");
            }


            totalIds = userFavoriteRelationService.getUserFavoriteRelationIdsByUserIDAndType(uid, UserFavoriteRelation.TYPE_LESSON, 0, Integer.MAX_VALUE);

            favoriteLog.info("   total = " + totalIds.size());
            Integer totalPage = (((totalIds.size() - 1)) / size) + 1;
            favoriteLog.info("   totalPage = " + totalPage);


            List<Long> periodIds = null;
            Long progressId = null;
            List<Period> periodList = null;
            Long periodOrderId = null;
            UserOrder userOrder = null;
            for (Lesson lesson : lessons) {
                if (lesson != null) {
                    Integer leve = lesson.getLevel();
                    Long subId = lesson.getSubject();

                    userLog.info("=====验证是否收藏，学习进度=====");
                    if (null != leve) {
                        Long gradeId = gradeClassRelationService.getGradeClassRelationIdsByGradeName
                                (subId, leve);
                        if (null != gradeId) {
                            GradeClassRelation gradeClassRelation = gradeClassRelationService.getObjectById(gradeId);
                            lesson.setLevelName(gradeClassRelation.getLevel());
                            lesson.setGradeIntroduce(gradeClassRelation.getIntroduce());
                        }
                    }

                    //学习进度
                    List<Long> progressList = new ArrayList<>();
                    periodIds = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(lesson.getId(), Period.status_normal, 0, Integer.MAX_VALUE);

                    if (periodIds != null && periodIds.size() > 0) {
                        lesson.setPeriodCount(periodIds.size());
                        lessonService.update(lesson);
                        for (Long periodId : periodIds) {
                            progressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, periodId, Progress.TYPE_PERIOD);
                            if (null != progressId) {
                                progressList.add(progressId);
                            }
                        }
                        if (progressList.size() == 0) {
                            lesson.setProgress(-1);
                        } else {
                            lesson.setProgress(progressList.size());
                        }
                    }

                    //学习状态
                    progressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, lesson.getId(), Progress.TYPE_LESSON);
                    Progress progress = progressService.getObjectById(progressId);
                    if (progress != null) {
                        lesson.setOver(progress.getStatus());
                    }
                    periodList = periodService.getObjectsByIds(periodIds);
                    Long paperId = null;
                    Long orderId = null;
                    String moneyPrice = "0";
                    Double price = 0D;
                    for (Period period : periodList) {
                        paperId = period.getPaperID();
                        if (paperId != null) {
                            Paper paper = paperService.getObjectById(paperId);
                            if (paper != null) {
                                orderId = userOrderService.getUserOrderIdsByUidAndBuyTypeAndTargetId(uid, UserOrder.ORDER_PPAPER, paper.getId());
                                if (orderId == null) {
                                    price = Double.valueOf(moneyPrice) + Double.valueOf(paper.getPrice());
                                    moneyPrice = price.toString();
                                }
                            }
                        }

                        //只要有一个课时解锁就是不锁定
                        if (period.getLocked() == 1) {
                            periodOrderId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, period.getId());
                            if (periodOrderId != null) {
                                lesson.setUserLock(Lesson.UnLock);
                            }
                        } else {
                            lesson.setUserLock(Lesson.UnLock);
                            break;
                        }
                    }
                    lesson.setPaperPrice(moneyPrice);
                    moneyPrice = "0";
                    price = 0D;
                }
                periodOrderId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_LESSON, lesson.getId());
                if (periodOrderId != null) {
                    lesson.setUserLock(Lesson.UnLock);
                }
            }


            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("page", page);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("lessons", lessons);

        } catch (Throwable t) {
            t.printStackTrace();
            favoriteLog.error(t.getMessage());
            favoriteLog.error("get favorite lesson error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/lesson/json/userFavoriteLesson";
    }


    //13、用户收藏课时列表
    @RequestMapping(value = "/a/u/period/favorite/list", method = RequestMethod.GET)
    public String getFavoritePeriod(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {

        List<Long> periodIds = new ArrayList<>();
        List<Period> periods = new ArrayList<>();
        List<Long> totalIds = new ArrayList<>();
        Long relationId = 0L;
        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }
        int firstNmuber = (page - 1) * size;
        Boolean next = false;

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        favoriteLog.info("get uid " + uid);

        favoriteLog.info("user : " + uid + " get favorite list");

        try {

            favoriteLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            favoriteLog.info("=====获取收藏课时列表id=====");
            List<Long> relationIds = userFavoriteRelationService.getUserFavoriteRelationIdsByUserIDAndType(uid, UserFavoriteRelation.TYPE_PERIOD, firstNmuber, size);
            favoriteLog.info("relationIds size : " + relationIds.size());
            if (CollectionUtils.isNotEmpty(relationIds)) {
                List<UserFavoriteRelation> userFavoriteRelations = userFavoriteRelationService.getObjectsByIds(relationIds);
                for (UserFavoriteRelation userFavoriteRelation : userFavoriteRelations) {
                    periodIds.add(userFavoriteRelation.getTargetID());
                }
            }
            totalIds = userFavoriteRelationService.getUserFavoriteRelationIdsByUserIDAndType(uid, UserFavoriteRelation.TYPE_PERIOD, firstNmuber, size);
            favoriteLog.info("favorite lessonIds : " + periodIds);

            if (CollectionUtils.isNotEmpty(periodIds)) {
                periods = periodService.getObjectsByIds(periodIds);
            }

            favoriteLog.info("   total = " + periodIds.size());
            Integer totalPage = (((periodIds.size() - 1)) / size) + 1;
            favoriteLog.info("   totalPage = " + totalPage);

            if (periodIds != null && periodIds.size() > 0) {
                if (size.equals(periodIds.size())) {
                    next = true;
                    periodIds = periodIds.subList(0, size);
                }
            }
            List<Long> taskIds = null;
            Long progressID = null;
            Progress progress = new Progress();
            Long paperId = null;
            Long periodOrderId = null;
            UserOrder userOrder = new UserOrder();
            for (Period period : periods) {

                favoriteLog.info("=====验证是否收藏，学习进度=====");
                //学习进度
                List<Long> progressList = new ArrayList<>();
                taskIds = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(period.getId(), Period.status_normal, 0, Integer.MAX_VALUE);

                if (taskIds != null && taskIds.size() > 0) {
                    favoriteLog.info("====================" + 2);
                    period.setTaskCount(taskIds.size());
                    periodService.update(period);
                    favoriteLog.info("====================" + 3);
                    for (Long taskId : taskIds) {
                        taskId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, taskId, Progress.TYPE_TASK);
                        favoriteLog.info("====================" + 4);
                        if (null != taskId) {
                            progressList.add(taskId);
                        }
                    }
                    favoriteLog.info("====================" + 5);
                    period.setProgress(progressList.size());
                }
                progressID = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, period.getId(), Progress.TYPE_PERIOD);
                progress = progressService.getObjectById(progressID);
                if (progress != null) {
                    period.setOver(progress.getStatus());
                    period.setProgress(Integer.valueOf(progress.getSort().toString()));
                } else {
                    period.setProgress(-1);
                }
                paperId = period.getPaperID();
                if (paperId != null) {
                    Paper paper = paperService.getObjectById(paperId);
                    if (paper != null) {
                        period.setPaperPrice(paper.getPrice());
                    }
                }
                periodOrderId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, period.getId());
                if (period.getLocked() == 2) {
                    period.setUserLock(2);
                } else if (periodOrderId != null) {
                    period.setUserLock(Period.UnLock);
                }
                if (Period.Lesson.equals(period.getType())) {
                    periodOrderId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_LESSON, period.getLessonID());
                    if (periodOrderId != null) {
                        period.setUserLock(2);
                    }

                    Lesson lesson = lessonService.getObjectById(period.getLessonID());
                    if (lesson != null) {
                        period.setBookName(lesson.getName());
                        period.setLessonName(lesson.getName());
                    } else {
                        userLog.info("lesson : " + period.getLessonID() + " not exist");
                    }
                } else {
                    Book book = bookService.getObjectById(period.getBookID());
                    if (book != null) {
                        period.setBookName(book.getName());
                        period.setLessonName(book.getName());
                    } else {
                        userLog.info("book : " + period.getBookID() + " not exist");
                    }
                }
            }
            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("page", page);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("periods", periods);

        } catch (Throwable t) {
            t.printStackTrace();
            favoriteLog.error(t.getMessage());
            favoriteLog.error("get favorite period error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/period/json/userFavoritePeriod";
    }

    //14、签到
    @RequestMapping(value = "/a/u/user/sign", method = RequestMethod.PUT)
    public String sign(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        userLog.info("get uid " + uid);

        userLog.info("user : " + uid + " sign");

        try {

            userLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            userLog.info("=====判断当天是否签到=====");
            Long now = System.currentTimeMillis();
            Long signId = signService.getSignIdByUidAndSignDate(uid, MyTimeUtil.getStartTime(now));
//            判断用户今天有没有签到过。
            if (null != signId) {
                user.setSign(User.SIGN);
                userService.update(user);
                userLog.info("already sign today");
                model.addAttribute("code", -2017);
                return "/common/success";
            } else {
                userLog.info("user not sign");
            }
//
            Integer signStatus = user.getSign();
            userLog.info("user sign is : " + signStatus);

            userLog.info("=====插入用户签到记录=====");
            Sign signRecord = new Sign();
            signRecord.setUid(uid);
            signRecord.setSignAt(now);
            signRecord.setSignDate(MyTimeUtil.getStartTime(now));
            userLog.info("insert sign record : " + signRecord);
            signService.insert(signRecord);


            userLog.info("=====判断用户是不是会员=====");
            Boolean isMember=false;

            List<Long> userMemberRelationIds = userMemberRelationService.getUserMemberRelationIdsByUidAndStatus(uid, User.IS_MEMBER, 0, 1);
            if (CollectionUtils.isEmpty(userMemberRelationIds)) {
                userLog.info(" user " + uid + " is not a member ");

            } else {
                userLog.info(" user " + uid + "  member record id = " + userMemberRelationIds.get(0));
                UserMemberRelation userMemberRelation = userMemberRelationService.getObjectById(userMemberRelationIds.get(0));
                userLog.info(" user member endAt is " + getDate(userMemberRelation.getEndAt()) + " now is " + getDate(now));
                if (now.longValue() >= userMemberRelation.getEndAt().longValue()) {
                    userLog.info(" user member is out of date ");

                } else {
                    userLog.info(" user is member ");
                    isMember=true;
                }
            }

            //查询昨天是否签到，决定当前连续签到次数
            Long yDayZero = MyTimeUtil.getPreZeroTimeMillions(1);
            userLog.info("yesterday zero time : " + yDayZero);
            Long yDaySignId = signService.getSignIdByUidAndSignDate(uid, yDayZero);
            if (null == yDaySignId) {
                userLog.info("not continue sign");
                user.setConsecutive(1);
            } else {
                userLog.info("continue sign");
                Integer consecutive = user.getConsecutive();
                user.setConsecutive(consecutive + 1);
                userLog.info("user consecutive : " + consecutive + " >>>>>>>>>> " + user.getConsecutive());
            }

            userLog.info("=====修改历史最高签到记录=====");
            //根据当前连续签到次数与历史最高签到次数比较，确定是否更新历史最高签到记录
            Integer signHighest = user.getSignHighest();
            userLog.info("user signHighest : " + signHighest);
            userLog.info(user.getConsecutive() + " " + signHighest);
            if (user.getConsecutive() > signHighest) {
                user.setSignHighest(user.getConsecutive());
                userLog.info("user consecutive : " + signHighest + " >>>>>>>>>> " + user.getSignHighest());
            } else {
                userLog.info("user consecutive less than signHighest");
            }

            //获取学习星数按当前连续签到次数计算
            Integer addScore = user.getConsecutive();
            if (addScore > 5) {
                addScore = 10;
            }
            if(isMember.equals(true)){
                addScore = addScore*2;
            }
            Integer score = user.getScore();
            user.setScore(score + addScore);
            userLog.info("user learnTime : " + score + " >>>>>>>>>> " + user.getScore());
            user.setSign(User.SIGN);

            Integer learnTime = user.getLearnTime();
            user.setLearnTime(learnTime + 1);
            userLog.info("user learnTime : " + learnTime + " >>>>>>>>>> " + user.getLearnTime());

            userService.update(user);

            //这是一个垃圾的单发短信。。。。
            DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String date = dateFormat.format(new Date(System.currentTimeMillis()));
            String title = "获得学习星通知";
            String content = "您已完成签到，获得" + addScore + "颗学习星。";

            Message message = new Message();
            message.setType(Message.Type_pesson);
            message.setName(title);
            message.setContent(content);
            message.setUserId(uid);
            message.setPublishAt(System.currentTimeMillis());
            message.setSort(1);
            Long mid = messageService.insert(message);
            userLog.info("send message success");

            UserMessageRelation userMessageRelation = new UserMessageRelation();
            userMessageRelation.setUserRead(UserMessageRelation.notRead);
            userMessageRelation.setTargetId(mid);
            userMessageRelation.setUserId(uid);
            userMessageRelationService.insert(userMessageRelation);

            model.addAttribute("code", 0);
            model.addAttribute("score", addScore);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("user : " + uid + " sign error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/user/json/signInfo";
    }


    //14、用户签到信息
    @RequestMapping(value = "/a/u/user/sign/list", method = RequestMethod.GET)
    public String sign(HttpServletRequest request, HttpServletResponse response, ModelMap model, String year, String month) throws Exception {

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        userLog.info("get uid " + uid);

        userLog.info("get user : " + uid + " " + year + "-" + month + " sign list");

        if (StringUtil.isEmpty(year) || StringUtil.isEmpty(month)) {
            userLog.info("params is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {

            userLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            Date inDate = new Date();

            try {
                if (Integer.valueOf(month) < 10) {
                    month = "0" + month;
                }
                String date = year + month + "01000000";
                DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                inDate = dateFormat.parse(date);

            } catch (Exception e) {
                userLog.error(e.getMessage());
                userLog.info("wrong date format");
                model.addAttribute("code", -1007);
                return "/common/success";
            }

            DateFormat weekFormat = new SimpleDateFormat("E");
            DateFormat dayFormat = new SimpleDateFormat("dd");
            Date monthBegin = TimeUtil.getMonthBegin(inDate);
            Date monthEnd = TimeUtil.getMonthEnd(inDate);
            String week = weekFormat.format(monthBegin);
            String day = dayFormat.format(monthEnd);
            userLog.info("the first day week of month : " + week + " , the day number of month : " + day);
            model.addAttribute("week", week);
            model.addAttribute("dayCount", day);

            userLog.info("=====判断用户是不是会员=====");
            Long now = System.currentTimeMillis();
            Boolean isMember=false;

            List<Long> userMemberRelationIds = userMemberRelationService.getUserMemberRelationIdsByUidAndStatus(uid, User.IS_MEMBER, 0, 1);
            if (CollectionUtils.isEmpty(userMemberRelationIds)) {
                userLog.info(" user " + uid + " is not a member ");

            } else {
                userLog.info(" user " + uid + "  member record id = " + userMemberRelationIds.get(0));
                UserMemberRelation userMemberRelation = userMemberRelationService.getObjectById(userMemberRelationIds.get(0));
                userLog.info(" user member endAt is " + getDate(userMemberRelation.getEndAt()) + " now is " + getDate(now));
                if (now.longValue() >= userMemberRelation.getEndAt().longValue()) {
                    userLog.info(" user member is out of date ");

                } else {
                    userLog.info(" user is member ");
                    isMember=true;
                }
            }

            //查询昨天是否签到，决定当前连续签到次数
            Long yDayZero = MyTimeUtil.getPreZeroTimeMillions(1);
            Long tDayZero = MyTimeUtil.getPreZeroTimeMillions(0);
            Long yDaySignId = signService.getSignIdByUidAndSignDate(uid, yDayZero);
            Long tDaySignId = signService.getSignIdByUidAndSignDate(uid, tDayZero);
            userLog.info("yesterday sign id : " + yDaySignId + " , today sign id : " + tDaySignId);

            if (null == yDaySignId && null == tDaySignId) {
                userLog.info("not continue sign");
                user.setConsecutive(0);
                userService.update(user);
                userLog.info("update user consecutive : 0 ");
            } else {
                userLog.info("continue sign : " + user.getConsecutive());
            }

            model.addAttribute("continue", user.getConsecutive());
            model.addAttribute("member", isMember);

            Map<Long, String> id_signDay = new HashMap();
            List<Integer> signDayList = new ArrayList<>();
            List<Long> signIds = signService.getSignIdsByUidAndSignDateAreaOrderBySignDateAsc(uid, monthBegin.getTime(), monthEnd.getTime());
            userLog.info("sign id size : " + signIds.size());
            List<Sign> signs = signService.getObjectsByIds(signIds);

            String signDay = "";
            for (Sign sign : signs) {
                signDay = dayFormat.format(sign.getSignDate());
                id_signDay.put(sign.getId(), signDay);

                Integer dayDate = Integer.valueOf(signDay);
                signDayList.add(dayDate);
            }

            List<Integer> signList = new ArrayList<>();
            Integer dayCountInt = Integer.valueOf(day);
            for (int i = 1; i <= dayCountInt; i++) {
                if (signDayList.contains(i)) {
                    signList.add(1);
                } else {
                    signList.add(0);
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("signIds", signIds);
            model.addAttribute("signList", signList);
            model.addAttribute("id_signDay", id_signDay);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("user : " + uid + " sign error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/user/json/userSignList";
    }

    /**
     * @param
     * @Description 首页接口
     * @Author: PeiyuFeng
     * @Time 2017/2/13 15:18
     */
    @RequestMapping(value = "/a/u/index/info", method = RequestMethod.GET)
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap model)
            throws Exception {

        List<Long> sids = null;
        List<Long> cids = null;

        try {

            sids = subjectService.getSubjectIdsByStatusAndTypeOrderBySort(Subject.status_normal, Subject.TYPE_1, 0, Integer.MAX_VALUE);

            cids = subjectService.getSubjectIdsByStatusAndTypeOrderBySort(Subject.status_normal, Subject.TYPE_3, 0, Integer.MAX_VALUE);
            if (sids == null) {
                userLog.info("get own subject error and ids is null");
                model.addAttribute("code", 2);
                return "/common/success";
            }
            List<Subject> subjectList = subjectService.getObjectsByIds(sids);
            userLog.info("get subject data is " + subjectList);

            List<Subject> collaborateList = subjectService.getObjectsByIds(cids);
            userLog.info("get collaborate data is " + collaborateList);

            model.addAttribute("code", 0);
            model.addAttribute("subjectList", subjectList);
            model.addAttribute("collaborateList", collaborateList);

        } catch (Throwable t) {
            userLog.error(t.getMessage());
            userLog.error("get subject and collaborate error");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/user/json/indexJson";
    }


    /**
     * @param
     * @Description 用户消息状态
     * @Author: PeiyuFeng
     * @Time 2017/4/6 18:58
     */
    @RequestMapping(value = "/a/u/message/status", method = RequestMethod.GET)
    public String userMessageStatus(HttpServletRequest request, HttpServletResponse response, ModelMap model)
            throws Exception {

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        userLog.info("get uid " + uid + " message status");

        try {

            Boolean userMessageStatus = false;

            Map<String, Object> params = DynamicUtil.getUserMessageList(null, uid, UserMessageRelation.notRead);
            List<Long> ids = userMessageRelationService.getIdsByDynamicCondition(UserMessageRelation.class, params, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isNotEmpty(ids)) {
                userLog.info("user have message : " + ids + " not read");
                userMessageStatus = true;
            } else {
                userLog.info("user have no message not read");
            }

            model.addAttribute("code", 0);
            model.addAttribute("userMessageStatus", userMessageStatus);

        } catch (Throwable t) {
            userLog.error(t.getMessage());
            userLog.error("get user : " + uid + " message status error");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/user/json/userMessageStatus";
    }


    /**
     * @param
     * @Description 用户消息全部已读
     * @Author: PeiyuFeng
     * @Time 2017/4/8 12:52
     */
    @RequestMapping(value = "/a/u/message/status", method = RequestMethod.PUT)
    public String updateUserMessageStatus(HttpServletRequest request, HttpServletResponse response, ModelMap model)
            throws Exception {

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        userLog.info("update uid " + uid + " message status");

        try {

            Boolean userMessageStatus = false;

            Map<String, Object> params = DynamicUtil.getUserMessageList(null, uid, UserMessageRelation.notRead);
            List<Long> ids = userMessageRelationService.getIdsByDynamicCondition(UserMessageRelation.class, params, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isNotEmpty(ids)) {
                userLog.info("user have message : " + ids + " not read");
                List<UserMessageRelation> relations = userMessageRelationService.getObjectsByIds(ids);
                for (UserMessageRelation relation : relations) {
                    relation.setUserRead(UserMessageRelation.read);
                }

                userMessageRelationService.updateList(relations);
                userLog.info("update user not read message success");
            } else {
                userLog.info("user have no message not read");
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            userLog.error(t.getMessage());
            userLog.error("update user : " + uid + " message error");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    private boolean verifyModel() {
//        return "test".equals(this.accountConfig.get("testModel"));
        return true;
    }


    // 验证码校验
    private boolean verifyMobileCode(ModelMap model, String mobile, String type, String verify)
            throws ServiceException, ServiceDaoException {
        registerLog.info("log2: mobile is " + mobile + ",type = " + type + ",verify" + verify);
        // 是否有发送验证码
        Long sid = smsService.getSmsIdByMobileAndType(mobile, type);
        registerLog.info("sid is " + sid);

        if (sid == null) {
            return false;
        }
        // 获取验证码信息
        Sms sms = smsService.getObjectById(sid);
        registerLog.info("sms is " + sms);
        // 获取验证码
        String message = sms.getMessage();
        registerLog.info("message is " + message);

        //发送是否超时
        Long delay = System.currentTimeMillis() - sms.getSendAt();

        if (delay > 600000) {
            registerLog.info("require verify too long");
            return false;
        }

        if (message.equals(verify)) {
            return true;
        } else {
            return false;
        }

    }


    @RequestMapping(value = "/a/u/img/{module}", method = RequestMethod.POST)
    public String uploadFile(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model,
                             @RequestParam MultipartFile file, @PathVariable String module)
            throws Exception {
        userLog.info("hello upload " + module);
        if (org.apache.commons.lang3.StringUtils.isBlank(module)) {
            module = "common";
        }
        int code = 0;
        userLog.info(file.getOriginalFilename());

        //Long uid = cookieUtil.getID(request, response);
        try {
            String type = file.getContentType();
            long size = file.getSize();
            userLog.info("  size is =" + size / 1048576);
            String extend = FileUtil.getFileExtension(file
                    .getOriginalFilename());

            String fileName = UUID.randomUUID().toString() + "." + extend;
            userLog.info("new name is " + fileName);
            //  /data/temp/
            String filePath = "/data/temp/" + fileName;

            File tempPic = new File(filePath);
            file.transferTo(tempPic);
            String url = this.imgStorageUtil.imgStorage(module, module + "/"
                    + fileName, filePath);
            userLog.info(module + " upload success ,and file name is " + fileName
                    + "temp path is " + filePath + " access url is " + url);
            tempPic.delete();
            userLog.info(file.getOriginalFilename() + " delete success ");
            model.addAttribute("url", url);
            model.addAttribute("code", 0);
            return "/common/img";
        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            return "/common/success";
        }

    }

    //排行榜
    @RequestMapping(value = "/a/u/user/list", method = RequestMethod.GET)
    public String getUserList(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, Integer page, Integer size)
            throws Exception {
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        userLog.info("get user list " + uid);
        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 5;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {

            List<Long> userIds = userService.getUserIdsByStudyList(start, size);
            favoriteLog.info("================userids size" + userIds);
            List<User> userList = userService.getObjectsByIds(userIds);
//            favoriteLog.info("================useridlist size"+userList.size());


            model.addAttribute(userList);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            return "/common/success";
        }
        return "/learn-course-service/user/json/userStudyList";
    }

    /**
     * @Description 分享统计
     * @param
     * @Author: ShaoboLi
     * @Time 2017/2/16 17:31
     */
    @RequestMapping(value = "/a/u/share/stats", method = RequestMethod.PUT)
    public String addShareRecords(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model)
            throws Exception {

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        String invitationCode =user.getInvitationCode();
        try {
            //判断是不是推广人
            //是推广人则进行统计
            if (User.IS_MEMBER == user.getRecommendFlag()){
                UserRecommend userRecommend = userRecommendService.getObjectById(uid);
                if (userRecommend == null) {

                    //用户是推广人有邀请码但是无userRecommend数据（可能是老版本数据，补充userRecommend数据）
                    UserRecommend newUserRecommend = new UserRecommend();
                    newUserRecommend.setId(uid);
                    newUserRecommend.setLastShare(System.currentTimeMillis());
                    newUserRecommend.setShareCount(1);
                    userRecommendService.insert(newUserRecommend);
                    userLog.info("UserRecommend :  user Recommend is null, insert success");
                }else {

                    //记录最后分享时间；分享次数
                    userRecommend.setLastShare(System.currentTimeMillis());
                    userRecommend.setShareCount(userRecommend.getShareCount()+1);
                    userRecommendService.update(userRecommend);
                    userLog.info("UserRecommend :  user Recommend update success");
                }

            }

        } catch (Throwable t) {
            userLog.error(t.getMessage());
            userLog.error("update UserRecommend error,id is  " + uid);
            model.addAttribute("code", -1);
        }
        model.addAttribute("code",0);
        return "/common/success";
    }




    /**
     * 强制更新版本重定向到此请求
     *
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequestMapping(value = "/a/force/update/version", method = RequestMethod.GET)
    public String forceUpdate(HttpServletRequest request, HttpServletResponse response,
                              ModelMap model) {
        userLog.info("method forceUpdate begin...");

        try {
            Long constantIdByCode = constantService.getConstantIdByKeyAndType("code", "version");
            Long constantIdByIosCode = constantService.getConstantIdByKeyAndType("iosCode", "version");
            Long constantIdByAndCode = constantService.getConstantIdByKeyAndType("androidCode", "version");
            Long constantIdByUrl = constantService.getConstantIdByKeyAndType("url", "version");
            Long constantIdByIosName = constantService.getConstantIdByKeyAndType("iosName", "version");
            Long constantIdByAndroidName = constantService.getConstantIdByKeyAndType("androidName", "version");
            Long constantIdByInfo = constantService.getConstantIdByKeyAndType("info", "version");

            if (null != constantIdByCode && null != constantIdByUrl) {
                Constant constantByIosCode = constantService.getObjectById(constantIdByIosCode);
                Constant constantByAndCode = constantService.getObjectById(constantIdByAndCode);
                Constant constantByCode = constantService.getObjectById(constantIdByCode);
                Constant constantByUrl = constantService.getObjectById(constantIdByUrl);
                Constant constantByIosName = constantService.getObjectById(constantIdByIosName);
                Constant constantByAndroidName = constantService.getObjectById(constantIdByAndroidName);
                Constant constantByInfo = constantService.getObjectById(constantIdByInfo);

                String iosName = constantByIosName.getValue();
                String androidName = constantByAndroidName.getValue();
                String url = constantByUrl.getValue();
                String versionCode = constantByCode.getValue();
                String iosCode = constantByIosCode.getValue();
                String androidCode = constantByAndCode.getValue();
                String info = constantByInfo.getValue();

                model.addAttribute("url", url);
                model.addAttribute("iosName", iosName);
                model.addAttribute("androidName", androidName);
                model.addAttribute("info", info);
                model.addAttribute("versionCode", versionCode);
                model.addAttribute("iosCode", iosCode);
                model.addAttribute("androidCode", androidCode);

                userLog.info("get version : iosName =  " + iosName + " androidName " + androidName + " url = " + url +
                        " code = " + versionCode + " iosCode = " + iosCode + " androidCode = " + androidCode + " info = " + info);
            } else {
                userLog.info("no version");
            }

            model.addAttribute("code", -9);

        } catch (Exception e) {
            e.printStackTrace();
            userLog.error(e.getMessage());
            model.addAttribute("code", -9);
            return "/common/success";
        }

        return "/common/versionUpdate";
    }


    StringBuilder getUserId(Long uid) {

        char[] charSet = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
        char[] chars = String.valueOf(uid).toCharArray();
        Long time = System.currentTimeMillis();
        Stack<Character> stack = new Stack<>();
        stack.add(chars[chars.length - 1]);
        stack.add(chars[chars.length - 2]);
        StringBuilder result = new StringBuilder();
        while (time != 0) {
            stack.add(charSet[new Long(time % 62).intValue()]);
            time = time / 62;
        }
        for (int i = stack.size() - 1; i >= 0; i--) {
            result.append(stack.get(i));
        }
        return result;
    }
//@Test
//    public void getUserId() {
//
//        Long uid=165453L;
//        char[] chars=String.valueOf(uid).toCharArray();
//        Long time = System.currentTimeMillis();
//    System.out.println(System.currentTimeMillis());
//        Stack<Character> stack = new Stack<>();
//    StringBuilder stringBuilder = new StringBuilder();
//        stack.add(chars[chars.length - 1]);
//        stack.add(chars[chars.length - 2]);
//        StringBuilder result = new StringBuilder();
//        while (time != 0) {
//            stack.add(charSet[new Long(time%62).intValue()]);
//            time = time / 62;
//        }
//
//    System.out.println(stringBuilder);
//    }


    public String sendMailMsg(String mail, String type) throws ServiceException, ServiceDaoException {

        String code = "";
        String template = "";
        int count = 0;
        Sms sms = new Sms();

        if (type.equals("register")) {
            template = "sendRegisterMail";
        } else if (type.equals("password")) {
            template = "sendPwdMail";
        }
        userLog.info("template is :" + template);

        Long smsId = smsService.getSmsIdByMobileAndType(mail, type);
        userLog.info(" smsId = " + smsId);
        String returnString = "";
        // 已经请求过验证码
        if (smsId != null) {
            userLog.info(" didn't send sms ever ");
            // 检验每天发送次数
            sms = smsService.getObjectById(smsId);
            Format formatter = new SimpleDateFormat("d");
            String ftime = formatter.format(System.currentTimeMillis());
            String stime = formatter.format(sms.getSendAt());
            if (!ftime.equals(stime)) {
                sms.setCount(0);
            }
            int intNum = sms.getCount() + 1;
            String num = "" + intNum;
            if (sms.getCount() < 5) {
                userLog.info(" < 5   ");

                // 同类型30分钟内验证码相同
                Long delay = System.currentTimeMillis() - sms.getTypeSendAt();
                if (delay <= 1800000) {

                    userLog.info("30分钟内发送相同验证码");
                    code = sms.getMessage();

                    try {
                        returnString = mailUtil.sendSMSMail(mail, code, template);
                    } catch (Exception e) {
                        userLog.error(e.getMessage());
                    }

                    userLog.info("邮件发送返回值：" + returnString);

                    if (returnString.equals("-1")) {
                        return SmsService.ErrorCode_sendError;
                    } else if (returnString.equals("0")) {
                        // TODO 处理返回值,参见HTTP协议文档
                        sms.setSendAt(System.currentTimeMillis());
                        count = sms.getCount();
                        count += 1;
                        sms.setCount(count);
                        userLog.info("信息发送成功");
                    }

                } else {
                    userLog.info("30分钟外发送相同验证码");
                    // 生成验证码
                    Random rand = new Random();
                    for (int i = 0; i < 6; i++) {
                        code = code + rand.nextInt(10);
                    }
                    code = code.trim();

                    try {
                        returnString = mailUtil.sendSMSMail(mail, code, template);
                    } catch (Exception e) {
                        userLog.error(e.getMessage());
                    }

                    userLog.info("短信发送返回值：" + returnString);

                    if (returnString.equals("-1")) {
                        return SmsService.ErrorCode_sendError;
                    } else if (returnString.equals("0")) {
                        // TODO 处理返回值,参见HTTP协议文档;
                        sms.setSendAt(System.currentTimeMillis());
                        sms.setTypeSendAt(System.currentTimeMillis());
                        count = sms.getCount();
                        count += 1;
                        sms.setCount(count);
                        sms.setMessage(code);
                        userLog.info("超过30分钟发送新验证码");
                    }

                }
                smsService.update(sms);
            } else {
                userLog.info("count > 5 ");

                return smsService.ErrorCode_SMS_smsMoreThan5;
            }

            // 第一次发送请求
        } else {

            userLog.info(" first send code   ");
            // 生成验证码

            Random rand = new Random();
            for (int i = 0; i < 6; i++) {
                code = code + rand.nextInt(10);
            }
            code = code.trim();
            sms.setCount(0);
            int intNum = sms.getCount() + 1;
            String num = "" + intNum;

            // 发送邮件
            try {

                returnString = mailUtil.sendSMSMail(mail, code, template);

                userLog.info("短信发送返回值：" + returnString);
                if (returnString.equals("-1")) {
                    return SmsService.ErrorCode_sendError;
                } else if (returnString.equals("0")) {
                    // TODO 处理返回值,参见HTTP协议文档
                    count += 1;
                    // 保存sms对象信息
                    sms.setMobile(mail);
                    sms.setType(type);
                    sms.setMessage(code);
                    sms.setSendAt(System.currentTimeMillis());
                    sms.setTypeSendAt(System.currentTimeMillis());
                    sms.setCount(count);
                    Long ms = smsService.insert(sms);
                    userLog.info("发送成功！ 信息保存结果：" + ms);
                }

            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

        }

        return "";
    }


    public String dateTime() {
        Long time = System.currentTimeMillis();
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = format.format(time);
        return date;
    }

}