package com.ptteng.course.home.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ptteng.course.constant.TencentConstantConfig;
import com.ptteng.course.constant.WxConstantConfig;
import com.ptteng.course.util.ThreePartPropertiesUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.json.GsonUtil;
import com.qding.community.common.weixin.vo.WXUser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

/**
 * Created by asus on 2016/8/12.
 */
@Controller
public class TencentController {

    private static final Log log = LogFactory.getLog("qq");

    private static final Executor exec = Executors.newFixedThreadPool(3);
    private String accessToken = "";

    @RequestMapping(value = "/a/qq/openid/{code}", method = RequestMethod.GET)
    public String doGet(HttpServletRequest request, ModelMap model, HttpServletResponse response, @PathVariable String code) throws Exception {
        log.info("code : " + code + " get openid");

        try {

            log.info("==========1、获取token==========");
            String tokenUrl = ThreePartPropertiesUtil.getProperty("qqToken");
            tokenUrl = tokenUrl.replace("{appid}", TencentConstantConfig.appId);
            tokenUrl = tokenUrl.replace("{appkey}", TencentConstantConfig.key);
            tokenUrl = tokenUrl.replace("{code}", code);
            tokenUrl = tokenUrl.replace("{redirect}", TencentConstantConfig.redirect_uri);
            log.info("token url is " + tokenUrl);

            String tokenResponse = HttpClientUtil.sendGetRequest(tokenUrl, (String) null);
            log.info("tokenResponse:" + tokenResponse);

            String[] list = tokenResponse.split("&");
            log.info("list : " + list);
            String access_tokenMap = list[0];
            log.info("access_tokenMap:" + access_tokenMap);
            String access_token = access_tokenMap.split("=")[1];

            this.accessToken = access_token;
            log.info("token : " + access_token);

            log.info("==========2、获取openid==========");
            String openidUrl = ThreePartPropertiesUtil.getProperty("qqOpenid");
            openidUrl = openidUrl.replace("{token}", access_token);

            String openidResponse = HttpClientUtil.sendGetRequest(openidUrl, (String) null);
            log.info("openidResponse:" + openidResponse);

            String openidObj = getOpenidObj(openidResponse);
            log.info("openidObj : " + openidObj);

            String openid = GsonUtil.get("openid", openidObj);
            log.info("openid : " + openid);

            log.info("==========3、获取用户信息==========");
            String userUrl = ThreePartPropertiesUtil.getProperty("qqUser");
            userUrl = userUrl.replace("{token}", access_token);
            userUrl = userUrl.replace("{appid}", TencentConstantConfig.appId);
            userUrl = userUrl.replace("{openid}", openid);

            String userResponse = HttpClientUtil.sendGetRequest(userUrl, (String) null);
            log.info("userResponse:" + userResponse);

            String ret = GsonUtil.get("ret", userResponse);
            log.info("ret : " + ret);
            if ("0".equals(ret)) {
                log.info("userInfo success");
                String nickname = GsonUtil.get("nickname", userResponse);
                String figureurl_2 = GsonUtil.get("figureurl_2", userResponse);
                String gender = GsonUtil.get("gender", userResponse);
                model.addAttribute("message", "success");
                model.addAttribute("nickname", nickname);
                model.addAttribute("figureurl_2", figureurl_2);
                model.addAttribute("gender", gender);
            } else {
                log.info("userInfo fail");
                String msg = GsonUtil.get("msg", userResponse);
                model.addAttribute("code", ret);
                model.addAttribute("message", msg);
            }
            log.info("code : " + code);

            model.addAttribute("code", 0);
            model.addAttribute("openid", openid);

        } catch (Throwable t) {
            log.error("get openid error ");
            t.printStackTrace();
        }
        return "/tencent/getUser";
    }

    public static String getOpenidObj(String str) {
        StringBuffer sb = new StringBuffer();
        if (str != null) {
            for (int i = 10; i < str.length()-3; i++) {
                char c = str.charAt(i);

                sb.append(c);

            }
        }


        return sb.toString();
    }
}
