package com.ptteng.course.home.controller;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.course.util.DynamicUtil;
import com.ptteng.course.util.PaperModel;
import com.ptteng.course.util.TxtUtil;
import com.ptteng.course.util.mailUtil;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


/**
 * Paper  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class PaperController {
	private static final Log paperLog = LogFactory.getLog("paper");

	@Autowired
	private UserPaperRelationService userPaperRelationService;
	@Autowired
	private UserOrderService userOrderService;
	@Autowired
	private PaperService paperService;
	@Autowired
	private LessonService lessonService;
	@Autowired
	private PeriodService periodService;
	@Autowired
	private CookieUtil cookieUtil;
	@Autowired
	private SubjectService subjectService;
	@Autowired
	private BookService bookService;



	//13、用户资料列表
	@RequestMapping(value = "/a/u/user/paper/list", method = RequestMethod.GET)
	public String paperList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {

		Lesson lesson = new Lesson();
		Period period = new Period();
		Book book = new Book();
		String name = "";
		List<Long> orderIds = new ArrayList<>();
		List<UserOrder> orders = new ArrayList<>();
		Map<Long, String> orderId_name = new HashMap<>();

		if (null == page) {
			page = 1;
		}
		if (null == size) {
			size = 10;
		}
		int firstNmuber = (page - 1) * size;
		Boolean next = false;

		User user = (User) request.getAttribute("user");
		Long uid = user.getId();
		paperLog.info("get uid " + uid);

		paperLog.info("user : " + uid + " get favorite list");

		try {
			paperLog.info(" user is " + user);
			if (user == null) {
				model.addAttribute("code", -2000);
				return "/common/success";
			}

			paperLog.info("=====获取购买资料订单id=====");
			orderIds = userOrderService.getPaperUserOrderIdsByUid(uid,firstNmuber,size);
			paperLog.info("orderIds size : " + orderIds.size());
			if (CollectionUtils.isNotEmpty(orderIds)) {
				orders = userOrderService.getObjectsByIds(orderIds);
				for(UserOrder order : orders){
					paperLog.info("orderId : " + order.getId());
					if(UserOrder.ORDER_LPAPER == order.getBuyType()){
						lesson = lessonService.getObjectById(order.getTargetId());
						if(null == lesson){
							paperLog.info("data mistake , orderId " + order.getId() + " target lesson not exist");
							model.addAttribute("code", -4031);
							return "/common/success";
						}
						name = lesson.getName();
					}else if(UserOrder.ORDER_PPAPER == order.getBuyType()){
						period = periodService.getObjectById(order.getTargetId());
						if(null == period){
							paperLog.info("data mistake , orderId " + order.getId() + " target period not exist");
							model.addAttribute("code", -4032);
							return "/common/success";
						}
						name = period.getName();
					}else if(UserOrder.ORDER_BPAPER == order.getBuyType()){
						book = bookService.getObjectById(order.getTargetId());
						if(null == book){
							paperLog.info("data mistake , orderId " + order.getId() + " target book not exist");
							model.addAttribute("code", -4039);
							return "/common/success";
						}
						name = book.getName();
					}else{
						paperLog.info("data mistake , orderId " + order.getId() + " buy type error");
						model.addAttribute("code", -4040);
						return "/common/success";
					}
					orderId_name.put(order.getId(),name);
				}
				orders = userOrderService.getObjectsByIds(orderIds);
				Collections.sort(orders);
			}
			paperLog.info("user orderIds : " + orderIds);

			paperLog.info("   total = " + orderIds.size());
			Integer totalPage = (((orderIds.size() - 1)) / size) + 1;
			paperLog.info("   totalPage = " + totalPage);

			if (orderIds != null && orderIds.size() > 0) {
				if (size.equals(orderIds.size())) {
					next = true;
					orderIds = orderIds.subList(0, size);
				}
			}

			model.addAttribute("code", 0);
			model.addAttribute("next", next);
			model.addAttribute("page", page);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("orders", orders);
			model.addAttribute("orderId_name", orderId_name);

		} catch (Throwable t) {
			t.printStackTrace();
			paperLog.error(t.getMessage());
			paperLog.error("get user paper list error ");
			model.addAttribute("code", -1);
		}

		return "/learn-course-service/paper/json/userPaperList";
	}

	//14、用户资料详情
	@RequestMapping(value = "/a/u/paper/detail/{id}", method = RequestMethod.GET)
	public String paperDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

		String name = "";

		User user = (User) request.getAttribute("user");
		Long uid = user.getId();
		paperLog.info("get uid " + uid);

		paperLog.info("user : " + uid + " get favorite list");

		try {
			paperLog.info(" user is " + user);
			if (user == null) {
				model.addAttribute("code", -2000);
				return "/common/success";
			}

			UserOrder order = userOrderService.getObjectById(id);

			paperLog.info("=====检测订单是否存在=====");
			if(null == order){
				paperLog.info("order not exist");
				model.addAttribute("code", -3007);
				return "/common/success";
			}

			paperLog.info("=====检测订单是否属于登陆用户=====");
			if(!uid.equals(order.getUid())){
				paperLog.info("is not yours order");
				model.addAttribute("code", -3006);
				return "/common/success";
			}

			paperLog.info("=====获取购买资料课时列表id=====");
			Integer type = order.getBuyType();
			if(UserOrder.ORDER_LPAPER == type){
				Lesson lesson = lessonService.getObjectById(order.getTargetId());
				name = lesson.getName();
			}else if (UserOrder.ORDER_PPAPER == type){
				Period period = periodService.getObjectById(order.getTargetId());
				name = period.getName();
			}

			paperLog.info("name : " + name);

			model.addAttribute("code", 0);
			model.addAttribute("order", order);
			model.addAttribute("name", name);

		} catch (Throwable t) {
			t.printStackTrace();
			paperLog.error(t.getMessage());
			paperLog.error("get paper detail error ");
			model.addAttribute("code", -1);
		}

		return "/learn-course-service/paper/json/paperDetail";
	}

	//已经下架的课时，可以发送资料
	//8、发送资料邮件
	@RequestMapping(value = "/a/u/paper/{oid}", method = RequestMethod.POST)
	public String sendMail(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long oid) throws Exception {

		Process proc = null;
		String jsonTxt = "";
		String name = "";
		Boolean includePaper = false;

		List<PaperModel> paperModels = new ArrayList<>();
		List<String> urls = new ArrayList<>();

		User user = (User) request.getAttribute("user");
		Long uid = user.getId();
		paperLog.info("get uid " + uid);

		paperLog.info("user : " + uid + " send paper : " + oid + " mail ");

		try {

			UserOrder order = userOrderService.getObjectById(oid);

			paperLog.info("=====检测订单是否存在=====");
			if(null == order){
				paperLog.info("order not exist");
				model.addAttribute("code", -3007);
				return "/common/success";
			}

			paperLog.info("=====检测订单是否属于登陆用户=====");
			if(!uid.equals(order.getUid())){
				paperLog.info("is not yours order");
				model.addAttribute("code", -3006);
				return "/common/success";
			}

			paperLog.info("=====检测订单是否为资料订单=====");
			if(UserOrder.ORDER_LPAPER != order.getBuyType()&&UserOrder.ORDER_PPAPER != order.getBuyType()&&UserOrder.ORDER_BPAPER != order.getBuyType()){
				paperLog.info("is not paper order");
				model.addAttribute("code", -4038);
				return "/common/success";
			}

			Long targetId = order.getTargetId();

			paperLog.info("=====根据订单类型获取资料url=====");
			if(UserOrder.ORDER_PPAPER == order.getBuyType()){
				paperLog.info(" order buy type = "+UserOrder.ORDER_PPAPER);
				paperLog.info("period paper order");
				Period period = periodService.getObjectById(targetId);
				Long paperId = paperService.getPaperIdByPeriodId(targetId);
				if(null == paperId){
					paperLog.info("period not paper");
					model.addAttribute("code", -4026);
					return "/common/success";
				}
				Paper paper = paperService.getObjectById(paperId);
				paperLog.info(" paper url  = "+paper.getUrl());
				PaperModel paperModel = new PaperModel();
				paperModel.setName(period.getName());
				urls.clear();
				urls.add(paper.getUrl());
				paperLog.info("  urls = " + urls);
				paperModel.setUrl(urls);
				paperLog.info(" paperModel = "+paperModel);
				paperModels.add(paperModel);
				includePaper = true;



			}else if (UserOrder.ORDER_LPAPER == order.getBuyType()){
				paperLog.info("lesson paper order");
				Lesson lesson = lessonService.getObjectById(targetId);
				List<Long> pids = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(targetId, Period.status_normal , 0 , Integer.MAX_VALUE);
				List<Period> periods = periodService.getObjectsByIds(pids);
				for(Period period : periods){
					Long paperId = paperService.getPaperIdByPeriodId(period.getId());
					paperLog.info(" paperId = "+paperId);
					if(null != paperId){
						Paper paper = paperService.getObjectById(paperId);
						paperLog.info(" paper url  = "+paper.getUrl());
						PaperModel paperModel = new PaperModel();
						paperModel.setName(period.getName());
						urls.clear();
						urls.add(paper.getUrl());
						paperLog.info("  urls = "+urls);
						paperModel.setUrl(urls);
						paperLog.info(" paperModel = "+paperModel);
						paperModels.add(paperModel);
						includePaper = true;
					}
				}

				if(!includePaper){
					paperLog.info("lesson not paper");
					model.addAttribute("code", -4044);
					return "/common/success";
				}

				name = lesson.getName();

			}else if(UserOrder.ORDER_BPAPER == order.getBuyType()){
				paperLog.info("book paper order");
				Book book = bookService.getObjectById(targetId);
				List<Long> pids = periodService.getPeriodIdsByBookIDAndStatusOrderBySort(targetId, Period.status_normal , 0 , Integer.MAX_VALUE);
				List<Period> periods = periodService.getObjectsByIds(pids);
				for(Period period : periods){
					Long paperId = paperService.getPaperIdByPeriodId(period.getId());
					paperLog.info(" paperId = "+paperId);

					if(null != paperId){
						Paper paper = paperService.getObjectById(paperId);
						paperLog.info(" paper url = "+paper.getUrl());

						PaperModel paperModel = new PaperModel();
						paperModel.setName(period.getName());
						urls.clear();
						urls.add(paper.getUrl());
						paperLog.info(" usls = " + paperId);

						paperModel.setUrl(urls);
						paperLog.info(" paperModel = "+paperModel);
						paperModels.add(paperModel);
						includePaper = true;
					}
				}

				if(!includePaper){
					paperLog.info("book not paper");
					model.addAttribute("code", -4043);
					return "/common/success";
				}

				name = book.getName();
			}
			paperLog.info("name : " + name + " paperModels : " + paperModels);

			JSONObject obj1 = new JSONObject();
			obj1.put("file",paperModels);
			obj1.put("name","paper");

			JSONObject obj2 = new JSONObject();
			JSONArray array2 = new JSONArray();
			array2.put(obj1);
			obj2.put("file",array2);
			obj2.put("name","paper");

			JSONObject jsonObject = new JSONObject();
			JSONArray array3 = new JSONArray();
			array3.put(obj2);
			jsonObject.put("file",array3);
			jsonObject.put("name",targetId.toString());
			jsonObject.put("txtUrl", TxtUtil.path + targetId.toString() + ".txt");

			paperLog.info("  jsonObject =" + jsonObject);
			String jsonString = jsonObject.toString();

			jsonTxt = TxtUtil.creatTxtFile(targetId.toString());

			TxtUtil.writeTxtFile(jsonString, targetId.toString());

			paperLog.info("ready to execute shell : " + "python "+Paper.SCRIPT_DEV+"download_3.py  " + jsonTxt);
			proc = Runtime.getRuntime().exec("python "+Paper.SCRIPT_DEV+"download_3.py  " + jsonTxt);

			BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
			String line;
			while ((line = in.readLine()) != null) {
				paperLog.info("  line  " + line);
			}
			in.close();
			proc.waitFor();
			paperLog.info("execute finish");

			String paperLocation = Paper.PAPER_DEV + targetId.toString() + ".zip";

			mailUtil mailUtil = new mailUtil();
			paperLog.info("send mail : " + user.getNick() + " mail : " + user.getMail() + " paper : " + paperLocation);
			String mailResponse = mailUtil.sendMail(user.getNick(), user.getMail(), name, paperLocation);
			paperLog.info("send mail response : " + mailResponse);

			TxtUtil.deleteZipFile(targetId.toString());


			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			paperLog.error(t.getMessage());
			paperLog.error("send mail error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}


	//已经下架的课时，可以发送资料
	//8、会员直接发送资料邮件
	@RequestMapping(value = "/a/u/member/paper/{targetId}", method = RequestMethod.POST)
	public String sendMail(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long targetId, Integer type) throws Exception {

		Process proc = null;
		String jsonTxt = "";
		String name = "";
		Boolean includePaper = false;

		List<PaperModel> paperModels = new ArrayList<>();
		List<String> urls = new ArrayList<>();

		User user = (User) request.getAttribute("user");
		Long uid = user.getId();

		Long time1 = System.currentTimeMillis();
		paperLog.info("send member paper start =============================================================== start time :" + dateTime());
		paperLog.info("get uid " + uid);

		paperLog.info("member user : " + uid + " send paper : " + targetId + " mail ");

		try {

			Integer member = user.getMember();
			paperLog.info("user member status : " + member);
			if(User.IS_NOT_MEMBER == member){
				paperLog.info("user not member");
				model.addAttribute("code", -2018);
				return "/common/success";
			}

			paperLog.info("=====根据资料类型获取资料url=====");
			if(UserOrder.ORDER_PPAPER == type){
				paperLog.info("paper type = "+ UserOrder.ORDER_PPAPER);
				paperLog.info("period paper");
				Period period = periodService.getObjectById(targetId);
				Long paperId = paperService.getPaperIdByPeriodId(targetId);
				if(null == paperId){
					paperLog.info("period not paper");
					model.addAttribute("code", -4026);
					return "/common/success";
				}
				Paper paper = paperService.getObjectById(paperId);
				paperLog.info(" paper url  = "+paper.getUrl());
				PaperModel paperModel = new PaperModel();
				paperModel.setName(period.getName());
				urls.clear();
				urls.add(paper.getUrl());
				paperLog.info("  urls = " + urls);
				paperModel.setUrl(urls);
				paperLog.info(" paperModel = "+paperModel);
				paperModels.add(paperModel);
				includePaper = true;

			}else if (UserOrder.ORDER_LPAPER == type){
				paperLog.info("lesson paper");
				Lesson lesson = lessonService.getObjectById(targetId);
				List<Long> pids = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(targetId, Period.status_normal , 0 , Integer.MAX_VALUE);
				List<Period> periods = periodService.getObjectsByIds(pids);
				for(Period period : periods){
					Long paperId = paperService.getPaperIdByPeriodId(period.getId());
					paperLog.info(" paperId = "+paperId);
					if(null != paperId){
						Paper paper = paperService.getObjectById(paperId);
						paperLog.info(" paper url  = "+paper.getUrl());
						PaperModel paperModel = new PaperModel();
						paperModel.setName(period.getName());
						urls.clear();
						urls.add(paper.getUrl());
						paperLog.info("  urls = "+urls);
						paperModel.setUrl(urls);
						paperLog.info(" paperModel = "+paperModel);
						paperModels.add(paperModel);
						includePaper = true;
					}
				}

				if(!includePaper){
					paperLog.info("lesson not paper");
					model.addAttribute("code", -4044);
					return "/common/success";
				}

				name = lesson.getName();

			}else if(UserOrder.ORDER_BPAPER == type){
				paperLog.info("book paper order");
				Book book = bookService.getObjectById(targetId);
				List<Long> pids = periodService.getPeriodIdsByBookIDAndStatusOrderBySort(targetId, Period.status_normal , 0 , Integer.MAX_VALUE);
				List<Period> periods = periodService.getObjectsByIds(pids);
				for(Period period : periods){
					Long paperId = paperService.getPaperIdByPeriodId(period.getId());
					paperLog.info(" paperId = "+paperId);

					if(null != paperId){
						Paper paper = paperService.getObjectById(paperId);
						paperLog.info(" paper url = "+paper.getUrl());

						PaperModel paperModel = new PaperModel();
						paperModel.setName(period.getName());
						urls.clear();
						urls.add(paper.getUrl());
						paperLog.info(" usls = " + paperId);

						paperModel.setUrl(urls);
						paperLog.info(" paperModel = "+paperModel);
						paperModels.add(paperModel);
						includePaper = true;
					}
				}

				if(!includePaper){
					paperLog.info("book not paper");
					model.addAttribute("code", -4043);
					return "/common/success";
				}

				name = book.getName();
			}

			paperLog.info("send paper start time : " + dateTime());
			mailUtil.sendPaperByAsynchrony(name, paperModels, targetId, user, true);
			paperLog.info("send paper " + targetId + " success");
			paperLog.info("send paper end time : " + dateTime());

			Long endTime = System.currentTimeMillis();
			paperLog.info("send member paper end =============================================================== end time : " + dateTime() + " total time : " + (endTime-time1)/1000 + "s");
			model.addAttribute("code", 0);


		} catch (Throwable t) {
			t.printStackTrace();
			paperLog.error(t.getMessage());
			paperLog.error("send mail error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}


	//是否增加上下架搜索
	/**
	 * 条件搜索资料
	 * @param request
	 * @param response
	 * @param page
	 * @param size
	 * @param model
	 * @param subjectId
	 * @param lessonId
	 * @param periodId
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/paper/list", method = RequestMethod.GET)
	public String getMultiPaperJson(HttpServletRequest request,
									HttpServletResponse response,Integer page,Integer size, ModelMap model,Long subjectId,Long lessonId,Long periodId,Integer level,Integer type,Long bookId)
			throws Exception {
		paperLog.info("subjectId :"+subjectId+"lessonId"+lessonId+"periodId"+periodId+"level"+level);
		List<Long> idList = new ArrayList();

		if(page==null){

			page=1;
		}

		if(size == null){
			size=10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		User user = (User) request.getAttribute("user");
		Long uid = user.getId();
		Map<String, Object> param = DynamicUtil.getPaperList(subjectId, lessonId, periodId,bookId,level,type);
		Long userPaperId = null;
		try {
			idList = paperService.getIdsByDynamicCondition(Paper.class, param, start, size);
			List<Long> count = paperService.getIdsByDynamicCondition(Paper.class, param, 0, Integer.MAX_VALUE);
			List<Paper> paperList = paperService.getObjectsByIds(idList);
			paperLog.info("get  paper data is " + paperList);
			for (Paper paper : paperList) {
				lessonId=paper.getLessonId();
				periodId=paper.getPeriodId();
				subjectId=paper.getSubjectId();
				bookId=paper.getBookId();
				paperLog.info("get paper success");
				Lesson lesson = lessonService.getObjectById(lessonId);
				Period period = periodService.getObjectById(periodId);
				Subject subject = subjectService.getObjectById(subjectId);
				Book book = bookService.getObjectById(bookId);
				if (subject != null) {
					paper.setSubjectName(subject.getName());
				}
				if (lesson != null) {
					paper.setLeesonName(lesson.getName());
				}
				if (period != null) {
					paper.setPeriodName(period.getName());
				}
				if (book != null) {
					paper.setBookName(book.getName());
				}
				userPaperId=userPaperRelationService.getUserTargetRelationIdsByTypeAndUidAndTargetId(UserPaperRelation.TYPE_PPAPER, uid, paper.getId());
				if (userPaperId != null) {
					paper.setBuy(Paper.Buy);
				}
			}
			Integer total=count.size();
			model.addAttribute("code", 0);
			boolean next=false;
			if (idList.size() + start +1<= total) {
				next=true;
			}
			Integer totalPage=(total-1)/size+1;
			model.addAttribute("next", next);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total",total);

			model.addAttribute("paperList", paperList);

		} catch (Throwable t) {
			paperLog.error(t.getMessage());
			paperLog.error("get paper error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/paper/json/paperListJson";
	}




	public String dateTime(){
		Long time = System.currentTimeMillis();
		DateFormat format=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String date = format.format(time);
		return date;
	}
}

