package com.ptteng.course.home.controller;

import com.ptteng.learn.course.model.DictationLevel;
import com.ptteng.learn.course.model.DictationSubject;
import com.ptteng.learn.course.service.DictationLevelService;
import com.ptteng.learn.course.service.DictationSubjectService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * DictationSubject  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class DictationSubjectController {
	private static final Log log = LogFactory.getLog(DictationSubjectController.class);

	@Autowired
	private DictationSubjectService dictationSubjectService;

	@Autowired
	private DictationLevelService dictationLevelService;

	
	/**
	 * @Description 听写科目列表
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/17 14:56
	 */
	@RequestMapping(value = "/a/u/dictation/subject/list", method = RequestMethod.GET)
	public String getDictationSubjectList(HttpServletRequest request,
											   HttpServletResponse response, ModelMap model) throws Exception {

		log.info("get dictation subject list");

		try {
			List<Long> idList = dictationSubjectService.getIdsOnline(0, Integer.MAX_VALUE);
			List<DictationSubject> dictationSubjectList = dictationSubjectService.getObjectsByIds(idList);
			log.info("get  dictationSubject data is " + dictationSubjectList);

			Map<Long, List<DictationLevel>> sid_levels = new HashMap<>();
			for(DictationSubject subject : dictationSubjectList){
				List<Long> lidList = dictationLevelService.getIdsBySid(subject.getId());
				List<DictationLevel> dictationLevelList = dictationLevelService.getObjectsByIds(lidList);
				log.info("get subject : " + subject.getId() + " dictationLevel data is " + lidList);
				sid_levels.put(subject.getId(), dictationLevelList);
			}

			model.addAttribute("code", 0);			
			model.addAttribute("total",dictationSubjectList.size());

			model.addAttribute("dictationSubjectList", dictationSubjectList);
			model.addAttribute("sid_levels", sid_levels);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get dictationSubject error ");
			model.addAttribute("code", -1);
		}

		return "/learn-course-service/dictationSubject/json/dictationSubjectListJson";
	}
	
}

