package com.ptteng.course.home.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.GradeClassRelationService;
import com.ptteng.learn.course.service.LessonService;
import com.ptteng.learn.course.service.PeriodService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.learn.course.service.SubjectService;

/**
 * Subject  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class SubjectController {
	private static final Log log = LogFactory.getLog(SubjectController.class);

	@Autowired
	private SubjectService subjectService;
	@Autowired
	private GradeClassRelationService gradeClassRelationService;
	@Autowired
	private LessonService lessonService;
	@Autowired
	private PeriodService periodService;




    /**
     * 根据类型名字获得科目
	 * @param request
	 * @param response
	 * @param model
	 * @param page
	 * @param size
	 * @param name
	 * @param type
	 * @return
     * @throws Exception
     */
		@RequestMapping(value = "/a/u/grade/introduce", method = RequestMethod.GET)
	public String getSubjectIdsByNameAndTypeJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,String name,Integer type,Long subjectId,Long lessonId,Long periodId) throws Exception {


			Subject subject = null;
			Lesson lesson = null;
		try {
			if (subjectId != null) {
				 subject = subjectService.getObjectById(subjectId);
				if (null != subject) {

						List<Long> gradeIds = gradeClassRelationService.getGradeClassRelationIdsBySubject(subjectId, 0, Integer.MAX_VALUE);
						List<GradeClassRelation> gradeClassRelationList = gradeClassRelationService.getObjectsByIds(gradeIds);
						model.addAttribute("gradeClassRelationList", gradeClassRelationList);




				} else {
					model.addAttribute("code", 2);
					return "/common/success";
				}
			} else if (lessonId != null) {
				lesson = lessonService.getObjectById(lessonId);
				if (lesson != null) {
					subjectId = lesson.getSubject();
					subject = subjectService.getObjectById(subjectId);
				} else {
					model.addAttribute("code", 2);
					return "/common/success";
				}
				if (null != subject) {
					if (subject.getGradeType() == 1) {
						model.addAttribute("code", 2);
						return "/common/success";
					}
					if (subject.getGradeType() == 2) {
						List<Long> gradeIds = gradeClassRelationService.getGradeClassRelationIdsByLevel(subjectId, lesson.getLevel(), 0, Integer.MAX_VALUE);
						List<GradeClassRelation> gradeClassRelationList = gradeClassRelationService.getObjectsByIds(gradeIds);
						model.addAttribute("gradeClassRelationList", gradeClassRelationList);
					}
				} else {
					model.addAttribute("code", 2);
					return "/common/success";
				}

			} else if (periodId != null) {
				Period period = periodService.getObjectById(periodId);
				if (period != null) {
					subjectId = period.getSubjectID();
					lessonId = period.getLessonID();
					lesson = lessonService.getObjectById(lessonId);
					subjectId = lesson.getSubject();
					subject = subjectService.getObjectById(subjectId);
				} else {
					model.addAttribute("code", 2);
					return "/common/success";
				}
				if (null != subject) {
					if (subject.getGradeType() == 1) {
						model.addAttribute("code", 2);
						return "/common/success";
					}
					if (subject.getGradeType() == 2) {
						List<Long> gradeIds = gradeClassRelationService.getGradeClassRelationIdsByLevel(subjectId, lesson.getLevel(), 0, Integer.MAX_VALUE);
						List<GradeClassRelation> gradeClassRelationList = gradeClassRelationService.getObjectsByIds(gradeIds);
						model.addAttribute("gradeClassRelationList", gradeClassRelationList);
					}
				} else {
					model.addAttribute("code", 2);
					return "/common/success";
				}

			} else {
				model.addAttribute("code", -1001);
				return "/commom/success";
			}


			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get subject grade introduce error  id is");
			// for test
			model.addAttribute("code", -1);
		}

		return "/learn-course-service/subject/json/gradeIntroduceJson";
	}




	/**
	 * 查看详情
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/subject/{id}", method = RequestMethod.GET)
	public String getSubjectJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			Subject subject = subjectService.getObjectById(id);
			if (subject.getStatus() == 2) {
				model.addAttribute("code", -5048);
				return "/common/success";
			}
			log.info("get subject data is " + subject);
			List<Long> gradeIdList=gradeClassRelationService.getGradeClassRelationIdsBySubject(id,0,Integer.MAX_VALUE);
			List<GradeClassRelation> gradeClassRelationList = gradeClassRelationService.getObjectsByIds(gradeIdList);
			model.addAttribute("gradeClassRelationList", gradeClassRelationList);
			model.addAttribute("code", 0);

			model.addAttribute("subject", subject);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get subject error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/subject/json/subjectDetailJson";
	}
			
			

	

	/**
	 * 获得科目列表
	 * @param request
	 * @param response
	 * @param model
	 * @return
     * @throws Exception
     */
	@RequestMapping(value = "/a/u/subject/list", method = RequestMethod.GET)
	public String getMultiSubjectJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Integer page,Integer size)
			throws Exception {
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}


		List<Long> ids=null;

		try {
			log.info(subjectService);
			ids = subjectService.getSubjectIdsByStatusOrderBySort(Subject.status_normal, 0, Integer.MAX_VALUE);
			if (ids == null) {
				log.info("get subject error and ids is null");
				model.addAttribute("code", 2);
				return "/common/success";
			}
			List<Subject> subjectList = subjectService.getObjectsByIds(ids);

			log.info("get  subject data is " + subjectList);
			Integer total = subjectList.size();
			model.addAttribute("code", 0);
			boolean next=false;
			if (ids.size() + start +1<= total) {
				next=true;
			}
			Integer totalPage=(total-1)/size+1;
			model.addAttribute("next", next);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("subjectList", subjectList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get subject error,id is  " + ids);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/subject/json/subjectListJson";
	}



	/**
	 * @Description 根据用户年级获取科目列表
	 * @param 
	 * @Author: PeiyuFeng
	 * @Time 2017/3/9 12:33
	 */
	@RequestMapping(value = "/a/u/grade/subject/list", method = RequestMethod.GET)
	public String getGradeSubjectList(HttpServletRequest request, HttpServletResponse response, ModelMap model)
			throws Exception {

		List<Long> ids=null;

		User user = (User) request.getAttribute("user");
		Long uid = user.getId();
		log.info("get uid " + uid);

		log.info("get user : " + uid + " subject list");

		try {

			if (user == null) {
				model.addAttribute("code", -2000);
				return "/common/success";
			}else {
				log.info("user : " + user);
			}

			Integer grade = user.getGrade();
			log.info("user grade : " + grade);
			if(User.preGrade.equals(grade)){
				log.info("user grade are preschool");
				ids = subjectService.getSubjectIdsByStatusAndUserTypeOrderBySort(Subject.status_normal, Subject.user_type_preschool, 0 , Integer.MAX_VALUE);
			}else {
				log.info("user grade are primary school");
				ids = subjectService.getSubjectIdsByStatusAndUserTypeOrderBySort(Subject.status_normal, Subject.user_type_primaryschool, 0, Integer.MAX_VALUE);
			}
			log.info("user : " + uid + " subject size " + ids.size());

			List<Subject> subjectList = subjectService.getObjectsByIds(ids);

			model.addAttribute("code", 0);
			model.addAttribute("subjectList", subjectList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get user grade subject error,id is  " + ids);
			model.addAttribute("code", -1);
		}

		return "/learn-course-service/subject/json/subjectListJson";
	}
	
}

