package com.ptteng.course.home.controller;

import com.gemantic.common.util.StringUtil;
import com.ptteng.learn.course.model.Coupon;
import com.ptteng.learn.course.model.User;
import com.ptteng.learn.course.model.UserMemberRelation;
import com.ptteng.learn.course.service.CouponService;
import com.ptteng.learn.course.service.UserMemberRelationService;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Coupon  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CouponController {
	private static final Log log = LogFactory.getLog("Coupon");

	@Autowired
	private CouponService couponService;
	@Autowired
	private UserMemberRelationService userMemberRelationService;



	/**
	 * 卡券激活会员
	 * @param request
	 * @param response
	 * @param model
	 * @param coupon
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/coupon/active", method = RequestMethod.PUT)
	public String updateCouponJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Coupon coupon) throws Exception {

		log.info("update coupon : coupon= " + coupon);
		User user = (User)request.getAttribute("user");
		Long uid = user.getId();
		try {
			if(StringUtil.isEmpty(coupon.getNumber())){
				model.addAttribute("code", -6005);
				return "/common/success";
			}
			if(StringUtil.isEmpty(coupon.getPwd())){
				model.addAttribute("code", -6006);
				return "/common/success";
			}

			Long now = System.currentTimeMillis();

			//查找卡券,是否存在
			Coupon coupon1 =  couponService.getObjectById(Long.valueOf(coupon.getNumber()));
			if(DataUtils.isNullOrEmpty(coupon1)){
				model.addAttribute("code", -6000);
				return "/common/success";
			}else {
				//查看卡券状态，是否是未使用
				if(Coupon.UNUSE_STATUS == coupon1.getStatus()){
					//查看卡券是否已过期
					if(now.longValue()>=coupon1.getDeadline().longValue()){
						coupon1.setStatus(Coupon.OUTOFDATE_STATUS);
						couponService.update(coupon1);
						model.addAttribute("code", -6001);
						return "/common/success";
					}

					//查看密码是否正确
					if(coupon.getPwd().equals(coupon1.getPwd())){

					}else {
						model.addAttribute("code", -6004);
						return "/common/success";
					}

					coupon1.setStatus(Coupon.USED_STATUS);
					couponService.update(coupon1);

					Long endAt = 0L;
					Long startAt = 0L;

					//判断是开会员还是续费会员
					List<Long> userMemberRelationIds = userMemberRelationService.getUserMemberRelationIdsByUidAndStatus(uid, User.IS_MEMBER, 0, Integer.MAX_VALUE);
					if(CollectionUtils.isEmpty(userMemberRelationIds)){
						log.info(" user "+uid+" is not a member ");

						log.info("==========开会员逻辑==========");

						startAt = now;

					}else {
						List<UserMemberRelation> userMemberRelations = userMemberRelationService.getObjectsByIds(userMemberRelationIds);
						for (UserMemberRelation userMemberRelation : userMemberRelations) {
							log.info(" user member endAt is " + getDate(userMemberRelation.getEndAt()) + " now is " + getDate(now));
							if (userMemberRelation.getEndAt().longValue() >= endAt) {
								log.info(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is more than " + endAt);
								endAt = userMemberRelation.getEndAt().longValue();
							} else {
								log.info(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is less than " + endAt);
							}
						}
						log.info("final end at member time is : " + endAt);

						startAt = endAt;

					}

					//给用户添加会员记录
					UserMemberRelation userMemberRelation = new UserMemberRelation();
					userMemberRelation.setUid(uid);
					userMemberRelation.setCouponId(coupon1.getId());
					userMemberRelation.setName(coupon1.getName());
					userMemberRelation.setPrice(coupon1.getPrice());
					userMemberRelation.setPeriod(coupon1.getPeriod());
					userMemberRelation.setStatus(User.IS_MEMBER);
					userMemberRelation.setStartAt(startAt);

					Date startDate = new Date(startAt);
					Date endDate = DateUtils.addMonths(startDate, coupon1.getPeriod().intValue());

					endAt = endDate.getTime();
					userMemberRelation.setEndAt(endAt);
					log.info(" user "+uid+" member startAt = "+getDate(now)+" endAt = "+getDate(endAt));
					Long userMemberRelationId = userMemberRelationService.insert(userMemberRelation);
					log.info(" user "+uid+" member id is = "+userMemberRelationId);

				}else if(Coupon.USED_STATUS == coupon1.getStatus()){
					model.addAttribute("code", -6002 );
					return "/common/success";
				}else if(Coupon.OUTOFDATE_STATUS == coupon1.getStatus()){
					model.addAttribute("code", -6001);
					return "/common/success";
				}
			}

			couponService.update(coupon);

			model.addAttribute("code", 0);

			model.addAttribute("coupon", coupon);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update coupon error,id is  " + coupon.getId());
			model.addAttribute("code", -1);

		}

		return "/common/success";
	}
	public static String getDate(Long time){
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String date = "";

		if(null != time){
			date = dateFormat.format(new Date(time));
		}
		return  date;
	}



	
	
	
}

