package com.ptteng.course.util;

import com.ptteng.learn.course.model.Paper;
import com.ptteng.learn.course.model.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class mailUtil {

    private static final Log paperLog = LogFactory.getLog("paper");

    private static final Executor exec = Executors.newFixedThreadPool(3);

    static final String url = "http://www.sendcloud.net/webapi/mail.send_template.json";
    static final String apiUser = "dounixue_test_wbm1KP";
    static final String apiKey = "rED5IeXHeHqxzk2a";

    public static String sendPaperByAsynchrony(final String name,final List<PaperModel> paperModels,final Long targetId,final User user, boolean asynchrony) {
        paperLog.info("name is " + name + ",paperModels=" + paperModels + ",targetId is " + targetId + ",user is " + user);
        String result = "";

        if (asynchrony) {
            Runnable task = new Runnable() {
                @Override
                public void run() {
                    try {
                        sendPaper(name, paperModels, targetId, user);
                    } catch (Exception e) {
                        e.printStackTrace();
                        paperLog.info(e.getMessage());
                        paperLog.error("send mail thread error ");
                    }
                }
            };
            exec.execute(task);
        } else {
            try {
                sendPaper(name, paperModels, targetId, user);
            } catch (Exception e) {
                e.printStackTrace();
                paperLog.info(e.getMessage());
                paperLog.error("send mail thread error ");
            }
        }

        return result;
    }

    public static void sendPaper(String name, List<PaperModel> paperModels, Long targetId, User user) throws Exception {
        paperLog.info("name : " + name + " paperModels : " + paperModels);

        String jsonTxt = "";
        Process proc = null;

        JSONObject obj1 = new JSONObject();
        obj1.put("file",paperModels);
        obj1.put("name","paper");

        JSONObject obj2 = new JSONObject();
        JSONArray array2 = new JSONArray();
        array2.put(obj1);
        obj2.put("file",array2);
        obj2.put("name","paper");

        JSONObject jsonObject = new JSONObject();
        JSONArray array3 = new JSONArray();
        array3.put(obj2);
        jsonObject.put("file",array3);
        jsonObject.put("name",targetId.toString());
        jsonObject.put("txtUrl", TxtUtil.path + targetId.toString() + ".txt");

        paperLog.info("  jsonObject =" + jsonObject);
        String jsonString = jsonObject.toString();

        jsonTxt = TxtUtil.creatTxtFile(targetId.toString());

        TxtUtil.writeTxtFile(jsonString, targetId.toString());

        paperLog.info("ready to execute shell : " + "python "+ Paper.SCRIPT_DEV+"download_3.py  " + jsonTxt);
        proc = Runtime.getRuntime().exec("python "+Paper.SCRIPT_DEV+"download_3.py  " + jsonTxt);

        BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String line;
        while ((line = in.readLine()) != null) {
            paperLog.info("  line  " + line);
        }
        in.close();
        proc.waitFor();
        paperLog.info("execute finish");

        String paperLocation = Paper.PAPER_DEV + targetId.toString() + ".zip";

        mailUtil mailUtil = new mailUtil();
        paperLog.info("send mail : " + user.getNick() + " mail : " + user.getMail() + " paper : " + paperLocation);
		String mailResponse = mailUtil.sendMail(user.getNick(), user.getMail(), name, paperLocation);
		paperLog.info("send mail response : " + mailResponse);

		TxtUtil.deleteZipFile(targetId.toString());
    }

    public static String sendMail(String userName, String mailAdress, String periodName, String path) throws IOException {

        HttpClient httpclient = new DefaultHttpClient();
        HttpPost httpost = new HttpPost(url);

        String vars = "{\"to\": [\"" + mailAdress + "\"],\"sub\":{\"%name%\": [\"" + periodName + "\"],\"%user%\":[\"" + userName + "\"]}}";

        // 涉及到附件上传, 需要使用 MultipartEntity
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, null, Charset.forName("UTF-8"));
        entity.addPart("api_user", new StringBody(apiUser, Charset.forName("UTF-8")));
        entity.addPart("api_key", new StringBody(apiKey, Charset.forName("UTF-8")));
        entity.addPart("substitution_vars", new StringBody(vars, Charset.forName("UTF-8")));
        entity.addPart("template_invoke_name", new StringBody("sendpaper", Charset.forName("UTF-8")));
        entity.addPart("from", new StringBody("huijiaxuexi@dounixue.net", Charset.forName("UTF-8")));
        entity.addPart("fromname", new StringBody("回家学习", Charset.forName("UTF-8")));
        entity.addPart("subject", new StringBody("回家学习" + periodName + "学习资料！", Charset.forName("UTF-8")));
        entity.addPart("resp_email_id", new StringBody("true"));

        // 添加附件
        File file = new File(path);
        FileBody attachment = new FileBody(file, "application/octet-stream", "UTF-8");
        entity.addPart("files", attachment);

        httpost.setEntity(entity);

        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        Long startTime = System.currentTimeMillis();
        String startDate = format.format(startTime);

        // 请求
        paperLog.info("http start : " + startDate);
        HttpResponse response = httpclient.execute(httpost);

        Long endTime = System.currentTimeMillis();
        String endDate = format.format(endTime);
        paperLog.info("http end : " + endDate);

        // 处理响应
        if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) { // 正常返回
            // 读取xml文档
            String result = EntityUtils.toString(response.getEntity());
            paperLog.info(result);
        } else {
            paperLog.info("send mail error");
        }
        httpost.releaseConnection();
        return response + "";
    }

    public static String sendSMSMail(String mailAdress, String code, String template) throws IOException {

        HttpClient httpclient = new DefaultHttpClient();
        HttpPost httpost = new HttpPost(url);
        String resultCode = "";

        String vars = "{\"to\": [\"" + mailAdress + "\"],\"sub\":{\"%code%\":[\"" + code + "\"]}}";

        // 涉及到附件上传, 需要使用 MultipartEntity
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, null, Charset.forName("UTF-8"));
        entity.addPart("api_user", new StringBody(apiUser, Charset.forName("UTF-8")));
        entity.addPart("api_key", new StringBody(apiKey, Charset.forName("UTF-8")));
        entity.addPart("substitution_vars", new StringBody(vars, Charset.forName("UTF-8")));
        entity.addPart("template_invoke_name", new StringBody(template, Charset.forName("UTF-8")));
        entity.addPart("from", new StringBody("huijiaxuexi@dounixue.net", Charset.forName("UTF-8")));
        entity.addPart("fromname", new StringBody("回家学习", Charset.forName("UTF-8")));
        entity.addPart("subject", new StringBody("回家学习账号注册验证码", Charset.forName("UTF-8")));
        entity.addPart("resp_email_id", new StringBody("true"));

        httpost.setEntity(entity);

        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        Long startTime = System.currentTimeMillis();
        String startDate = format.format(startTime);

        // 请求
        paperLog.info("http start : " + startDate);
        HttpResponse response = httpclient.execute(httpost);

        Long endTime = System.currentTimeMillis();
        String endDate = format.format(endTime);
        paperLog.info("http end : " + endDate);

        // 处理响应
        if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) { // 正常返回
            // 读取xml文档
            String result = EntityUtils.toString(response.getEntity());
            paperLog.info(result);
            resultCode = "0";
        } else {
            paperLog.info("send mail error");
            resultCode = "-1";
        }
        httpost.releaseConnection();
//        return response + "";
        return resultCode;
    }


    public static void main(String[] args) throws IOException {
        mailUtil test = new mailUtil();
        test.sendMail("冯培宇", "fengpeiyu@ptteng.com", "公倍数问题", "C:\\Users\\asus\\Desktop\\TIM截图20170527001959.png");
//        test.sendSMSMail("fengpeiyu@ptteng.com", "123456", "sendPwdMail");
    }

    public String dateTime() {
        Long time = System.currentTimeMillis();
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = format.format(time);
        return date;
    }
}