package com.ptteng.course.home.controller;

import com.ptteng.course.constant.SinaConstantConfig;
import com.ptteng.course.constant.TencentConstantConfig;
import com.ptteng.course.util.ThreePartPropertiesUtil;
import com.ptteng.course.util.aliPayUtil.apacheCommonUtil.codec.Encoder;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.json.GsonUtil;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

/**
 * Created by asus on 2016/8/12.
 */
@Controller
public class WeiboController {

    private static final Log log = LogFactory.getLog("weibo");

    @Autowired
    private HttpClientUtil httpClientUtil;

    private static final Executor exec = Executors.newFixedThreadPool(3);
    private String accessToken = "";
    private String key = TencentConstantConfig.key;
    private String appid = TencentConstantConfig.appId;

    public WeiboController() {
        this.appid = TencentConstantConfig.appId;
        this.key = TencentConstantConfig.key;
    }

    @RequestMapping(value = "/a/wb/openid/{code}", method = RequestMethod.GET)
    public String doGet(HttpServletRequest request, ModelMap model, HttpServletResponse response, @PathVariable String code) throws Exception {
        log.info("code : " + code + " get openid");

        try {

            String tokenUrl = ThreePartPropertiesUtil.getProperty("wbToken");

            HashMap<String , String> params = new HashMap<>();
            params.put("client_id", SinaConstantConfig.key);
            params.put("client_secret", SinaConstantConfig.secret);
            params.put("grant_type", "authorization_code");
            params.put("code", code);
            params.put("redirect_uri", SinaConstantConfig.redirect_uri);
            log.info("params is " + params);

            String tokenResponse = httpClientUtil.sendPostRequest(tokenUrl, params,null,null);
            log.info("tokenResponse:" + tokenResponse);

            String access_token = GsonUtil.get("access_token", tokenResponse);
            String uid = GsonUtil.get("uid", tokenResponse);

            String userUrl = ThreePartPropertiesUtil.getProperty("wbUser");
            userUrl = userUrl.replace("{token}", access_token);
            userUrl = userUrl.replace("{uid}", uid);

            String userResponse = HttpClientUtil.sendGetRequest(userUrl, (String) null);
            log.info("userResponse:" + userResponse);

            JSONObject Obj = JSONObject.fromObject(userResponse);

            String nick = Obj.get("screen_name").toString();
            String img = Obj.get("profile_image_url").toString();

            model.addAttribute("code", 0);
            model.addAttribute("nick", nick);
            model.addAttribute("img", img);
            model.addAttribute("uid", uid);

        } catch (Throwable t) {
            log.error("get openid error ");
            t.printStackTrace();
        }
        return "/weibo/getUserInfo";
    }
}
