package com.ptteng.course.home.controller;

import com.ptteng.learn.admin.model.Constant;
import com.ptteng.learn.admin.model.Version;
import com.ptteng.learn.admin.service.ConstantService;
import com.ptteng.learn.admin.service.VersionService;
import com.ptteng.learn.course.model.Unit;
import com.ptteng.learn.course.model.User;
import com.ptteng.learn.course.model.UserUnitRelation;
import com.ptteng.learn.course.service.UnitService;
import com.ptteng.learn.course.service.UserUnitRelationService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * UserUnitRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserUnitRelationController {
	private static final Log log = LogFactory.getLog(UserUnitRelationController.class);

	@Autowired
	private UserUnitRelationService userUnitRelationService;
	@Autowired
	private UnitService unitService;
	@Autowired
	private ConstantService constantService;
	@Autowired
	private VersionService versionService;


	@RequestMapping(value = "/a/u/userunitrelation/{id}", method = RequestMethod.GET)
	public String getUserUnitRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			UserUnitRelation userUnitRelation = userUnitRelationService.getObjectById(id);
			log.info("get userUnitRelation data is " + userUnitRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userUnitRelation", userUnitRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userUnitRelation error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/learn-course-service/userUnitRelation/json/userUnitRelationDetailJson";
	}


	@RequestMapping(value = "/a/userunitrelation/share/{id}", method = RequestMethod.GET)
	public String getUserUnitRelation(HttpServletRequest request,
										  HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			UserUnitRelation userUnitRelation = userUnitRelationService.getObjectById(id);
			log.info("get userUnitRelation data is " + userUnitRelation);
			List<Long> andVids = versionService.getVersionIdsByOsOrderByVersionCode(Version.os_android, 0, Integer.MAX_VALUE);
			log.info("android version id list : " + andVids);

			if(CollectionUtils.isNotEmpty(andVids)){

				List<Version> andVersions = versionService.getObjectsByIds(andVids);
				Collections.sort(andVersions);
				Version andVersion = andVersions.get(0);
				log.info("android version : " + andVersion);

				model.addAttribute("appDownUrl", andVersion.getUrl());

			}else {
				log.info("no android version");
			}


			model.addAttribute("code", 0);

			model.addAttribute("userUnitRelation", userUnitRelation);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userUnitRelation error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/learn-course-service/userUnitRelation/json/userUnitRelationDetailJson";
	}



	@RequestMapping(value = "/a/u/userunitrelation/{id}", method = RequestMethod.PUT)
	public String updateUserUnitRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Integer score,String url,String text,@PathVariable Long id) throws Exception {
		
		log.info("update userUnitRelation : userUnitRelation= ");
		if (score == null) {
			model.addAttribute("code", -5055);
			return "/common/success";
		}
//		if (url == null) {
//			model.addAttribute("code", -5056);
//			return "/common/success";
//		}
//		if (text == null) {
//			model.addAttribute("code", -5057);
//			return "/common/success";
//		}
		try {
			UserUnitRelation userUnitRelation=userUnitRelationService.getObjectById(id);
			userUnitRelation.setScore(score);
			userUnitRelation.setUrl(url);
			userUnitRelation.setText(text);
			model.addAttribute("code", 0);

			model.addAttribute("userUnitRelation", userUnitRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update userUnitRelation error,id is  " + id);
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/userunitrelation", method = RequestMethod.POST)
	public String addUserUnitRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Integer score,String url,Long unitId) throws Exception {
		
		log.info("add userUnitRelation : unitId = " + unitId + " score = " + score + " url = " + url);
		User user = (User) request.getAttribute("user");
		Long uid = user.getId();
		try {
			UserUnitRelation userUnitRelation = new UserUnitRelation();
			userUnitRelation.setId(null);
			userUnitRelation.setUserId(uid);
			userUnitRelation.setUnitId(unitId);
			userUnitRelation.setScore(score);
			userUnitRelation.setUrl(url);
			Unit unit = unitService.getObjectById(unitId);
			log.info("unit = " + unit);
			if(null==unit) {
				model.addAttribute("code", -5058);
				return "/common/success";
			}
				userUnitRelation.setText(unit.getText());

			Long NewId=userUnitRelationService.insert(userUnitRelation);

			model.addAttribute("code", 0);
			model.addAttribute("newId", NewId);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add userUnitRelation error ");
			model.addAttribute("code", -1);
		}
//		/learn-course-service/userUnitRelation/json/userUnitRelation/userUnitRelationDetailJson
		return "/common/voiceSuccess";
	}

	@RequestMapping(value = "/a/u/userunitrelation/{id}", method = RequestMethod.DELETE)
	public String deleteUserUnitRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete userUnitRelation : id= " + id);
		try {
			userUnitRelationService.delete(id);

			log.info("add userUnitRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete userUnitRelation error,id is  " + id);
			model.addAttribute("code", -1);

		}

		return "/common/success";
	}
//
//
//	@RequestMapping(value = "/a/multi/userUnitRelation", method = RequestMethod.GET)
//	public String getMultiUserUnitRelationJson(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model, Long[] ids)
//			throws Exception {
//
//		List<Long> idList = new ArrayList();
//	   if (ids == null) {
//
//		} else {
//			idList = Arrays.asList(ids);
//		}
//		try {
//
//
//
//			List<UserUnitRelation> userUnitRelationList = userUnitRelationService.getObjectsByIds(idList);
//			log.info("get  userUnitRelation data is " + userUnitRelationList);
//
//			model.addAttribute("code", 0);
//			model.addAttribute("total",userUnitRelationList.size());
//
//			model.addAttribute("userUnitRelationList", userUnitRelationList);
//
//		} catch (Throwable t) {
//			log.error(t.getMessage());
//			log.error("get userUnitRelation error,id is  " + idList);
//			model.addAttribute("code", -100000);
//		}
//
//		return "/learn-course-service/userUnitRelation/json/userUnitRelationListJson";
//	}
//
	
	
	
	
}

