package com.ptteng.course.home.controller;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.common.model.Message;
import com.ptteng.learn.common.model.UserMessageRelation;
import com.ptteng.learn.common.service.MessageService;
import com.ptteng.learn.common.service.UserMessageRelationService;
import com.ptteng.learn.course.model.User;
import com.ptteng.learn.course.service.UserService;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * Message  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class MessageController {
	private static final Log log = LogFactory.getLog(MessageController.class);

	@Autowired
	private MessageService messageService;
	@Autowired
	private UserService userService;
	@Autowired
	private CookieUtil cookieUtil;
	@Autowired
	private UserMessageRelationService userMessageRelationService;


	/**
	 * 提交意见
	 * @param request
	 * @param response
	 * @param model
	 * @param content
	 * @return
     * @throws Exception
     */
	@RequestMapping(value = "/a/u/message", method = RequestMethod.POST)
	public String addMessageqJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,String content,Integer type) throws Exception {
		
		log.info("send message : message= " + content);
	type=3;
		User user = (User) request.getAttribute("user");
		try {
			Message message=new Message();
			message.setId(null);

			message.setMail(user.getMail());
			message.setContent(content);
			message.setUserId(user.getId());
			message.setNick(user.getNick());
			message.setType(type);
			message.setSort(1);
			messageService.insert(message);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add message error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}


	/**
	 * 根据条件搜索消息
	 * @param request
	 * @param response
	 * @param type
	 * @param page
	 * @param size
	 * @param model
	 * @param name
	 * @param messageType
	 * @param nick
	 * @param timeLow
	 * @param timeHigh
     * @param mail
     * @return
     * @throws Exception
     */
	@RequestMapping(value = "/a/u/message/list", method = RequestMethod.GET)
	public String getMultiMessageJson(HttpServletRequest request,
			HttpServletResponse response,Integer type, Integer page,Integer size,ModelMap model,String name,
									  Integer messageType,String nick,Long timeLow,Long timeHigh,String mail,Integer grade)
			throws Exception {
		User user = (User) request.getAttribute("user");
		List<Long> idList = new ArrayList();
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		Integer totalType=0;
		try {
			Map<String, Object> param = DynamicUtil.getMessageList(user.getGrade(),name, messageType, nick, timeLow, timeHigh, mail,type,user.getId());
			idList = messageService.getIdsByDynamicCondition(Message.class, param, start, size);
			List<Long> count = messageService.getIdsByDynamicCondition(Message.class, param, 0, Integer.MAX_VALUE);
			List<Message> messageList = messageService.getObjectsByIds(idList);
			log.info("get  message data is " + messageList);
			if (type==1) {
				Long userTime = user.getCreateAt();
				Message message = null;
				int m=0;
				for (int i=0;i<messageList.size();i++) {
					message = messageList.get(i);
					if (userTime > message.getPublishAt()) {
						m++;
					}
				}
				if (m>0) {
					for(int n=m;n>0;n--) {
						messageList.remove(messageList.size() - 1);
					}
				}
				List<Message> countList = messageService.getObjectsByIds(idList);
				m=0;
				for (int i=0;i<messageList.size();i++) {
					message = messageList.get(i);
					if (userTime > message.getPublishAt()) {
						m++;
					}
				}
				if (m>0) {
					for (int n = m; n > 0; n--) {
						messageList.remove(messageList.size() - 1);
					}
				}
				totalType = messageList.size();
			}
			Integer total=count.size();
			if (type == 1) {
				total = totalType;
			}
			model.addAttribute("code", 0);
			boolean next=false;
			if (idList.size() + start +1<= total) {
				next=true;
			}
			Integer totalPage=(total-1)/size+1;
			model.addAttribute("next", next);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("messageList", messageList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get message error,id is  " + idList);
			model.addAttribute("code", -1);
		}

		return "/learn-course-service/message/json/messageListJson";
	}


	/**
	 * 获得消息列表
	 * @param request
	 * @param response
	 * @param model
	 * @param page
	 * @param size
	 * @return
     * @throws Exception
     */
	@RequestMapping(value = "/a/u/user/message/list", method = RequestMethod.GET)
	public String getMessageJson(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model,Integer page,Integer size)
			throws Exception {
		User user = (User) request.getAttribute("user");
		Long uid = user.getId();
		log.info("get data : user id= " + uid);
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		try {
			List<Long> messageAndUserIds = userMessageRelationService.getUserMessageRelationIdsByNick(uid, start, size);
			List<UserMessageRelation> userMessageRelationList = userMessageRelationService.getObjectsByIds(messageAndUserIds);
			Message message = new Message();
			Long messageId = null;
			for (UserMessageRelation userMessageRelation : userMessageRelationList) {
				messageId = userMessageRelation.getTargetId();
				message = messageService.getObjectById(messageId);
				userMessageRelation.setContent(message.getContent());
				userMessageRelation.setTitle(message.getName());
				userMessageRelation.setUrl(message.getUrl());
			}
			Map<String, Object> param = DynamicUtil.getUserMessageList(null, uid, UserMessageRelation.notRead);
			Map<String, Object> countParam = DynamicUtil.getUserMessageList(null, uid, null);
			List<Long> countUnRead = userMessageRelationService.getIdsByDynamicCondition(UserMessageRelation.class, param, 0, Integer.MAX_VALUE);
			List<Long> countMessage = userMessageRelationService.getIdsByDynamicCondition(UserMessageRelation.class, countParam, 0, Integer.MAX_VALUE);
			model.addAttribute("totalMessage", countMessage.size());
			model.addAttribute("unRead", countUnRead.size());
			model.addAttribute("code", 0);

			model.addAttribute("userMessageRelationList", userMessageRelationList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get messagelist error,id is  "  );
			model.addAttribute("code", -1);
		}

		return "/learn-course-service/message/json/userMessageRelationListJson";
	}

	/**
	 * 删除消息
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
     * @throws Exception
     */
	@RequestMapping(value = "/a/u/user/message/{id}", method = RequestMethod.DELETE)
	public String deleteUserMessageRelationJson(HttpServletRequest request,
												HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete userMessageRelation : id= " + id);
		try {
			userMessageRelationService.delete(id);

			log.info("add userMessageRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete userMessageRelation error,id is  " + id);
			model.addAttribute("code", -1);

		}

		return "/common/success";
	}


	/**
	 * 阅读消息详情
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
     * @throws Exception
     */
	@RequestMapping(value = "/a/u/user/message/{id}", method = RequestMethod.GET)
	public String getUserMessageRelationJson(HttpServletRequest request,
											 HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			UserMessageRelation userMessageRelation = userMessageRelationService.getObjectById(id);
			log.info("get userMessageRelation data is " + userMessageRelation);
			Long messageId = userMessageRelation.getTargetId();
			Message message = messageService.getObjectById(messageId);
			userMessageRelation.setContent(message.getContent());
			userMessageRelation.setTitle(message.getName());
			userMessageRelation.setUrl(message.getUrl());
			userMessageRelation.setUserRead(UserMessageRelation.read);
			userMessageRelationService.update(userMessageRelation);
			model.addAttribute("code", 0);

			model.addAttribute("userMessageRelation", userMessageRelation);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userMessageRelation error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/learn-course-service/message/json/userMessageRelationDetailJson";
	}

	@RequestMapping(value = "/a/u/message/{id}", method = RequestMethod.GET)
	public String getMessageJson(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Message message = messageService.getObjectById(id);
			log.info("get message data is " + message);

			model.addAttribute("code", 0);

			model.addAttribute("message", message);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get message error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/message/json/messageDetailJson";
	}

}

