package com.ptteng.course.home.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.DictationSubjectService;
import com.ptteng.learn.course.service.DictationWordsService;
import com.ptteng.learn.course.service.UserDsubjectRelationService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.learn.course.service.DictationNoteService;

/**
 * DictationNote  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class DictationNoteController {
    private static final Log log = LogFactory.getLog(DictationNoteController.class);

    @Autowired
    private DictationNoteService dictationNoteService;

    @Autowired
    private DictationSubjectService dictationSubjectService;

    @Autowired
    private DictationWordsService dictationWordsService;

    @Autowired
    private UserDsubjectRelationService userDsubjectRelationService;

    @Autowired
    private CookieUtil cookieUtil;


    /**
     * @param
     * @Description 获取用户某科目错词本分组
     * @Author: PeiyuFeng
     * @Time 2017/5/22 11:38
     */
    @RequestMapping(value = "/a/u/user/dictation/note/{sid}", method = RequestMethod.GET)
    public String getUserDictationNoteList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                           @PathVariable Long sid) throws Exception {

        log.info("get user dictation note : subject id= " + sid);

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        try {
            DictationSubject subject = dictationSubjectService.getObjectById(sid);
            if(subject == null){
                log.info("subject not exist");
                model.addAttribute("code", -2106);
                return "/common/success";
            }

            Long nid = 0L;
            List<Long> nids = dictationNoteService.getDictationNoteIdsByUidAndSid(uid, sid);
            log.info("get dictationNote ids is " + nids);
            Long rid = userDsubjectRelationService.getUserDsubjectRelationIdsByUidAndSid(uid, sid);

            if (CollectionUtils.isEmpty(nids)) {
                DictationNote note = new DictationNote();
                note.setUid(uid);
                note.setSid(sid);
                note.setDefaultStatus(DictationNote.DEFAULT);
                note.setWordCount(0);
                note.setName("未分组词汇");
                nid = dictationNoteService.insert(note);

                nids.add(nid);
                log.info("add default note : " + nid);
            } else {
                log.info("get dictationNote ids is " + nids);

                nid = dictationNoteService.getDefaultDictationNoteIdByUidAndSid(uid, sid);

            }

            if(rid == null){
                UserDsubjectRelation userDsubjectRelation = new UserDsubjectRelation();
                userDsubjectRelation.setRecheckNum(20);
                userDsubjectRelation.setDefaultNoteId(nid);
                userDsubjectRelation.setDefaultNoteStatus(UserDsubjectRelation.DEFAULT_NOTE);
                userDsubjectRelation.setLastNoteId(nid);
                userDsubjectRelation.setSubjectId(sid);
                userDsubjectRelation.setUserId(uid);
                rid = userDsubjectRelationService.insert(userDsubjectRelation);
                log.info("add user : " + uid + " subject : " + sid + " relation");
            }else {
                log.info("get rid : " + rid );
            }

            UserDsubjectRelation relation = userDsubjectRelationService.getObjectById(rid);
            model.addAttribute("defaultStatus", relation.getDefaultNoteStatus());
            model.addAttribute("defaultNoteId", relation.getDefaultNoteId());
            model.addAttribute("lastNoteId", relation.getLastNoteId());

            List<DictationNote> notes = dictationNoteService.getObjectsByIds(nids);

            Integer wordCount = 0;
            for(DictationNote note : notes){
                wordCount = wordCount + note.getWordCount();
            }

            model.addAttribute("code", 0);
            model.addAttribute("wordCount", wordCount);
            model.addAttribute("dictationNoteList", notes);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get dictationNote error, subject id is  " + sid);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/dictationNote/json/dictationNoteListJson";
    }


    /**
     * @param
     * @Description 获取用户分组错词
     * @Author: PeiyuFeng
     * @Time 2017/5/22 12:54
     */
    @RequestMapping(value = "/a/u/dictation/note/word/{id}", method = RequestMethod.GET)
    public String getDictationNoteWord(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                       @PathVariable Long id, Integer page, Integer size) throws Exception {

        log.info("get dictation note word : id = " + id);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        try {
            DictationNote note = dictationNoteService.getObjectById(id);
            if (note == null) {
                log.info("no such dictation note");
                model.addAttribute("code", -2200);
                return "/common/success";
            } else {
                if (uid.equals(note.getUid())) {
                    log.info("note " + id + " belong to user : " + uid);
                } else {
                    log.info("note " + id + " not belong to user : " + uid);
                    model.addAttribute("code", -2205);
                    return "/common/success";
                }
            }

            List<Long> wordIds = dictationWordsService.getDictationWordsIdsByNid(id, start, size);
            log.info("get  words data is " + wordIds.size());

            List<DictationWords> words = dictationWordsService.getObjectsByIds(wordIds);

            List<Long> wordsCountIds = dictationWordsService.getDictationWordsIdsByNid(id, 0, Integer.MAX_VALUE);

            Integer wordsCount = wordsCountIds.size();
            Integer totalPage = (((wordsCount - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);

            Boolean next = false;
            if (wordIds != null && wordIds.size() > 0) {
                if (size.equals(wordIds.size())) {
                    next = true;
                }
            }

            //更新用户科目关系中的最后查阅分组
            Long rid = userDsubjectRelationService.getUserDsubjectRelationIdsByUidAndSid(uid, note.getSid());
            UserDsubjectRelation relation = userDsubjectRelationService.getObjectById(rid);
            relation.setLastNoteId(id);
            userDsubjectRelationService.update(relation);

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("dictationWordsList", words);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get dictation note word error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/learn-course-service/dictationWords/json/dictationWordsListJson";
    }


    /**
     * @param
     * @Description 新建错词本分组
     * @Author: PeiyuFeng
     * @Time 2017/5/22 13:30
     */
    @RequestMapping(value = "/a/u/dictation/note", method = RequestMethod.POST)
    public String addDictationNoteJson(HttpServletRequest request,
                                       HttpServletResponse response, ModelMap model, String name, Long sid) throws Exception {

        log.info("add dictationNote : " + name);

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        if (DataUtils.isNullOrEmpty(name) || DataUtils.isNullOrEmpty(sid)) {
            log.info("params is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        } else {
            //校验科目id
            DictationSubject subject = dictationSubjectService.getObjectById(sid);
            if (subject == null) {
                log.info("subject not exist");
                model.addAttribute("code", -2106);
                return "/common/success";
            } else {
                log.info("get subject name info : " + subject.getName());
            }

            Long oldId = dictationNoteService.getDictationNoteIdsByUidAndSidAndName(uid, sid, name);
            if (oldId != null) {
                log.info("same name note exist");
                model.addAttribute("code", -2206);
                return "/common/success";
            } else {
                log.info("no same name note");
            }
        }

        try {
            DictationNote note = new DictationNote();
            note.setUid(uid);
            note.setName(name);
            note.setWordCount(0);
            note.setDefaultStatus(DictationNote.NOT_DEFAULT);
            note.setSid(sid);

            dictationNoteService.insert(note);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add dictationNote error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @Description 获取该科目所有错词
     * @Author: PeiyuFeng
     * @Time 2017/5/22 13:55
     */
    @RequestMapping(value = "/a/u/dictation/words/{id}", method = RequestMethod.GET)
    public String deleteDictationNoteJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                          @PathVariable Long id, Integer page, Integer size) throws Exception {

        log.info("get dictation words : sid= " + id);

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            DictationSubject Subject = dictationSubjectService.getObjectById(id);

            if (null == Subject) {
                log.info("old subject is null ");
                model.addAttribute("code", -2106);
                return "/common/success";
            }

            Map<String, Object> params = DynamicUtil.getDictationWordsList(id, uid);

            List<Long> wids = dictationWordsService.getIdsByDynamicCondition(DictationWords.class, params, start, size);
            log.info("get  words data is " + wids.size());

            List<DictationWords> words = dictationWordsService.getObjectsByIds(wids);

            List<Long> wordsCountIds = dictationWordsService.getIdsByDynamicCondition(DictationWords.class, params, 0, Integer.MAX_VALUE);
            Integer wordsCount = wordsCountIds.size();
            Integer totalPage = (((wordsCount - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);

            Boolean next = false;
            if (wids != null && wids.size() > 0) {
                if (size.equals(wids.size())) {
                    next = true;
                }
            }

            Long rid = userDsubjectRelationService.getUserDsubjectRelationIdsByUidAndSid(uid, id);
            UserDsubjectRelation relation = userDsubjectRelationService.getObjectById(rid);
            relation.setLastNoteId(0L);
            userDsubjectRelationService.update(relation);

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("dictationWordsList", words);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get dictation words error, sid is  " + id);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/dictationWords/json/dictationWordsListJson";
    }


    /**
     * @param
     * @Description 添加错词
     * @Author: PeiyuFeng
     * @Time 2017/5/22 14:24
     */
    @RequestMapping(value = "/a/u/dictation/word", method = RequestMethod.POST)
    public String getMultiDictationNoteJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                            DictationWords word) throws Exception {

        if (word == null) {
            log.info("word is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if (word.getVoiceJson() == null || word.getNid() == null|| word.getType() == null || word.getPid() == null) {
            model.addAttribute("code", -1000);
            return "/common/success";
        } else {
            log.info("params OK");
        }

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        try {

            //校验科目id
            DictationNote note = dictationNoteService.getObjectById(word.getNid());
            if (note == null) {
                log.info("note not exist");
                model.addAttribute("code", -2200);
                return "/common/success";
            } else {
                log.info("get note name info : " + note.getName());
                if (uid.equals(note.getUid())) {
                    log.info("note " + word.getNid() + " belong to user : " + uid);
                } else {
                    log.info("note " + word.getNid() + " not belong to user : " + uid);
                    model.addAttribute("code", -2205);
                    return "/common/success";
                }
            }

            Map<String, Object> params = DynamicUtil.getDictationWord(word.getImg(), word.getContent(), word.getType(), uid, word.getPid());
            List<Long> idList = dictationWordsService.getIdsByDynamicCondition(DictationWords.class, params, 0, 1);

            if(CollectionUtils.isNotEmpty(idList)){
                log.info("already save the word : " + word + " in : word id : " + idList.get(0));
                model.addAttribute("code", -2207);
                return "/common/success";
            }else {
                log.info("verify OK");
            }

            word.setId(null);

            word.setCreateAt(System.currentTimeMillis());
            word.setCreateBy(uid);
            dictationWordsService.insert(word);

            Integer wordCount = note.getWordCount();
            note.setWordCount(wordCount + 1);
            log.info("note : " + word.getNid() + " wordCount : " + wordCount + " >>>>>>>>>> " + note.getWordCount());
            dictationNoteService.update(note);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("add dictation word error, word is  " + word);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @Description 删除错词
     * @Author: PeiyuFeng
     * @Time 2017/5/23 12:41
     */
    @RequestMapping(value = "/a/u/dictation/word", method = RequestMethod.DELETE)
    public String deleteWords(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long ids[]) throws Exception {

        if (ids == null) {
            log.info("word ids is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        log.info("delete user dictation lesson : ids= " + ids);

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        try {
            List<Long> idList = Arrays.asList(ids);
            List<DictationNote> notes = new ArrayList<>();

            List<Long> wids = new ArrayList<>();
            List<DictationWords> words = dictationWordsService.getObjectsByIds(idList);
            for (DictationWords word : words) {
                if (word != null) {
                    DictationNote note = new DictationNote();

                    //遍历已获取note列表中是否包含该单词所属note
                    Boolean include = false;
                    for (DictationNote noteInList : notes) {
                        if (noteInList.getId().equals(word.getNid())) {
                            include = true;

                            wids.add(word.getId());

                            Integer wordCount = noteInList.getWordCount();
                            noteInList.setWordCount(wordCount - 1);
                            log.info("note : " + word.getNid() + " wordCount : " + wordCount + " >>>>>>>>>> " + noteInList.getWordCount());
                        }
                    }

                    //notes中无该词所属词组时，将note中单词数-1加入notes
                    if (!include) {
                        note = dictationNoteService.getObjectById(word.getNid());
                        if (note != null) {
                            if (uid.equals(note.getUid())) {
                                wids.add(word.getId());

                                Integer wordCount = note.getWordCount();
                                note.setWordCount(wordCount - 1);
                                log.info("note : " + word.getNid() + " wordCount : " + wordCount + " >>>>>>>>>> " + note.getWordCount());

                                notes.add(note);
                            } else {
                                log.info("the word : " + word.getId() + " not belong to user : " + uid);
                            }
                        } else {
                            log.info("words : " + word.getId() + " no note");
                        }
                    } else {

                    }
                } else {
                    log.info("word : " + word.getId() + " not exist");
                }
            }

            dictationWordsService.deleteList(DictationWords.class, wids);
            dictationNoteService.updateList(notes);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("delete dictation word error, word is  " + ids);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @Description 错词移到对应分组
     * @Author: PeiyuFeng
     * @Time 2017/5/23 13:04
     */
    @RequestMapping(value = "/a/u/dictation/word/note", method = RequestMethod.PUT)
    public String MoveWords(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long nid, Long ids[]) throws Exception {

        if (nid == null || ids == null) {
            log.info("params is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        log.info("move user dictation words : " + ids + " to note : " + nid);

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        try {
            List<Long> idList = Arrays.asList(ids);

            List<Long> wids = new ArrayList<>();
            List<DictationWords> words = dictationWordsService.getObjectsByIds(idList);
            for (DictationWords word : words) {
                if (word != null) {
                    DictationNote note = dictationNoteService.getObjectById(word.getNid());
                    if (note != null) {
                        if (uid.equals(note.getUid())) {
                            word.setNid(nid);
                            note.setWordCount(note.getWordCount() - 1);
                            dictationNoteService.update(note);

                            DictationNote newNote = dictationNoteService.getObjectById(nid);
                            newNote.setWordCount(newNote.getWordCount() + 1);
                            dictationNoteService.update(newNote);
                        } else {
                            log.info("the word : " + word.getId() + " not belong to user : " + uid);
                        }
                    } else {
                        log.info("words : " + word.getId() + " no note");
                    }

                } else {
                    log.info("word : " + word.getId() + " not exist");
                }
            }

            dictationWordsService.updateList(words);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("delete dictation word error, word is  " + ids);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @Description 重命名错词本分组
     * @Author: PeiyuFeng
     * @Time 2017/5/23 13:22
     */
    @RequestMapping(value = "/a/u/dictation/note/{id}", method = RequestMethod.PUT)
    public String renameNote(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name,
                             @PathVariable Long id) throws Exception {

        if (DataUtils.isNullOrEmpty(name)) {
            log.info("name is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        log.info("rename dictation note : " + id + " to : " + name);

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        try {

            DictationNote note = dictationNoteService.getObjectById(id);
            if (note != null) {
                if (uid.equals(note.getUid()) && DictationNote.NOT_DEFAULT.equals(note.getDefaultStatus())) {
                    Long oldId = dictationNoteService.getDictationNoteIdsByUidAndSidAndName(uid, note.getSid(), name);
                    if (oldId != null) {
                        log.info("same name note exist");
                        model.addAttribute("code", -2206);
                        return "/common/success";
                    } else {
                        log.info("no same name note");
                        note.setName(name);
                    }
                } else if (!uid.equals(note.getUid())) {
                    log.info("the note : not belong to user : " + uid);
                    model.addAttribute("code", -2201);
                    return "/common/success";
                } else {
                    log.info("the note is default note");
                    model.addAttribute("code", -2202);
                    return "/common/success";
                }

            } else {
                log.info("note not exist");
                model.addAttribute("code", -2200);
                return "/common/success";
            }

            dictationNoteService.update(note);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("update dictation note error, id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @Description 删除错词本分组
     * @Author: PeiyuFeng
     * @Time 2017/5/23 14:19
     */
    @RequestMapping(value = "/a/u/dictation/note/{id}", method = RequestMethod.DELETE)
    public String deleteNote(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id,
                             Integer type) throws Exception {

        if (type == null) {
            log.info("type is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        } else if (type != 1 && type != 2) {
            log.info("type is wrong");
            model.addAttribute("code", -1000);
            return "/common/success";
        } else {
            log.info("type verify OK");
        }

        log.info("delete dictation note : " + id + " type : " + type);

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        try {

            DictationNote note = dictationNoteService.getObjectById(id);
            if (note != null) {

                List<Long> rids = userDsubjectRelationService.getUserDsubjectRelationIdsByUid(uid, 0, Integer.MAX_VALUE);
                List<UserDsubjectRelation> relations = userDsubjectRelationService.getObjectsByIds(rids);
                List<Long> defaultIds = MyListUtil.getFieldValueListFromModelList(relations, false, UserDsubjectRelation.class.getDeclaredField("defaultNoteId"));

                if (uid.equals(note.getUid()) && DictationNote.NOT_DEFAULT.equals(note.getDefaultStatus()) && !defaultIds.contains(id)) {
                    dictationNoteService.delete(id);
                    List<Long> wids = dictationWordsService.getDictationWordsIdsByNid(id, 0, Integer.MAX_VALUE);
                    if (type == 1) {
                        log.info("type 1 , delete all words in note : " + id);
                        dictationWordsService.deleteList(DictationWords.class, wids);
                    } else {
                        Long defaultNoteId = dictationNoteService.getDefaultDictationNoteIdByUidAndSid(uid, note.getSid());
                        log.info("get default note : " + defaultNoteId);

                        log.info("type 2 , move all words in note : " + id + " into default note : " + defaultNoteId);
                        List<DictationWords> words = dictationWordsService.getObjectsByIds(wids);

                        DictationNote defaultNote = dictationNoteService.getObjectById(defaultNoteId);
                        defaultNote.setWordCount(defaultNote.getWordCount() + wids.size());
                        dictationNoteService.update(defaultNote);
                        for (DictationWords word : words) {
                            word.setNid(defaultNoteId);
                        }

                        dictationWordsService.updateList(words);
                    }
                } else if (!uid.equals(note.getUid())) {
                    log.info("the note : not belong to user : " + uid);
                    model.addAttribute("code", -2203);
                    return "/common/success";
                } else {
                    log.info("the note is default note");
                    model.addAttribute("code", -2204);
                    return "/common/success";
                }
            } else {
                log.info("note not exist");
                model.addAttribute("code", -2200);
                return "/common/success";
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("update dictation note error, id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @Description 获取用户某科目错词本设置
     * @Author: PeiyuFeng
     * @Time 2017/5/23 17:28
     */
    @RequestMapping(value = "/a/u/dictation/setting/{sid}", method = RequestMethod.GET)
    public String renameNote(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long sid) throws Exception {

        log.info("get dictation note setting , sid : " + sid);

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        try {
            DictationSubject subject = dictationSubjectService.getObjectById(sid);
            if(subject == null){
                log.info("subject not exist");
                model.addAttribute("code", -2106);
                return "/common/success";
            }

            Long defaultNoteId = dictationNoteService.getDefaultDictationNoteIdByUidAndSid(uid, sid);
            Long rid = userDsubjectRelationService.getUserDsubjectRelationIdsByUidAndSid(uid, sid);

            if (defaultNoteId == null) {
                DictationNote defaultNote = new DictationNote();
                defaultNote.setUid(uid);
                defaultNote.setSid(sid);
                defaultNote.setDefaultStatus(DictationNote.DEFAULT);
                defaultNote.setWordCount(0);
                defaultNote.setName("未分组词汇");
                defaultNoteId = dictationNoteService.insert(defaultNote);

                log.info("add default note : " + defaultNoteId);
            } else {
                log.info("get default note : " + defaultNoteId);
            }

            if(rid == null){
                UserDsubjectRelation userDsubjectRelation = new UserDsubjectRelation();
                userDsubjectRelation.setRecheckNum(20);
                userDsubjectRelation.setDefaultNoteId(defaultNoteId);
                userDsubjectRelation.setDefaultNoteStatus(UserDsubjectRelation.DEFAULT_NOTE);
                userDsubjectRelation.setLastNoteId(defaultNoteId);
                userDsubjectRelation.setSubjectId(sid);
                userDsubjectRelation.setUserId(uid);
                rid = userDsubjectRelationService.insert(userDsubjectRelation);
            }

            DictationNote note = dictationNoteService.getObjectById(defaultNoteId);
            UserDsubjectRelation relation = userDsubjectRelationService.getObjectById(rid);

            DictationNote defaultNote = dictationNoteService.getObjectById(relation.getDefaultNoteId());

            model.addAttribute("code", 0);
            model.addAttribute("recheckNum", relation.getRecheckNum());
            model.addAttribute("defaultNoteStatus", relation.getDefaultNoteStatus());
            model.addAttribute("defaultNoteId", relation.getDefaultNoteId());
            model.addAttribute("defaultNoteName", defaultNote.getName());

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get dictation note setting error, sid is  " + sid);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/dictationSubject/json/dictationSetting";
    }


    /**
     * @param
     * @Description 错词本设置
     * @Author: PeiyuFeng
     * @Time 2017/5/23 17:30
     */
    @RequestMapping(value = "/a/u/dictation/subject/{sid}", method = RequestMethod.PUT)
    public String renameNote(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long sid,
                             Integer recheckNum, Integer defaultNoteStatus, Long defaultNoteId) throws Exception {

        log.info("update dictation note setting , sid : " + sid + " recheckNum : " + recheckNum + " defaultNoteStatus : " +
                defaultNoteStatus + " defaultNoteId : " + defaultNoteId);

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        try {
            if (DataUtils.isNullOrEmpty(recheckNum) || DataUtils.isNullOrEmpty(defaultNoteStatus)) {
                log.info("params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            } else if (!UserDsubjectRelation.DEFAULT_NOTE.equals(defaultNoteStatus) && !UserDsubjectRelation.NO_DEFAULT_NOTE.equals(defaultNoteStatus)) {
                log.info("defaultNoteStatus is wrong");
                model.addAttribute("code", -1000);
                return "/common/success";
            } else if (UserDsubjectRelation.DEFAULT_NOTE.equals(defaultNoteStatus) && DataUtils.isNullOrEmpty(defaultNoteId)) {
                log.info("defaultNoteId is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            } else if(recheckNum < 0){
                log.info("defaultNoteId is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }else {
                log.info("params check OK");
            }

            Long noteId = dictationNoteService.getDefaultDictationNoteIdByUidAndSid(uid, sid);
            Long rid = userDsubjectRelationService.getUserDsubjectRelationIdsByUidAndSid(uid, sid);
            if (noteId == null) {
                DictationNote note = new DictationNote();
                note.setUid(uid);
                note.setSid(sid);
                note.setDefaultStatus(DictationNote.DEFAULT);
                note.setWordCount(0);
                note.setName("未分组词汇");
                noteId = dictationNoteService.insert(note);
                log.info("add default note : " + noteId);
            } else {
                log.info("get default relation : " + rid);
            }

            if(rid == null){
                UserDsubjectRelation userDsubjectRelation = new UserDsubjectRelation();
                userDsubjectRelation.setRecheckNum(recheckNum);
                userDsubjectRelation.setDefaultNoteId(defaultNoteId);
                userDsubjectRelation.setDefaultNoteStatus(defaultNoteStatus);
                userDsubjectRelation.setLastNoteId(noteId);
                userDsubjectRelation.setSubjectId(sid);
                userDsubjectRelation.setUserId(uid);
                rid = userDsubjectRelationService.insert(userDsubjectRelation);
            }

            UserDsubjectRelation relation = userDsubjectRelationService.getObjectById(rid);
            DictationNote note = dictationNoteService.getObjectById(defaultNoteId);
            if(note != null){
                if(uid.equals(note.getUid())){
                    relation.setDefaultNoteId(defaultNoteId);
                }else {
                    log.info("defaultNoteId not belong user");
                    model.addAttribute("code", -1000);
                    return "/common/success";
                }
            }else {
                log.info("not change defaultNoteId");
            }
            relation.setDefaultNoteStatus(defaultNoteStatus);
            relation.setRecheckNum(recheckNum);
            userDsubjectRelationService.update(relation);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("update dictation note setting error, sid is  " + sid);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }
}

