package com.ptteng.course.home.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * DictationLesson  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class DictationLessonController {
    private static final Log log = LogFactory.getLog(DictationLessonController.class);

    @Autowired
    private DictationLessonService dictationLessonService;

    @Autowired
    private BookVersionService bookVersionService;

    @Autowired
    private UserDlessonRelationService userDlessonRelationService;

    @Autowired
    private DictationPeriodService dictationPeriodService;

    @Autowired
    private UserDperiodRelationService userDperiodRelationService;

    @Autowired
    private DictationLevelService dictationLevelService;


    /**
     * @param
     * @Description 听写课程列表
     * @Author: PeiyuFeng
     * @Time 2017/5/17 10:25
     */
    @RequestMapping(value = "/a/u/dictation/list", method = RequestMethod.GET)
    public String getDictationLessonList(HttpServletRequest request, HttpServletResponse response,
                                         ModelMap model, Integer page, Integer size, Long subject, Long grade) throws Exception {

        log.info("get dictationLesson list sid is" + subject + "levelId is " + grade);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        List<DictationLesson> lessonList = null;

        try {
            if (DataUtils.isNullOrEmpty(subject) || DataUtils.isNullOrEmpty(grade)) {
                log.info("params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            } else {

                List<Long> levelIds = dictationLevelService.getIdsBySid(subject);

                if (levelIds.contains(grade)) {
                    log.info("params verify OK");
                } else {
                    log.info("grade not belong subject");
                    model.addAttribute("code", -2102);
                    return "/common/success";
                }
            }

            List<Long> ids = dictationLessonService.getLessonListBySidAndLidAndStatus(subject, grade, DictationLesson.STATUS_NORMAL, start, size);
            log.info("dictationLesson ids : " + ids);
            Integer total = dictationLessonService.countLessonListBySidAndLidAndStatus(subject, grade, DictationLesson.STATUS_NORMAL);
            lessonList = dictationLessonService.getObjectsByIds(ids);

            List<Long> versionIds = MyListUtil.getFieldValueListFromModelList(lessonList, false, DictationLesson.class.getDeclaredField("versionId"));
            List<BookVersion> bookVersions = bookVersionService.getObjectsByIds(versionIds);
            Map<Long, String> id_version = MyListUtil.convert2Map(BookVersion.class.getDeclaredField("id"), BookVersion.class.getDeclaredField("versionName"), bookVersions);

            //获取用户收藏课程
            List<Long> lessonIds = new ArrayList<>();
            List<DictationLesson> lessons = new ArrayList<>();
            log.info("=====获取收藏课程列表id=====");
            List<Long> relationIds = userDlessonRelationService.getIdsByUid(uid, start, size);
            if (CollectionUtils.isNotEmpty(relationIds)) {
                List<UserDlessonRelation> userFavoriteRelations = userDlessonRelationService.getObjectsByIds(relationIds);
                for (UserDlessonRelation userFavoriteRelation : userFavoriteRelations) {
                    lessonIds.add(userFavoriteRelation.getLessonId());
                }
            }
            log.info("user selected lessonIds : " + lessonIds);

            //判断列表中课程状态
            Map<Long, Integer> lid_status = new HashMap<>();
            for(Long id : ids){
                if(lessonIds.contains(id)){
                    //该课程用户已收藏
                    lid_status.put(id, 1);
                }else {
                    //该课程用户未收藏
                    lid_status.put(id, 2);
                }
            }

            model.addAttribute("code", 0);
            boolean next = false;
            if (ids.size() + start + 1 <= total) {
                next = true;
            }
            Integer totalPage = total / size + 1;
            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("dictationLessonList", lessonList);
            model.addAttribute("id_version", id_version);
            model.addAttribute("lid_status", lid_status);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get dictationLesson list error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/dictationLesson/json/dictationLessonListJson";
    }

    /**
     * @param
     * @Description 用户在学听写课程列表
     * @Author: PeiyuFeng
     * @Time 2017/5/17 12:39
     */
    @RequestMapping(value = "/a/u/user/dictation/list", method = RequestMethod.GET)
    public String getUserDictationLessonList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                             Integer page, Integer size) throws Exception {

        log.info("get user dictationLesson list ");

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        Boolean next = false;

        try {

            List<Long> lessonIds = new ArrayList<>();
            List<DictationLesson> lessons = new ArrayList<>();
            log.info("=====获取收藏课程列表id=====");
            List<Long> relationIds = userDlessonRelationService.getIdsByUid(uid, start, size);
            if (CollectionUtils.isNotEmpty(relationIds)) {
                List<UserDlessonRelation> userFavoriteRelations = userDlessonRelationService.getObjectsByIds(relationIds);
                for (UserDlessonRelation userFavoriteRelation : userFavoriteRelations) {
                    lessonIds.add(userFavoriteRelation.getLessonId());
                }
            }
            log.info("user selected lessonIds : " + lessonIds);

            if (lessonIds != null && lessonIds.size() > 0) {
                if (size.equals(lessonIds.size())) {
                    next = true;
                    lessonIds = lessonIds.subList(0, size);
                }
            }
            log.info("user selected lessonIds : " + lessonIds);

            lessons = dictationLessonService.getObjectsByIds(new ArrayList(Arrays.asList(lessonIds.toArray())));
            if (CollectionUtils.isNotEmpty(lessons)) {
                log.info("lessons size : " + lessons.size());
            } else {
                log.info("lessons is null ");
            }

            List<Long> versionIds = MyListUtil.getFieldValueListFromModelList(lessons, false, DictationLesson.class.getDeclaredField("versionId"));
            List<BookVersion> bookVersions = bookVersionService.getObjectsByIds(versionIds);
            Map<Long, String> id_version = MyListUtil.convert2Map(BookVersion.class.getDeclaredField("id"), BookVersion.class.getDeclaredField("versionName"), bookVersions);


            Integer total = userDlessonRelationService.countIdsByUid(uid);

            log.info("   total = " + total);
            Integer totalPage = (((total - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("page", page);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("dictationLessonList", lessons);
            model.addAttribute("id_version", id_version);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user dictationLesson list error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/dictationLesson/json/dictationLessonListJson";
    }

    /**
     * @param
     * @Description 新增用户听写教材列表
     * @Author: PeiyuFeng
     * @Time 2017/5/17 12:57
     */
    @RequestMapping(value = "/a/u/user/dictation/list", method = RequestMethod.POST)
    public String addUserBook(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                              Long ids[]) throws Exception {

        log.info("add user dictation lesson : ids= " + ids);

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        try {
            List<Long> idList = Arrays.asList(ids);

            List<DictationLesson> lessons = dictationLessonService.getObjectsByIds(idList);
            List<UserDlessonRelation> relations = new ArrayList<>();

            for (DictationLesson lesson : lessons) {
                if (DictationLesson.STATUS_FORBIDDEN.equals(lesson.getStatus())) {
                    log.info("lesson " + lesson.getId() + " offline");
                    model.addAttribute("code", -2101);
                    return "/common/success";
                } else {
                    //课程上架状态，可添加
                }
            }

            for (DictationLesson lesson : lessons) {
                Long relationId = userDlessonRelationService.getIdsByUserIdAndLessonId(uid, lesson.getId());
                if(relationId != null){
                    log.info("lesson : " + lesson.getId() + " exist in user lesson relation");
                }else {
                    UserDlessonRelation relation = new UserDlessonRelation();
                    relation.setUserId(uid);
                    relation.setLessonId(lesson.getId());
                    relations.add(relation);
                }

            }
            userDlessonRelationService.insertList(relations);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add dictation lesson error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    /**
     * @param
     * @Description 删除用户学习教材列表
     * @Author: PeiyuFeng
     * @Time 2017/5/17 13:03
     */
    @RequestMapping(value = "/a/u/user/dictation/list", method = RequestMethod.DELETE)
    public String deleteUserBook(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long ids[]) throws Exception {

        log.info("delete user dictation lesson : ids= " + ids);

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        try {
            List<Long> pids = new ArrayList<>();

            for (Long id : ids) {
                Long pid = userDlessonRelationService.getIdsByUserIdAndLessonId(uid, Long.valueOf(id));
                if (pid != null) {
                    pids.add(pid);
                } else {
                    log.info("user : " + uid + " and book : " + id + " relation not exist");
                }

            }
            userDlessonRelationService.deleteList(UserDlessonRelation.class, pids);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete dictation lesson error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @Description 听写课程详情
     * @Author: PeiyuFeng
     * @Time 2017/5/17 13:17
     */
    @RequestMapping(value = "/a/u/dictation/detail/{id}", method = RequestMethod.GET)
    public String getBookJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer start, Integer size)
            throws Exception {

        log.info("get data : id= " + id);
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();

        try {

            DictationLesson lesson = dictationLessonService.getObjectById(id);
            if (lesson == null) {
                log.info("lesson not exist");
                model.addAttribute("code", -2100);
                return "/common/success";
            } else {
                if (DictationLesson.STATUS_FORBIDDEN.equals(lesson.getStatus())) {
                    log.info("lesson offline");
                    model.addAttribute("code", -2101);
                    return "/common/success";
                } else {
                    log.info("get lesson data");
                }
            }

            List<Long> pids = dictationPeriodService.getIdsByLidOrderBySort(id);
            List<DictationPeriod> periods = dictationPeriodService.getObjectsByIds(pids);

            Long relationId = 0L;
            UserDperiodRelation relation = new UserDperiodRelation();
            Map<Long, Integer> pid_status = new HashMap<>();
            for (DictationPeriod period : periods) {
                log.info("=====校验听写课时状态=====");
                relationId = userDperiodRelationService.getIdsByUserIdAndPeriodId(uid, period.getId());
                if (relationId != null) {
                    relation = userDperiodRelationService.getObjectById(relationId);
                    pid_status.put(period.getId(), relation.getStatus());
                } else {
                    UserDperiodRelation newRelation = new UserDperiodRelation();
                    newRelation.setUserId(uid);
                    newRelation.setStatus(UserDperiodRelation.STATUS_START);
                    newRelation.setPeriodId(period.getId());
                    userDperiodRelationService.insert(newRelation);
                    pid_status.put(period.getId(), UserDperiodRelation.STATUS_START);
                }

            }

            BookVersion bookVersion = bookVersionService.getObjectById(lesson.getVersionId());
            String version = "";
            if (bookVersion != null) {
                version = bookVersion.getVersionName();
            } else {
                log.info("bookVersion : " + lesson.getVersionId() + " not exist");
            }

            log.info("pid_status : " + pid_status);

            model.addAttribute("code", 0);
            model.addAttribute("dictationLesson", lesson);
            model.addAttribute("version", version);
            model.addAttribute("pid_status", pid_status);
            model.addAttribute("periods", periods);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get book error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/dictationLesson/json/dictationLessonDetailJson";
    }
}

