package com.ptteng.course.home.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.learn.course.model.Collaborate;
import com.ptteng.learn.course.service.CollaborateService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;



/**
 * Collaborate  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CollaborateController {
	private static final Log log = LogFactory.getLog(CollaborateController.class);

	@Autowired
	private CollaborateService collaborateService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/collaborate", method = RequestMethod.GET)
	public String getcollaborateList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/collaborate  to /collaborate/view/collaborateList");

		return "/learn-course-service/collaborate/view/collaborateList";
	}
    
    

    
	
	@RequestMapping(value = "/c/collaborate/{id}", method = RequestMethod.GET)
	public String getCollaborate(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/collaborate/" + id + "  to /collaborate/view/collaborateDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/learn-course-service/collaborate/view/collaborateDetail";
	}
	
	
	
	    
	

	@RequestMapping(value = "/a/collaborate/{id}", method = RequestMethod.GET)
	public String getCollaborateJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Collaborate collaborate = collaborateService.getObjectById(id);
			log.info("get collaborate data is " + collaborate);

			model.addAttribute("code", 0);

			model.addAttribute("collaborate", collaborate);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get collaborate error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/collaborate/json/collaborateDetailJson";
	}

	@RequestMapping(value = "/a/collaborate/{id}", method = RequestMethod.PUT)
	public String updateCollaborateJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Collaborate collaborate) throws Exception {
		
		log.info("update collaborate : collaborate= " + collaborate);
		
		try {
			
			collaborateService.update(collaborate);

			model.addAttribute("code", 0);

			model.addAttribute("collaborate", collaborate);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update collaborate error,id is  " + collaborate.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/collaborate", method = RequestMethod.POST)
	public String addCollaborateJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Collaborate collaborate) throws Exception {
		
		log.info("update collaborate : collaborate= " + collaborate);
		
		try { 
			collaborate.setId(null);

			collaborateService.insert(collaborate);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add collaborate error ");
			model.addAttribute("code", -1);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/collaborate/{id}", method = RequestMethod.DELETE)
	public String deleteCollaborateJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete collaborate : id= " + id);
		try {
			collaborateService.delete(id);

			log.info("add collaborate success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete collaborate error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/collaborate", method = RequestMethod.GET)
	public String getMultiCollaborateJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Collaborate> collaborateList = collaborateService.getObjectsByIds(idList);
			log.info("get  collaborate data is " + collaborateList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",collaborateList.size());

			model.addAttribute("collaborateList", collaborateList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get collaborate error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/collaborate/json/collaborateListJson";
	}
	
	
	
	
	
}

