package com.ptteng.course.home.controller;

import java.io.BufferedReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.*;
import java.util.concurrent.locks.Lock;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.course.util.aliPayUtil.apacheCommonUtil.httpclient.util.DateUtil;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


/**
 * Lesson  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class LessonController {
    private static final Log log = LogFactory.getLog("Lesson");

    private static final Log userLessonLog = LogFactory.getLog("userLesson");

    @Autowired
    private LessonService lessonService;
    @Autowired
    private LocksService locksService;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private IntroduceService introduceService;
    @Autowired
    private CollaborateService collaborateService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private ProgressService progressService;
    @Autowired
    private GradeClassRelationService gradeClassRelationService;
    @Autowired
    private UserFavoriteRelationService userFavoriteRelationService;
    @Autowired
    private PaperService paperService;
    @Autowired
    private UserOrderService userOrderService;
    @Autowired
    private UserPaperRelationService userPaperRelationService;


    /**
     * 分享查看课程详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/lesson/detail/{id}", method = RequestMethod.GET)
    public String getShareLessonJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id,
                                     Integer type, Integer page, Integer size)
            throws Exception {
        //peogressId
        Long progressId = 0L;
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        if (id == null) {
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        log.info("get data : id= " + id);
        try {

            Lesson lesson = lessonService.getObjectById(id);

            if (lesson == null) {
                model.addAttribute("code", -5043);
                return "/common/success";
            }
            Long subjectId = lesson.getSubject();
            Subject subject = subjectService.getObjectById(subjectId);

            Collaborate collaborate = collaborateService.getObjectById(subject.getCollaborateId());
            Map<String, Object> param = DynamicUtil.getPeriodList(null, null, id, null, type, null, null);
            log.info(" param = " + param);
            List<Long> periodIds = periodService.getIdsByDynamicCondition(Period.class, param, start, size);
            List<Long> countPeriod = periodService.getIdsByDynamicCondition(Period.class, param, 0, Integer.MAX_VALUE);
            if (periodIds.size() <= 0) {
                log.info("period is null");
            }
            log.info(" countPeriod =  " + countPeriod);
            List<Period> periodList = periodService.getObjectsByIds(countPeriod);
            Integer level = lesson.getLevel();
            Long subId = lesson.getSubject();
            List<Long> gradeIds = gradeClassRelationService.getGradeClassRelationIdsByLevel(subId, level, 0, Integer.MAX_VALUE);
            List<GradeClassRelation> gradeList = gradeClassRelationService.getObjectsByIds(gradeIds);
            if (gradeList.size() > 0) {
                GradeClassRelation gradeClassRelation = gradeList.get(0);
                if (gradeClassRelation != null) {
                    lesson.setGradeIntroduce(gradeClassRelation.getIntroduce());
                }
            }


            if (subject != null) {
                lesson.setGradeType(subject.getGradeType());
            }
            log.info("get lesson data is " + lesson.getId() + " buy = " + lesson.getBuy());

            Integer periodCount = countPeriod.size();
            model.addAttribute("code", 0);
//			model.addAttribute("progress", progress);
            //查询lesson的levelName
            if (null != lesson.getLevel()) {
                Long gradeId = gradeClassRelationService.getGradeClassRelationIdsByGradeName
                        (subId, lesson.getLevel());
                if (null != gradeId) {
                    GradeClassRelation gradeClassRelation = gradeClassRelationService.getObjectById(gradeId);
                    lesson.setLevelName(gradeClassRelation.getLevel());
                }
            }

            model.addAttribute("lesson", lesson);
            model.addAttribute("periodList", periodList);
            model.addAttribute("collaborate", collaborate);
            model.addAttribute("periodCount", periodCount);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get lesson error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/learn-course-service/lesson/json/lessonDetailJson";
    }


    /**
     * 查看课程详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/lesson/detail/{id}", method = RequestMethod.GET)
    public String getLessonJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer type, Integer page, Integer size)
            throws Exception {
        //peogressId
        Long progressId = 0L;
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        if (id == null) {
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get data : id= " + id);
        try {

            Boolean memberStatus = false;
            Integer member = user.getMember();
            log.info("user member status : " + member);
            if (User.IS_MEMBER == member) {
                log.info("user is member");
                memberStatus = true;
            }

            Lesson lesson = lessonService.getObjectById(id);

            if (lesson == null) {
                model.addAttribute("code", -5043);
                return "/common/success";
            }
            Long subjectId = lesson.getSubject();
            Subject subject = subjectService.getObjectById(subjectId);

            Collaborate collaborate = collaborateService.getObjectById(subject.getCollaborateId());
            Map<String, Object> param = DynamicUtil.getPeriodList(null, null, id, null, type, null, null);
            log.info(" param = " + param);
            List<Long> periodIds = periodService.getIdsByDynamicCondition(Period.class, param, start, size);
            List<Long> countPeriod = periodService.getIdsByDynamicCondition(Period.class, param, 0, Integer.MAX_VALUE);
            if (periodIds.size() <= 0) {
                log.info("period is null");
            }
            log.info(" countPeriod =  " + countPeriod);
            List<Period> periodList = periodService.getObjectsByIds(countPeriod);
            Integer level = lesson.getLevel();
            Long subId = lesson.getSubject();
            List<Long> gradeIds = gradeClassRelationService.getGradeClassRelationIdsByLevel(subId, level, 0, Integer.MAX_VALUE);
            List<GradeClassRelation> gradeList = gradeClassRelationService.getObjectsByIds(gradeIds);
            if (gradeList.size() > 0) {
                GradeClassRelation gradeClassRelation = gradeList.get(0);
                if (gradeClassRelation != null) {
                    lesson.setGradeIntroduce(gradeClassRelation.getIntroduce());
                }
            }
            userLessonLog.info("=====验证是否收藏，学习进度=====");
            Long progressID = userFavoriteRelationService.getUserFavoriteRelationIdByUserIDAndTypeAndTargetID(uid, UserFavoriteRelation.TYPE_LESSON, lesson.getId());
            log.info(" progressID = " + progressID);
            if (progressID != null) {
                lesson.setFavorite(UserFavoriteRelation.STATUS_LIKE);
            }

//            学习进度
            List<Long> progressList = new ArrayList<>();
            periodIds = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(lesson.getId(), Period.status_normal, 0, Integer.MAX_VALUE);

//            Long lessonLockId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_LESSON, lesson.getId());
            if (periodIds != null && periodIds.size() > 0) {
                log.info(lesson + "====" + periodIds);
                lesson.setPeriodCount(periodIds.size());
                lessonService.update(lesson);

                for (Long periodId : periodIds) {
                    progressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, periodId, Progress.TYPE_PERIOD);
                    if (null != progressId) {
                        progressList.add(progressId);
                    }
                }
                lesson.setProgress(progressList.size());
            }
            //学习状态
            progressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, lesson.getId(), Progress.TYPE_LESSON);
            Progress progress = progressService.getObjectById(progressId);
            if (progress != null) {
                lesson.setOver(progress.getStatus());
            }
            Long paperId = null;
            String moneyPrice = "0";
            Long paperOrderId = null;
            Double price = 0D;
            Long periodOrderId = null;
            UserOrder userOrder = new UserOrder();
            Long locksId = null;
            BigDecimal lessonPrice = new BigDecimal(0);
            Integer starPrice = 0;
            Long lessonOrderId = null;
            Long lessonLocksId = null;
            for (Period period : periodList) {
                userLessonLog.info("=====验证是否收藏，学习进度=====");
                progressID = userFavoriteRelationService.getUserFavoriteRelationIdByUserIDAndTypeAndTargetID(uid, UserFavoriteRelation.TYPE_PERIOD, period.getId());
                if (progressID != null) {
                    period.setFavorite(UserFavoriteRelation.STATUS_LIKE);
                }

                //学习进度
                progressList = new ArrayList<>();
                param = DynamicUtil.getTaskList(null, null, null, null, period.getId(), null, 1);
                List<Long> taskIds = taskService.getIdsByDynamicCondition(Task.class, param, 0, Integer.MAX_VALUE);
                if (taskIds != null && taskIds.size() > 0) {
                    log.info(lesson + "====" + periodIds);
                    period.setTaskCount(taskIds.size());
                    lessonService.update(lesson);
                    for (Long taskId : taskIds) {
                        progressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, taskId, Progress.TYPE_TASK);
                        if (null != progressId) {
                            progressList.add(progressId);
                        }
                    }
                    period.setProgress(progressList.size());
                }
                //学习状态
                progressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, period.getId(), Progress.TYPE_PERIOD);
                progress = progressService.getObjectById(progressId);
                if (progress != null) {
                    period.setOver(progress.getStatus());
                }
                //验证资料是否购买
                paperId = period.getPaperID();
                log.info(" paperId = " + paperId);
                if (paperId != null) {
                    Paper paper = paperService.getObjectById(paperId);
                    log.info(" paper price = " + paper.getPrice());
                    if (paper != null) {
                        paperOrderId = userPaperRelationService.getUserTargetRelationIdsByTypeAndUidAndTargetId(UserPaperRelation.TYPE_PPAPER, uid, period.getId());
                        log.info(" orderId  =  " + paperOrderId);
                        if (paperOrderId == null) {

                            price = Double.valueOf(moneyPrice) + Double.valueOf(paper.getPrice());
                            log.info(" price = " + price);
                            DecimalFormat decimalFormat = new DecimalFormat("0.00");
                            price = new Double(decimalFormat.format(price));
                            moneyPrice = price.toString();
                            lesson.setBuy(Lesson.notBuy);
                            period.setBuy(Period.notBuy);
                            lessonOrderId = userPaperRelationService.getUserTargetRelationIdsByTypeAndUidAndTargetId(UserPaperRelation.TYPE_LPAPER, uid, period.getLessonID());
                            if (lessonOrderId != null) {
                                userPaperRelationService.delete(lessonOrderId);
                            }
                        } else {
                            period.setBuy(Period.Buy);
                        }
                    }
                    //验证资料是否已经被购买
//                    Long userPaperId = userPaperRelationService.getUserTargetRelationIdsByTypeAndUidAndTargetId(UserPaperRelation.TYPE_PPAPER, uid, period.getId());
//                    if (userPaperId != null) {
//                        period.setBuy(Paper.Buy);
//                    } else {
//                        period.setBuy(Paper.NotBuy);
//                    }
                } else {
                    period.setBuy(Period.noPaper);
                }
                log.info(" moneyPrice = " + moneyPrice);

                lesson.setPaperPrice(moneyPrice);

//             if (lessonLockId!=null){
//                 lesson.setUserLock(2);
//                 period.setUserLock(2);
//             }else
                log.info("  period buy is = " + period.getBuy() + " lesson buy = " + lesson.getBuy());
                if (period.getLocked() == 1) {
                    log.info(" period Locked() =  1 ");
                    periodOrderId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, period.getId());
                    if (periodOrderId != null) {
                        period.setUserLock(2);
                        lesson.setUserLock(2);
                    } else {
                        lessonLocksId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_LESSON, period.getLessonID());
                        if (lessonLocksId != null) {
                            locksService.delete(lessonLocksId);
                        }
                    }
                } else {
                    log.info(" period Locked() !=  1 ");

                    lesson.setUserLock(2);
                    period.setUserLock(2);
                    period.getUserLock();
                }

//                periodIds = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(lesson.getId(), Period.status_normal, 0, Integer.MAX_VALUE);
//                periodList = periodService.getObjectsByIds(periodIds);

                locksId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, period.getId());
                if (locksId == null) {
                    if (period.getLocked() == 1) {
                        lessonPrice = lessonPrice.add(period.getMoneyPrice());
                        starPrice += period.getStarPrice();
                    }
                }
                if (lesson.getPaperCount() == 0) {
                    lesson.setBuy(Lesson.noPaper);
                }

                lesson.setMoneyPrice(lessonPrice);
                lesson.setStarPrice(starPrice);


            }
            //查询最近的一个订单
            List<Long> orderIds = new LinkedList<>();
            Long orderID = null;
            log.info("=========================================================================================================================");
            log.info(" periodList = " + periodList.size());
            log.info(" lesson id = " + lesson.getId() + " buy is = " + lesson.getBuy());

            if (periodList.size() == 0) {
                orderID = userOrderService.getUserOrderIdsByUidAndBuyTypeAndTargetId(uid, UserOrder.ORDER_LPAPER, lesson.getId());
                log.info(" user order id = " + orderID);
                if (orderID != null) {
                    lesson.setOrderId(orderID);
                } else {
                    lesson.setBuy(Lesson.noPaper);
                    lesson.setLocked(Lesson.UnLock);
                    lesson.setUserLock(Lesson.UnLock);
                }
            } else if (lesson.getBuy().equals(Book.Buy)) {
                log.info(" lesson buy is 1 ");

                orderID = userOrderService.getUserOrderIdsByUidAndBuyTypeAndTargetId(uid, UserOrder.ORDER_LPAPER, lesson.getId());

                if (orderID != null) {
                    log.info(" orderID = " + orderID);
                    orderIds.add(orderID);

                }
                log.info(" periodList size = " + periodList.size());
                for (Period periods : periodList) {
                    log.info(" periods id = " + periods.getId() + " paperId = " + periods.getId());


                    orderID = userOrderService.getUserOrderIdsByUidAndBuyTypeAndTargetId(uid, UserOrder.ORDER_PPAPER, periods.getId());
                    log.info(" orderID=  " + orderID);
                    if (orderID != null) {
                        orderIds.add(orderID);
                    }

                }


            }
            log.info(" orderIds =  " + orderIds);
            List<UserOrder> userOrders = userOrderService.getObjectsByIds(orderIds);
            log.info("  userOrders  size = " + userOrders.size());

            if (orderIds.size() > 0 && orderIds.size() < 2) {
                log.info(" orderIds size = 1 ");
                lesson.setOrderId(orderIds.get(0));
            } else if (orderIds.size() > 1) {
                log.info(" orderIds size > 1 ");

                long s = userOrders.get(0).getId();
                log.info(" s = " + s);
                for (int i = 0; i < userOrders.size() - 1; i++) {
                    if (userOrders.get(i).getCreateAt() < userOrders.get(i + 1).getCreateAt()) {
                        s = userOrders.get(i + 1).getId();
                    }
                }
                log.info(" s = " + s);
                lesson.setOrderId(s);
            }
//            else{
//                log.info(" lesson order is null,so check paper order = "+paperOrderId);
//                if(null != paperOrderId){
//                    lesson.setOrderId(paperOrderId);
//                }
//            }
            log.info(" lesson orderId = " + lesson.getOrderId());

            if (memberStatus) {
                if (lesson.getOver() == 3 || lesson.getOver() == null) {
                    model.addAttribute("continue", 2);
                } else {
                    model.addAttribute("continue", 3);
                }
            } else {
                if (lesson.getUserLock() == 1) {
                    model.addAttribute("continue", 1);
                } else if (lesson.getUserLock() == 2 && lesson.getOver() == 3) {
                    model.addAttribute("continue", 2);
                } else if (lesson.getUserLock() == 2 && lesson.getOver() == null) {
                    model.addAttribute("continue", 2);
                } else {
                    model.addAttribute("continue", 3);
                }
            }


            if (subject != null) {
                lesson.setGradeType(subject.getGradeType());
            }
            log.info("get lesson data is " + lesson.getId() + " buy = " + lesson.getBuy());

            Integer periodCount = countPeriod.size();
            model.addAttribute("code", 0);
//			model.addAttribute("progress", progress);
            //查询lesson的levelName
            if (null != lesson.getLevel()) {
                Long gradeId = gradeClassRelationService.getGradeClassRelationIdsByGradeName
                        (subId, lesson.getLevel());
                if (null != gradeId) {
                    GradeClassRelation gradeClassRelation = gradeClassRelationService.getObjectById(gradeId);
                    lesson.setLevelName(gradeClassRelation.getLevel());
                }
            }


            model.addAttribute("lesson", lesson);
            model.addAttribute("periodList", periodList);
            model.addAttribute("collaborate", collaborate);
            model.addAttribute("periodCount", periodCount);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get lesson error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/learn-course-service/lesson/json/lessonDetailJson";
    }


    /**
     * //根据条件查找课程
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @RequestMapping(value = "/a/u/lesson/list", method = RequestMethod.GET)
    public String getLessonIdsByLevelOrderBySortJsonList(HttpServletRequest request,
                                                         HttpServletResponse response, ModelMap model, Integer page,
                                                         Integer size, Integer level, Long subjectId, String name) throws Exception {

        log.info("get lessson level is" + level + "subject is " + subjectId + "name is " + name);

//        //课程课时id
        List<Long> periodIds = new ArrayList<>();

        List<Period> periodList = new ArrayList<>();
        Long periodOrderId = null;
        Long locksId = null;
        if (page == null) {
            page = 1;
        }
        if (size == null || size == 0) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        try {
            Map<String, Object> param = DynamicUtil.getLessonList(name, subjectId, level);
            List<Long> ids = lessonService.getIdsByDynamicCondition(Lesson.class, param, start, size);
            List<Long> count = lessonService.getIdsByDynamicCondition(Lesson.class, param, 0, Integer.MAX_VALUE);
            log.info("get countLessonIdsByLevelOrderBySort size is " + ids.size());

            List<Lesson> lessonList = lessonService.getObjectsByIds(ids);
            BigDecimal moneyPrice = new BigDecimal(0);
            Integer starPrice = 0;
            for (Lesson lesson : lessonList) {
                Long id = lesson.getSubject();
                Subject subject = subjectService.getObjectById(id);
                if (subject != null) {
                    lesson.setGradeType(subject.getGradeType());
                }
            }
            log.info("get lesson data is " + lessonList.size());

            for (Lesson lesson : lessonList) {
                if (lesson != null) {
                    Integer leve = lesson.getLevel();
                    Long subId = lesson.getSubject();
                    //查询lesson的levelName
                    if (null != lesson.getLevel()) {
                        Long gradeId = gradeClassRelationService.getGradeClassRelationIdsByGradeName
                                (subId, leve);
                        if (null != gradeId) {
                            GradeClassRelation gradeClassRelation = gradeClassRelationService.getObjectById(gradeId);
                            lesson.setLevelName(gradeClassRelation.getLevel());
                            lesson.setGradeIntroduce(gradeClassRelation.getIntroduce());
                        }
                    }


                    //计算星星和钱总价

                    periodIds = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(lesson.getId(), Period.status_normal, 0, Integer.MAX_VALUE);
                    periodList = periodService.getObjectsByIds(periodIds);
                    for (Period period : periodList) {
                        if (period.getLocked() == 1) {
                            locksId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, period.getId());
                            if (locksId == null) {
                                if (period.getMoneyPrice() != null) {
                                    moneyPrice = moneyPrice.add(period.getMoneyPrice());
                                }
                                if (period.getStarPrice() != null) {
                                    starPrice += period.getStar();
                                }
                            } else {
                                period.setUserLock(Locks.USER_UNLOCK);
                            }
                        } else {
                            lesson.setUserLock(Locks.USER_UNLOCK);
                            period.setUserLock(Locks.USER_UNLOCK);
                        }
                        //只要有一个课时解锁就是不锁定

                    }
                    lesson.setMoneyPrice(moneyPrice);
                    lesson.setStarPrice(starPrice);
                    moneyPrice = new BigDecimal(0);
                    starPrice = 0;

                    for (Period period : periodList) {
                        //只要有一个课时解锁就是不锁定
                        if (period.getLocked() == 1) {
                            if (lesson.getId() == 86) {
                                log.info(period.getId());
                            }
                            periodOrderId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, period.getId());
                            if (periodOrderId != null) {
                                lesson.setUserLock(2);
                                break;
                            }
                        } else {
                            lesson.setUserLock(2);
                            break;
                        }
                    }
                }
            }
            Integer total = count.size();
            log.info("get lesson count is " + total);

            model.addAttribute("code", 0);
            boolean next = false;
            if (lessonList.size() + start + 1 <= total) {
                next = true;
            }
            Integer totalPage = (total - 1) / size + 1;
            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute(lessonList);
            model.addAttribute("lessonList", lessonList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get lesson list error,page is  " + start + " , size "
                    + size);

            model.addAttribute("code", -100000);
        }

        return "/learn-course-service/lesson/json/lessonListJson";
    }


    /**
     * 根据年级获得推荐列表
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param level
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/recommend ", method = RequestMethod.GET)
    public String getLessonIdsByRecommendOrderBySortJsonList(HttpServletRequest request,
                                                             HttpServletResponse response, ModelMap model, Integer page,
                                                             Integer size, Integer level) throws Exception {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);
        Integer total = 0;
        List<Introduce> introduceList = null;
        try {
            if (level != null) {
                List<Long> ids = introduceService.getIntroduceIdsByLevel(level, start, size);
                log.info("get introduce size is " + ids.size());
                if (ids == null || ids.isEmpty()) {
                    model.addAttribute("code", 2);
                    return "/common/success";
                }

                introduceList = introduceService.getObjectsByIds(ids);
                log.info("get lesson data is " + introduceList.size());
                total = introduceService.countIntroduceIdsByLevel(level);
            } else {
                List<Long> ids = introduceService.getIntroduceIds(0, Integer.MAX_VALUE);
                Random random = new Random();
                List<Long> newIds = new LinkedList<>();
                for (int i = 0; i < 8; i++) {
                    int index = random.nextInt(ids.size());
                    newIds.add(ids.get(index));
                }
                introduceList = introduceService.getObjectsByIds(newIds);
                total = introduceService.countIntroduceIds();
            }

            log.info("get lesson count is " + total);

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);

            model.addAttribute("total", total);

            model.addAttribute("introduceList", introduceList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get lesson list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/learn-course-service/lesson/json/lessonListJson";
    }


    @RequestMapping(value = "/a/u/lesson/recommend/{id}", method = RequestMethod.GET)
    public String getLessonJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        log.info("get data : id= " + id);
        try {
            Lesson lesson = lessonService.getObjectById(id);
            List<Lesson> lessonList = new ArrayList<>();
            String arrayString = lesson.getIntroduceHome();
            if (arrayString.isEmpty()) {

            } else {
                String[] array = arrayString.split("\\,");
                System.out.println(arrayString);
//            log.info(array.length+"=========="+array[0]);
                if (array.length > 0) {
                    for (int i = 0; i < array.length; i++) {
                        String a = array[i];
                        Long lessonID = Long.parseLong(a);
                        Lesson lesson1 = lessonService.getObjectById(lessonID);
                        if (lesson1 != null) {
                            lessonList.add(lesson1);

                            Integer leve = lesson.getLevel();
                            Long subId = lesson.getSubject();
                            //查询lesson的levelName
                            if (null != lesson.getLevel()) {
                                Long gradeId = gradeClassRelationService.getGradeClassRelationIdsByGradeName(subId, leve);
                                if (null != gradeId) {
                                    GradeClassRelation gradeClassRelation = gradeClassRelationService.getObjectById(gradeId);
                                    lesson.setLevelName(gradeClassRelation.getLevel());
                                    lesson.setGradeIntroduce(gradeClassRelation.getIntroduce());
                                }
                            }
                        }
                    }
                }
            }

            model.addAttribute("code", 0);

            model.addAttribute("lessonList", lessonList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get lesson error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/learn-course-service/lesson/json/introduceListJson";
    }


    //1、用户学习课程列表
    @RequestMapping(value = "/a/u/user/lesson/list", method = RequestMethod.GET)
    public String getUserLesson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {

        Long periodId = 0l;
        //课程id
        Long lid = 0L;
        //用户解锁状态
        Integer userLock = Locks.USER_UNLOCK;
        //是否收藏
        Integer favorite_status = 0;
        //用户收藏表id
        Long favorite_relation = 0L;
        //peogressId
        Long progressId = 0L;
        //课程id_是否收藏关系
        Map<Long, Integer> lid_favorite = new HashMap<>();
        //课程id_学习进度
        Map<Long, Integer> lid_progress = new HashMap<>();
        //课程id_是否完成
        Map<Long, Integer> lid_over = new HashMap<>();
        //课程id_是否下架
        Map<Long, Integer> lid_freeze = new HashMap<>();
        //用户是否解锁
        Map<Long, Integer> lid_userLock = new HashMap();
        Map<String, Object> param = null;
        List<Long> periodIdList = new LinkedList<>();
        List<Period> periodList = new LinkedList<>();
        Long lockId = null;
        Subject subject = new Subject();
        Integer grade = 0;
        Boolean gradeVerify = false;
        //课程课时id
        List<Long> periodIds = new ArrayList<>();
        List<Long> lessonIds = new ArrayList<>();
        List<Lesson> lessons = new ArrayList<>();
        List<Long> totalIds = new ArrayList<>();
        Long relationId = 0L;
        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }
        int firstNmuber = (page - 1) * size;
        Boolean next = false;

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        userLessonLog.info("get uid " + uid);

        userLessonLog.info("user : " + uid + " get favorite list");

        try {

            userLessonLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            } else {
                grade = user.getGrade();
                userLessonLog.info("user grade : " + grade);
            }

            userLessonLog.info("=====获取在学课程列表id=====");
            List<Long> relationIds = progressService.getProgressIdsByUserIDAndTypeOrderByUpdateAt(uid, Progress.TYPE_LESSON, firstNmuber, size);
            userLessonLog.info("relationIds size : " + relationIds.size());
            if (CollectionUtils.isNotEmpty(relationIds)) {
                List<Progress> progresses = progressService.getObjectsByIds(relationIds);
                for (Progress progress : progresses) {
                    lid = progress.getTargetID();
                    Lesson lesson = lessonService.getObjectById(lid);
                    if (lesson != null) {
                        userLessonLog.info("progress " + progress.getId() + " lesson : " + lid + " get");
                        subject = subjectService.getObjectById(lesson.getSubject());
                    } else {
                        userLessonLog.info("the progress : " + progress.getId() + " lessonId not exist");
                        model.addAttribute("code", -4035);
                        return "/common/success";
                    }

                    //记录是否符合用户年级
                    gradeVerify = (Subject.user_type_preschool.equals(subject.getUserType()) && User.preGrade.equals(grade)) ||
                            (Subject.user_type_primaryschool.equals(subject.getUserType()) && !User.preGrade.equals(grade) ||
                                    Subject.user_type_both.equals(subject.getUserType()));
                    userLessonLog.info("grade verify result : " + gradeVerify);

                    if (gradeVerify) {
                        userLessonLog.info("lid is " + lid);
                        lessonIds.add(lid);

                        //是否收藏
                        favorite_relation = userFavoriteRelationService.getUserFavoriteRelationIdByUserIDAndTypeAndTargetID(uid, UserFavoriteRelation.TYPE_LESSON, lid);
                        if (null == favorite_relation) {
                            favorite_status = UserFavoriteRelation.STATUS_DISLIKE;
                        } else {
                            favorite_status = UserFavoriteRelation.STATUS_LIKE;
                        }
                        lid_favorite.put(lid, favorite_status);

                        //学习进度
                        //是否解锁
                        //这里的课时总进度是上架总课时，在学课时数量也是上架在学课时数量
                        List<Long> progressList = new ArrayList<>();
                        periodIds = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(lid, Period.status_normal, 0, Integer.MAX_VALUE);
                        userLessonLog.info("periodIds : " + periodIds);
                        lesson.setPeriodCount(periodIds.size());
                        lessonService.update(lesson);
                        userLessonLog.info("update lesson success ");

                        List<Period> periods = periodService.getObjectsByIds(periodIds);
                        for (Period period : periods) {
                            periodId = period.getId();
                            progressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, periodId, Progress.TYPE_PERIOD);
                            if (null != progressId) {
                                progressList.add(progressId);
                            }
                            if (Period.Lock.equals(period.getLocked())) {
                                lockId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, periodId);
                                if (lockId != null) {
                                    userLock = Locks.USER_UNLOCK;
                                }
                            }
                        }
                        lid_userLock.put(lid, userLock);
                        lid_progress.put(lid, progressList.size());

                        //是否完成
                        lid_over.put(lid, progress.getStatus());

                        //课程上下架状态
                        Integer freeze = lesson.getStatus();
                        lid_freeze.put(lid, freeze);
                    } else {
                        userLessonLog.info("user grade not compare to subject user_type");
                    }
                }
            }
            userLessonLog.info("user lessonIds : " + lessonIds);

            if (CollectionUtils.isNotEmpty(lessonIds)) {
                lessons = lessonService.getObjectsByIds(lessonIds);
                for (Lesson lesson : lessons) {
                    Integer leve = lesson.getLevel();
                    Long subId = lesson.getSubject();
                    //查询lesson的levelName
                    if (null != leve) {
                        Long gradeId = gradeClassRelationService.getGradeClassRelationIdsByGradeName
                                (subId, leve);
                        if (null != gradeId) {
                            GradeClassRelation gradeClassRelation = gradeClassRelationService.getObjectById(gradeId);
                            lesson.setLevelName(gradeClassRelation.getLevel());
                            lesson.setGradeIntroduce(gradeClassRelation.getIntroduce());
                        }
                    }
                }
            }

            userLessonLog.info("   total = " + lessonIds.size());
            Integer totalPage = (((lessonIds.size() - 1)) / size) + 1;
            userLessonLog.info("   totalPage = " + totalPage);

            if (lessonIds != null && lessonIds.size() > 0) {
                if (size.equals(lessonIds.size())) {
                    next = true;
                    lessonIds = lessonIds.subList(0, size);
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("page", page);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("lessons", lessons);
            model.addAttribute("lid_progress", lid_progress);
            model.addAttribute("lid_userLock", lid_userLock);
            model.addAttribute("lid_favorite", lid_favorite);
            model.addAttribute("lid_over", lid_over);
            model.addAttribute("lid_freeze", lid_freeze);
            model.addAttribute("lid_userLock", lid_userLock);

        } catch (Throwable t) {
            t.printStackTrace();
            userLessonLog.error(t.getMessage());
            userLessonLog.error("get user lessons error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/lesson/json/userLessonList";
    }

    //1、批量删除学习记录
    @RequestMapping(value = "/a/u/progress", method = RequestMethod.DELETE)
    public String deleteLessonProgress(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                       Long ids[], Integer page, Integer size) throws Exception {

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("delete progress uid is " + uid + "=====progress ids is " + ids);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        if (ids == null) {

            model.addAttribute("code", -5054);
            return "/common/success";

        }

        log.info(ids);
        log.info(ids.length);
        try {

            List<Long> progressIds = new LinkedList<>();
            //尝试用in
            for (int i = 0; i < ids.length; i++) {
                progressIds.add(progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, Long.valueOf(String.valueOf(ids[i])), Progress.TYPE_LESSON));
                log.info("delete progress ids is " + progressIds);
            }
            List<Progress> progressList = progressService.getObjectsByIds(progressIds);
            for (Progress progress : progressList) {
                progress.setDeleteStatus(Progress.bedelete);
            }
            progressService.updateList(progressList);
            log.info("delete progress uid is " + uid + "=========success");

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("sort task error ");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }


    //1、用来跟威叔测试body的接口
    @RequestMapping(value = "/a/u/progress", method = RequestMethod.POST)
    public String testBody(HttpServletRequest request, HttpServletResponse response, ModelMap model, @RequestBody List<Long> ids, Integer page, Integer size) throws Exception {

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("delete progress uid is " + uid + "=====progress ids is " + ids);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        if (ids == null) {

            model.addAttribute("code", -5054);
            return "/common/success";

        }

        log.info(ids);
        log.info(ids.size());
        try {

            List<Long> progressIds = new LinkedList<>();
            //尝试用in
            for (int i = 0; i < ids.size(); i++) {
                progressIds.add(progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, Long.valueOf(String.valueOf(ids.get(i))), Progress.TYPE_LESSON));
                log.info("delete progress ids is " + progressIds);
            }
            List<Progress> progressList = progressService.getObjectsByIds(progressIds);
            for (Progress progress : progressList) {
                progress.setDeleteStatus(Progress.bedelete);
            }
            progressService.updateList(progressList);
            log.info("delete progress uid is " + uid + "=========success");

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("sort task error ");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }


    /**
     * 开始继续学习课程
     *
     * @param request
     * @param response
     * @param model
     * @param lid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/learn/lesson/{lid}", method = RequestMethod.POST)
    public String learnLesson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long lid) throws Exception {

        List<Long> periodIds = new ArrayList<>();
        List<Period> periods = new ArrayList<>();
        Long unlockPeriodId = 0L;
        Long lockedId = 0L;
        Period period = new Period();
        Integer locked = 0;
        Boolean unlockStatus = false;
        Long pid = 0L;
        Progress learnPeriodProgress = new Progress();
        Integer sort = null;

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        userLessonLog.info("get uid " + uid);

        userLessonLog.info("user : " + uid + " get start learn lesson : " + lid);

        try {

            Boolean memberStatus = false;
            Integer member = user.getMember();
            userLessonLog.info("user member status : " + member);
            if (User.IS_MEMBER == member) {
                userLessonLog.info("user is member");
                memberStatus = true;
            }

            userLessonLog.info("=====课程是否存在=====");
            Lesson lesson = lessonService.getObjectById(lid);
            if (null == lesson) {
                userLessonLog.info("lesson is not exist");
                model.addAttribute("code", -4019);
                return "/common/success";
            }
            userLessonLog.info("lesson exist");

            userLessonLog.info("=====课程是否所有课时上锁、获取本课程第一个可学课时=====");
            periodIds = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(lid, Period.status_normal, 0, Integer.MAX_VALUE);

            if (CollectionUtils.isEmpty(periodIds)) {
                userLessonLog.info("no period in the book");
                model.addAttribute("code", -4046);
                return "/common/success";
            } else {
                userLessonLog.info("there are " + periodIds.size() + " period in book");
            }

            userLessonLog.info("periodIds is " + periodIds);
            for (Long periodId : periodIds) {
                userLessonLog.info("periodId : " + periodId);
                period = periodService.getObjectById(periodId);
                locked = period.getLocked();
                if (Period.UnLock.equals(locked)) {
                    unlockStatus = true;
                    unlockPeriodId = periodId;
                    userLessonLog.info("unlockPid is " + unlockPeriodId);
                    break;
                } else if (Period.Lock.equals(locked)) {
                    lockedId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, periodId);
                    if (null != lockedId) {
                        unlockStatus = true;
                        unlockPeriodId = periodId;
                        userLessonLog.info("unlockPid is " + unlockPeriodId);
                        break;
                    }
                }
            }
            userLessonLog.info("first unlock period : " + unlockPeriodId);

            if (!unlockStatus && !memberStatus) {
                //用户非会员且无被解锁课程
                log.info("every period is locked");
                model.addAttribute("code", -4025);
                return "/common/success";
            } else if (memberStatus) {
                //用户为会员，直接取第一个课时
                unlockPeriodId = periodIds.get(0);
                log.info("user is member , so first period " + unlockPeriodId + " is must unlock");
            } else {
                //用户非会员，取第一个解锁课时
                log.info("user is not member , so first unlock period is " + unlockPeriodId);
            }

            //第一个可学课程 第一个任务是否存在
            Long tid = taskService.getTaskIdsByPeriodIDAndSort(unlockPeriodId, 1);
            if (null == tid) {
                userLessonLog.info("the period have no task");
                model.addAttribute("code", -4028);
                return "/common/success";
            } else {
                log.info("first task in period " + unlockPeriodId + " is " + tid);
            }

            userLessonLog.info("=====判断是开始学习还是继续学习=====");
            Long progressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, lid, Progress.TYPE_LESSON);
            userLessonLog.info("progressId is : " + progressId);
            if (null != progressId) {

                userLessonLog.info("=====继续学习=====");
                Progress progress = progressService.getObjectById(progressId);
                progressService.update(progress);
                if (Progress.STATUS_ING.equals(progress.getStatus())) {

                    userLessonLog.info("=====课程学习中，获取最后一个学习中课时id=====");
                    Period nextPeriod = periodService.getObjectById(progress.getSort());

                    if (Period.status_normal.equals(nextPeriod.getStatus())) {
                        userLessonLog.info("=====最后在学课时未被下架=====");
                        unlockPeriodId = progress.getSort();
                        userLessonLog.info("period id : " + unlockPeriodId);

                    } else {
                        if (!Period.status_freeze.equals(nextPeriod.getStatus())) {
                            userLessonLog.info("=====最后在学课时状态错误，获取第一个在学课时=====");
                            userLessonLog.info("period status error");
                        }

                        userLessonLog.info("=====最后在学课时被下架，获取第一个在学课时=====");
                        periods = periodService.getObjectsByIds(periodIds);
                        //获取教材每个课时
                        for (Period learnPeriod : periods) {
                            pid = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, learnPeriod.getId(), Progress.TYPE_PERIOD);
                            //是否学习该课时
                            if (null != pid) {
                                learnPeriodProgress = progressService.getObjectById(pid);
                                //判断是否学习中
                                if (Progress.STATUS_ING.equals(learnPeriodProgress.getStatus())) {
                                    //若学习中，取出sort序号比较：第一个课时id不存在：添加，存在：比较大小、若小则替换
                                    if (null == sort) {
                                        sort = learnPeriod.getSort();
                                    } else {
                                        if (learnPeriod.getSort() < sort) {
                                            sort = learnPeriod.getSort();
                                        }
                                    }
                                }
                            }
                        }

                        if (null != sort) {
                            unlockPeriodId = periodService.getPeriodIdByLessonIDAndSort(lid, sort);
                        } else {
                            userLessonLog.info("=====在学课时全部下架，获取第一个可学课时id=====");

                            //记录课时进度
                            Progress periodProgress = new Progress();
                            periodProgress.setStatus(Progress.STATUS_ING);
                            periodProgress.setType(Progress.TYPE_PERIOD);
                            periodProgress.setTargetID(unlockPeriodId);
                            periodProgress.setUserID(uid);
                            periodProgress.setSort(1L);
                            progressService.insert(periodProgress);
                            userLessonLog.info("insert period progress success");

                            //添加课时学习人数
                            Period unlockPeriod = periodService.getObjectById(unlockPeriodId);
                            Integer periodCount = unlockPeriod.getStudyCount();
                            unlockPeriod.setStudyCount(periodCount + 1);
                            periodService.update(unlockPeriod);
                        }

                        userLessonLog.info("first period id : " + unlockPeriodId);
                    }
                } else {
                    userLessonLog.info("=====课程已完成，获取第一个可学课时id=====");
                }

            } else {
                userLessonLog.info("=====开始学习=====");

                //记录课程进度
                Progress lessonProgress = new Progress();
                lessonProgress.setStatus(Progress.STATUS_ING);
                lessonProgress.setType(Progress.TYPE_LESSON);
                lessonProgress.setTargetID(lid);
                lessonProgress.setUserID(uid);
                lessonProgress.setSort(unlockPeriodId);
                progressService.insert(lessonProgress);
                userLessonLog.info("insert lesson progress success");

                //添加课程学习人数
                Integer lessonCount = lesson.getStudyCount();
                lesson.setStudyCount(lessonCount + 1);
                lessonService.update(lesson);

                //记录课时进度
                Progress periodProgress = new Progress();
                periodProgress.setStatus(Progress.STATUS_ING);
                periodProgress.setType(Progress.TYPE_PERIOD);
                periodProgress.setTargetID(unlockPeriodId);
                periodProgress.setUserID(uid);
                periodProgress.setSort(1L);
                progressService.insert(periodProgress);
                userLessonLog.info("insert period progress success");

                //添加课时学习人数
                Period unlockPeriod = periodService.getObjectById(unlockPeriodId);
                Integer periodCount = unlockPeriod.getStudyCount();
                unlockPeriod.setStudyCount(periodCount + 1);
                periodService.update(unlockPeriod);
            }


            model.addAttribute("code", 0);
            model.addAttribute("pid", unlockPeriodId);

        } catch (Throwable t) {
            t.printStackTrace();
            userLessonLog.error(t.getMessage());
            userLessonLog.error("start learn lesson error, lid is  " + lid);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/lesson/json/learnLesson";
    }


    /**
     * @param
     * @Description 获取用户
     * @Author: PeiyuFeng
     * @Time 2017/3/9 20:35
     */
    @RequestMapping(value = "/a/u/subject/sort", method = RequestMethod.POST)
    public String sort(HttpServletRequest request,
                       HttpServletResponse response, ModelMap model,
                       @RequestBody List<Long> ids) throws Exception {

        log.info("sort lesson : uids= " + ids);

        try {
            List<Subject> subjectList = subjectService
                    .getObjectsByIds(ids);

            int index = 1;
            for (Subject subject : subjectList) {
                subject.setSort(index);
                index = index + 1;
            }
            this.subjectService.updateList(subjectList);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add bookUnit error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @Description 获取精选课程列表
     * @Author: PeiyuFeng
     * @Time 2017/3/10 9:57
     */
    @RequestMapping(value = "/a/u/select/lesson/list", method = RequestMethod.GET)
    public String getSelectLesson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page,
                                  Integer size) throws Exception {

        log.info("get select lesson ");

        //课程课时id
        List<Long> periodIds = new ArrayList<>();
        List<Period> periodList = new ArrayList<>();
        Long periodOrderId = null;
        Long locksId = null;
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);
        User user = (User) request.getAttribute("user");
        Long uid = 0L;
        try {
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            } else {
                uid = user.getId();
                log.info("user : " + user);
            }

            Integer grade = user.getGrade();
            Integer userType = 0;
            if (User.preGrade.equals(grade)) {
                userType = Subject.user_type_preschool;
            } else {
                userType = Subject.user_type_primaryschool;
            }

            List<Long> ids = lessonService.getLessonIdsBySubjectTypeAndSelected(userType, start, size);
            List<Long> count = lessonService.getLessonIdsBySubjectTypeAndSelected(userType, 0, Integer.MAX_VALUE);
            log.info("get getLessonIdsBySubjectTypeAndSelected size is " + ids.size());

            List<Lesson> lessonList = lessonService.getObjectsByIds(ids);
            BigDecimal moneyPrice = new BigDecimal(0);
            Integer starPrice = 0;
            for (Lesson lesson : lessonList) {
                Long id = lesson.getSubject();
                Subject subject = subjectService.getObjectById(id);
                if (subject != null) {
                    lesson.setGradeType(subject.getGradeType());
                }
            }
            log.info("get lesson data is " + lessonList.size());

            for (Lesson lesson : lessonList) {
                if (lesson != null) {
                    Integer leve = lesson.getLevel();
                    Long subId = lesson.getSubject();
                    //查询lesson的levelName
                    if (null != lesson.getLevel()) {
                        Long gradeId = gradeClassRelationService.getGradeClassRelationIdsByGradeName
                                (subId, leve);
                        if (null != gradeId) {
                            GradeClassRelation gradeClassRelation = gradeClassRelationService.getObjectById(gradeId);
                            lesson.setLevelName(gradeClassRelation.getLevel());
                            lesson.setGradeIntroduce(gradeClassRelation.getIntroduce());
                        }
                    }


                    //计算星星和钱总价
                    periodIds = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(lesson.getId(), Period.status_normal, 0, Integer.MAX_VALUE);
                    periodList = periodService.getObjectsByIds(periodIds);
                    for (Period period : periodList) {
                        if (period.getLocked() == 1) {
                            locksId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, period.getId());
                            if (locksId == null) {
                                if (period.getMoneyPrice() != null) {
                                    moneyPrice = moneyPrice.add(period.getMoneyPrice());
                                }
                                if (period.getStarPrice() != null) {
                                    starPrice += period.getStar();
                                }
                            } else {
                                period.setUserLock(Locks.USER_UNLOCK);
                            }
                        } else {
                            lesson.setUserLock(Locks.USER_UNLOCK);
                            period.setUserLock(Locks.USER_UNLOCK);
                        }
                        //只要有一个课时解锁就是不锁定

                    }
                    lesson.setMoneyPrice(moneyPrice);
                    lesson.setStarPrice(starPrice);
                    moneyPrice = new BigDecimal(0);
                    starPrice = 0;

                    for (Period period : periodList) {
                        //只要有一个课时解锁就是不锁定
                        if (period.getLocked() == 1) {
                            if (lesson.getId() == 86) {
                                log.info(period.getId());
                            }
                            periodOrderId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, period.getId());
                            if (periodOrderId != null) {
                                lesson.setUserLock(2);
                                break;
                            }
                        } else {
                            lesson.setUserLock(2);
                            break;
                        }
                    }
                }
            }
            Integer total = count.size();
            log.info("get lesson count is " + total);

            model.addAttribute("code", 0);
            boolean next = false;
            if (lessonList.size() + start + 1 <= total) {
                next = true;
            }
            Integer totalPage = (total - 1) / size + 1;
            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("lessonList", lessonList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get lesson list error,page is  " + start + " , size "
                    + size);

            model.addAttribute("code", -100000);
        }

        return "/learn-course-service/lesson/json/lessonListJson";
    }

}

