package com.ptteng.course.home.controller;

import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.util.MyListUtil;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * Book  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class BookController {
    private static final Log log = LogFactory.getLog("book");

    @Autowired
    private BookService bookService;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private UserFavoriteRelationService userFavoriteRelationService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProgressService progressService;
    @Autowired
    private PaperService paperService;
    @Autowired
    private UserOrderService userOrderService;
    @Autowired
    private LocksService locksService;
    @Autowired
    private UserPaperRelationService userPaperRelationService;
    @Autowired
    private BookVersionService bookVersionService;
    @Autowired
    private BookSubjectService bookSubjectService;
    @Autowired
    private BookUnitService bookUnitService;


    /**
     * 分享教材详情
     *
     * @param request
     * @param response
     * @param model
     * @param bid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/book/detail/{bid}", method = RequestMethod.GET)
    public String getShareBookJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long bid, Integer start, Integer size)
            throws Exception {

        log.info("get data : id= " + bid);

        String paperPrice = "0";
        Map<Long, List<Period>> unitIds_Periods = new HashMap<>();

        try {

            Book book = bookService.getObjectById(bid);
            if (book == null) {
                model.addAttribute("code", -5044);
                return "/common/success";
            }

            List<Long> unitIds = bookUnitService.getBookUnitIdsByBid(bid);
            List<BookUnit> bookUnits = bookUnitService.getObjectsByIds(unitIds);

            for (Long unitId : unitIds) {
                Map<String, Object> params = DynamicUtil.getPeriodList(null, null, null, null, Period.Book, bid, unitId);
                List<Long> ids = periodService.getIdsByDynamicCondition(Period.class, params, 0, Integer.MAX_VALUE);
                List<Period> periodList = periodService.getObjectsByIds(ids);
                log.info("unit : " + unitId + " periodList : " + ids);
                unitIds_Periods.put(unitId, periodList);
            }

            BookVersion bookVersion = bookVersionService.getObjectById(book.getPress());
            String version = "";
            if (bookVersion != null) {
                version = bookVersion.getVersionName();
            } else {
                log.info("bookVersion : " + book.getPress() + " not exist");
            }

            model.addAttribute("code", 0);

            model.addAttribute("book", book);
            model.addAttribute("bookUnits", bookUnits);
            model.addAttribute("press", version);
            model.addAttribute("unitIds_Periods", unitIds_Periods);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get book error,id is  " + bid);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/book/json/bookDetailJson";
    }


    /**
     * 根据难度搜索教材
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param grade
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/book/list", method = RequestMethod.GET)
    public String getBookIdsByGradeOrderBySortJsonList(HttpServletRequest request,
                                                       HttpServletResponse response, ModelMap model, Integer page,
                                                       Integer size, Integer grade, String press, Long sid) throws Exception {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        log.info("pageList : page= " + start + " , size=" + size);
        Integer total = 0;
        List<Book> bookList = null;
        List<Long> ids = new LinkedList<>();
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        try {
            Map<String, Object> params = DynamicUtil.getBookList(null, press, grade, null, sid);
            log.info("params : " + params);
            List<Long> bookIds = bookService.getIdsByDynamicCondition(Book.class, params, start, size);
            log.info("book ids : " + bookIds);
            List<Long> count = bookService.getIdsByDynamicCondition(Book.class, params, 0, Integer.MAX_VALUE);
            bookList = bookService.getObjectsByIds(bookIds);
            total = count.size();
            Long periodId = null;
            Long paperId = null;
            List<Long> periodIds = null;
            Map<String, Object> param = new HashedMap();
            List<Period> periodList = null;
            Paper paper = new Paper();
            Long orderId = null;
            String paperPrice = "0";
            Double price = 0D;
            for (Book book : bookList) {
                param = DynamicUtil.getPeriodList(null, null, null, null, Period.Book, book.getId(), null);
                periodIds = periodService.getIdsByDynamicCondition(Period.class, param, 0, Integer.MAX_VALUE);
                if (periodIds != null) {
                    periodList = periodService.getObjectsByIds(periodIds);
                    if (periodList != null && periodList.size() > 0) {
                        for (Period period : periodList) {
                            paperId = period.getPaperID();
                            if (paperId != null) {
                                paper = paperService.getObjectById(paperId);
                                if (paper != null) {
                                    orderId = userOrderService.getUserOrderIdsByUidAndBuyTypeAndTargetId(uid, UserOrder.ORDER_PPAPER, paper.getId());
                                    if (orderId == null) {
                                        price = Double.valueOf(paperPrice) + Double.valueOf(paper.getPrice());
                                        log.info("===============================" + price);
                                        paperPrice = price.toString();
                                    }
                                }
                            }
                        }
                    }

                }
                book.setPaperPrice(paperPrice);
                paperPrice = "0";
                price = 0D;
            }

            List<Long> versionIds = MyListUtil.getFieldValueListFromModelList(bookList, false, Book.class.getDeclaredField("press"));
            List<BookVersion> bookVersions = bookVersionService.getObjectsByIds(versionIds);
            Map<Long, String> id_version = MyListUtil.convert2Map(BookVersion.class.getDeclaredField("id"), BookVersion.class.getDeclaredField("versionName"), bookVersions);


            model.addAttribute("code", 0);
            boolean next = false;
            if (ids.size() + start + 1 <= total) {
                next = true;
            }
            Integer totalPage = total / size + 1;
            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("bookList", bookList);
            model.addAttribute("id_version", id_version);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get book list error,page is  " + start + " , size " + size);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/book/json/bookListJson";
    }

    /**
     * 教材详情
     *
     * @param request
     * @param response
     * @param model
     * @param bid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/book/detail/{bid}", method = RequestMethod.GET)
    public String getBookJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, @PathVariable Long bid, Integer start, Integer size)
            throws Exception {

        log.info("get data : id= " + bid);
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        Map<Long, List<Period>> unitIds_Periods = new HashMap<>();
        Progress progress = new Progress();
        Long progressID = 0L;
        Long progressId = null;
        Long paperId = null;
        String paperPrice = "0";
        Paper paper = null;
        Double price = 0D;
        Long orderId = null;
        try {

            Boolean memberStatus = false;
            Integer member = user.getMember();
            log.info("user member status : " + member);
            if (User.IS_MEMBER == member) {
                log.info("user is member");
                memberStatus = true;
            }

            Book book = bookService.getObjectById(bid);
            if (book == null) {
                model.addAttribute("code", -5044);
                return "/common/success";
            }

            List<Long> unitIds = bookUnitService.getBookUnitIdsByBidAndStatus(bid, BookUnit.STATUS_ON);
            List<BookUnit> bookUnits = bookUnitService.getObjectsByIds(unitIds);

            for (Long unitId : unitIds) {
                Map<String, Object> params = DynamicUtil.getPeriodList(null, null, null, null, Period.Book, bid, unitId);
                List<Long> ids = periodService.getIdsByDynamicCondition(Period.class, params, 0, Integer.MAX_VALUE);
                List<Period> periodList = periodService.getObjectsByIds(ids);
                log.info("unit : " + unitId + " periodList : " + ids);
                unitIds_Periods.put(unitId, periodList);

                Map<String, Object> param = null;
                Long periodOrderId = null;
                for (Period period : periodList) {
                    log.info("=====验证是否收藏，学习进度=====");
                    progressID = userFavoriteRelationService.getUserFavoriteRelationIdByUserIDAndTypeAndTargetID(uid, UserFavoriteRelation.TYPE_PERIOD, period.getId());
                    if (progressID != null) {
                        period.setFavorite(UserFavoriteRelation.STATUS_LIKE);
                    }

                    //学习进度
                    List<Long> progressList = new ArrayList<>();
                    param = DynamicUtil.getTaskList(null, null, null, null, period.getId(), null, 1);
                    List<Long> taskIds = taskService.getIdsByDynamicCondition(Task.class, param, 0, Integer.MAX_VALUE);
                    if (taskIds != null && taskIds.size() > 0) {
                        period.setTaskCount(taskIds.size());
                        periodService.update(period);
                        for (Long taskId : taskIds) {
                            progressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, taskId, Progress.TYPE_TASK);
                            if (null != progressId) {
                                progressList.add(progressId);
                            }
                        }
                        period.setProgress(progressList.size());
                    }
                    //学习状态
                    progressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, period.getId(), Progress.TYPE_PERIOD);
                    progress = progressService.getObjectById(progressId);
                    if (progress != null) {
                        period.setOver(progress.getStatus());
                    }
                    paperId = period.getPaperID();
                    if (paperId != null) {
                        paper = paperService.getObjectById(paperId);
                        if (paper != null) {

                            orderId = userPaperRelationService.getUserTargetRelationIdsByTypeAndUidAndTargetId(UserPaperRelation.TYPE_PPAPER, uid, period.getId());
                            period.setPaperPrice(paper.getPrice());
                            if (orderId == null) {
                                price = Double.valueOf(paperPrice) + Double.valueOf(paper.getPrice());
                                paperPrice = price.toString();
                                period.setBuy(Period.notBuy);
                                book.setBuy(Book.notBuy);
                            } else {
                                period.setBuy(Period.Buy);
                            }
                        }
                    } else {
                        period.setBuy(Period.noPaper);
                    }
                    if (period.getLocked() == 1) {
                        periodOrderId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, period.getId());
                        if (periodOrderId != null) {
                            period.setUserLock(2);
                            book.setUserLock(2);
                        }
                    } else {
                        book.setUserLock(2);
                        period.setUserLock(2);
                    }

                }
            }

            List<Long> ids = periodService.getPeriodIdsByBookIdOrderBySort(bid, 0, Integer.MAX_VALUE);
            List<Period> periodList = periodService.getObjectsByIds(ids);
            log.info(periodList);

            if (book.getPaperCount() == 0) {
                book.setBuy(Book.noPaper);
            }
            //查询最近的一个订单
            List<Long> orderIds = new LinkedList<>();
            Long orderID = null;
            if (book.getBuy().equals(Book.Buy)) {
                orderID = userOrderService.getUserOrderIdsByUidAndBuyTypeAndTargetId(uid, UserOrder.ORDER_BPAPER, book.getId());
                if (orderID != null) {
                    book.setOrderId(orderID);
                } else {
                    for (Period period : periodList) {
                        if (period.getPaperID() != null) {
                            orderID = userOrderService.getUserOrderIdsByUidAndBuyTypeAndTargetId(uid, UserOrder.ORDER_PPAPER, period.getPaperID());
                            if (orderID != null) {
                                orderIds.add(orderID);
                            }
                        }
                    }
                }
            }
            List<UserOrder> userOrders = userOrderService.getObjectsByIds(orderIds);
            if (orderIds.size() > 0 && orderIds.size() < 2) {
                book.setOrderId(orderIds.get(0));
            } else if (orderIds.size() > 1) {
                long s = userOrders.get(0).getId();
                for (int i = 0; i < userOrders.size() - 1; i++) {
                    if (userOrders.get(i).getCreateAt() < userOrders.get(i + 1).getCreateAt()) {
                        s = userOrders.get(i + 1).getId();
                    }
                }
                book.setOrderId(s);
            }
            progressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, book.getId(), Progress.TYPE_BOOK);
            progress = progressService.getObjectById(progressId);
            if (progress != null) {
                book.setOver(progress.getStatus());
            }
            log.info("userLock" + book.getUserLock() + "over" + book.getOver());

            if (memberStatus) {
                if (book.getOver() == 3 || book.getOver() == null) {
                    model.addAttribute("continue", 2);
                } else {
                    model.addAttribute("continue", 3);
                }
            } else {
                if (book.getUserLock() == 1) {
                    model.addAttribute("continue", 1);
                } else if (book.getUserLock() == 2 && book.getOver() == 3) {
                    model.addAttribute("continue", 2);
                } else if (book.getUserLock() == 2 && book.getOver() == null) {
                    model.addAttribute("continue", 2);
                } else {
                    model.addAttribute("continue", 3);
                }
            }


            book.setPaperPrice(paperPrice);
//            log.info("get book data is " + book);

            BookVersion bookVersion = bookVersionService.getObjectById(book.getPress());
            String version = "";
            if (bookVersion != null) {
                version = bookVersion.getVersionName();
            } else {
                log.info("bookVersion : " + book.getPress() + " not exist");
            }

            log.info("unitIds_Periods : " + unitIds_Periods);

            model.addAttribute("code", 0);
            model.addAttribute("book", book);
            model.addAttribute("press", version);
            model.addAttribute("bookUnits", bookUnits);
            model.addAttribute("unitIds_Periods", unitIds_Periods);
            model.addAttribute("periodList", periodList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get book error,id is  " + bid);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/book/json/bookDetailJson";
    }


    /**
     * 开始继续学习教材
     *
     * @param request
     * @param response
     * @param model
     * @param bid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/learn/book/{bid}", method = RequestMethod.POST)
    public String learnBook(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long bid) throws Exception {

        List<Long> periodIds = new ArrayList<>();
        List<Period> periods = new ArrayList<>();
        Long unlockPeriodId = 0L;
        Long lockedId = 0L;
        Period period = new Period();
        Integer locked = 0;
        Boolean unlockStatus = false;
        Long pid = 0L;
        Progress learnPeriodProgress = new Progress();
        Integer sort = null;

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        log.info("user : " + uid + " get start learn book : " + bid);

        try {

            Boolean memberStatus = false;
            Integer member = user.getMember();
            log.info("user member status : " + member);
            if (User.IS_MEMBER == member) {
                log.info("user is member");
                memberStatus = true;
            }

            log.info("=====教材是否存在=====");
            Book book = bookService.getObjectById(bid);
            if (null == book) {
                log.info("book is not exist");
                model.addAttribute("code", -5044);
                return "/common/success";
            }
            log.info("lesson exist");

            log.info("=====教材是否所有课时上锁、获取本教材第一个可学课时=====");
            periodIds = periodService.getPeriodIdsByBookIDAndStatusOrderBySort(bid, Book.status_normal, 0, Integer.MAX_VALUE);

            if (CollectionUtils.isEmpty(periodIds)) {
                log.info("no period in the book");
                model.addAttribute("code", -4046);
                return "/common/success";
            } else {
                log.info("there are " + periodIds.size() + " period in book");
            }

            for (Long periodId : periodIds) {
                period = periodService.getObjectById(periodId);
                locked = period.getLocked();
                if (Period.UnLock.equals(locked)) {
                    unlockStatus = true;
                    unlockPeriodId = periodId;
                    break;
                } else if (Period.Lock.equals(locked)) {
                    log.info("uid is" + uid + "locks " + Locks.TYPE_PERIOD + "periodId" + periodId);
                    lockedId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, periodId);
                    if (null != lockedId) {
                        unlockStatus = true;
                        unlockPeriodId = periodId;
                        break;
                    }
                }
            }
            log.info("first unlock period : " + unlockPeriodId);


            if (!unlockStatus && !memberStatus) {
                //用户非会员且无被解锁课程
                log.info("every period is locked");
                model.addAttribute("code", -4025);
                return "/common/success";
            } else if (memberStatus) {
                //用户为会员，直接取第一个课时
                unlockPeriodId = periodIds.get(0);
                log.info("user is member , so first period " + unlockPeriodId + " is must unlock");
            } else {
                //用户非会员，取第一个解锁课时
                log.info("user is not member , so first unlock period is " + unlockPeriodId);
            }

            //第一个可学课程 第一个任务是否存在
            Long tid = taskService.getTaskIdsByPeriodIDAndSort(unlockPeriodId, 1);
            if (null == tid) {
                log.info("the period have no task");
                model.addAttribute("code", -4028);
                return "/common/success";
            } else {
                log.info("first task in period " + unlockPeriodId + " is " + tid);
            }

            log.info("=====判断是开始学习还是继续学习=====");
            Long progressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, bid, Progress.TYPE_BOOK);
            if (null != progressId) {

                log.info("=====继续学习=====");
                Progress progress = progressService.getObjectById(progressId);
                if (Progress.STATUS_ING.equals(progress.getStatus())) {

                    log.info("=====教材学习中，获取最后一个学习中课时id=====");
                    Period nextPeriod = periodService.getObjectById(progress.getSort());

                    if (Period.status_normal.equals(nextPeriod.getStatus())) {
                        log.info("=====最后在学课时未被下架=====");
                        unlockPeriodId = progress.getSort();
                        log.info("period id : " + unlockPeriodId);

                    } else {
                        if (!Period.status_freeze.equals(nextPeriod.getStatus())) {
                            log.info("=====最后在学课时状态错误，获取第一个在学课时=====");
                            log.info("period status error");
                        }

                        log.info("=====最后在学课时被下架，获取第一个在学课时=====");
                        periods = periodService.getObjectsByIds(periodIds);

                        List<Long> unitIds = MyListUtil.getFieldValueListFromModelList(periods, false, Period.class.getDeclaredField("unitId"));
                        List<BookUnit> units = bookUnitService.getObjectsByIds(unitIds);
                        Map<Long, Integer> buid_sort = MyListUtil.convert2Map(BookUnit.class.getDeclaredField("id"), BookUnit.class.getDeclaredField("sort"), units);

                        //获取教材每个课时
                        Integer unitSort = 0;
                        Long learnPeriodId = 0L;
                        for (Period learnPeriod : periods) {
                            pid = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, learnPeriod.getId(), Progress.TYPE_PERIOD);
                            //是否学习该课时
                            if (null != pid) {
                                learnPeriodProgress = progressService.getObjectById(pid);
                                //判断是否学习中
                                if (Progress.STATUS_ING.equals(learnPeriodProgress.getStatus())) {
                                    //若学习中，取出sort序号比较：第一个课时id不存在：添加，存在：比较大小、若小则替换
                                    if(learnPeriod.getUnitId() == null){
                                        log.info("period no belongs units");
                                        model.addAttribute("code", -4049);
                                        return "/common/success";
                                    }else {
                                        if (null == sort || null == unitSort) {
                                            unitSort = buid_sort.get(learnPeriod.getUnitId());
                                            sort = learnPeriod.getSort();
                                            learnPeriodId = learnPeriod.getId();
                                        } else {
                                            if(buid_sort.get(learnPeriod.getUnitId()) < unitSort && learnPeriod.getSort() < sort){
                                                unitSort = buid_sort.get(learnPeriod.getUnitId());
                                                sort = learnPeriod.getSort();
                                                learnPeriodId = learnPeriod.getId();
                                            }
                                        }
                                    }
                                }
                            }
                        }

                        if (null != sort && null != unitSort) {
                            unlockPeriodId = learnPeriodId;
                        } else {
                            log.info("=====在学课时全部下架，获取第一个可学课时id=====");

                            //记录课时进度
                            Progress periodProgress = new Progress();
                            periodProgress.setStatus(Progress.STATUS_ING);
                            periodProgress.setType(Progress.TYPE_PERIOD);
                            periodProgress.setTargetID(unlockPeriodId);
                            periodProgress.setUserID(uid);
                            periodProgress.setSort(1L);
                            progressService.insert(periodProgress);
                            log.info("insert period progress success");

                            //添加课时学习人数
                            Period unlockPeriod = periodService.getObjectById(unlockPeriodId);
                            Integer periodCount = unlockPeriod.getStudyCount();
                            unlockPeriod.setStudyCount(periodCount + 1);
                            periodService.update(unlockPeriod);
                        }

                        log.info("first period id : " + unlockPeriodId);
                    }

                } else {
                    log.info("=====教材已完成，获取第一个可学课时id=====");
                }

            } else {
                log.info("=====开始学习=====");

                //记录教材进度
                Progress bookProgress = new Progress();
                bookProgress.setStatus(Progress.STATUS_ING);
                bookProgress.setType(Progress.TYPE_BOOK);
                bookProgress.setTargetID(bid);
                bookProgress.setUserID(uid);
                bookProgress.setSort(unlockPeriodId);
                progressService.insert(bookProgress);
                log.info("insert book progress success");

                //记录课时进度
                Progress periodProgress = new Progress();
                periodProgress.setStatus(Progress.STATUS_ING);
                periodProgress.setType(Progress.TYPE_PERIOD);
                periodProgress.setTargetID(unlockPeriodId);
                periodProgress.setUserID(uid);
                periodProgress.setSort(1L);
                progressService.insert(periodProgress);
                log.info("insert period progress success");

                //添加课时学习人数
                Period unlockPeriod = periodService.getObjectById(unlockPeriodId);
                Integer periodCount = unlockPeriod.getStudyCount();
                unlockPeriod.setStudyCount(periodCount + 1);
                periodService.update(unlockPeriod);
            }

            model.addAttribute("code", 0);
            model.addAttribute("pid", unlockPeriodId);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("start learn lesson error, bid is  " + bid);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/lesson/json/learnLesson";
    }


    /**
     * 用户学习教材id
     *
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/learn/book", method = RequestMethod.GET)
    public String getBook(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

        Long bookId = null;

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        log.info("user : " + uid + " get learn book");

        try {

            List<Long> bookIds = new ArrayList<>();
            List<Book> books = new ArrayList<>();
            Map<Long, String> id_version = new HashMap<>();

            log.info("=====是否有在学教材=====");
            List<Long> progressId = progressService.getProgressIdsByUserIDAndTypeOrderByUpdateAt(uid, Progress.TYPE_BOOK, 0, Integer.MAX_VALUE);

            if (CollectionUtils.isNotEmpty(progressId)) {
                log.info("=====继续学习=====");
                List<Progress> progress = progressService.getObjectsByIds(progressId);
                bookIds = MyListUtil.getFieldValueListFromModelList(progress, false, Progress.class.getDeclaredField("targetID"));
                bookId = bookIds.get(0);

                books = bookService.getObjectsByIds(bookIds);
                List<Long> versionIds = MyListUtil.getFieldValueListFromModelList(books, false, Book.class.getDeclaredField("press"));

                List<BookVersion> bookVersions = bookVersionService.getObjectsByIds(versionIds);
                id_version = MyListUtil.convert2Map(BookVersion.class.getDeclaredField("id"), BookVersion.class.getDeclaredField("versionName"), bookVersions);

            } else {
                log.info("=====无在学教材=====");
            }

            model.addAttribute("code", 0);
            model.addAttribute("bid", bookId);
            model.addAttribute("books", books);
            model.addAttribute("id_version", id_version);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get learn book error");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/book/json/getBook";
    }

    /**
     * @param ids 教材id
     * @Description 新增用户学习教材
     * @Author: PeiyuFeng
     * @Time 2017/3/30 18:02
     */
    @RequestMapping(value = "/a/u/user/book/list", method = RequestMethod.POST)
    public String addUserBook(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                              Long ids[]) throws Exception {

        log.info("add user book : ids= " + ids);

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        try {
            List<Long> idList = Arrays.asList(ids);

            List<Book> books = bookService.getObjectsByIds(idList);
            List<Progress> progresses = new ArrayList<>();

            for (Book book : books) {
                Progress progress = new Progress();
                progress.setUserID(uid);
                progress.setTargetID(book.getId());
                progress.setType(Progress.TYPE_BOOK);
                progress.setStatus(Progress.STATUS_ING);
                progresses.add(progress);

                Integer bookCount = book.getStudyCount();
                book.setStudyCount(bookCount + 1);
            }
            progressService.insertList(progresses);
            bookService.updateList(books);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add book error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param ids 教材id
     * @Description 删除用户在学教材
     * @Author: PeiyuFeng
     * @Time 2017/3/30 20:22
     */
    @RequestMapping(value = "/a/u/user/book/list", method = RequestMethod.DELETE)
    public String deleteUserBook(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                 Long ids[]) throws Exception {

        log.info("delete user book : ids= " + ids);

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        try {
            List<Long> pids = new ArrayList<>();

            for (Long id : ids) {
                Long pid = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, Long.valueOf(id), Progress.TYPE_BOOK);
                if (pid != null) {
                    pids.add(pid);
                } else {
                    log.info("user : " + uid + " and book : " + id + " relation not exist");
                }

            }
            progressService.deleteList(Progress.class, pids);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete book error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @Description 查看科目列表
     * @Author: PeiyuFeng
     * @Time 2017/3/31 14:21
     */
    @RequestMapping(value = "/a/u/book/subject/list", method = RequestMethod.GET)
    public String getBookSubjectList(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

        log.info("get book subject list ");
        List<Long> idList = new ArrayList();

        try {
            Map<String, Object> params = DynamicUtil.getBookSubjectList(null, BookSubject.STATUS_ON);
            idList = bookSubjectService.getIdsByDynamicCondition(BookSubject.class, params, 0, Integer.MAX_VALUE);
            List<BookSubject> bookSubjects = bookSubjectService.getObjectsByIds(idList);
            log.info("get book subject data is " + bookSubjects.size());

            model.addAttribute("code", 0);
            model.addAttribute("bookSubjectList", bookSubjects);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get bookSubject error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/bookSubject/json/bookSubjectListJson";
    }

}

