package com.ptteng.course.util;


import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.learn.common.model.Message;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.map.HashedMap;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * Created by liangxj on 2015/9/7.
 */
public class
DynamicUtil {

    public static Map<String, Object> getVersionList(Integer type, String os, String version) {
        Map<String, Object> params = new HashedMap();

        params.put("type", type);
        params.put("img", " '" + os + "'");
        params.put("title &>", " '" + version + "'");
        params.put("@order", "  is_force_update desc ");
        params.put("@query", " id");
        params.put("@table", " article ");

        return params;
    }

    public static Map<String, Object> getLessonList(String name, Long subjectId, Integer level) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like", " '%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(subjectId)) {
            params.put("subject_id", "'" + subjectId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(level)) {
            params.put("level", "'" + level + "'");
        }
        params.put("status", 1);
        params.put("@order", "  sort asc,update_at desc,level ");
        params.put("@query", " id");

        params.put("@table", " lesson ");

        return params;
    }


    public static Map<String, Object> getPeriodList(Integer level, String name, Long lessonId,
                                                    Long subjectId, Integer type, Long bookId, Long unitId) {
        Map<String, Object> params = new HashedMap();
        System.out.println(name + "name" + "lessonId" + lessonId + "subjectID" + subjectId + "type" + type);
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like", " '%" + name + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(lessonId)) {

            params.put("lesson_id", "'" + lessonId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(subjectId)) {

            params.put("subject_id", "'" + subjectId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {

            params.put("type", "'" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(level)) {

            params.put("level", "'" + level + "'");
        }
        if (DataUtils.isNotNullOrEmpty(bookId)) {

            params.put("book_id", "'" + bookId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(unitId)) {

            params.put("unit_id", "'" + unitId + "'");
        }
        params.put("status", 1);


        params.put("@order", "  sort ,level ");
        params.put("@query", " id ");

        params.put("@table", "  period ");

        return params;

    }


    public static Map<String, Object> getMessageList(Integer grade, String name, Integer messageType, String nick, Long timeLow, Long timeHigh, String mail, Integer type, Long userId) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like", " '%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(mail)) {
            params.put("mail & like", " '%" + mail + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(nick)) {
            params.put("nick & like", " '%" + nick + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(messageType)) {
            params.put("message_type", "'" + messageType + "'");
        }
        if (DataUtils.isNotNullOrEmpty(timeLow)) {
            params.put("create_at&>", "'" + timeLow + "'");
        }

        if (DataUtils.isNotNullOrEmpty(type) && DataUtils.isNotNullOrEmpty(userId)) {
            if (type == 1) {
                if (grade == 7) {
                    params.put("&((type =", "'" + 1 + "' and grade =7)  or  (type=4 and user_id =" + userId + "))");

                } else {
                    params.put("&((type =", "'" + 1 + "' and grade =7)  or  (type=4 and user_id =" + userId + ") or  (type=1 and grade = " + grade + "))");

                    System.out.println(grade);
                }

            } else {
                params.put("type", "'" + type + "'");
            }
        }

        if (DataUtils.isNotNullOrEmpty(timeHigh)) {
            params.put("create_at&<", "'" + timeHigh + "'");
        }
        params.put("up_down", 1);
        if (Message.Type_Help.equals(type)) {
            params.put("@order", "  sort asc ");

        } else {
            params.put("@order", "  publish_at desc ");

        }
        params.put("@query", " id");

        params.put("@table", " message ");
        return params;
    }

    public static Map<String, Object> getPaperList(Long subjectId, Long lessonId, Long periodId, Long bookId, Integer level, Integer type) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(subjectId)) {
            params.put("subject_id", " '" + subjectId + "'");
        }

        if (DataUtils.isNotNullOrEmpty(lessonId)) {
            params.put("lesson_id", " '" + lessonId + "'");
        }


        if (DataUtils.isNotNullOrEmpty(bookId)) {
            params.put("book_id", " '" + bookId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", " '" + type + "'");
        }

        if (DataUtils.isNotNullOrEmpty(periodId)) {
            params.put("period_id", " '" + periodId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(level)) {
            params.put("level", " '" + level + "'");
        }

        params.put("@order", "  create_at desc ");
        params.put("@query", " paper.id");

        params.put("@table", " paper ");

        return params;
    }


    public static Map<String, Object> getArticleListParam(Long startAt, Long endAt,
                                                          Integer type, String title, String source, String status) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put(" update_at & >= ", "'" + startAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put("title & like", " '%" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put(" update_at & <= ", "'" + endAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }

        if (DataUtils.isNotNullOrEmpty(source)) {
            params.put("source", " '" + source + "' ");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);

        }


        params.put("@order", " orderBy asc, create_at desc ");
        params.put("@query", " id ");

        params.put("@table", "  article ");

        return params;
    }


    public static Map<String, Object> getTaskList(Integer type, String name, Long subjectId, Long lessonId, Long periodId, Integer level, Integer status) {
        Map<String, Object> params = new HashedMap();

        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like", " '%" + name + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(subjectId)) {
            params.put("subject_id", " '" + subjectId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", " '" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(lessonId)) {
            params.put("lesson_id", " '" + lessonId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(periodId)) {
            params.put("period_id", " '" + periodId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(level)) {
            params.put("level", " '" + level + "'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", " '" + status + "'");
        }
        params.put("@order", "  sort ,level ");
        params.put("@query", " id");

        params.put("@table", " task ");

        return params;
    }

    public static Map<String, Object> getUserMessageList(Long targetId, Long userId, Integer userRead) {
        Map<String, Object> params = new HashedMap();

        if (DataUtils.isNotNullOrEmpty(targetId)) {
            params.put("target_id", " '" + targetId + "'");
        }

        if (DataUtils.isNotNullOrEmpty(userId)) {
            params.put("user_id", " '" + userId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(userRead)) {
            params.put("user_read", " '" + userRead + "'");
        }

        params.put("@order", "  create_at desc ");
        params.put("@query", " id");

        params.put("@table", " user_message_relation ");

        return params;
    }


    public static Map<String, Object> getBookList(String name, String press, Integer grade, Integer term, Long sid) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("statistics");
        if (name != null) {
            params.put("name & like", " '%" + name + "%'");
        }
        if (grade != null) {
            params.put("grade", "'" + grade + "'");
        }
        if (press != null) {
            params.put("press", "'" + press + "'");
        }
        if (term != null) {
            params.put("term", term);
        }
        if (sid != null) {
            params.put("sid", sid);
        }
        params.put("status", 1);

        params.put("@order", " grade asc,press asc");

        params.put("@query", " id ");


        params.put("@table", " book");

        return params;

    }


    public static Map<String, Object> getBookSubjectList(String name, Integer status) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("unit_name & like", " '%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        params.put("@order", "  sort asc,update_at desc ");
        params.put("@query", " id");

        params.put("@table", " book_subject ");

        return params;
    }


    public static Map<String, Object> getDictationWordsList(Long sid, Long uid) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("dictation_note");
        tables.add("dictation_words");
        if (sid != null) {
            params.put("dictation_note.sid", sid);
        }
        if (uid != null) {
            params.put("dictation_note.uid", uid);
        }
        params.put("dictation_note.id", "dictation_words.nid");

        params.put("@order", " dictation_words.create_at desc");

        params.put("@query", " dictation_words.id ");

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }

    public static Map<String, Object> getDictationWord(String img, String content, Integer type, Long uid, Long pid) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("dictation_note");
        tables.add("dictation_words");

        params.put("dictation_note.uid", uid);

        params.put("dictation_words.img", " '" + img + "'");

        params.put("dictation_words.pid", pid);

        params.put("dictation_words.content", " '" + content + "'");

        params.put("dictation_words.type", type);

        params.put("dictation_note.id", "dictation_words.nid");

        params.put("@query", " dictation_words.id ");

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }
}
