package com.ptteng.course.home.controller;

import java.math.BigDecimal;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.crypto.Data;


import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.common.util.PasswordUtils;
import com.ptteng.course.constant.AlipayConstantConfig;
import com.ptteng.course.constant.WxConstantConfig;
import com.ptteng.course.util.Base64;
import com.ptteng.course.util.OrderIdUtil;
import com.ptteng.course.util.aliPayUtil.util.AlipaySubmit;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.json.GsonUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * UserOrder  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class UserOrderController {
    private static final Log orderlog = LogFactory.getLog("order");


    @Autowired
    private UserOrderService userOrderService;
    @Autowired
    private PaperService paperService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private LocksService locksService;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private BookService bookService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserPaperRelationService userPaperRelationService;
    @Autowired
    private UserMemberRelationService userMemberRelationService;
    @Autowired
    private UserRecommendService userRecommendService;
    @Autowired
    private HttpClientUtil httpClientUtil;
    @Autowired
    private MemberService memberService;


    //新建订单
    @RequestMapping(value = "/a/u/order", method = RequestMethod.POST)
    public String createOrder(HttpServletRequest request, HttpServletResponse response,
                              ModelMap model, Long targetId, Integer type) throws Exception {
        Long oid = 0L;
        String name = "";
        Long relationId = 0L;
        Long lockedId = 0L;
        Paper paper = new Paper();
        Period period = new Period();
        String paperPrice = "";

        BigDecimal price = new BigDecimal(0);
        Boolean lockStatus = false;
        List<Long> lessonPeriodIds = new ArrayList<>();
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        orderlog.info("get uid " + uid);

        orderlog.info("create order : targetId = " + targetId + " type = " + type);
        String mail = user.getMail();
        try {
            orderlog.info("==========参数校验==========");
            if (DataUtils.isNullOrEmpty(type) || DataUtils.isNullOrEmpty(targetId)) {
                orderlog.info("params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            orderlog.info("==========购买目标是否存在==========");
            if (UserOrder.ORDER_PERIOD == type) {
                period = periodService.getObjectById(targetId);
                if (null == period) {
                    orderlog.info("period not exist");
                    model.addAttribute("code", -4012);
                    return "/common/success";
                }
                if (Period.UnLock.equals(period.getLocked())) {
                    orderlog.info("period not locked");
                    model.addAttribute("code", -4021);
                    return "/common/success";
                }
                price = period.getMoneyPrice();
                name = period.getName();

            } else if (UserOrder.ORDER_LESSON == type) {
                Lesson lesson = lessonService.getObjectById(targetId);
                if (null == lesson) {
                    orderlog.info("lesson not exist");
                    model.addAttribute("code", -4019);
                    return "/common/success";
                }

                lessonPeriodIds = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(targetId, Period.status_normal, 0, Integer.MAX_VALUE);
                for (Long periodId : lessonPeriodIds) {
                    period = periodService.getObjectById(periodId);
                    if (Period.Lock.equals(period.getLocked())) {
                        lockedId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, periodId);
                        if (null == lockedId) {
                            lockStatus = true;
                            price = price.add(period.getMoneyPrice());
                        }
                    }
                }
                orderlog.info("lock status : " + lockStatus);
                if (!lockStatus) {
                    orderlog.info("lesson not lock period");
                    model.addAttribute("code", -4036);
                    return "/common/success";
                }
                name = lesson.getName();

            } else if (UserOrder.ORDER_PPAPER == type) {
                period = periodService.getObjectById(targetId);
                if (null == period) {
                    orderlog.info("period not exist");
                    model.addAttribute("code", -4012);
                    return "/common/success";
                }
                Long pid = paperService.getPaperIdByPeriodId(targetId);
                if (null == pid) {
                    orderlog.info("period not paper");
                    model.addAttribute("code", -4026);
                    return "/common/success";
                }
                Long periodPaperID = period.getPaperID();
                Paper paper1 = paperService.getObjectById(periodPaperID);
                price = new BigDecimal(paper1.getPrice());
                name = period.getName();
            } else if (UserOrder.ORDER_LPAPER == type) {
                Lesson lesson = lessonService.getObjectById(targetId);
                if (null == lesson) {
                    orderlog.info("lesson not exist");
                    model.addAttribute("code", -4019);
                    return "/common/success";
                }
                //课程是否有未购课时资料
                lessonPeriodIds = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(targetId, Period.status_normal, 0, Integer.MAX_VALUE);
                orderlog.info("lessonPeriodIds size : " + lessonPeriodIds.size());
                List<Period> lessonPeriods = periodService.getObjectsByIds(lessonPeriodIds);
                for (Period period1 : lessonPeriods) {
                    if (null != period1.getPaperID()) {
                        relationId = userPaperRelationService.getUserTargetRelationIdsByTypeAndUidAndTargetId(UserPaperRelation.TYPE_PPAPER, uid, period1.getId());
                        if (null == relationId) {
                            paperPrice = paperService.getPaperPriceByPeriodId(period1.getId());
                            lockStatus = true;
                            price = price.add(new BigDecimal(paperPrice));
                        }
                    }
                }
                orderlog.info("lock status : " + lockStatus);
                if (!lockStatus) {
                    orderlog.info("lesson not paper");
                    model.addAttribute("code", -4027);
                    return "/common/success";
                }
                name = lesson.getName();

            } else if (UserOrder.ORDER_BPAPER == type) {
                Book book = bookService.getObjectById(targetId);
                if (null == book) {
                    orderlog.info("book not exist");
                    model.addAttribute("code", -5044);
                    return "/common/success";
                }
                //教材是否有未购课时资料
                lessonPeriodIds = periodService.getPeriodIdsByBookIDAndStatusOrderBySort(targetId, Period.status_normal, 0, Integer.MAX_VALUE);
                List<Period> lessonPeriods = periodService.getObjectsByIds(lessonPeriodIds);
                for (Period period1 : lessonPeriods) {
                    if (null != period1.getPaperID()) {
                        relationId = userPaperRelationService.getUserTargetRelationIdsByTypeAndUidAndTargetId(UserPaperRelation.TYPE_PPAPER, uid, period1.getId());
                        if (null == relationId) {
                            paperPrice = paperService.getPaperPriceByPeriodId(period1.getId());
                            lockStatus = true;
                            price = price.add(new BigDecimal(paperPrice));
                        }
                    }
                }
                orderlog.info("lock status : " + lockStatus);
                if (!lockStatus) {
                    orderlog.info("book not paper");
                    model.addAttribute("code", -4030);
                    return "/common/success";
                }
                name = book.getName();
            } else if (UserOrder.ORDER_MEMBER == type) {

                //判断用户是否是会员，如果不是，才能购买(已被续费替代)
//                if(User.IS_MEMBER== user.getMember()){
//                    model.addAttribute("code", -6003);
//                    return "/common/success";
//                }else {
                Member member = memberService.getObjectById(targetId);
                if (null == member) {
                    orderlog.info("no such member");
                    model.addAttribute("code", -6008);
                    return "/common/success";
                } else {

                    Boolean discountStatus = false;
                    BigDecimal discount = BigDecimal.ZERO;

                    //是否购买过会员
                    List<Long> orderIds = userOrderService.getUserOrderIdsByUidAndBuyTypeAndStatus(uid, UserOrder.ORDER_MEMBER, UserOrder.COMPLETED, 0, Integer.MAX_VALUE);
                    if (CollectionUtils.isEmpty(orderIds)) {
                        orderlog.info(" get user memberList ids ,size is 0 ");

                        Long recommendId = user.getRecommendId();
                        if(null == recommendId){
                            orderlog.info("user have no recommend user ");
                        }else {
                            orderlog.info("recommend id is : " + recommendId);
                            discountStatus = true;
                            UserRecommend recommendUser = userRecommendService.getObjectById(recommendId);
                            discount = recommendUser.getDiscount();
                        }

                    } else {
                        orderlog.info(" user almost buy member , no discount ");
                    }

                    if (discountStatus) {
                        price = member.getPrice().multiply(discount).divide(BigDecimal.TEN);
                        //保留2位小数
                        price = price.setScale(2, BigDecimal.ROUND_HALF_UP);
                    } else {
                        price = member.getPrice();
                    }

                    name = member.getName();
                }

//                }
            }
            orderlog.info("order price : " + price + " name : " + name);

            orderlog.info("==========检验是否买过本资料==========");
            Long orderId = userOrderService.getUserOrderIdsByUidAndBuyTypeAndTargetId(uid, type, targetId);
            if (null != orderId && type != UserOrder.ORDER_MEMBER) {
                orderlog.info("already pay the order");
                model.addAttribute("code", -4015);
                return "/common/success";
            }

            orderlog.info("==========生成订单号==========");
            String order_Id = OrderIdUtil.generateOrderId();
            while (null != userOrderService.getOrderObjectByOrderId(order_Id)) {
                order_Id = OrderIdUtil.generateOrderId();
            }
            orderlog.info("orderNo is " + order_Id);

            orderlog.info("==========新建订单==========");
            UserOrder order = new UserOrder();
            order.setOrderId(order_Id);
            order.setUid(uid);
            order.setTargetId(targetId);
            order.setBuyAt(System.currentTimeMillis());
            order.setBuyType(type);
            order.setStatus(UserOrder.WAITFORPAY);
            order.setPrice(price);
            order.setAddress(mail);

            oid = userOrderService.insert(order);
            orderlog.info("create order success , oid : " + oid);


            model.addAttribute("code", 0);
            model.addAttribute("oid", oid);
            model.addAttribute("orderNo", order_Id);

        } catch (Throwable t) {
            orderlog.error(t.getMessage());
            orderlog.error("create order error, uid is  " + uid);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/userOrder/json/createOrder";
    }

    //保存支付方式
    @RequestMapping(value = "/a/u/order/pay/{oid}", method = RequestMethod.PUT)
    public String updatePayWay(HttpServletRequest request, HttpServletResponse response,
                               ModelMap model, @PathVariable Long oid, Integer payWay) throws Exception {
        String subject = "";
        String body = "";

        orderlog.info("save order : " + oid + " payment type : " + payWay);

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        orderlog.info("get uid " + uid);

        try {
            if (UserOrder.PAYMANNER_2 != payWay
                    && UserOrder.PAYMANNER_3 != payWay
                    && UserOrder.PAYMANNER_4 != payWay
                    && UserOrder.PAYMANNER_5 != payWay) {
                orderlog.info("illegal payWay");
                model.addAttribute("code", -4017);
                return "/common/success";
            }

            orderlog.info("==========检验是否拥有本订单==========");
            UserOrder userOrder = userOrderService.getObjectById(oid);
            if (null == userOrder) {
                orderlog.info("already pay the order");
                model.addAttribute("code", -4015);
                return "/common/success";
            }

            if (!uid.equals(userOrder.getUid())) {
                orderlog.info("not your order");
                model.addAttribute("code", -4016);
                return "/common/success";
            }

            orderlog.info("==========修改支付方式==========");
            userOrder.setPayType(payWay);
            userOrderService.update(userOrder);
            orderlog.info("update payment success");

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            orderlog.error(t.getMessage());
            orderlog.error("update pay way error, oid is  " + oid);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    //保存支付结果
    @RequestMapping(value = "/a/u/order/result/{oid}", method = RequestMethod.PUT)
    public String updateResult(HttpServletRequest request, HttpServletResponse response,
                               ModelMap model, @PathVariable Long oid, Integer result) throws Exception {

        orderlog.info("save order : " + oid + " pay result : " + result);

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        orderlog.info("get uid " + uid);

        try {
            if (null == result) {
                orderlog.info("null result");
                model.addAttribute("code", -4045);
                return "/common/success";
            }

            if (UserOrder.PAY_SUCCESS != result && UserOrder.PAY_FAIL != result) {
                orderlog.info("illegal result");
                model.addAttribute("code", -4018);
                return "/common/success";
            }

            orderlog.info("==========检验是否拥有本订单==========");
            UserOrder userOrder = userOrderService.getObjectById(oid);
            if (null == userOrder) {
                orderlog.info("no such order");
                model.addAttribute("code", -3007);
                return "/common/success";
            }

            if (!uid.equals(userOrder.getUid())) {
                orderlog.info("not your order");
                model.addAttribute("code", -4016);
                return "/common/success";
            }

            orderlog.info("==========支付结果==========");
            if (null == userOrder.getPayType()) {
                orderlog.info("order payType is null");
                model.addAttribute("code", -3008);
                return "/common/success";
            }

            if (UserOrder.WAITFORPAY != userOrder.getStatus()) {
                orderlog.info("close or already pay order");
                model.addAttribute("code", -3009);
                return "/common/success";
            }

            orderlog.info(" /pay/check indentCode =  " + userOrder.getOrderId());


            // 如果是待支付，查银行
            Integer payManner = userOrder.getPayType();//支付方式
            orderlog.info("  payManner = " + payManner);

            switch (payManner) {

                case UserOrder.PAYMANNER_2: {
                    orderlog.info("==========银行卡==========");
                    break;
                }
                case UserOrder.PAYMANNER_3: {
                    orderlog.info("==========支付宝==========");

                    break;
                }
                case UserOrder.PAYMANNER_4: {
                    orderlog.info("==========微信==========");

                    break;

                }
                default:
                    break;
            }

            //调支付回调方法
            userOrderService.noticeBack(userOrder.getOrderId(), result, userOrder.getPayType(), user.getOs());
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            orderlog.error(t.getMessage());
            orderlog.error("update order result error, oid is  " + oid);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    public static void main(String[] a) {

    }


    public Boolean AliPayStatusQuery(String orderId) throws ServiceException, ServiceDaoException {

        boolean bRes = false;

        String out_trade_no = orderId.toString();

        Map<String, String> sParaTemp = new java.util.HashMap<String, String>();

        sParaTemp.put("service", "single_trade_query");
        sParaTemp.put("partner", AlipayConstantConfig.partner);
        sParaTemp.put("_input_charset", AlipayConstantConfig.input_charset);
        sParaTemp.put("out_trade_no", out_trade_no);

        String sHtmlText = null;
        try {
            sHtmlText = AlipaySubmit.buildRequest("", "", sParaTemp);
            orderlog.info("get alipay query response xml : " + sHtmlText);
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }

        Document document = null;

        try {
            document = DocumentHelper.parseText(sHtmlText);
        } catch (DocumentException e) {
            e.printStackTrace();
            return false;
        }

        Element root = document.getRootElement();
        Element isSuccess = root.element("is_success");
        if (isSuccess.getText().equals("T")) {
            UserOrder order = userOrderService.getOrderObjectByOrderId(orderId);
            orderlog.info("get order : " + order.toString());
            Element response = root.element("response");
            Element trade = response.element("trade");

            Element tradeStatus = trade.element("trade_status");
            if (tradeStatus.getText().equals("TRADE_SUCCESS")) {
                Element price = trade.element("price");
                BigDecimal priceB = new BigDecimal(price.getText());
                if (priceB.equals(order.getPrice())) {
                    bRes = true;
                }
            }

        }
        return bRes;
    }


}

