package com.ptteng.course.home.controller;

import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.course.util.VideoAndVoiceUtil;
import com.ptteng.learn.admin.model.Constant;
import com.ptteng.learn.admin.service.ConstantService;
import com.ptteng.learn.common.model.Message;
import com.ptteng.learn.common.model.UserMessageRelation;
import com.ptteng.learn.common.service.MessageService;
import com.ptteng.learn.common.service.UserMessageRelationService;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.mapping.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


/**
 * Task  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class TaskController {
    private static final Log taskLog = LogFactory.getLog("task");

    @Autowired
    private UserService userService;
    @Autowired
    private LocksService locksService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private UnitService unitService;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private BookService bookService;
    @Autowired
    private ProgressService progressService;
    @Autowired
    private UserPaperRelationService userPaperRelationService;
    @Autowired
    private UserUnitRelationService userUnitRelationService;
    @Autowired
    private ImgStorageUtil imgStorageJSUtil;
    @Autowired
    private MessageService messageService;
    @Autowired
    private BookUnitService bookUnitService;
    @Autowired
    private UserMessageRelationService userMessageRelationService;
    @Autowired
    private ConstantService constantService;


    /**
     * @param id 任务id
     * @Description 分享任务详情
     * @Author: PeiyuFeng
     * @Time 2017/2/17 14:37
     */
    @RequestMapping(value = "/a/task/{id}", method = RequestMethod.GET)
    public String getShareTaskJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        taskLog.info("get share task data : id= " + id);

        try {
            Task task = taskService.getObjectById(id);
            Period period = periodService.getObjectById(task.getPeriodID());
            Long paperId = period.getPaperID();
            task.setPaperId(paperId);

            task.setPaperId(task.getPaperId());
            taskLog.info(task);
            if (null == task) {
                model.addAttribute("code", 2);
                return "/common/success";
            }
            taskLog.info("get task data is " + task);
            List<Long> untiIds = unitService.getUnitIdsByTaskIDOrderBySort(id, 0, Integer.MAX_VALUE);
            if (untiIds.size() <= 0) {
                taskLog.info("unit is null");
            }
            List<UserUnitRelation> userUnitRelations = new LinkedList<>();
            List<Unit> unitList = unitService.getObjectsByIds(untiIds);

            model.addAttribute("code", 0);
            model.addAttribute("task", task);
            model.addAttribute("unitList", unitList);

        } catch (Throwable t) {
            t.printStackTrace();
            taskLog.error(t.getMessage());
            taskLog.error("get task error,id is  " + id);
            model.addAttribute("code", -1);
        }
        return "/learn-course-service/task/json/taskDetailJson";
    }


    /**
     * 获得任务详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */

    @RequestMapping(value = "/a/u/task/{id}", method = RequestMethod.GET)
    public String getTaskJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        taskLog.info("get data : id= " + id);

        Boolean buyStatus = false;

        User user = (User) request.getAttribute("user");
        taskLog.info("get uid " + user.getId());

        try {
            Task task = taskService.getObjectById(id);
            Period period = periodService.getObjectById(task.getPeriodID());
            Long paperId = period.getPaperID();
            task.setPaperId(paperId);
            Long relation = userPaperRelationService.getUserTargetRelationIdsByTypeAndUidAndTargetId
                    (UserPaperRelation.TYPE_PPAPER, user.getId(), task.getPeriodID());
            if (null != relation) {
                buyStatus = true;
            }

            task.setPaperId(task.getPaperId());
            taskLog.info(task);
            if (null == task) {
                model.addAttribute("code", 2);
                return "/common/success";
            }
            taskLog.info("get task data is " + task);
            List<Long> untiIds = unitService.getUnitIdsByTaskIDOrderBySort(id, 0, Integer.MAX_VALUE);
            if (untiIds.size() <= 0) {
                taskLog.info("unit is null");
            }
            List<UserUnitRelation> userUnitRelations = new LinkedList<>();
            List<Unit> unitList = unitService.getObjectsByIds(untiIds);
            //遍历的目的是取出有录音的步骤的成绩和生成动态的url
            for (Unit unit : unitList) {
                //改成金山云
//                if (Unit.Unit_Video.equals(unit.getType())) {
//                    String path = unit.getLink();
//                    String urls = imgStorageJSUtil.imgStorage(path, 1800);
//                    unit.setLink(urls);
//                }
                //只需要取最新的一个成绩，所以limit随便写了个3，提高效率，sql语句orderby  create_at desc;
                taskLog.info(user.getId() + "=======" + unit.getId());
                List<Long> unitRelationId = userUnitRelationService.getUserUnitRelationIdByUserIdAndUnitId(user.getId(), unit.getId(), 0, Integer.MAX_VALUE);
                taskLog.info(user.getId() + "=======" + unit.getId());
                if (unitRelationId != null && unitRelationId.size() > 0) {
                    UserUnitRelation userUnitRelation = userUnitRelationService.getObjectById(unitRelationId.get(0));
                    unit.setUserUnitRelation(userUnitRelation);
                }
            }

            Long cid = constantService.getConstantIdByKeyAndType("video", "img");
            if(null == cid){
                taskLog.info("no constant");
            }else {
                Constant constant = constantService.getObjectById(cid);
                model.addAttribute("constant", constant);
            }

            model.addAttribute("code", 0);
            model.addAttribute("task", task);
            model.addAttribute("unitList", unitList);
            model.addAttribute("buyStatus", buyStatus);

        } catch (Throwable t) {
            t.printStackTrace();
            taskLog.error(t.getMessage());
            taskLog.error("get task error,id is  " + id);
            model.addAttribute("code", -1);
        }
        return "/learn-course-service/task/json/taskDetailJson";
    }


    //14、上一任务
    @RequestMapping(value = "/a/u/task/before/{id}", method = RequestMethod.GET)
    public String taskBefore(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        taskLog.info("get uid " + uid);

        try {

            taskLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            Task task = taskService.getObjectById(id);
            if (null == task) {
                taskLog.info("the task is not exist ");
                model.addAttribute("code", -4006);
                return "/common/success";
            }

            taskLog.info("=====判断是否为第一个任务=====");
            Integer sort = task.getSort();
            taskLog.info("task sort is : " + sort);
            if (1 == sort) {
                taskLog.info("the task is first sort ");
                model.addAttribute("code", -4005);
                return "/common/success";
            }

            Long taskId = taskService.getTaskIdsByPeriodIDAndSort(task.getPeriodID(), sort - 1);

            //上一个任务名称
            Task task1 = taskService.getObjectById(taskId);

            model.addAttribute("code", 0);
            model.addAttribute("taskId", taskId);
            model.addAttribute("tname", task1.getName());

        } catch (Throwable t) {
            t.printStackTrace();
            taskLog.error(t.getMessage());
            taskLog.error(" get task before " + id + " error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/task/json/taskBefore";
    }

    //14、下一任务/完成任务
    @RequestMapping(value = "/a/u/task/next/{id}", method = RequestMethod.GET)
    public String taskNext(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        List<Long> periodIds = new ArrayList<>();
        Lesson lesson = new Lesson();
        Book book = new Book();
        Long periodId = 0L;
        Boolean firstStudy = false;
        Boolean nextTask = true;
        Boolean nextPeriodStatus = false;
        Boolean freezeStatus = false;
        Integer paperStatus;
        Boolean bugPaper = false;
        Integer star = 0;
        Long tid = 0L;
        Period nextPeriod = new Period();
        Progress lessonProgress = new Progress();
        Boolean lessonSortAdd = false;
        List<Period> availablePeriods = new ArrayList<>();
        List<Long> availablePeriodsId = new ArrayList<>();

        Long startTime = System.currentTimeMillis();

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        taskLog.info("get uid " + uid);

        taskLog.info("get task : " + id + " next task");

        try {

            taskLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            Task task = taskService.getObjectById(id);
            if (null == task) {
                taskLog.info("the task is not exist ");
                model.addAttribute("code", -4006);
                return "/common/success";
            } else {
                taskLog.info("get task : " + task);
                taskLog.info("获取task完成，耗时：" + (System.currentTimeMillis() - startTime));
            }

            //获取课时
            if (null == task.getPeriodID()) {
                taskLog.info("the task have no period");
                model.addAttribute("code", -4011);
                return "/common/success";
            } else {
                taskLog.info("get task period : " + task.getPeriodID());
            }
            Period period = periodService.getObjectById(task.getPeriodID());
            if (null == period) {
                taskLog.info("the period not exist");
                model.addAttribute("code", -4012);
                return "/common/success";
            } else {
                taskLog.info("get task period : " + period);
                taskLog.info("获取period完成，耗时：" + (System.currentTimeMillis() - startTime));
            }

            if (Task.lesson.equals(task.getType())) {
                taskLog.info("get task type : " + task.getType());
                lesson = lessonService.getObjectById(period.getLessonID());
                Long lessonProgressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, period.getLessonID(), Progress.TYPE_LESSON);
                lessonProgress = progressService.getObjectById(lessonProgressId);

                List<Long> pidList = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(lesson.getId(), Period.status_normal, 0, Integer.MAX_VALUE);
                List<Period> periods = periodService.getObjectsByIds(pidList);
                for (Period eachPeriod : periods) {
                    Long eachProgressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, eachPeriod.getId(), Progress.TYPE_PERIOD);
                    if (null != eachProgressId) {
                        Progress progress = progressService.getObjectById(eachProgressId);
                        if (Progress.STATUS_ING.equals(progress.getStatus())) {
                            availablePeriods.add(eachPeriod);
                            availablePeriodsId.add(eachPeriod.getId());
                        }
                    } else {
                        if (Period.UnLock.equals(eachPeriod.getLocked())) {
                            availablePeriods.add(eachPeriod);
                            availablePeriodsId.add(eachPeriod.getId());
                        } else {
                            Long lockId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, eachPeriod.getId());
                            if (null != lockId) {
                                availablePeriods.add(eachPeriod);
                                availablePeriodsId.add(eachPeriod.getId());
                            }
                        }
                    }
                }

                taskLog.info("available lesson period list : " + availablePeriodsId);

            } else if (Task.book.equals(task.getType())) {
                taskLog.info("get task type : " + task.getType());
                book = bookService.getObjectById(period.getBookID());
                Long bookProgressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, period.getBookID(), Progress.TYPE_BOOK);
                lessonProgress = progressService.getObjectById(bookProgressId);

                List<Long> pidList = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(book.getId(), Period.status_normal, 0, Integer.MAX_VALUE);
                List<Period> periods = periodService.getObjectsByIds(pidList);
                for (Period eachPeriod : periods) {
                    Long eachProgressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, eachPeriod.getId(), Progress.TYPE_PERIOD);
                    if (null != eachProgressId) {
                        Progress progress = progressService.getObjectById(eachProgressId);
                        if (Progress.STATUS_ING.equals(progress.getStatus())) {
                            availablePeriods.add(eachPeriod);
                            availablePeriodsId.add(eachPeriod.getId());
                        }
                    } else {
                        if (Period.UnLock.equals(eachPeriod.getLocked())) {
                            availablePeriods.add(eachPeriod);
                            availablePeriodsId.add(eachPeriod.getId());
                        } else {
                            Long lockId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, eachPeriod.getId());
                            if (null != lockId) {
                                availablePeriods.add(eachPeriod);
                                availablePeriodsId.add(eachPeriod.getId());
                            }
                        }
                    }
                }
                taskLog.info("available book period list : " + availablePeriodsId);
            } else {
                taskLog.info("the task type wrong");
                model.addAttribute("code", -4033);
                return "/common/success";
            }

            taskLog.info("获取可用课程教材完成，耗时：" + (System.currentTimeMillis() - startTime));

            star = period.getStar();

            taskLog.info("=====1、所属课程、课时是否下架=====");
            Integer periodStatus = period.getStatus();
            taskLog.info("periodStatus : " + periodStatus);

            if (Period.status_freeze.equals(periodStatus)) {
                taskLog.info("=====下架课时=====");
                taskLog.info("the task belong period freeze");
                model.addAttribute("code", -4041);
                return "/common/success";
            }

            List<Long> taskIds = taskService.getTaskIdsByPeriodIDOrderBySort(task.getPeriodID(), 0, Integer.MAX_VALUE);
            taskLog.info("taskId size is : " + taskIds.size());
            if (Task.lesson.equals(task.getType())) {
                periodIds = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(period.getLessonID(), Period.status_normal, 0, Integer.MAX_VALUE);
            } else if (Task.book.equals(task.getType())) {
                periodIds = periodService.getPeriodIdsByBookIDAndStatusOrderBySort(period.getBookID(), Period.status_normal, 0, Integer.MAX_VALUE);
            }
            taskLog.info("periodIds size is : " + periodIds.size());
            taskLog.info("获取任务列表、课时列表完成，耗时：" + (System.currentTimeMillis() - startTime));

            taskLog.info("=====2、是否购买本课程资料=====");
            Long relationId = userPaperRelationService.getUserTargetRelationIdsByTypeAndUidAndTargetId(UserPaperRelation.TYPE_PPAPER, uid, task.getPeriodID());
            Period period1 = periodService.getObjectById(task.getPeriodID());
            if (period1.getPaperID() == null) {
                paperStatus = 3;
            } else if (null == relationId) {
                paperStatus = 2;
            } else {
                paperStatus = 1;
            }
            taskLog.info("paper status : " + paperStatus);
            taskLog.info("获取资料状态完成，耗时：" + (System.currentTimeMillis() - startTime));

            taskLog.info("=====3、查看课时进度=====");
            Long pid = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, period.getId(), Progress.TYPE_PERIOD);
            taskLog.info("progressId : " + pid);
            if (null == pid) {
                taskLog.info("you don't learn the period");
                model.addAttribute("code", -4037);
                return "/common/success";
            }
            Progress progress = progressService.getObjectById(pid);
            Integer status = progress.getStatus();
            Integer periodSort = Integer.valueOf(progress.getSort().toString());
            taskLog.info("period sort is : " + periodSort);
            taskLog.info("获取课时进度完成，耗时：" + (System.currentTimeMillis() - startTime));

            taskLog.info("=====4、判断课课时是否完成=====");
            if (Progress.STATUS_ING.equals(status)) {
                taskLog.info("=====课时未完成=====");

                taskLog.info("=====4.1判断是否为最后一个任务=====");
                Integer sort = task.getSort();
                taskLog.info("task sort is : " + sort);

                if (sort > taskIds.size()) {
                    taskLog.info("task sort wrong");
                    model.addAttribute("code", -4013);
                    return "/common/success";

                } else if (taskIds.size() == sort) {
                    nextTask = false;
                    taskLog.info("=====最后一个任务=====");

                    taskLog.info("first finish");
                    firstStudy = true;
                    lessonSortAdd = true;
                    Integer periodLessonSort = period.getSort();
                    taskLog.info("period sort in lesson is : " + periodLessonSort);

                    taskLog.info("=====4.2 判断是否为最后一个课时=====");
                    if (Task.lesson.equals(task.getType())) {
                        if (periodLessonSort > periodIds.size()) {
                            taskLog.info("period sort wrong");
                            model.addAttribute("code", -4014);
                            return "/common/success";
                        }
                        if (periodIds.size() == periodLessonSort) {
                            taskLog.info("=====4.3 最后一个课时=====");
                            nextPeriodStatus = false;
                            taskLog.info("next period : " + nextPeriodStatus);
                        } else {
                            taskLog.info("=====4.4 取下一个课时=====");
                            periodId = periodService.getPeriodIdByLessonIDAndSort(period.getLessonID(), periodLessonSort + 1);
                            if (periodId == null) {
                                nextPeriodStatus = false;
                            } else {
                                nextPeriodStatus = true;
                            }
                            taskLog.info("next period : " + nextPeriodStatus);
                        }
                    } else {
                        //教材逻辑
                        Long result = nextPeriodId(period);
                        taskLog.info("result : " + result);
                        if (result.equals(0L)) {
                            nextPeriodStatus = false;
                        } else if (result > 0L) {
                            nextPeriodStatus = true;
                            periodId = result;
                        } else {
                            model.addAttribute("code", result);
                            return "/common/success";
                        }
                    }

                    progress.setStatus(Progress.STATUS_OVER);
                    progress.setSort(Progress.SORT_OVER);
                    progressService.update(progress);

                    Integer learnScore = user.getLearnScore();
                    user.setLearnScore(learnScore + 1);
                    taskLog.info("user learnScore : " + learnScore + " >>>>>>>>>> " + user.getLearnScore());

                    Integer score = user.getScore();
                    user.setScore(score + star);
                    taskLog.info("user score : " + score + " >>>>>>>>>> " + user.getScore());

                    //这是一个垃圾的单发短信。。。。
                    DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    String date = dateFormat.format(new Date(System.currentTimeMillis()));
                    String title = "获得学习星通知";
                    String content = "";
                    if (Task.lesson.equals(task.getType())) {
                        content = "您于" + date + "完成" + lesson.getName() + "课程的“" + period.getName() + "”，获得" + star + "颗学习星。";
                    } else {
                        content = "您于" + date + "完成" + book.getName() + "课程的“" + period.getName() + "”，获得" + star + "颗学习星。";
                    }

                    Message message = new Message();
                    message.setType(Message.Type_pesson);
                    message.setName(title);
                    message.setContent(content);
                    message.setUserId(uid);
                    message.setPublishAt(System.currentTimeMillis());
                    message.setSort(1);
                    Long mid = messageService.insert(message);
                    taskLog.info("send message success");

                    UserMessageRelation userMessageRelation = new UserMessageRelation();
                    userMessageRelation.setUserRead(UserMessageRelation.notRead);
                    userMessageRelation.setTargetId(mid);
                    userMessageRelation.setUserId(uid);
                    userMessageRelationService.insert(userMessageRelation);

                    userService.update(user);


                } else {
                    taskLog.info("=====不是最后一个任务=====");
                    nextTask = true;
                    tid = taskService.getTaskIdsByPeriodIDAndSort(task.getPeriodID(), sort + 1);
                    if (null == tid) {
                        taskLog.info("the task of period wrong ");
                        model.addAttribute("code", -4008);
                        return "/common/success";
                    }
                    taskLog.info("tid : " + tid);

                    if (sort > periodSort) {
                        taskLog.info("=====任务序号大于课时进度=====");
                        taskLog.info("you don't learn the task");
                        model.addAttribute("code", -4009);
                        return "/common/success";

                    } else if (sort.equals(periodSort)) {
                        taskLog.info("=====任务序号等于课时进度=====");

                        taskLog.info("=====开始学习新任务逻辑=====");
                        progress.setSort(Long.valueOf(sort + 1));
                        progressService.update(progress);

                    } else {
                        taskLog.info("=====任务序号小于课时进度====");
                    }
                }

            } else if (Progress.STATUS_OVER.equals(status)) {
                taskLog.info("=====非第一次学习完成=====");
                firstStudy = false;
                taskLog.info("=====4.1判断是否为最后一个任务=====");
                Integer sort = task.getSort();
                taskLog.info("task sort is : " + sort);

                if (sort > taskIds.size()) {
                    taskLog.info("task sort wrong");
                    model.addAttribute("code", -4013);
                    return "/common/success";

                } else if (taskIds.size() == sort) {
                    nextTask = false;
                    taskLog.info("=====最后一个任务=====");

                    lessonSortAdd = true;
                    Integer periodLessonSort = period.getSort();
                    taskLog.info("period sort in lesson is : " + periodLessonSort);

                    taskLog.info("=====4.2 判断是否为最后一个课时=====");
                    if (Task.lesson.equals(task.getType())) {
                        if (periodLessonSort > periodIds.size()) {
                            taskLog.info("period sort wrong");
                            model.addAttribute("code", -4014);
                            return "/common/success";
                        }
                        if (periodIds.size() == periodLessonSort) {
                            taskLog.info("=====4.3 最后一个课时=====");
                            nextPeriodStatus = false;
                            taskLog.info("next period : " + nextPeriodStatus);
                        } else {
                            taskLog.info("=====4.4 取下一个课时=====");
                            periodId = periodService.getPeriodIdByLessonIDAndSort(period.getLessonID(), periodLessonSort + 1);

                            nextPeriodStatus = true;
                            taskLog.info("next period : " + nextPeriodStatus);
                        }
                    } else {
                        //教材逻辑
                        Long result = nextPeriodId(period);
                        if (result.equals(0L)) {
                            nextPeriodStatus = false;
                        } else if (result > 0L) {
                            nextPeriodStatus = true;
                            periodId = result;
                        } else {
                            model.addAttribute("code", result);
                            return "/common/success";
                        }
                    }

                } else {
                    taskLog.info("=====不是最后一个任务=====");
                    nextTask = true;
                    tid = taskService.getTaskIdsByPeriodIDAndSort(task.getPeriodID(), sort + 1);
                    if (null == tid) {
                        taskLog.info("the task of period wrong ");
                        model.addAttribute("code", -4008);
                        return "/common/success";
                    }
                    taskLog.info("tid : " + tid);
                }


            } else {
                taskLog.info("progress status wrong");
                model.addAttribute("code", -4010);
                return "/common/success";
            }

            taskLog.info("获取课时进度完成，耗时：" + (System.currentTimeMillis() - startTime));

            //设置下一个课时列表
            Long sort = period.getId();
            Integer periodSortInLesson = period.getSort();

            if (lessonSortAdd) {
                for (Period availablePeriod : availablePeriods) {
                    if (availablePeriod.getSort() > periodSortInLesson) {
                        sort = availablePeriod.getId();
                        break;
                    }
                }
                if (sort.equals(period.getId())) {
                    for (Period availablePeriod : availablePeriods) {
                        if (availablePeriod.getSort() < periodSortInLesson) {
                            sort = availablePeriod.getId();
                            break;
                        }
                    }
                }
                taskLog.info("update lesson sort : " + sort);
            } else {
                taskLog.info("not update lesson sort : " + sort);
            }


            if (Task.lesson.equals(task.getType())) {
                Long paperRelation = userPaperRelationService.getUserTargetRelationIdsByTypeAndUidAndTargetId(UserPaperRelation.TYPE_LPAPER, uid, period.getLessonID());
                if (null == paperRelation) {
                    bugPaper = true;
                }
                model.addAttribute("belong", "lesson");
                model.addAttribute("lessonName", lesson.getName());
                model.addAttribute("lessonId", lesson.getId());

                if (null == lessonProgress) {
                    Progress newProgress = new Progress();
                    newProgress.setUserID(uid);
                    newProgress.setTargetID(period.getLessonID());
                    newProgress.setStatus(Progress.TYPE_LESSON);
                    newProgress.setSort(sort);
                    progressService.insert(newProgress);
                } else {
                    lessonProgress.setSort(sort);
                    progressService.update(lessonProgress);
                }

            } else if (Task.book.equals(task.getType())) {
                Long paperRelation = userPaperRelationService.getUserTargetRelationIdsByTypeAndUidAndTargetId(UserPaperRelation.TYPE_BPAPER, uid, period.getBookID());
                if (null == paperRelation) {
                    bugPaper = true;
                }
                model.addAttribute("belong", "book");
                model.addAttribute("lessonName", book.getName());
                model.addAttribute("lessonId", book.getId());

                if (null == lessonProgress) {
                    Progress newProgress = new Progress();
                    newProgress.setUserID(uid);
                    newProgress.setTargetID(period.getBookID());
                    newProgress.setStatus(Progress.TYPE_BOOK);
                    newProgress.setSort(sort);
                    progressService.insert(newProgress);
                } else {
                    lessonProgress.setSort(sort);
                    progressService.update(lessonProgress);
                }
            }


            //下一个任务名称
            Task task1 = new Task();
            if (nextTask) {
                task1 = taskService.getObjectById(tid);
            }

            taskLog.info("接口完成，耗时：" + (System.currentTimeMillis() - startTime));

            model.addAttribute("code", 0);
            model.addAttribute("tid", tid);
            model.addAttribute("tname", task1.getName());
            model.addAttribute("nextTask", nextTask);
            model.addAttribute("star", star);
            model.addAttribute("paperStatus", paperStatus);
            model.addAttribute("nextPeriod", nextPeriodStatus);
            model.addAttribute("periodName", period.getName());
            model.addAttribute("belongPeriodId", period.getId());
            model.addAttribute("pid", periodId);
            model.addAttribute("firstStudy", firstStudy);
            model.addAttribute("bugPaper", bugPaper);

        } catch (Throwable t) {
            t.printStackTrace();
            taskLog.error(t.getMessage());
            taskLog.error(" get task next " + id + " error ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/task/json/taskNext";
    }


    public Long nextPeriodId(Period period) throws Exception {
        Integer periodLessonSort = period.getSort();
        List<Long> periodIds = new ArrayList<>();
        Boolean nextPeriodStatus = false;
        Long periodId = 0L;

        //正序取最后一个教材上架单元
        Long lastbuid = 0L;
        List<Long> buids = bookUnitService.getBookUnitIdsByBidAndStatus(period.getBookID(), BookUnit.STATUS_ON);
        if (CollectionUtils.isEmpty(buids)) {
            taskLog.info("book no units");
            return -4048L;
        } else {
            lastbuid = buids.get(buids.size() - 1);
            taskLog.info("lastbuid : " + lastbuid);
        }

        if (period.getUnitId() == null) {
            taskLog.info("period no belongs units");
            return -4049L;
        } else {
            //该教材属于最后一个上架单元
            if (lastbuid.equals(period.getUnitId())) {
                taskLog.info("=====最后一个单元=====");
                //取该课时所属单元所有课时
                periodIds = periodService.getPeriodIdsByBookUnitIDAndStatusOrderBySort(period.getUnitId(), Period.status_normal, 0, Integer.MAX_VALUE);
                taskLog.info("periodIds in unit : " + period.getUnitId() + " : " + periodIds);
                if (periodLessonSort > periodIds.size()) {
                    taskLog.info("period sort wrong");
                    return -4014L;
                }
                if (periodIds.size() == periodLessonSort) {
                    taskLog.info("=====4.3 最后一个课时=====");
                    nextPeriodStatus = false;
                    taskLog.info("next period : " + nextPeriodStatus);
                    return 0L;
                } else {
                    taskLog.info("=====4.4 取下一个课时=====");
                    periodId = periodService.getPeriodIdByUnitIdAndSort(period.getUnitId(), periodLessonSort + 1);
                    if (periodId == null) {
                        nextPeriodStatus = false;
                        taskLog.info("next period : " + nextPeriodStatus);
                        return 0L;
                    } else {
                        nextPeriodStatus = true;
                        taskLog.info("next period : " + nextPeriodStatus);
                        return periodId;
                    }

                }
            } else {
                taskLog.info("=====不是最后一个单元=====");
                //不属于最后一个上架单元
                //取该课时所属单元所有课时
                periodIds = periodService.getPeriodIdsByBookUnitIDAndStatusOrderBySort(period.getUnitId(), Period.status_normal, 0, Integer.MAX_VALUE);
                taskLog.info("periodIds in unit : " + period.getUnitId() + " : " + periodIds);
                if (periodLessonSort > periodIds.size()) {
                    taskLog.info("period sort wrong");
                    return -4014L;
                }
                if (periodIds.size() == periodLessonSort) {
                    taskLog.info("=====4.3 该单元最后一个课时=====");
                    //取下个单元第一个课程
                    BookUnit unit = bookUnitService.getObjectById(period.getUnitId());
                    Integer unitSort = unit.getSort();
                    Long nextUnitId = bookUnitService.getIdBySortAndBookId(unitSort + 1, period.getBookID());
                    if(nextUnitId == null){
                        taskLog.info("unit " + period.getUnitId() + " next unit " + unitSort + 1 +" not exist");
                        return -4014L;
                    }
                    periodId = periodService.getPeriodIdByUnitIdAndSort(nextUnitId, 1);

                    nextPeriodStatus = true;
                    taskLog.info("next period : " + nextPeriodStatus);
                    return periodId;
                } else {
                    taskLog.info("=====4.4 取下一个课时=====");
                    periodId = periodService.getPeriodIdByUnitIdAndSort(period.getUnitId(), periodLessonSort + 1);
                    if (periodId == null) {
                        nextPeriodStatus = false;
                        taskLog.info("next period : " + nextPeriodStatus);
                        return 0L;
                    } else {
                        nextPeriodStatus = true;
                        taskLog.info("next period : " + nextPeriodStatus);
                        return periodId;
                    }
                }
            }
        }
    }
}

