package com.ptteng.course.home.controller;

import com.ptteng.learn.course.model.Introduce;
import com.ptteng.learn.course.model.Lesson;
import com.ptteng.learn.course.model.Subject;
import com.ptteng.learn.course.service.IntroduceService;
import com.ptteng.learn.course.service.LessonService;
import com.ptteng.learn.course.service.SubjectService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * Introduce  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class IntroduceController {
    private static final Log log = LogFactory.getLog("introduce");

    @Autowired
    private IntroduceService introduceService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private SubjectService subjectService;


    /**
     * 根据年级获得推荐列表
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param level
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/introduce/list", method = RequestMethod.GET)
    public String getIntroduceIdsByLevelJsonList(HttpServletRequest request,
                                                 HttpServletResponse response, ModelMap model, Integer page,
                                                 Integer size, Integer level) throws Exception {

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 8;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        List<Introduce> introduceList = null;
        List<Long> randomList = new ArrayList<>();
        log.info("pageList : page= " + start + " , size=" + size);
        Random random = new Random();
        Integer total = 0;
        try {
            List<Long> idList = new ArrayList<>();


            if (level == null || level == 7) {

                //获取所有年级热门推荐
                log.info("get all introduce");
                idList = introduceService.getIntroduceIds(0, Integer.MAX_VALUE);

            } else {

                //获取某年级热门推荐
                if (level < 0 || level > 6) {
                    model.addAttribute("code", -5024);
                    return "/common/success";
                }else {
                    log.info("get level : " + level + " introduce");
                }

                idList = introduceService.getIntroduceIdsByLevel(level, 0, Integer.MAX_VALUE);
                log.info("get countIntroduceIdsByLevel size is " + idList.size());
                log.info("id list : " + idList);

            }

            if (idList == null || idList.isEmpty()) {
                log.info("introduce ids null");
            } else {
//                List<Introduce> introduceLists = introduceService.getObjectsByIds(idList);
//                Set<Long> set = new HashSet<>();
//                List<Long> introduceIds = new LinkedList<>();
//                List<Long> intro = new LinkedList<>();
//                for (Introduce introduce : introduceLists) {
//                    set.add(introduce.getLessonId());
//                }
//                for (Long lessonId : set) {
//                    intro = introduceService.getIdsByLessonId(lessonId);
//                    if (intro.size() > 0) {
//                        introduceIds.add(intro.get(0));
//                    }
//                }
//                idList = introduceIds;
                if (idList.size() >= size) {
                    for (int i = 0; i < size; ) {
                        Integer index = random.nextInt(idList.size());
                        Long id = idList.get(index);
                        if (!randomList.contains(id)) {
                            randomList.add(id);
                            i++;
                        }
                    }
                    total = size;
                } else {
                    for (int i = 0; i < idList.size(); ) {
                        Integer index = random.nextInt(idList.size());
                        Long id = idList.get(index);
                        if (!randomList.contains(id)) {
                            randomList.add(id);
                            i++;
                        }
                    }
                    total = idList.size();
                }
            }

            log.info("randomList : " + randomList);
            introduceList = introduceService.getObjectsByIds(randomList);

            if (introduceList != null) {
                for (Introduce introduce : introduceList) {
                    Long lesonId = introduce.getLessonId();
                    Lesson lesson = lessonService.getObjectById(lesonId);
                    if (lesson != null) {
                        introduce.setLessonName(lesson.getName());
                        introduce.setStudyCount(lesson.getStudyCount());
                    }
                    Long subjectId = introduce.getSubjectId();
                    Subject subject = subjectService.getObjectById(subjectId);
                    if (subject != null) {
                        introduce.setSubjectName(subject.getName());
                    }
                }
            }


            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("introduceList", introduceList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get introduce list error,page is  " + start + " , size " + size);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/introduce/json/introduceListJson";
    }


    /**
     * 查看推荐详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/introduce/{id}", method = RequestMethod.GET)
    public String getIntroduceJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            Introduce introduce = introduceService.getObjectById(id);
            log.info("get introduce data is " + introduce);

            Long lesonId = introduce.getLessonId();
            Lesson lesson = lessonService.getObjectById(lesonId);
            if (lesson != null) {
                introduce.setLessonName(lesson.getName());
            }

            model.addAttribute("code", 0);

            model.addAttribute("introduce", introduce);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get introduce error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/learn-course-service/introduce/json/introduceDetailJson";
    }


}

