/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.finance.etl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.ptteng.common.storage.util.notice.NoticeUtil;
import com.ptteng.learn.common.model.Message;
import com.ptteng.learn.common.model.UserMessageRelation;
import com.ptteng.learn.common.service.MessageService;
import com.ptteng.learn.common.service.UserMessageRelationService;
import com.ptteng.learn.course.model.User;
import com.ptteng.learn.course.service.UserService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class ConsignPayEtl {
    private static final int TASK_LEN = 100;
    private static final long SLEEP_MILLISECOND = 30000L;
    private static final Log log = LogFactory.getLog((String)"autoScan");
    private MessageService messageService;
    private UserService userService;
    private UserMessageRelationService userMessageRelationService;
    @Autowired
    private NoticeUtil androidPushServiceImpl;
    @Autowired
    private NoticeUtil iosPushServiceImpl;
    private Long interval = 2000L;

    public void process() throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    List<Message> messages;
                    if (CollectionUtils.isEmpty(messages = this.getMessages())) {
                        log.info((Object)"messages etl not get any id ,sleep 30000 ms ");
                        Thread.sleep(30000L);
                    }
                    this.processOrder(messages);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                Thread.sleep(30000L);
                log.error((Object)("process goods bytime status error ,sleep " + t.getMessage()));
                continue;
            }
            break;
        }
    }

    private List<Message> getMessages() {
        List<Object> messages = new ArrayList<Message>();
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        conditions.put("message_type", Message.later);
        conditions.put("up_down", Message.status_freeze);
        conditions.put("type", Message.Type_Message);
        conditions.put("@table", " message ");
        Long now = System.currentTimeMillis();
        try {
            List ids = this.messageService.getIdsByDynamicCondition(Message.class, conditions, Integer.valueOf(0), Integer.valueOf(100));
            if (CollectionUtils.isEmpty((Collection)ids)) {
                log.info((Object)"not ger any process message ");
            } else {
                messages = this.messageService.getObjectsByIds(ids);
                for (Message message : messages) {
                    if (now < message.getPublishAt()) continue;
                    log.info((Object)(" message id = " + message.getId()));
                    message.setUpAndDown(Message.status_normal);
                    this.noticePush(message);
                }
                this.messageService.updateList(messages);
                log.info((Object)("get process messages is " + messages.size()));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t);
        }
        return messages;
    }

    private void processOrder(List<Message> messages) throws ServiceException, ServiceDaoException, InterruptedException {
        ArrayList readyMessages = new ArrayList();
        if (CollectionUtils.isEmpty(readyMessages)) {
            log.info((Object)"no query messages ");
            return;
        }
        log.info((Object)(this.interval + " will query messages id is " + readyMessages));
        Integer status = 0;
        try {
            for (Message message : readyMessages) {
                status = message.getUpAndDown();
                if (Message.status_normal.equals(status)) continue;
                message.setUpAndDown(Message.status_normal);
                this.messageService.update(message);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public UserMessageRelationService getUserMessageRelationService() {
        return this.userMessageRelationService;
    }

    public void setUserMessageRelationService(UserMessageRelationService userMessageRelationService) {
        this.userMessageRelationService = userMessageRelationService;
    }

    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public void messageUp(Message message) throws Exception {
        message.setPublishAt(Long.valueOf(System.currentTimeMillis()));
        message.setStatus(Message.status_normal);
        List userIds = null;
        UserMessageRelation userMessageRelation = new UserMessageRelation();
        userMessageRelation.setTargetId(message.getId());
        userIds = message.getGrade() == 7 ? this.userService.getUserIds(Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE)) : this.userService.getUserIdByGrade(message.getGrade());
        for (Long userId : userIds) {
            userMessageRelation.setUserId(userId);
            this.userMessageRelationService.insert(userMessageRelation);
        }
    }

    public static void main(String[] arg) {
    }

    private String noticePush(Message message) throws ServiceException, ServiceDaoException, IOException {
        log.info((Object)" noticePush start ... ");
        Integer status = message.getStatus();
        log.info((Object)(" status is =  " + status));
        Integer grade = message.getGrade();
        String result = "";
        if (Message.synchronization.equals(status)) {
            List userIds = new ArrayList();
            log.info((Object)" synchronization is true ");
            if (User.allGrade.equals(grade)) {
                log.info((Object)" all ");
                userIds = this.userService.getUserIds(Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            } else {
                userIds = this.userService.getUserIdByGrade(grade);
            }
            log.info((Object)(" user size = " + userIds.size()));
            if (userIds.size() > 0) {
                JSONObject data;
                List users = this.userService.getObjectsByIds(userIds);
                StringBuilder anDevicceTokens = new StringBuilder("");
                StringBuilder iosDevicceTokens = new StringBuilder("");
                for (int i = 0; i < users.size(); ++i) {
                    if ("android".equals(((User)users.get(i)).getPlatform())) {
                        if (!StringUtil.isNotEmpty((String)((User)users.get(i)).getDeviceToken())) continue;
                        anDevicceTokens.append(((User)users.get(i)).getDeviceToken() + ",");
                        continue;
                    }
                    if (!"ios".equals(((User)users.get(i)).getPlatform()) || !StringUtil.isNotEmpty((String)((User)users.get(i)).getDeviceToken())) continue;
                    iosDevicceTokens.append(((User)users.get(i)).getDeviceToken() + ",");
                }
                Long startAt = null;
                Long endAt = message.getCreateAt() + 604800000L;
                log.info((Object)(" endAt = " + endAt));
                if (StringUtil.isNotEmpty((String)anDevicceTokens.toString())) {
                    log.info((Object)" android ");
                    result = this.androidPushServiceImpl.pushMessaeForList("android", "notification", "listcast", anDevicceTokens.toString(), message.getName(), message.getName(), message.getContent(), "go_app", "", "", "", "", startAt, "", "true", endAt, "\u56de\u5bb6\u5b66\u4e60\u901a\u77e5");
                    JSONObject jsonObject = JSONObject.fromObject((Object)result);
                    if ("SUCCESS".equals((String)jsonObject.get("ret"))) {
                        log.info((Object)" push success ");
                    } else {
                        log.info((Object)("fail" + jsonObject.get("data")));
                        data = JSONObject.fromObject((Object)jsonObject.get("data").toString());
                        log.info((Object)(" data = " + data));
                        log.info((Object)(" errorCode = " + data.get("error_code")));
                    }
                }
                if (StringUtil.isNotEmpty((String)iosDevicceTokens.toString())) {
                    log.info((Object)" ios ");
                    result = this.iosPushServiceImpl.pushMessaeForList("ios", "notification", "listcast", iosDevicceTokens.toString(), message.getName(), message.getName(), message.getContent(), "go_app", "", "", "", "", startAt, "", "true", endAt, "\u56de\u5bb6\u5b66\u4e60\u901a\u77e5");
                    log.info((Object)(" result = " + result));
                    JSONObject jsonObjectios = JSONObject.fromObject((Object)result);
                    if ("SUCCESS".equals((String)jsonObjectios.get("ret"))) {
                        log.info((Object)" push success ");
                    } else {
                        log.info((Object)(" ==== " + jsonObjectios.get("data")));
                        data = JSONObject.fromObject((Object)jsonObjectios.get("data").toString());
                        log.info((Object)(" data = " + data));
                        log.info((Object)(" errorCode = " + data.get("error_code")));
                    }
                }
            }
        }
        return result;
    }
}

