/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.LoginRecord;
import com.ptteng.learn.course.service.LoginRecordService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginRecordServiceImpl
extends BaseDaoServiceImpl
implements LoginRecordService {
    private static final Log log = LogFactory.getLog(LoginRecordServiceImpl.class);

    public Long insert(LoginRecord loginRecord) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + loginRecord));
        if (loginRecord == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        loginRecord.setCreateAt(Long.valueOf(currentTimeMillis));
        loginRecord.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)loginRecord);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + loginRecord));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<LoginRecord> insertList(List<LoginRecord> loginRecordList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (loginRecordList == null ? "null" : Integer.valueOf(loginRecordList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(loginRecordList)) {
            return new ArrayList<LoginRecord>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (LoginRecord loginRecord : loginRecordList) {
            loginRecord.setCreateAt(Long.valueOf(currentTimeMillis));
            loginRecord.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(loginRecordList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + loginRecordList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(LoginRecord.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(LoginRecord loginRecord) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (loginRecord == null ? "null" : loginRecord.getId())));
        boolean result = false;
        if (loginRecord == null) {
            return true;
        }
        loginRecord.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)loginRecord);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + loginRecord));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + loginRecord));
        }
        return result;
    }

    public boolean updateList(List<LoginRecord> loginRecordList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (loginRecordList == null ? "null" : Integer.valueOf(loginRecordList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(loginRecordList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (LoginRecord loginRecord : loginRecordList) {
            loginRecord.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(loginRecordList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + loginRecordList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + loginRecordList.size()));
        return result;
    }

    public LoginRecord getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        LoginRecord loginRecord = null;
        if (id == null) {
            return loginRecord;
        }
        try {
            loginRecord = (LoginRecord)this.dao.get(LoginRecord.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return loginRecord;
    }

    public List<LoginRecord> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List loginRecord = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<LoginRecord>();
        }
        try {
            loginRecord = this.dao.getList(LoginRecord.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (loginRecord == null ? "null" : Integer.valueOf(loginRecord.size()))));
        return loginRecord;
    }

    public List<Long> getLoginRecordIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids by uid,start,limit " + uid + " , " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLoginRecordIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong uid,start,limit " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getLoginRecordIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLoginRecordIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countLoginRecordIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getLoginRecordIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getLoginRecordIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

