/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.BookUnit;
import com.ptteng.learn.course.service.BookUnitService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BookUnitServiceImpl
extends BaseDaoServiceImpl
implements BookUnitService {
    private static final Log log = LogFactory.getLog(BookUnitServiceImpl.class);

    public Long insert(BookUnit bookUnit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + bookUnit));
        if (bookUnit == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        bookUnit.setCreateAt(Long.valueOf(currentTimeMillis));
        bookUnit.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)bookUnit);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + bookUnit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<BookUnit> insertList(List<BookUnit> bookUnitList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (bookUnitList == null ? "null" : Integer.valueOf(bookUnitList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(bookUnitList)) {
            return new ArrayList<BookUnit>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (BookUnit bookUnit : bookUnitList) {
            bookUnit.setCreateAt(Long.valueOf(currentTimeMillis));
            bookUnit.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(bookUnitList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + bookUnitList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(BookUnit.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(BookUnit bookUnit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (bookUnit == null ? "null" : bookUnit.getId())));
        boolean result = false;
        if (bookUnit == null) {
            return true;
        }
        bookUnit.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)bookUnit);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + bookUnit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + bookUnit));
        }
        return result;
    }

    public boolean updateList(List<BookUnit> bookUnitList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (bookUnitList == null ? "null" : Integer.valueOf(bookUnitList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(bookUnitList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (BookUnit bookUnit : bookUnitList) {
            bookUnit.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(bookUnitList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + bookUnitList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + bookUnitList.size()));
        return result;
    }

    public BookUnit getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        BookUnit bookUnit = null;
        if (id == null) {
            return bookUnit;
        }
        try {
            bookUnit = (BookUnit)this.dao.get(BookUnit.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return bookUnit;
    }

    public List<BookUnit> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List bookUnit = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<BookUnit>();
        }
        try {
            bookUnit = this.dao.getList(BookUnit.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (bookUnit == null ? "null" : Integer.valueOf(bookUnit.size()))));
        return bookUnit;
    }

    public List<Long> getBookUnitIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBookUnitIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countBookUnitIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getBookUnitIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getBookUnitIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public List<Long> getUnitIdsByStatusOrderBySort(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUnitIdsByStatusOrderBySort", new Object[]{status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getIdByNameAndBookId(String name, Long bid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by name  : " + name + " book id : " + bid));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getIdByNameAndBookId", new Object[]{name, bid});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by name  : " + name + " book id : " + bid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getBookUnitIdsByBid(Long bid) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids by bid : " + bid));
        List idList = null;
        try {
            idList = this.dao.getIdList("getUnitIdsByBidOrderBySort", new Object[]{bid}, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong bid : " + bid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getBookUnitIdsByBidAndStatus(Long bid, Integer status) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids by bid : " + bid + " status : " + status));
        List idList = null;
        try {
            idList = this.dao.getIdList("getBookUnitIdsByBidAndStatus", new Object[]{bid, status}, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong bid : " + bid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getIdBySortAndBookId(Integer sort, Long bid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by sort  : " + sort + " book id : " + bid));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getIdBySortAndBookId", new Object[]{sort, bid});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by sort  : " + sort + " book id : " + bid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }
}

