package com.ptteng.learn.course.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.learn.course.model.UserTaskRecordRelation;
import com.ptteng.learn.course.service.UserTaskRecordRelationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class UserTaskRecordRelationServiceImpl extends BaseDaoServiceImpl implements UserTaskRecordRelationService {

 

	private static final Log log = LogFactory.getLog(UserTaskRecordRelationServiceImpl.class);



		   
		@Override
		public Long insert(UserTaskRecordRelation userTaskRecordRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userTaskRecordRelation);

		if (userTaskRecordRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userTaskRecordRelation.setCreateAt(currentTimeMillis);
		userTaskRecordRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userTaskRecordRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userTaskRecordRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserTaskRecordRelation> insertList(List<UserTaskRecordRelation> userTaskRecordRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userTaskRecordRelationList == null ? "null" : userTaskRecordRelationList.size()));
      
		List<UserTaskRecordRelation> resultList = null;

		if (CollectionUtils.isEmpty(userTaskRecordRelationList)) {
			return new ArrayList<UserTaskRecordRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserTaskRecordRelation userTaskRecordRelation : userTaskRecordRelationList) {
			userTaskRecordRelation.setCreateAt(currentTimeMillis);
			userTaskRecordRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserTaskRecordRelation>) dao.batchSave(userTaskRecordRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userTaskRecordRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserTaskRecordRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserTaskRecordRelation userTaskRecordRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userTaskRecordRelation == null ? "null" : userTaskRecordRelation.getId()));

		boolean result = false;

		if (userTaskRecordRelation == null) {
			return true;
		}

		userTaskRecordRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userTaskRecordRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + userTaskRecordRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userTaskRecordRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserTaskRecordRelation> userTaskRecordRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userTaskRecordRelationList == null ? "null" : userTaskRecordRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userTaskRecordRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserTaskRecordRelation userTaskRecordRelation : userTaskRecordRelationList) {
			userTaskRecordRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userTaskRecordRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userTaskRecordRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userTaskRecordRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserTaskRecordRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserTaskRecordRelation userTaskRecordRelation = null;

		if (id == null) {
			return userTaskRecordRelation;
		}

		try {
			userTaskRecordRelation = (UserTaskRecordRelation) dao.get(UserTaskRecordRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userTaskRecordRelation;		
		}	
		  
    	   
		@Override
		public List<UserTaskRecordRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserTaskRecordRelation> userTaskRecordRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserTaskRecordRelation>();
		}

		try {
			userTaskRecordRelation = (List<UserTaskRecordRelation>) dao.getList(UserTaskRecordRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userTaskRecordRelation == null ? "null" : userTaskRecordRelation.size()));
    
		return userTaskRecordRelation;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserTaskRecordRelationIdsByUserIdAndNoteTypeOrderByCreateAt(Long userId,Long taskId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by userId,taskId,start,limit  : " + userId+" , "+taskId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserTaskRecordRelationIdsByUserIdAndNoteTypeOrderByCreateAt", new Object[] { userId,taskId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by userId,taskId,start,limit)  : " + userId+" , "+taskId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserTaskRecordRelationIdsByUserIdAndTaskIdOrderByCreateAt(Long userId,Long taskId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by userId,taskId  : " + userId+" , "+taskId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserTaskRecordRelationIdsByUserIdAndNoteTypeOrderByCreateAt", new Object[] { userId,taskId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by userId,taskId)  : " + userId+" , "+taskId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getUserTaskRecordRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserTaskRecordRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserTaskRecordRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserTaskRecordRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserTaskRecordRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

