package com.ptteng.learn.course.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.learn.course.model.Period;
import com.ptteng.learn.course.service.PeriodService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class PeriodServiceImpl extends BaseDaoServiceImpl implements PeriodService {

 

	private static final Log log = LogFactory.getLog(PeriodServiceImpl.class);



		   
		@Override
		public Long insert(Period period)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + period);

		if (period == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		period.setCreateAt(currentTimeMillis);
		period.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(period);
		} catch (DaoException e) {
			log.error(" insert wrong : " + period);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Period> insertList(List<Period> periodList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (periodList == null ? "null" : periodList.size()));
      
		List<Period> resultList = null;

		if (CollectionUtils.isEmpty(periodList)) {
			return new ArrayList<Period>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Period period : periodList) {
			period.setCreateAt(currentTimeMillis);
			period.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Period>) dao.batchSave(periodList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + periodList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Period.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Period period)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (period == null ? "null" : period.getId()));

		boolean result = false;

		if (period == null) {
			return true;
		}

		period.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(period);
		} catch (DaoException e) {
			log.error(" update wrong : " + period);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + period);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Period> periodList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (periodList == null ? "null" : periodList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(periodList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Period period : periodList) {
			period.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(periodList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + periodList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + periodList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Period getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Period period = null;

		if (id == null) {
			return period;
		}

		try {
			period = (Period) dao.get(Period.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return period;		
		}	
		  
    	   
		@Override
		public List<Period> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Period> period = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Period>();
		}

		try {
			period = (List<Period>) dao.getList(Period.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (period == null ? "null" : period.size()));
    
		return period;	
		}

	@Override
	public List<Long> getPeriodIdsByName(String name) throws ServiceException, ServiceDaoException {

		log.info(" get id is : " + name);

		List<Long> id = new ArrayList<>();
		if (StringUtils.isEmpty(name)) {
			log.info("name is null");
			return id;
		}

		try {
			id = dao.getIdList("getPeriodIdsByName", new Object[]{name}, 0, Integer.MAX_VALUE, false);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}


		return id;
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getPeriodIdsByLessonIDOrderBySort(Long lessonID,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by lessonID,start,limit  : " + lessonID+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getPeriodIdsByLessonIDOrderBySort", new Object[] { lessonID},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by lessonID,start,limit)  : " + lessonID+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}

	@Override
	public List<Long> getPeriodIdsByLessonIDAndStatusOrderBySort(Long lessonID, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get ids by lessonID,status,start,limit  : " + lessonID+" , "+status+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getPeriodIdsByLessonIDAndStatusOrderBySort", new Object[] { lessonID, status},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by lessonID,status,start,limit)  : " + lessonID+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}

	@Override
	public List<Long> getPeriodIdsByBookIDAndStatusOrderBySort(Long bookID, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get ids by bookID,status,start,limit  : " + bookID+" , "+status+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getPeriodIdsByBookIDAndStatusOrderBySort", new Object[] { bookID, status},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by bookID,status,start,limit)  : " + bookID+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}

	@Override
	public List<Long> getPeriodIdsByBookUnitIDAndStatusOrderBySort(Long bookUnitId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get ids by bookUnitId,status,start,limit  : " + bookUnitId+" , "+status+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getPeriodIdsByBookUnitIDAndStatusOrderBySort", new Object[] { bookUnitId, status},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by bookUnitId,status,start,limit)  : " + bookUnitId+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countPeriodIdsByLessonIDOrderBySort(Long lessonID)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by lessonID  : " + lessonID );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getPeriodIdsByLessonIDOrderBySort", new Object[] { lessonID});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by lessonID)  : " + lessonID );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}

	@Override
	public Long getPeriodIdByLessonIDAndSort(Long lessonID, Integer sort) throws ServiceException, ServiceDaoException {

		if(log.isInfoEnabled()){
			log.info(" get ids by lessonID  : " + lessonID+" , "+sort );
		}
		Long id = null;


		try {
			id = (Long) dao.getMapping("getPeriodIdByLessonIDAndSort", new Object[] { lessonID , sort});


		} catch (DaoException e) {
			log.error(" get ids  wrong by lessonID,start,limit)  : " + lessonID+"and sort is"+sort );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;

	}

	@Override
	public Long getPeriodIdByUnitIdAndSort(Long unitId, Integer sort) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get ids by unitId  : " + unitId+" , "+sort );
		}
		Long id = null;


		try {
			id = (Long) dao.getMapping("getPeriodIdByUnitIdAndSort", new Object[] { unitId,sort});


		} catch (DaoException e) {
			log.error(" get ids  wrong by unitId,start,limit)  : " + unitId+"and sort is"+sort );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;
	}

	@Override
	public  List<Long>  getPeriodIdsByBookIdOrderBySort(Long bookID,Integer start,Integer limit) throws ServiceException, ServiceDaoException {

			if(log.isInfoEnabled()){
				log.info(" get ids by lessonID,start,limit  : " + bookID+" , "+start+" , "+limit );
			}
			List<Long> idList = null;

			// TODO 参数检查!

			if (start == null) {
				start = 0;
			}

			if (limit == null) {
				limit = Integer.MAX_VALUE;
			}

			try {
				idList = dao.getIdList("getPeriodIdsByBookIDOrderBySort", new Object[] { bookID},start,limit, false);


			} catch (DaoException e) {
				log.error(" get ids  wrong by lessonID,start,limit)  : " + bookID+" , "+start+" , "+limit );
				log.error(e);
				e.printStackTrace();
				throw new ServiceDaoException(e);
			}
			if(log.isInfoEnabled()){
				log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
			}
			return idList;



		}



	@Override
	public List<Long> getPeriodIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getPeriodIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countPeriodIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getPeriodIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getPeriodIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

