package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.GameScoreRecords;
import com.ptteng.learn.course.service.GameScoreRecordsService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class GameScoreRecordsServiceImpl extends BaseDaoServiceImpl implements GameScoreRecordsService {

 

	private static final Log log = LogFactory.getLog(GameScoreRecordsServiceImpl.class);



		   
		@Override
		public Long insert(GameScoreRecords gameScoreRecords)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + gameScoreRecords);

		if (gameScoreRecords == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		gameScoreRecords.setCreateAt(currentTimeMillis);
		gameScoreRecords.setUpdateAt(currentTimeMillis);
		log.info("gameScoreRecords is "+gameScoreRecords);

		Long result = null;
		try {
			result = (Long) dao.save(gameScoreRecords);
		} catch (DaoException e) {
			log.error(" insert wrong : " + gameScoreRecords);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<GameScoreRecords> insertList(List<GameScoreRecords> gameScoreRecordsList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (gameScoreRecordsList == null ? "null" : gameScoreRecordsList.size()));
      
		List<GameScoreRecords> resultList = null;

		if (CollectionUtils.isEmpty(gameScoreRecordsList)) {
			return new ArrayList<GameScoreRecords>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (GameScoreRecords gameScoreRecords : gameScoreRecordsList) {
			gameScoreRecords.setCreateAt(currentTimeMillis);
			gameScoreRecords.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<GameScoreRecords>) dao.batchSave(gameScoreRecordsList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + gameScoreRecordsList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(GameScoreRecords.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(GameScoreRecords gameScoreRecords)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (gameScoreRecords == null ? "null" : gameScoreRecords.getId()));

		boolean result = false;

		if (gameScoreRecords == null) {
			return true;
		}

		gameScoreRecords.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(gameScoreRecords);
		} catch (DaoException e) {
			log.error(" update wrong : " + gameScoreRecords);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + gameScoreRecords);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<GameScoreRecords> gameScoreRecordsList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (gameScoreRecordsList == null ? "null" : gameScoreRecordsList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(gameScoreRecordsList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (GameScoreRecords gameScoreRecords : gameScoreRecordsList) {
			gameScoreRecords.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(gameScoreRecordsList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + gameScoreRecordsList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + gameScoreRecordsList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public GameScoreRecords getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		GameScoreRecords gameScoreRecords = null;

		if (id == null) {
			return gameScoreRecords;
		}

		try {
			gameScoreRecords = (GameScoreRecords) dao.get(GameScoreRecords.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return gameScoreRecords;		
		}	
		  
    	   
		@Override
		public List<GameScoreRecords> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<GameScoreRecords> gameScoreRecords = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<GameScoreRecords>();
		}

		try {
			gameScoreRecords = (List<GameScoreRecords>) dao.getList(GameScoreRecords.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (gameScoreRecords == null ? "null" : gameScoreRecords.size()));
    
		return gameScoreRecords;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getGameScoreRecordsIdsByUserIdOrderByCreateAt(Long userId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by userId,start,limit  : " + userId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getGameScoreRecordsIdsByUserIdOrderByCreateAt", new Object[] { userId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by userId,start,limit)  : " + userId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countGameScoreRecordsIdsByUserIdOrderByCreateAt(Long userId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by userId  : " + userId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getGameScoreRecordsIdsByUserIdOrderByCreateAt", new Object[] { userId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by userId)  : " + userId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getGameScoreRecordsIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getGameScoreRecordsIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countGameScoreRecordsIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getGameScoreRecordsIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getGameScoreRecordsIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

