package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.DictationLevel;
import com.ptteng.learn.course.service.DictationLevelService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class DictationLevelServiceImpl extends BaseDaoServiceImpl implements DictationLevelService {


    private static final Log log = LogFactory.getLog(DictationLevelServiceImpl.class);


    @Override
    public Long insert(DictationLevel dictationLevel) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + dictationLevel);

        if (dictationLevel == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        dictationLevel.setCreateAt(currentTimeMillis);
        dictationLevel.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(dictationLevel);
        } catch (DaoException e) {
            log.error(" insert wrong : " + dictationLevel);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<DictationLevel> insertList(List<DictationLevel> dictationLevelList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (dictationLevelList == null ? "null" : dictationLevelList.size()));

        List<DictationLevel> resultList = null;

        if (CollectionUtils.isEmpty(dictationLevelList)) {
            return new ArrayList<DictationLevel>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (DictationLevel dictationLevel : dictationLevelList) {
            dictationLevel.setCreateAt(currentTimeMillis);
            dictationLevel.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<DictationLevel>) dao.batchSave(dictationLevelList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + dictationLevelList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(DictationLevel.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(DictationLevel dictationLevel) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (dictationLevel == null ? "null" : dictationLevel.getId()));

        boolean result = false;

        if (dictationLevel == null) {
            return true;
        }

        dictationLevel.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(dictationLevel);
        } catch (DaoException e) {
            log.error(" update wrong : " + dictationLevel);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + dictationLevel);
        }
        return result;
    }


    @Override
    public boolean updateList(List<DictationLevel> dictationLevelList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (dictationLevelList == null ? "null" : dictationLevelList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(dictationLevelList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (DictationLevel dictationLevel : dictationLevelList) {
            dictationLevel.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(dictationLevelList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + dictationLevelList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + dictationLevelList.size());

        return result;
    }


    @Override
    public DictationLevel getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        DictationLevel dictationLevel = null;

        if (id == null) {
            return dictationLevel;
        }

        try {
            dictationLevel = (DictationLevel) dao.get(DictationLevel.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return dictationLevel;
    }


    @Override
    public List<DictationLevel> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<DictationLevel> dictationLevel = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<DictationLevel>();
        }

        try {
            dictationLevel = (List<DictationLevel>) dao.getList(DictationLevel.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (dictationLevel == null ? "null" : dictationLevel.size()));

        return dictationLevel;
    }

    @Override
    public List<Long> getIdsBySid(Long sid) throws ServiceException, ServiceDaoException {
        log.info(" get ids by sid : " + sid);
        List<Long> idList = null;

        try {
            idList = dao.getIdList("getIdsBySid", new Object[]{sid}, 0, Integer.MAX_VALUE, false);
        } catch (DaoException e) {
            log.error(" get ids wrong by by sid : " + sid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public List<Long> getDictationLevelIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getDictationLevelIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countDictationLevelIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getDictationLevelIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getDictationLevelIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

