package com.ptteng.learn.course.service.impl;

import java.util.List;
import java.util.ArrayList;

import com.ptteng.learn.course.model.UserPaperRelation;

import com.ptteng.learn.course.service.UserPaperRelationService;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class UserPaperRelationServiceImpl extends BaseDaoServiceImpl implements UserPaperRelationService {

 

	private static final Log log = LogFactory.getLog(UserPaperRelationServiceImpl.class);



		   
		@Override
		public Long insert(UserPaperRelation userPaperRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userPaperRelation);

		if (userPaperRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userPaperRelation.setCreateAt(currentTimeMillis);
		userPaperRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userPaperRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userPaperRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserPaperRelation> insertList(List<UserPaperRelation> userPaperRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userPaperRelationList == null ? "null" : userPaperRelationList.size()));
      
		List<UserPaperRelation> resultList = null;

		if (CollectionUtils.isEmpty(userPaperRelationList)) {
			return new ArrayList<UserPaperRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserPaperRelation userPaperRelation : userPaperRelationList) {
			userPaperRelation.setCreateAt(currentTimeMillis);
			userPaperRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserPaperRelation>) dao.batchSave(userPaperRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userPaperRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserPaperRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserPaperRelation userPaperRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userPaperRelation == null ? "null" : userPaperRelation.getId()));

		boolean result = false;

		if (userPaperRelation == null) {
			return true;
		}

		userPaperRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userPaperRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + userPaperRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userPaperRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserPaperRelation> userPaperRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userPaperRelationList == null ? "null" : userPaperRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userPaperRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserPaperRelation userPaperRelation : userPaperRelationList) {
			userPaperRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userPaperRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userPaperRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userPaperRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserPaperRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserPaperRelation userPaperRelation = null;

		if (id == null) {
			return userPaperRelation;
		}

		try {
			userPaperRelation = (UserPaperRelation) dao.get(UserPaperRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userPaperRelation;
		}	
		  
    	   
		@Override
		public List<UserPaperRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserPaperRelation> userPaperRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserPaperRelation>();
		}

		try {
			userPaperRelation = (List<UserPaperRelation>) dao.getList(UserPaperRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userPaperRelation == null ? "null" : userPaperRelation.size()));
    
		return userPaperRelation;
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserTargetRelationIdsByType(Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by type,start,limit  : " + type+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserTargetRelationIdsByType", new Object[] { type},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by type,start,limit)  : " + type+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserTargetRelationIdsByTypeAndUid(Integer type,Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by type,uid,start,limit  : " + type+" , "+uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = new ArrayList<>();
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {

		idList = dao.getIdList("getUserTargetRelationIdsByTypeAndUid", new Object[] {type,uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by type,uid,start,limit)  : " + type+" , "+uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}

	@Override
	public Long getUserTargetRelationIdsByTypeAndUidAndTargetId(Integer type, Long uid, Long targetId) throws ServiceException, ServiceDaoException {

		if(log.isInfoEnabled()){
			log.info(" get id by type , uid , targetId  : " + type + " , " + uid + " , " + targetId );
		}
		Long id = null;

		// TODO 参数检查!

		try {



			id = (Long) dao.getMapping("getUserTargetRelationIdsByTypeAndUidAndTargetId", new Object[] {type, uid, targetId });
		} catch (DaoException e) {
			log.error(" get id wrong by type , uid , targetId  : " + type + " , " + uid + " , " + targetId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserTargetRelationIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserTargetRelationIdsByUid", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserTargetRelationIdsByType(Integer type)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by type  : " + type );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserTargetRelationIdsByType", new Object[] { type});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by type)  : " + type );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserTargetRelationIdsByTypeAndUid(Integer type,Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by type,uid  : " + type+" , "+uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserTargetRelationIdsByTypeAndUid", new Object[] { type,uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by type,uid)  : " + type+" , "+uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserTargetRelationIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserTargetRelationIdsByUid", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getUserTargetRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserTargetRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserTargetRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserTargetRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserTargetRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

