package com.ptteng.learn.course.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.learn.course.model.UserFavoriteRelation;
import com.ptteng.learn.course.service.UserFavoriteRelationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class UserFavoriteRelationServiceImpl extends BaseDaoServiceImpl implements UserFavoriteRelationService {

 

	private static final Log log = LogFactory.getLog(UserFavoriteRelationServiceImpl.class);



		   
		@Override
		public Long insert(UserFavoriteRelation userFavoriteRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userFavoriteRelation);

		if (userFavoriteRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userFavoriteRelation.setCreateAt(currentTimeMillis);
		userFavoriteRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userFavoriteRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userFavoriteRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserFavoriteRelation> insertList(List<UserFavoriteRelation> userFavoriteRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userFavoriteRelationList == null ? "null" : userFavoriteRelationList.size()));
      
		List<UserFavoriteRelation> resultList = null;

		if (CollectionUtils.isEmpty(userFavoriteRelationList)) {
			return new ArrayList<UserFavoriteRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserFavoriteRelation userFavoriteRelation : userFavoriteRelationList) {
			userFavoriteRelation.setCreateAt(currentTimeMillis);
			userFavoriteRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserFavoriteRelation>) dao.batchSave(userFavoriteRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userFavoriteRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserFavoriteRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserFavoriteRelation userFavoriteRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userFavoriteRelation == null ? "null" : userFavoriteRelation.getId()));

		boolean result = false;

		if (userFavoriteRelation == null) {
			return true;
		}

		userFavoriteRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userFavoriteRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + userFavoriteRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userFavoriteRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserFavoriteRelation> userFavoriteRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userFavoriteRelationList == null ? "null" : userFavoriteRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userFavoriteRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserFavoriteRelation userFavoriteRelation : userFavoriteRelationList) {
			userFavoriteRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userFavoriteRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userFavoriteRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userFavoriteRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserFavoriteRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserFavoriteRelation userFavoriteRelation = null;

		if (id == null) {
			return userFavoriteRelation;
		}

		try {
			userFavoriteRelation = (UserFavoriteRelation) dao.get(UserFavoriteRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userFavoriteRelation;		
		}	
		  
    	   
		@Override
		public List<UserFavoriteRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserFavoriteRelation> userFavoriteRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserFavoriteRelation>();
		}

		try {
			userFavoriteRelation = (List<UserFavoriteRelation>) dao.getList(UserFavoriteRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userFavoriteRelation == null ? "null" : userFavoriteRelation.size()));
    
		return userFavoriteRelation;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getUserFavoriteRelationIdByUserIDAndTypeAndTargetID(Long userID,Integer type,Long targetID)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by userID,type,targetID  : " + userID+" , "+type+" , "+targetID );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getUserFavoriteRelationIdByUserIDAndTypeAndTargetID", new Object[] {userID,type,targetID });
   } catch (DaoException e) {
			log.error(" get id wrong by userID,type,targetID  : " + userID+" , "+type+" , "+targetID );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserFavoriteRelationIdsByUserID(Long userID,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by userID,start,limit  : " + userID+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserFavoriteRelationIdsByUserID", new Object[] { userID},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by userID,start,limit)  : " + userID+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}

	@Override
	public List<Long> getUserFavoriteRelationIdsByUserIDAndType(Long userID, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get ids by userID,type,start,limit  : " + userID+" , "+type+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getUserFavoriteRelationIdsByUserIDAndType", new Object[] { userID,type},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by userID,type,start,limit)  : " + userID+" , "+type+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserFavoriteRelationIdsByUserID(Long userID)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by userID  : " + userID );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserFavoriteRelationIdsByUserID", new Object[] { userID});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by userID)  : " + userID );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getUserFavoriteRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserFavoriteRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserFavoriteRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserFavoriteRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserFavoriteRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

