package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.UserDsubjectRelation;
import com.ptteng.learn.course.service.UserDsubjectRelationService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class UserDsubjectRelationServiceImpl extends BaseDaoServiceImpl implements UserDsubjectRelationService {

 

	private static final Log log = LogFactory.getLog(UserDsubjectRelationServiceImpl.class);



		   
		@Override
		public Long insert(UserDsubjectRelation userDsubjectRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userDsubjectRelation);

		if (userDsubjectRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userDsubjectRelation.setCreateAt(currentTimeMillis);
		userDsubjectRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userDsubjectRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userDsubjectRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserDsubjectRelation> insertList(List<UserDsubjectRelation> userDsubjectRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userDsubjectRelationList == null ? "null" : userDsubjectRelationList.size()));
      
		List<UserDsubjectRelation> resultList = null;

		if (CollectionUtils.isEmpty(userDsubjectRelationList)) {
			return new ArrayList<UserDsubjectRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserDsubjectRelation userDsubjectRelation : userDsubjectRelationList) {
			userDsubjectRelation.setCreateAt(currentTimeMillis);
			userDsubjectRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserDsubjectRelation>) dao.batchSave(userDsubjectRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userDsubjectRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserDsubjectRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserDsubjectRelation userDsubjectRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userDsubjectRelation == null ? "null" : userDsubjectRelation.getId()));

		boolean result = false;

		if (userDsubjectRelation == null) {
			return true;
		}

		userDsubjectRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userDsubjectRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + userDsubjectRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userDsubjectRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserDsubjectRelation> userDsubjectRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userDsubjectRelationList == null ? "null" : userDsubjectRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userDsubjectRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserDsubjectRelation userDsubjectRelation : userDsubjectRelationList) {
			userDsubjectRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userDsubjectRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userDsubjectRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userDsubjectRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserDsubjectRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserDsubjectRelation userDsubjectRelation = null;

		if (id == null) {
			return userDsubjectRelation;
		}

		try {
			userDsubjectRelation = (UserDsubjectRelation) dao.get(UserDsubjectRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userDsubjectRelation;		
		}	
		  
    	   
		@Override
		public List<UserDsubjectRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserDsubjectRelation> userDsubjectRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserDsubjectRelation>();
		}

		try {
			userDsubjectRelation = (List<UserDsubjectRelation>) dao.getList(UserDsubjectRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userDsubjectRelation == null ? "null" : userDsubjectRelation.size()));
    
		return userDsubjectRelation;	
		}

	@Override
	public Long getUserDsubjectRelationIdsByUidAndSid(Long uid, Long sid) throws ServiceException, ServiceDaoException {
		if (log.isInfoEnabled()) {
			log.info(" get id by uid,sid  : " + uid + " , " + sid);
		}
		Long id = null;

		// TODO 参数检查!

		try {


			id = (Long) dao.getMapping("getUserDsubjectRelationIdsByUidAndSid", new Object[]{uid, sid});
		} catch (DaoException e) {
			log.error(" get id wrong by uid,sid  : " + uid + " , " + sid);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get id success : " + id);
		}
		return id;
	}

	@Override
	public List<Long> getUserDsubjectRelationIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		log.info(" get ids by uid " + uid );
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getUserDsubjectRelationIdsByUid",new Object[] {uid},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by uid : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public List<Long> getUserDsubjectRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserDsubjectRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserDsubjectRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserDsubjectRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserDsubjectRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

