/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.Paper;
import com.ptteng.learn.course.service.PaperService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PaperServiceImpl
extends BaseDaoServiceImpl
implements PaperService {
    private static final Log log = LogFactory.getLog(PaperServiceImpl.class);

    public Long insert(Paper paper) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + paper));
        if (paper == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        paper.setCreateAt(Long.valueOf(currentTimeMillis));
        paper.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)paper);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + paper));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Paper> insertList(List<Paper> paperList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (paperList == null ? "null" : Integer.valueOf(paperList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(paperList)) {
            return new ArrayList<Paper>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Paper paper : paperList) {
            paper.setCreateAt(Long.valueOf(currentTimeMillis));
            paper.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(paperList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + paperList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Paper.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Paper paper) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (paper == null ? "null" : paper.getId())));
        boolean result = false;
        if (paper == null) {
            return true;
        }
        paper.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)paper);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + paper));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + paper));
        }
        return result;
    }

    public boolean updateList(List<Paper> paperList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (paperList == null ? "null" : Integer.valueOf(paperList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(paperList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Paper paper : paperList) {
            paper.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(paperList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + paperList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + paperList.size()));
        return result;
    }

    public Paper getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Paper paper = null;
        if (id == null) {
            return paper;
        }
        try {
            paper = (Paper)this.dao.get(Paper.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return paper;
    }

    public List<Paper> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List paper = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Paper>();
        }
        try {
            paper = this.dao.getList(Paper.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (paper == null ? "null" : Integer.valueOf(paper.size()))));
        return paper;
    }

    public List<Long> getPaperIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPaperIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getPaperIdByPeriodId(Long periodId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by period : " + periodId));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getPaperIdByPeriodId", new Object[]{periodId});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by period : " + periodId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public String getPaperPriceByPeriodId(Long periodId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get price by period : " + periodId));
        }
        String price = "";
        try {
            price = (String)this.dao.getMapping("getPaperPriceByPeriodId", new Object[]{periodId});
        }
        catch (DaoException e) {
            log.error((Object)(" get price wrong by period : " + periodId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get price success : " + price));
        }
        return price;
    }

    public Integer countPaperIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getPaperIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getPaperIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

