/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.BookSubject;
import com.ptteng.learn.course.service.BookSubjectService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BookSubjectServiceImpl
extends BaseDaoServiceImpl
implements BookSubjectService {
    private static final Log log = LogFactory.getLog(BookSubjectServiceImpl.class);

    public Long insert(BookSubject bookSubject) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + bookSubject));
        if (bookSubject == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        bookSubject.setCreateAt(Long.valueOf(currentTimeMillis));
        bookSubject.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)bookSubject);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + bookSubject));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<BookSubject> insertList(List<BookSubject> bookSubjectList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (bookSubjectList == null ? "null" : Integer.valueOf(bookSubjectList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(bookSubjectList)) {
            return new ArrayList<BookSubject>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (BookSubject bookSubject : bookSubjectList) {
            bookSubject.setCreateAt(Long.valueOf(currentTimeMillis));
            bookSubject.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(bookSubjectList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + bookSubjectList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(BookSubject.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(BookSubject bookSubject) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (bookSubject == null ? "null" : bookSubject.getId())));
        boolean result = false;
        if (bookSubject == null) {
            return true;
        }
        bookSubject.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)bookSubject);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + bookSubject));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + bookSubject));
        }
        return result;
    }

    public boolean updateList(List<BookSubject> bookSubjectList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (bookSubjectList == null ? "null" : Integer.valueOf(bookSubjectList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(bookSubjectList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (BookSubject bookSubject : bookSubjectList) {
            bookSubject.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(bookSubjectList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + bookSubjectList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + bookSubjectList.size()));
        return result;
    }

    public BookSubject getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        BookSubject bookSubject = null;
        if (id == null) {
            return bookSubject;
        }
        try {
            bookSubject = (BookSubject)this.dao.get(BookSubject.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return bookSubject;
    }

    public List<BookSubject> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List bookSubject = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<BookSubject>();
        }
        try {
            bookSubject = this.dao.getList(BookSubject.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (bookSubject == null ? "null" : Integer.valueOf(bookSubject.size()))));
        return bookSubject;
    }

    public Long getIdByName(String name) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by name  : " + name));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getBookSubjectIdByName", new Object[]{name});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by name  : " + name));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getBookSubjectIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBookSubjectIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countBookSubjectIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getBookSubjectIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getBookSubjectIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public List<Long> getSubjectIdsByStatusOrderBySort(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBookSubjectIdsByStatusOrderBySort", new Object[]{status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }
}

