/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.Answer;
import com.ptteng.learn.course.service.AnswerService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AnswerServiceImpl
extends BaseDaoServiceImpl
implements AnswerService {
    private static final Log log = LogFactory.getLog(AnswerServiceImpl.class);

    public Long insert(Answer answer) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + answer));
        if (answer == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        answer.setCreateAt(Long.valueOf(currentTimeMillis));
        answer.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)answer);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + answer));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Answer> insertList(List<Answer> answerList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (answerList == null ? "null" : Integer.valueOf(answerList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(answerList)) {
            return new ArrayList<Answer>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Answer answer : answerList) {
            answer.setCreateAt(Long.valueOf(currentTimeMillis));
            answer.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(answerList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + answerList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Answer.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Answer answer) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (answer == null ? "null" : answer.getId())));
        boolean result = false;
        if (answer == null) {
            return true;
        }
        answer.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)answer);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + answer));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + answer));
        }
        return result;
    }

    public boolean updateList(List<Answer> answerList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (answerList == null ? "null" : Integer.valueOf(answerList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(answerList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Answer answer : answerList) {
            answer.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(answerList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + answerList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + answerList.size()));
        return result;
    }

    public Answer getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Answer answer = null;
        if (id == null) {
            return answer;
        }
        try {
            answer = (Answer)this.dao.get(Answer.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return answer;
    }

    public List<Answer> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List answer = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Answer>();
        }
        try {
            answer = this.dao.getList(Answer.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (answer == null ? "null" : Integer.valueOf(answer.size()))));
        return answer;
    }

    public List<Long> getAnswerIdsByTaskIdOrderByCreateAt(Long taskId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by taskId,start,limit  : " + taskId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getAnswerIdsByTaskIdOrderByCreateAt", new Object[]{taskId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by taskId,start,limit)  : " + taskId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countAnswerIdsByTaskIdOrderByCreateAt(Long taskId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by taskId  : " + taskId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getAnswerIdsByTaskIdOrderByCreateAt", new Object[]{taskId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by taskId)  : " + taskId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getAnswerIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getAnswerIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countAnswerIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getAnswerIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getAnswerIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

