package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.learn.course.model.UserRecommend;
import com.ptteng.learn.course.service.UserRecommendService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class UserRecommendServiceImpl extends BaseDaoServiceImpl implements UserRecommendService {

 

	private static final Log log = LogFactory.getLog(UserRecommendServiceImpl.class);



		   
		@Override
		public Long insert(UserRecommend userRecommend)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userRecommend);

		if (userRecommend == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userRecommend.setCreateAt(currentTimeMillis);
		userRecommend.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userRecommend);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userRecommend);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserRecommend> insertList(List<UserRecommend> userRecommendList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userRecommendList == null ? "null" : userRecommendList.size()));
      
		List<UserRecommend> resultList = null;

		if (CollectionUtils.isEmpty(userRecommendList)) {
			return new ArrayList<UserRecommend>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserRecommend userRecommend : userRecommendList) {
			userRecommend.setCreateAt(currentTimeMillis);
			userRecommend.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserRecommend>) dao.batchSave(userRecommendList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userRecommendList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserRecommend.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserRecommend userRecommend)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userRecommend == null ? "null" : userRecommend.getId()));

		boolean result = false;

		if (userRecommend == null) {
			return true;
		}

		userRecommend.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userRecommend);
		} catch (DaoException e) {
			log.error(" update wrong : " + userRecommend);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userRecommend);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserRecommend> userRecommendList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userRecommendList == null ? "null" : userRecommendList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userRecommendList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserRecommend userRecommend : userRecommendList) {
			userRecommend.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userRecommendList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userRecommendList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userRecommendList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserRecommend getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserRecommend userRecommend = null;

		if (id == null) {
			return userRecommend;
		}

		try {
			userRecommend = (UserRecommend) dao.get(UserRecommend.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userRecommend;		
		}	
		  
    	   
		@Override
		public List<UserRecommend> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserRecommend> userRecommend = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserRecommend>();
		}

		try {
			userRecommend = (List<UserRecommend>) dao.getList(UserRecommend.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userRecommend == null ? "null" : userRecommend.size()));
    
		return userRecommend;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getUserRecommendIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserRecommendIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserRecommendIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserRecommendIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserRecommendIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

