/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.Locks;
import com.ptteng.learn.course.model.Member;
import com.ptteng.learn.course.model.OrderStatistics;
import com.ptteng.learn.course.model.Period;
import com.ptteng.learn.course.model.RecommendStatistics;
import com.ptteng.learn.course.model.User;
import com.ptteng.learn.course.model.UserMemberRelation;
import com.ptteng.learn.course.model.UserOrder;
import com.ptteng.learn.course.model.UserPaperRelation;
import com.ptteng.learn.course.model.UserRecommend;
import com.ptteng.learn.course.service.LessonService;
import com.ptteng.learn.course.service.LocksService;
import com.ptteng.learn.course.service.MemberService;
import com.ptteng.learn.course.service.OrderStatisticsService;
import com.ptteng.learn.course.service.PeriodService;
import com.ptteng.learn.course.service.RecommendStatisticsService;
import com.ptteng.learn.course.service.UserMemberRelationService;
import com.ptteng.learn.course.service.UserOrderService;
import com.ptteng.learn.course.service.UserPaperRelationService;
import com.ptteng.learn.course.service.UserRecommendService;
import com.ptteng.learn.course.service.UserService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UserOrderServiceImpl
extends BaseDaoServiceImpl
implements UserOrderService {
    private static final Log log = LogFactory.getLog((String)"order");
    @Autowired
    UserPaperRelationService userPaperRelationService;
    @Autowired
    PeriodService periodService;
    @Autowired
    UserService userService;
    @Autowired
    LocksService locksService;
    @Autowired
    LessonService lessonService;
    @Autowired
    MemberService memberService;
    @Autowired
    UserRecommendService userRecommendService;
    @Autowired
    UserMemberRelationService userMemberRelationService;
    @Autowired
    RecommendStatisticsService recommendStatisticsService;
    @Autowired
    OrderStatisticsService orderStatisticsService;

    public Long insert(UserOrder userOrder) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + userOrder));
        if (userOrder == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        userOrder.setCreateAt(Long.valueOf(currentTimeMillis));
        userOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)userOrder);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + userOrder));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<UserOrder> insertList(List<UserOrder> userOrderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (userOrderList == null ? "null" : Integer.valueOf(userOrderList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(userOrderList)) {
            return new ArrayList<UserOrder>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserOrder userOrder : userOrderList) {
            userOrder.setCreateAt(Long.valueOf(currentTimeMillis));
            userOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(userOrderList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + userOrderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(UserOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(UserOrder userOrder) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (userOrder == null ? "null" : userOrder.getId())));
        boolean result = false;
        if (userOrder == null) {
            return true;
        }
        userOrder.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)userOrder);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + userOrder));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + userOrder));
        }
        return result;
    }

    public boolean updateList(List<UserOrder> userOrderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (userOrderList == null ? "null" : Integer.valueOf(userOrderList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(userOrderList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserOrder userOrder : userOrderList) {
            userOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(userOrderList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + userOrderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + userOrderList.size()));
        return result;
    }

    public UserOrder getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        UserOrder userOrder = null;
        if (id == null) {
            return userOrder;
        }
        try {
            userOrder = (UserOrder)this.dao.get(UserOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return userOrder;
    }

    public List<UserOrder> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List userOrder = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserOrder>();
        }
        try {
            userOrder = this.dao.getList(UserOrder.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (userOrder == null ? "null" : Integer.valueOf(userOrder.size()))));
        return userOrder;
    }

    public UserOrder getOrderObjectByOrderId(String orderId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by order_id  : " + orderId));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getIdByOrderId", new Object[]{orderId});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by orderId  : " + orderId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return this.getObjectById(id);
    }

    public List<Long> getUserOrderIdsByUidAndBuyType(Long uid, Integer buyType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,buyType,start,limit  : " + uid + " , " + buyType + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByUidAndBuyType", new Object[]{uid, buyType}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,buyType,start,limit)  : " + uid + " , " + buyType + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getUserOrderIdsByUidAndBuyTypeAndTargetId(Long uid, Integer buyType, Long targetId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by uid,buyType,targetId : " + uid + " , " + buyType + " , " + targetId));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserOrderIdsByUidAndBuyTypeAndTargetId", new Object[]{uid, buyType, targetId});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by uid,buyType,targetId : " + uid + " , " + buyType + " , " + targetId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getUserOrderIdsByUidAndBuyTypeAndStatus(Long uid, Integer buyType, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by uid,buyType,status : " + uid + " , " + buyType + " , " + status));
        }
        List ids = null;
        try {
            ids = this.dao.getIdList("getUserOrderIdsByUidAndBuyTypeAndStatus", new Object[]{uid, buyType, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by uid,buyType,status : " + uid + " , " + buyType + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + ids));
        }
        return ids;
    }

    public List<Long> getUserOrderIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getUserOrderIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid, status,start,limit  : " + uid + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByUidAndStatus", new Object[]{uid, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,status,start,limit)  : " + uid + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getUserOrderIdsByUidAndStatusAndOs(Long uid, Integer status, Integer os, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid, status, os, start, limit  : " + uid + " , " + status + " , " + os + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByUidAndStatusAndOs", new Object[]{uid, status, os}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,status,os,start,limit)  : " + uid + " , " + status + " , " + os + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getPaperUserOrderIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPaperUserOrderIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserOrderIdsByUidAndBuyType(Long uid, Integer buyType) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid,buyType  : " + uid + " , " + buyType));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserOrderIdsByUidAndBuyType", new Object[]{uid, buyType});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid,buyType)  : " + uid + " , " + buyType));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countUserOrderIdsByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserOrderIdsByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getUserOrderIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserOrderIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getUserOrderIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getUserOrderIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public void noticeBack(String indentCode, int respCode, int payManner, String os) throws ServiceException, ServiceDaoException {
        Locks locks = new Locks();
        List pids = new ArrayList();
        ArrayList<Locks> lockses = new ArrayList<Locks>();
        Long lockRelation = 0L;
        UserPaperRelation userPaperRelation = new UserPaperRelation();
        ArrayList<UserPaperRelation> userPaperRelations = new ArrayList<UserPaperRelation>();
        try {
            log.info((Object)("noticeBack get indentCode : " + indentCode + " and respCode : " + respCode + " and payManner : " + payManner + " and os : " + os));
            UserOrder order = this.getOrderObjectByOrderId(indentCode);
            log.info((Object)("get order : " + order.toString()));
            if (!Integer.valueOf(1).equals(order.getStatus())) {
                log.info((Object)" indentinfo  service  status not  waitforpay 2  ");
                return;
            }
            Integer status = 0;
            Long targetId = order.getTargetId();
            Long uid = order.getUid();
            Boolean unlockStatus = true;
            User user = this.userService.getObjectById(uid);
            block1 : switch (respCode) {
                case 1: {
                    status = 3;
                    log.info((Object)("lesson order : " + order.getId() + " completed "));
                    switch (order.getBuyType()) {
                        case 1: {
                            log.info((Object)"==========\u89e3\u9501\u8bfe\u7a0b\u903b\u8f91==========");
                            locks.setTargetID(targetId);
                            locks.setUserID(uid);
                            locks.setType(order.getBuyType());
                            this.locksService.insert(locks);
                            pids = this.periodService.getPeriodIdsByLessonIDOrderBySort(targetId, null, null);
                            log.info((Object)("pids size : " + pids.size()));
                            List periods = this.periodService.getObjectsByIds(pids);
                            for (Period period : periods) {
                                if (!Period.Lock.equals(period.getLocked()) || null != (lockRelation = this.locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, period.getId()))) continue;
                                Locks locks1 = new Locks();
                                locks1.setUserID(uid);
                                locks1.setType(Locks.TYPE_PERIOD);
                                locks1.setTargetID(period.getId());
                                lockses.add(locks1);
                            }
                            this.locksService.insertList(lockses);
                            break;
                        }
                        case 2: {
                            Object locksId;
                            Long lockId;
                            Period period122;
                            List periods;
                            Object periodIds;
                            log.info((Object)"==========\u89e3\u9501\u8bfe\u65f6\u903b\u8f91==========");
                            locks.setTargetID(targetId);
                            locks.setUserID(uid);
                            locks.setType(order.getBuyType());
                            this.locksService.insert(locks);
                            Period period = this.periodService.getObjectById(targetId);
                            if (Period.Lesson.equals(period.getType())) {
                                periodIds = this.periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(period.getLessonID(), Period.status_normal, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                                periods = this.periodService.getObjectsByIds((List)periodIds);
                                for (Period period122 : periods) {
                                    if (!Period.Lock.equals(period.getLocked()) || null != (lockId = this.locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, period122.getId()))) continue;
                                    unlockStatus = false;
                                }
                                if (!unlockStatus.booleanValue() || null != (locksId = this.locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_LESSON, period.getLessonID()))) break block1;
                                locks.setId(null);
                                locks.setTargetID(period.getLessonID());
                                locks.setUserID(uid);
                                locks.setType(Locks.TYPE_LESSON);
                                this.locksService.insert(locks);
                                break;
                            }
                            periodIds = this.periodService.getPeriodIdsByBookIDAndStatusOrderBySort(period.getBookID(), Period.status_normal, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                            periods = this.periodService.getObjectsByIds((List)periodIds);
                            locksId = periods.iterator();
                            while (locksId.hasNext()) {
                                period122 = (Period)locksId.next();
                                if (!Period.Lock.equals(period.getLocked()) || null != (lockId = this.locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, period122.getId()))) continue;
                                unlockStatus = false;
                            }
                            if (!unlockStatus.booleanValue() || null != (locksId = this.locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_BOOK, period.getBookID()))) break block1;
                            locks.setId(null);
                            locks.setTargetID(period.getBookID());
                            locks.setUserID(uid);
                            locks.setType(Locks.TYPE_BOOK);
                            this.locksService.insert(locks);
                            break;
                        }
                        case 3: {
                            UserPaperRelation userPaperRelation1;
                            log.info((Object)"==========\u8d2d\u4e70\u8bfe\u7a0b\u8d44\u6599\u903b\u8f91==========");
                            userPaperRelation.setTarget(targetId);
                            userPaperRelation.setUid(uid);
                            userPaperRelation.setType(order.getBuyType());
                            this.userPaperRelationService.insert(userPaperRelation);
                            pids = this.periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(targetId, Period.status_normal, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                            List periods = this.periodService.getObjectsByIds(pids);
                            log.info((Object)("pids size : " + pids));
                            for (Period period : periods) {
                                log.info((Object)("pid is " + period.getId()));
                                if (null == period.getPaperID()) continue;
                                userPaperRelation1 = new UserPaperRelation();
                                userPaperRelation1.setUid(uid);
                                userPaperRelation1.setType(UserPaperRelation.TYPE_PPAPER);
                                userPaperRelation1.setTarget(period.getId());
                                userPaperRelations.add(userPaperRelation1);
                                log.info((Object)("insert relation : " + userPaperRelation));
                            }
                            this.userPaperRelationService.insertList(userPaperRelations);
                            Object learnBuy = user.getLearnBuy();
                            user.setLearnBuy(Integer.valueOf((Integer)learnBuy + 1));
                            log.info((Object)("user learn buy : " + learnBuy + " >>>>>>>>>> " + user.getLearnBuy()));
                            this.userService.update(user);
                            break;
                        }
                        case 4: {
                            Object relationId;
                            Long paperRelationId;
                            Period period122;
                            List periods;
                            Object periodIds;
                            log.info((Object)"==========\u8d2d\u4e70\u8bfe\u65f6\u8d44\u6599\u903b\u8f91==========");
                            userPaperRelation.setTarget(targetId);
                            userPaperRelation.setUid(uid);
                            userPaperRelation.setType(order.getBuyType());
                            this.userPaperRelationService.insert(userPaperRelation);
                            Period period = this.periodService.getObjectById(targetId);
                            if (Period.Lesson.equals(period.getType())) {
                                periodIds = this.periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(period.getLessonID(), Period.status_normal, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                                periods = this.periodService.getObjectsByIds((List)periodIds);
                                for (Period period122 : periods) {
                                    if (null == period.getPaperID() || null != (paperRelationId = this.userPaperRelationService.getUserTargetRelationIdsByTypeAndUidAndTargetId(UserPaperRelation.TYPE_PPAPER, uid, period122.getId()))) continue;
                                    unlockStatus = false;
                                }
                                if (unlockStatus.booleanValue() && null == (relationId = this.userPaperRelationService.getUserTargetRelationIdsByTypeAndUidAndTargetId(UserPaperRelation.TYPE_LPAPER, uid, period.getLessonID()))) {
                                    log.info((Object)"insert LPAPER record");
                                    userPaperRelation.setId(null);
                                    userPaperRelation.setTarget(period.getLessonID());
                                    userPaperRelation.setUid(uid);
                                    userPaperRelation.setType(UserPaperRelation.TYPE_LPAPER);
                                    this.userPaperRelationService.insert(userPaperRelation);
                                }
                            } else {
                                periodIds = this.periodService.getPeriodIdsByBookIDAndStatusOrderBySort(period.getBookID(), Period.status_normal, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                                periods = this.periodService.getObjectsByIds((List)periodIds);
                                relationId = periods.iterator();
                                while (relationId.hasNext()) {
                                    period122 = (Period)relationId.next();
                                    if (null == period.getPaperID() || null != (paperRelationId = this.userPaperRelationService.getUserTargetRelationIdsByTypeAndUidAndTargetId(UserPaperRelation.TYPE_BPAPER, uid, period122.getId()))) continue;
                                    unlockStatus = false;
                                }
                                if (unlockStatus.booleanValue() && null == (relationId = this.userPaperRelationService.getUserTargetRelationIdsByTypeAndUidAndTargetId(UserPaperRelation.TYPE_BPAPER, uid, period.getBookID()))) {
                                    log.info((Object)"insert BPAPER record");
                                    userPaperRelation.setId(null);
                                    userPaperRelation.setTarget(period.getBookID());
                                    userPaperRelation.setUid(uid);
                                    userPaperRelation.setType(UserPaperRelation.TYPE_BPAPER);
                                    this.userPaperRelationService.insert(userPaperRelation);
                                }
                            }
                            Object learnBuy = user.getLearnBuy();
                            user.setLearnBuy(Integer.valueOf((Integer)learnBuy + 1));
                            log.info((Object)("user learn buy : " + learnBuy + " >>>>>>>>>> " + user.getLearnBuy()));
                            this.userService.update(user);
                            break;
                        }
                        case 5: {
                            UserPaperRelation userPaperRelation1;
                            log.info((Object)"==========\u8d2d\u4e70\u6559\u6750\u8d44\u6599\u903b\u8f91==========");
                            userPaperRelation.setTarget(targetId);
                            userPaperRelation.setUid(uid);
                            userPaperRelation.setType(order.getBuyType());
                            this.userPaperRelationService.insert(userPaperRelation);
                            pids = this.periodService.getPeriodIdsByBookIDAndStatusOrderBySort(targetId, Period.status_normal, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                            List periods = this.periodService.getObjectsByIds(pids);
                            log.info((Object)("pids size : " + pids.size()));
                            for (Period period : periods) {
                                if (null == period.getPaperID()) continue;
                                userPaperRelation1 = new UserPaperRelation();
                                userPaperRelation1.setUid(uid);
                                userPaperRelation1.setType(UserPaperRelation.TYPE_PPAPER);
                                userPaperRelation1.setTarget(period.getId());
                                userPaperRelations.add(userPaperRelation1);
                            }
                            this.userPaperRelationService.insertList(userPaperRelations);
                            Object learnBuy = user.getLearnBuy();
                            user.setLearnBuy(Integer.valueOf((Integer)learnBuy + 1));
                            log.info((Object)("user learn buy : " + learnBuy + " >>>>>>>>>> " + user.getLearnBuy()));
                            this.userService.update(user);
                            break;
                        }
                        case 6: {
                            log.info((Object)"==========\u8d2d\u4e70\u4f1a\u5458\u903b\u8f91==========");
                            log.info((Object)" pay noticeBack ,type is member ");
                            Member member = this.memberService.getObjectById(targetId);
                            Long now = System.currentTimeMillis();
                            Long endAt = 0L;
                            Long startAt = 0L;
                            List userMemberRelationIds = this.userMemberRelationService.getUserMemberRelationIdsByUidAndStatus(uid, Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                            if (CollectionUtils.isEmpty((Collection)userMemberRelationIds)) {
                                log.info((Object)(" user " + uid + " is not a member "));
                                log.info((Object)"==========\u5f00\u4f1a\u5458\u903b\u8f91==========");
                                startAt = now;
                            } else {
                                List userMemberRelations = this.userMemberRelationService.getObjectsByIds(userMemberRelationIds);
                                for (UserMemberRelation userMemberRelation : userMemberRelations) {
                                    log.info((Object)(" user member endAt is " + UserOrderServiceImpl.getDate(userMemberRelation.getEndAt()) + " now is " + UserOrderServiceImpl.getDate(now)));
                                    if (userMemberRelation.getEndAt() >= endAt) {
                                        log.info((Object)(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is more than " + endAt));
                                        endAt = (long)userMemberRelation.getEndAt();
                                        continue;
                                    }
                                    log.info((Object)(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is less than " + endAt));
                                }
                                log.info((Object)("final end at member time is : " + endAt));
                                startAt = endAt;
                            }
                            UserMemberRelation userMemberRelation = new UserMemberRelation();
                            userMemberRelation.setUid(uid);
                            userMemberRelation.setName(member.getName());
                            userMemberRelation.setPrice(member.getPrice());
                            userMemberRelation.setPeriod(member.getPeriod());
                            userMemberRelation.setStatus(Integer.valueOf(1));
                            userMemberRelation.setStartAt(startAt);
                            Date startDate = new Date(startAt);
                            Date endDate = DateUtils.addMonths((Date)startDate, (int)member.getPeriod().intValue());
                            endAt = endDate.getTime();
                            userMemberRelation.setEndAt(endAt);
                            log.info((Object)(" user " + uid + " member startAt = " + UserOrderServiceImpl.getDate(now) + " endAt = " + UserOrderServiceImpl.getDate(endAt)));
                            Long userMemberRelationId = this.userMemberRelationService.insert(userMemberRelation);
                            log.info((Object)(" user " + uid + " member id is = " + userMemberRelationId));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    status = 2;
                    log.info((Object)("lesson order : " + order.getId() + " close "));
                }
            }
            if (1 == respCode) {
                log.info((Object)"==========\u652f\u4ed8\u6210\u529f\uff0c\u8bb0\u5f55\u63a8\u5e7f\u7edf\u8ba1\u4fe1\u606f==========");
                user = this.userService.getObjectById(uid);
                Long recommendId = user.getRecommendId();
                log.info((Object)(" user recommend is " + recommendId));
                if ("ios".equals(os)) {
                    BigDecimal userIosAmount = user.getIosAmount();
                    user.setIosAmount(userIosAmount.add(order.getPrice()));
                    log.info((Object)("user ios amount " + userIosAmount + " >>>>>>>>>> " + user.getIosAmount()));
                } else {
                    BigDecimal userAndroidAmount = user.getAndroidAmount();
                    user.setAndroidAmount(userAndroidAmount.add(order.getPrice()));
                    log.info((Object)("user ios amount " + userAndroidAmount + " >>>>>>>>>> " + user.getAndroidAmount()));
                }
                if (User.no_spend.equals(user.getSpendStatus())) {
                    user.setSpendStatus(User.spend);
                    this.userService.update(user);
                    log.info((Object)"user spend status update ");
                    if (null != recommendId) {
                        UserRecommend userRecommend = this.userRecommendService.getObjectById(recommendId);
                        if (null == userRecommend) {
                            UserRecommend newUserRecommend = new UserRecommend();
                            newUserRecommend.setId(recommendId);
                            log.info((Object)("insert newUserRecommend : " + newUserRecommend));
                            this.userRecommendService.insert(newUserRecommend);
                            userRecommend = this.userRecommendService.getObjectById(recommendId);
                            log.info((Object)("user recommend info not exist , create and insert data : " + userRecommend));
                        } else {
                            log.info((Object)("user recommend info : " + userRecommend));
                        }
                        Integer oldSpendNum = userRecommend.getSpendNum();
                        userRecommend.setSpendNum(Integer.valueOf(oldSpendNum + 1));
                        this.userRecommendService.update(userRecommend);
                        log.info((Object)("user : " + recommendId + " spend recommend user number " + oldSpendNum + " >>>>>>>>>> " + userRecommend.getSpendNum()));
                    }
                }
                if (null != recommendId) {
                    log.info((Object)" add recommend statistics ");
                    RecommendStatistics recommendStatistics = null;
                    Long staticAt = MyTimeUtil.getTodayZeroTimeMillions();
                    log.info((Object)(" today is = " + UserOrderServiceImpl.getDate(staticAt)));
                    List recommendStatisticsIds = this.recommendStatisticsService.getIdsByUserId(recommendId, Integer.valueOf(0), Integer.valueOf(1));
                    log.info((Object)(" recommendStatisticsIds size = " + recommendStatisticsIds.size()));
                    if (recommendStatisticsIds.size() > 0) {
                        recommendStatistics = this.recommendStatisticsService.getObjectById((Long)recommendStatisticsIds.get(0));
                        if (staticAt.equals(recommendStatistics.getStaticAt())) {
                            log.info((Object)" add 1 ");
                            recommendStatistics.setAmount(recommendStatistics.getAmount().add(order.getPrice()));
                            this.recommendStatisticsService.update(recommendStatistics);
                        } else {
                            log.info((Object)" new  recommendStatistics  ");
                            recommendStatistics = new RecommendStatistics();
                            recommendStatistics.setStaticAt(staticAt);
                            recommendStatistics.setUid(recommendId);
                            recommendStatistics.setAmount(order.getPrice());
                            this.recommendStatisticsService.insert(recommendStatistics);
                        }
                    } else {
                        log.info((Object)" new  recommendStatistics  ");
                        recommendStatistics = new RecommendStatistics();
                        recommendStatistics.setStaticAt(staticAt);
                        recommendStatistics.setUid(recommendId);
                        recommendStatistics.setAmount(order.getPrice());
                        this.recommendStatisticsService.insert(recommendStatistics);
                    }
                    UserRecommend userRecommend = this.userRecommendService.getObjectById(recommendId);
                    if (null == userRecommend) {
                        UserRecommend newUserRecommend = new UserRecommend();
                        newUserRecommend.setId(recommendId);
                        log.info((Object)("insert newUserRecommend : " + newUserRecommend));
                        this.userRecommendService.insert(newUserRecommend);
                        userRecommend = this.userRecommendService.getObjectById(recommendId);
                        log.info((Object)("user recommend info not exist , create and insert data : " + userRecommend));
                    } else {
                        log.info((Object)("user recommend info : " + userRecommend));
                    }
                    if ("ios".equals(os)) {
                        BigDecimal IosAmount = userRecommend.getIosAmount();
                        userRecommend.setIosAmount(IosAmount.add(order.getPrice()));
                        log.info((Object)("user ios amount " + IosAmount + " >>>>>>>>>> " + userRecommend.getIosAmount()));
                    } else {
                        BigDecimal AndroidAmount = userRecommend.getAndroidAmount();
                        userRecommend.setAndroidAmount(AndroidAmount.add(order.getPrice()));
                        log.info((Object)("user ios amount " + AndroidAmount + " >>>>>>>>>> " + userRecommend.getAndroidAmount()));
                    }
                    this.userRecommendService.update(userRecommend);
                }
                this.addOrderStatistics(order.getBuyType(), payManner, order.getPrice());
            } else {
                log.info((Object)"==========\u652f\u4ed8\u5931\u8d25\uff0c\u4e0d\u8bb0\u5f55\u7edf\u8ba1\u4fe1\u606f==========");
            }
            order.setStatus(status);
            order.setPayType(Integer.valueOf(payManner));
            order.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
            order.setPayAt(Long.valueOf(System.currentTimeMillis()));
            this.update(order);
            log.info((Object)"update order over");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            log.error((Object)e.getStackTrace());
            e.printStackTrace(System.out);
            log.error((Object)"error : ", (Throwable)e);
        }
    }

    public static String getDate(Long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = "";
        if (null != time) {
            date = dateFormat.format(new Date(time));
        }
        return date;
    }

    public void addOrderStatistics(Integer buyType, Integer payManner, BigDecimal price) throws ServiceException, ServiceDaoException {
        log.info((Object)" add recommend statistics ");
        Long staticAt = MyTimeUtil.getTodayZeroTimeMillions();
        log.info((Object)(" today is = " + UserOrderServiceImpl.getDate(staticAt)));
        Long sid = this.orderStatisticsService.getOrderStatisticsIdByStaticAt(staticAt);
        OrderStatistics orderStatistics = this.orderStatisticsService.getObjectById(sid);
        if (orderStatistics != null) {
            log.info((Object)" add 1 ");
            orderStatistics.setOrderCount(Integer.valueOf(orderStatistics.getOrderCount() + 1));
            orderStatistics.setTotalAmount(orderStatistics.getTotalAmount().add(price));
            switch (buyType) {
                case 1: {
                    orderStatistics.setLessonCount(Integer.valueOf(orderStatistics.getLessonCount() + 1));
                    orderStatistics.setLessonAmount(orderStatistics.getLessonAmount().add(price));
                    break;
                }
                case 2: {
                    orderStatistics.setLessonCount(Integer.valueOf(orderStatistics.getLessonCount() + 1));
                    orderStatistics.setLessonAmount(orderStatistics.getLessonAmount().add(price));
                    break;
                }
                case 3: {
                    orderStatistics.setPaperCount(Integer.valueOf(orderStatistics.getPaperCount() + 1));
                    orderStatistics.setPaperAmount(orderStatistics.getPaperAmount().add(price));
                    break;
                }
                case 4: {
                    orderStatistics.setPaperCount(Integer.valueOf(orderStatistics.getPaperCount() + 1));
                    orderStatistics.setPaperAmount(orderStatistics.getPaperAmount().add(price));
                    break;
                }
                case 5: {
                    orderStatistics.setPaperCount(Integer.valueOf(orderStatistics.getPaperCount() + 1));
                    orderStatistics.setPaperAmount(orderStatistics.getPaperAmount().add(price));
                    break;
                }
                case 6: {
                    orderStatistics.setVipCount(Integer.valueOf(orderStatistics.getVipCount() + 1));
                    orderStatistics.setVipAmount(orderStatistics.getVipAmount().add(price));
                }
            }
            switch (payManner) {
                case 3: {
                    orderStatistics.setAlipayAmount(orderStatistics.getAlipayAmount().add(price));
                    break;
                }
                case 4: {
                    orderStatistics.setWeixinAmount(orderStatistics.getWeixinAmount().add(price));
                    break;
                }
                case 5: {
                    orderStatistics.setAppleAmount(orderStatistics.getAppleAmount().add(price));
                }
            }
            this.orderStatisticsService.update(orderStatistics);
        } else {
            log.info((Object)" new  recommendStatistics  ");
            orderStatistics = new OrderStatistics();
            orderStatistics.setStaticAt(staticAt);
            orderStatistics.setOrderCount(Integer.valueOf(1));
            orderStatistics.setTotalAmount(price);
            switch (buyType) {
                case 1: {
                    orderStatistics.setLessonCount(Integer.valueOf(1));
                    orderStatistics.setLessonAmount(price);
                    break;
                }
                case 2: {
                    orderStatistics.setLessonCount(Integer.valueOf(1));
                    orderStatistics.setLessonAmount(price);
                    break;
                }
                case 3: {
                    orderStatistics.setPaperCount(Integer.valueOf(1));
                    orderStatistics.setPaperAmount(price);
                    break;
                }
                case 4: {
                    orderStatistics.setPaperCount(Integer.valueOf(1));
                    orderStatistics.setPaperAmount(price);
                    break;
                }
                case 5: {
                    orderStatistics.setPaperCount(Integer.valueOf(1));
                    orderStatistics.setPaperAmount(price);
                    break;
                }
                case 6: {
                    orderStatistics.setVipCount(Integer.valueOf(1));
                    orderStatistics.setVipAmount(price);
                }
            }
            switch (payManner) {
                case 3: {
                    orderStatistics.setAlipayAmount(price);
                    break;
                }
                case 4: {
                    orderStatistics.setWeixinAmount(price);
                    break;
                }
                case 5: {
                    orderStatistics.setAppleAmount(price);
                }
            }
            this.orderStatisticsService.insert(orderStatistics);
        }
    }
}

