/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.Unit;
import com.ptteng.learn.course.service.UnitService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnitServiceImpl
extends BaseDaoServiceImpl
implements UnitService {
    private static final Log log = LogFactory.getLog(UnitServiceImpl.class);

    public Long insert(Unit unit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + unit));
        if (unit == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        unit.setCreateAt(Long.valueOf(currentTimeMillis));
        unit.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)unit);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + unit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Unit> insertList(List<Unit> unitList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (unitList == null ? "null" : Integer.valueOf(unitList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(unitList)) {
            return new ArrayList<Unit>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Unit unit : unitList) {
            unit.setCreateAt(Long.valueOf(currentTimeMillis));
            unit.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(unitList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + unitList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Unit.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Unit unit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (unit == null ? "null" : unit.getId())));
        boolean result = false;
        if (unit == null) {
            return true;
        }
        unit.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)unit);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + unit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + unit));
        }
        return result;
    }

    public boolean updateList(List<Unit> unitList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (unitList == null ? "null" : Integer.valueOf(unitList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(unitList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Unit unit : unitList) {
            unit.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(unitList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + unitList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + unitList.size()));
        return result;
    }

    public Unit getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Unit unit = null;
        if (id == null) {
            return unit;
        }
        try {
            unit = (Unit)this.dao.get(Unit.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return unit;
    }

    public List<Unit> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List unit = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Unit>();
        }
        try {
            unit = this.dao.getList(Unit.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (unit == null ? "null" : Integer.valueOf(unit.size()))));
        return unit;
    }

    public List<Long> getUnitIdsByTaskIDOrderBySort(Long taskID, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by taskID,start,limit  : " + taskID + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUnitIdsByTaskIDOrderBySort", new Object[]{taskID}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by taskID,start,limit)  : " + taskID + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUnitIdsByTaskIDOrderBySort(Long taskID) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by taskID  : " + taskID));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUnitIdsByTaskIDOrderBySort", new Object[]{taskID});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by taskID)  : " + taskID));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getUnitIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUnitIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUnitIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getUnitIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getUnitIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

