/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.Coupon;
import com.ptteng.learn.course.service.CouponService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CouponServiceImpl
extends BaseDaoServiceImpl
implements CouponService {
    private static final Log log = LogFactory.getLog(CouponServiceImpl.class);

    public Long insert(Coupon coupon) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + coupon));
        if (coupon == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        coupon.setCreateAt(Long.valueOf(currentTimeMillis));
        coupon.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)coupon);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + coupon));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Coupon> insertList(List<Coupon> couponList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (couponList == null ? "null" : Integer.valueOf(couponList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(couponList)) {
            return new ArrayList<Coupon>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Coupon coupon : couponList) {
            coupon.setCreateAt(Long.valueOf(currentTimeMillis));
            coupon.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(couponList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + couponList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Coupon.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Coupon coupon) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (coupon == null ? "null" : coupon.getId())));
        boolean result = false;
        if (coupon == null) {
            return true;
        }
        coupon.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)coupon);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + coupon));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + coupon));
        }
        return result;
    }

    public boolean updateList(List<Coupon> couponList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (couponList == null ? "null" : Integer.valueOf(couponList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(couponList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Coupon coupon : couponList) {
            coupon.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(couponList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + couponList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + couponList.size()));
        return result;
    }

    public Coupon getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Coupon coupon = null;
        if (id == null) {
            return coupon;
        }
        try {
            coupon = (Coupon)this.dao.get(Coupon.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return coupon;
    }

    public List<Coupon> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List coupon = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Coupon>();
        }
        try {
            coupon = this.dao.getList(Coupon.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (coupon == null ? "null" : Integer.valueOf(coupon.size()))));
        return coupon;
    }

    public List<Long> getCouponIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCouponIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCouponIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getCouponIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getCouponIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

