/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.Book;
import com.ptteng.learn.course.service.BookService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BookServiceImpl
extends BaseDaoServiceImpl
implements BookService {
    private static final Log log = LogFactory.getLog(BookServiceImpl.class);

    public Long insert(Book book) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + book));
        if (book == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        book.setCreateAt(Long.valueOf(currentTimeMillis));
        book.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)book);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + book));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Book> insertList(List<Book> bookList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (bookList == null ? "null" : Integer.valueOf(bookList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(bookList)) {
            return new ArrayList<Book>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Book book : bookList) {
            book.setCreateAt(Long.valueOf(currentTimeMillis));
            book.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(bookList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + bookList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Book.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Book book) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (book == null ? "null" : book.getId())));
        boolean result = false;
        if (book == null) {
            return true;
        }
        book.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)book);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + book));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + book));
        }
        return result;
    }

    public boolean updateList(List<Book> bookList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (bookList == null ? "null" : Integer.valueOf(bookList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(bookList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Book book : bookList) {
            book.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(bookList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + bookList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + bookList.size()));
        return result;
    }

    public Book getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Book book = null;
        if (id == null) {
            return book;
        }
        try {
            book = (Book)this.dao.get(Book.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return book;
    }

    public List<Book> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List book = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Book>();
        }
        try {
            book = this.dao.getList(Book.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (book == null ? "null" : Integer.valueOf(book.size()))));
        return book;
    }

    public List<Long> getBookIdsByGradeOrderBySort(Integer grade, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by grade,start,limit  : " + grade + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBookIdsByGradeOrderBySort", new Object[]{grade}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by grade,start,limit)  : " + grade + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getBookIdsBySidBySort(Long sid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by sid  : " + sid + " start : " + start + " limit : " + limit));
        }
        List bookIds = null;
        try {
            bookIds = this.dao.getIdList("getBookIdsBySidBySort", new Object[]{sid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by sid  : " + sid + " start : " + start + " limit : " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + bookIds));
        }
        return bookIds;
    }

    public List<Long> getBookIdsByVersion(Long vid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by vid  : " + vid + " start : " + start + " limit : " + limit));
        }
        List bookIds = null;
        try {
            bookIds = this.dao.getIdList("getBookIdsByVersion", new Object[]{vid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by vid  : " + vid + " start : " + start + " limit : " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + bookIds));
        }
        return bookIds;
    }

    public Integer countBookIdsByGradeOrderBySort(Integer grade) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by grade  : " + grade));
        }
        Integer count = null;
        try {
            count = this.dao.count("getBookIdsByGradeOrderBySort", new Object[]{grade});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by grade)  : " + grade));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getBookIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBookIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countBookIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getBookIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getBookIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

