package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.RecommendStatistics;
import com.ptteng.learn.course.service.RecommendStatisticsService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class RecommendStatisticsServiceImpl extends BaseDaoServiceImpl implements RecommendStatisticsService {

 

	private static final Log log = LogFactory.getLog(RecommendStatisticsServiceImpl.class);



		   
		@Override
		public Long insert(RecommendStatistics recommendStatistics)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + recommendStatistics);

		if (recommendStatistics == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		recommendStatistics.setCreateAt(currentTimeMillis);
		recommendStatistics.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(recommendStatistics);
		} catch (DaoException e) {
			log.error(" insert wrong : " + recommendStatistics);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<RecommendStatistics> insertList(List<RecommendStatistics> recommendStatisticsList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (recommendStatisticsList == null ? "null" : recommendStatisticsList.size()));
      
		List<RecommendStatistics> resultList = null;

		if (CollectionUtils.isEmpty(recommendStatisticsList)) {
			return new ArrayList<RecommendStatistics>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (RecommendStatistics recommendStatistics : recommendStatisticsList) {
			recommendStatistics.setCreateAt(currentTimeMillis);
			recommendStatistics.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<RecommendStatistics>) dao.batchSave(recommendStatisticsList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + recommendStatisticsList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(RecommendStatistics.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(RecommendStatistics recommendStatistics)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (recommendStatistics == null ? "null" : recommendStatistics.getId()));

		boolean result = false;

		if (recommendStatistics == null) {
			return true;
		}

		recommendStatistics.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(recommendStatistics);
		} catch (DaoException e) {
			log.error(" update wrong : " + recommendStatistics);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + recommendStatistics);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<RecommendStatistics> recommendStatisticsList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (recommendStatisticsList == null ? "null" : recommendStatisticsList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(recommendStatisticsList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (RecommendStatistics recommendStatistics : recommendStatisticsList) {
			recommendStatistics.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(recommendStatisticsList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + recommendStatisticsList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + recommendStatisticsList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public RecommendStatistics getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		RecommendStatistics recommendStatistics = null;

		if (id == null) {
			return recommendStatistics;
		}

		try {
			recommendStatistics = (RecommendStatistics) dao.get(RecommendStatistics.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return recommendStatistics;		
		}	
		  
    	   
		@Override
		public List<RecommendStatistics> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<RecommendStatistics> recommendStatistics = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<RecommendStatistics>();
		}

		try {
			recommendStatistics = (List<RecommendStatistics>) dao.getList(RecommendStatistics.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (recommendStatistics == null ? "null" : recommendStatistics.size()));
    
		return recommendStatistics;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getRecommendStatisticsIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getRecommendStatisticsIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}

	@Override
	public List<Long> getIdsByUserId(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		log.info(" get ids   by uid,start,limit  ================== " +uid+" , " +start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getIdsByUserId",new Object[] {uid},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public Integer countRecommendStatisticsIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getRecommendStatisticsIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getRecommendStatisticsIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

