package com.ptteng.learn.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.learn.course.model.OrderStatistics;
import com.ptteng.learn.course.service.OrderStatisticsService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class OrderStatisticsServiceImpl extends BaseDaoServiceImpl implements OrderStatisticsService {

 

	private static final Log log = LogFactory.getLog(OrderStatisticsServiceImpl.class);



		   
		@Override
		public Long insert(OrderStatistics orderStatistics)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + orderStatistics);

		if (orderStatistics == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		orderStatistics.setCreateAt(currentTimeMillis);
		orderStatistics.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(orderStatistics);
		} catch (DaoException e) {
			log.error(" insert wrong : " + orderStatistics);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<OrderStatistics> insertList(List<OrderStatistics> orderStatisticsList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (orderStatisticsList == null ? "null" : orderStatisticsList.size()));
      
		List<OrderStatistics> resultList = null;

		if (CollectionUtils.isEmpty(orderStatisticsList)) {
			return new ArrayList<OrderStatistics>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (OrderStatistics orderStatistics : orderStatisticsList) {
			orderStatistics.setCreateAt(currentTimeMillis);
			orderStatistics.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<OrderStatistics>) dao.batchSave(orderStatisticsList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + orderStatisticsList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(OrderStatistics.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(OrderStatistics orderStatistics)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (orderStatistics == null ? "null" : orderStatistics.getId()));

		boolean result = false;

		if (orderStatistics == null) {
			return true;
		}

		orderStatistics.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(orderStatistics);
		} catch (DaoException e) {
			log.error(" update wrong : " + orderStatistics);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + orderStatistics);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<OrderStatistics> orderStatisticsList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (orderStatisticsList == null ? "null" : orderStatisticsList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(orderStatisticsList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (OrderStatistics orderStatistics : orderStatisticsList) {
			orderStatistics.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(orderStatisticsList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + orderStatisticsList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + orderStatisticsList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public OrderStatistics getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		OrderStatistics orderStatistics = null;

		if (id == null) {
			return orderStatistics;
		}

		try {
			orderStatistics = (OrderStatistics) dao.get(OrderStatistics.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return orderStatistics;		
		}	
		  
    	   
		@Override
		public List<OrderStatistics> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<OrderStatistics> orderStatistics = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<OrderStatistics>();
		}

		try {
			orderStatistics = (List<OrderStatistics>) dao.getList(OrderStatistics.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (orderStatistics == null ? "null" : orderStatistics.size()));
    
		return orderStatistics;	
		}

	@Override
	public Long getOrderStatisticsIdByStaticAt(Long staticAt) throws ServiceException, ServiceDaoException {
		if (log.isInfoEnabled()) {
			log.info(" get id by staticAt  : " + staticAt);
		}
		Long id = null;

		// TODO 参数检查!

		try {

			id = (Long) dao.getMapping("getOrderStatisticsIdByStaticAt", new Object[]{staticAt});

		} catch (DaoException e) {
			log.error("  get id wrong by staticAt  : " + staticAt);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get id success : " + id);
		}
		return id;
	}


	@Override
	public List<Long> getOrderStatisticsIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getOrderStatisticsIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countOrderStatisticsIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getOrderStatisticsIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getOrderStatisticsIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

