package com.ptteng.learn.course.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import com.ptteng.learn.course.model.Book;
import com.ptteng.learn.course.service.BookService;
import org.osoa.sca.annotations.Remotable;





import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class BookServiceImpl extends BaseDaoServiceImpl implements BookService {

 

	private static final Log log = LogFactory.getLog(BookServiceImpl.class);



		   
		@Override
		public Long insert(Book book)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + book);

		if (book == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		book.setCreateAt(currentTimeMillis);
		book.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(book);
		} catch (DaoException e) {
			log.error(" insert wrong : " + book);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Book> insertList(List<Book> bookList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (bookList == null ? "null" : bookList.size()));
      
		List<Book> resultList = null;

		if (CollectionUtils.isEmpty(bookList)) {
			return new ArrayList<Book>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Book book : bookList) {
			book.setCreateAt(currentTimeMillis);
			book.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Book>) dao.batchSave(bookList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + bookList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Book.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Book book)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (book == null ? "null" : book.getId()));

		boolean result = false;

		if (book == null) {
			return true;
		}

		book.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(book);
		} catch (DaoException e) {
			log.error(" update wrong : " + book);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + book);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Book> bookList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (bookList == null ? "null" : bookList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(bookList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Book book : bookList) {
			book.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(bookList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + bookList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + bookList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Book getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Book book = null;

		if (id == null) {
			return book;
		}

		try {
			book = (Book) dao.get(Book.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return book;		
		}	
		  
    	   
		@Override
		public List<Book> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Book> book = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Book>();
		}

		try {
			book = (List<Book>) dao.getList(Book.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (book == null ? "null" : book.size()));
    
		return book;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getBookIdsByGradeOrderBySort(Integer grade,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by grade,start,limit  : " + grade+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getBookIdsByGradeOrderBySort", new Object[] { grade},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by grade,start,limit)  : " + grade+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}

	@Override
	public List<Long> getBookIdsBySidBySort(Long sid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		if (log.isInfoEnabled()) {
			log.info(" get id by sid  : " + sid + " start : " + start + " limit : " + limit);
		}
		List<Long> bookIds = null;

		// TODO 参数检查!

		try {

			bookIds = dao.getIdList("getBookIdsBySidBySort", new Object[]{sid}, start, limit , false);

		} catch (DaoException e) {
			log.error(" get id wrong by sid  : " + sid + " start : " + start + " limit : " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success : " + bookIds);
		}
		return bookIds;
	}

	@Override
	public List<Long> getBookIdsByVersion(Long vid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		if (log.isInfoEnabled()) {
			log.info(" get id by vid  : " + vid + " start : " + start + " limit : " + limit);
		}
		List<Long> bookIds = null;

		// TODO 参数检查!

		try {

			bookIds = dao.getIdList("getBookIdsByVersion", new Object[]{vid}, start, limit , false);

		} catch (DaoException e) {
			log.error(" get id wrong by vid  : " + vid + " start : " + start + " limit : " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success : " + bookIds);
		}
		return bookIds;
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countBookIdsByGradeOrderBySort(Integer grade)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by grade  : " + grade );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getBookIdsByGradeOrderBySort", new Object[] { grade});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by grade)  : " + grade );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getBookIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getBookIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countBookIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getBookIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getBookIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

