/**
 * 
 */
package com.ptteng.sca.learn.course.client;

import java.util.List;
import java.util.Map;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.learn.course.model.Lesson;
import com.ptteng.learn.course.service.LessonService;

public class LessonSCAClient implements LessonService {

    private LessonService lessonService;

	public LessonService getLessonService() {
		return lessonService;
	}
	
	
	public void setLessonService(LessonService lessonService) {
		this.lessonService =lessonService;
	}
	
	
			   
		@Override
		public Long insert(Lesson lesson)throws ServiceException, ServiceDaoException{
		
		return lessonService.insert(lesson);
		          
		
		}	
		  
    	   
		@Override
		public List<Lesson> insertList(List<Lesson> lessonList)throws ServiceException, ServiceDaoException{
		
		return lessonService.insertList(lessonList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return lessonService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Lesson lesson)throws ServiceException, ServiceDaoException{
		
		return lessonService.update(lesson);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Lesson> lessonList)throws ServiceException, ServiceDaoException{
		
		return lessonService.updateList(lessonList);
		          
		
		}	
		  
    	   
		@Override
		public Lesson getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return lessonService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Lesson> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return lessonService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getLessonIdsByLevelOrderBySort(Integer level,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return lessonService.getLessonIdsByLevelOrderBySort(level,start,limit);
	
	
	}

	@Override
	public List<Long> getLessonIdsByLevelAndSubjectOrderBySort(Integer level, Long sujectID, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return lessonService.getLessonIdsByLevelAndSubjectOrderBySort(level,sujectID,start,limit);
	}

	@Override
	public List<Long> getLessonIdsBySubjectOrderBySort(Long sujectID, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return lessonService.getLessonIdsBySubjectOrderBySort(sujectID, start, limit);
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getLessonIdsByRecommendOrderBySort(Integer recommend,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return lessonService.getLessonIdsByRecommendOrderBySort(recommend,start,limit);
	
	
	}

	@Override
	public List<Long> getLessonIdsBySubjectTypeAndSelected(Integer userType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return lessonService.getLessonIdsBySubjectTypeAndSelected(userType,start,limit);
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countLessonIdsByLevelOrderBySort(Integer level)throws ServiceException, ServiceDaoException{
		
		return lessonService.countLessonIdsByLevelOrderBySort(level);
	
	
	}

	@Override
	public Integer countLessonIdsByLevelAndSubjectOrderBySort(Integer level, Integer subjectId) throws ServiceException, ServiceDaoException {
		return lessonService.countLessonIdsByLevelAndSubjectOrderBySort(level, subjectId);
	}

//	@Override
//	public Integer countLessonIdsByLevelOrderBySort(Integer level, Integer subjectId) throws ServiceException, ServiceDaoException {
//		return lessonService.countLessonIdsByLevelOrderBySort(level, subjectId);
//	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countLessonIdsByRecommendOrderBySort(Integer recommend)throws ServiceException, ServiceDaoException{
		
		return lessonService.countLessonIdsByRecommendOrderBySort(recommend);
	
	
	}
	
		
	
		@Override
	public List<Long> getLessonIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return lessonService.getLessonIds(start, limit);
	}

	@Override
	public Integer countLessonIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return lessonService.countLessonIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return lessonService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return lessonService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   lessonService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.lessonService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

