/**
 * 
 */
package com.ptteng.sca.learn.course.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.learn.course.model.BookUnit;
import com.ptteng.learn.course.service.BookUnitService;

import java.util.List;
import java.util.Map;

public class BookUnitSCAClient implements BookUnitService {

    private BookUnitService bookUnitService;

	public BookUnitService getBookUnitService() {
		return bookUnitService;
	}
	
	
	public void setBookUnitService(BookUnitService bookUnitService) {
		this.bookUnitService =bookUnitService;
	}
	
	
			   
		@Override
		public Long insert(BookUnit bookUnit)throws ServiceException, ServiceDaoException{
		
		return bookUnitService.insert(bookUnit);
		          
		
		}	
		  
    	   
		@Override
		public List<BookUnit> insertList(List<BookUnit> bookUnitList)throws ServiceException, ServiceDaoException{
		
		return bookUnitService.insertList(bookUnitList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return bookUnitService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(BookUnit bookUnit)throws ServiceException, ServiceDaoException{
		
		return bookUnitService.update(bookUnit);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<BookUnit> bookUnitList)throws ServiceException, ServiceDaoException{
		
		return bookUnitService.updateList(bookUnitList);
		          
		
		}	
		  
    	   
		@Override
		public BookUnit getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return bookUnitService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<BookUnit> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return bookUnitService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
		
	
	
    		
	
		@Override
	public List<Long> getBookUnitIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return bookUnitService.getBookUnitIds(start, limit);
	}

	@Override
	public Integer countBookUnitIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return bookUnitService.countBookUnitIds();
	}

	@Override
	public List<Long> getUnitIdsByStatusOrderBySort(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return bookUnitService.getUnitIdsByStatusOrderBySort(status, start, limit);
	}

	@Override
	public Long getIdByNameAndBookId(String name, Long bid) throws ServiceException, ServiceDaoException {
		return bookUnitService.getIdByNameAndBookId(name, bid);
	}

	@Override
	public List<Long> getBookUnitIdsByBid(Long bid) throws ServiceException, ServiceDaoException {
		return bookUnitService.getBookUnitIdsByBid(bid);
	}

	@Override
	public List<Long> getBookUnitIdsByBidAndStatus(Long bid, Integer status) throws ServiceException, ServiceDaoException {
		return bookUnitService.getBookUnitIdsByBidAndStatus(bid, status);
	}

	@Override
	public Long getIdBySortAndBookId(Integer sort, Long bid) throws ServiceException, ServiceDaoException {
		return bookUnitService.getIdBySortAndBookId(sort, bid);
	}


	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return bookUnitService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return bookUnitService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   bookUnitService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.bookUnitService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

