package com.ptteng.learn.course.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.learn.course.model.GradeClassRelation;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface GradeClassRelationService extends BaseDaoService {

	



   		   
		
		public Long insert(GradeClassRelation gradeClassRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<GradeClassRelation> insertList(List<GradeClassRelation> gradeClassRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(GradeClassRelation gradeClassRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<GradeClassRelation> gradeClassRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public GradeClassRelation getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<GradeClassRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countGradeClassRelationIdsByUidAndName(Long uid, String name)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param subjectId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
     */
	public List<Long>  getGradeClassRelationIdsBySubject(Long subjectId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;
	public List<Long>  getGradeClassRelationIdsBySubjectOrderByGradeNameDesc(Long subjectId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getGradeClassRelationIdsByUidAndName(Long uid, String name, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	public List<Long>  getGradeClassRelationIdsByLevel(Long subjectId, Integer level, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
	public Long getGradeClassRelationIdsByGradeName(Long subjectId, Integer gradeName)throws ServiceException, ServiceDaoException;


	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getGradeClassRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countGradeClassRelationIds() throws ServiceException, ServiceDaoException;
	

}

