package com.ptteng.learn.course.model;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "subject")
public class Subject implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 728579523720422400L;

	public static final Integer status_normal = 1;
	public static final Integer status_freeze = 2;

	/**
	 * 难度等级类型
	 * 1--年级
	 * 2--等级
	 */
	public static final Integer GRADE_TYPE_1 = 1;
	public static final Integer GRADE_TYPE_2 = 2;

	/**
	 * 科目类型
	 * 1--自有
	 * 2--校内
	 * 3--合作
	 */
	public static final Integer TYPE_1 = 1;
	public static final Integer TYPE_2 = 2;
	public static final Integer TYPE_3 = 3;
   	 
    private  Long id;
	
  	 
    private  String name;
	
  	 
    private  Integer type;
	
  	 
    private  Integer gradeName;
	
  	 
    private  Integer sort;
	
  	 
    private  Long classId;
	
  	 
    private  Long createBy;
	
  	 
    private  Long updateBy;
	
  	 
    private  Long updateAt;
	
  	 
    private  Long createAt;

	private  Integer gradeType;

	private Integer status=Subject.status_freeze;

//分开展示还是一起展示
	private Integer step=1;
	private String style;
	private Long collaborateId;
	private String  levelInfo;

	private String chineseCode;

	public static final Integer user_type_preschool = 1;
	public static final Integer user_type_primaryschool = 2;
	public static final Integer user_type_both = 3;

	/**
	 * 1、幼升小
	 * 2、小学
	 * 3、兼容
	 */
	private  Integer userType;
		 	
         	 	   @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}

	@Transient
	public String getLevelInfo() {
		return levelInfo;
	}

	public void setLevelInfo(String levelInfo) {
		this.levelInfo = levelInfo;
	}

	@Column(name = "name")
	public String getName() {
		return name;
	}
	
	
	public void setName(String name) {
		this.name = name;
	}
		 	@Column(name = "type")
	public Integer getType() {
		return type;
	}
	
	
	public void setType(Integer type) {
		this.type = type;
	}
		 	@Column(name = "grade_name")
	public Integer getGradeName() {
		return gradeName;
	}
	
	
	public void setGradeName(Integer gradeName) {
		this.gradeName = gradeName;
	}
		 	@Column(name = "sort")
	public Integer getSort() {
		return sort;
	}
	
	
	public void setSort(Integer sort) {
		this.sort = sort;
	}
		 	@Column(name = "class_id")
	public Long getClassId() {
		return classId;
	}
	
	
	public void setClassId(Long classId) {
		this.classId = classId;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}
	@Column(name = "grade_type")
	public Integer getGradeType() {
		return gradeType;
	}

	public void setGradeType(Integer gradeType) {
		this.gradeType = gradeType;
	}
	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}
	@Column(name = "step")
	public Integer getStep() {
		return step;
	}

	public void setStep(Integer step) {
		this.step = step;
	}

	@Column( name = "style")
	public String getStyle() {
		return style;
	}

	public void setStyle(String style) {
		this.style = style;
	}

	@Column( name = "collaborate_id")
	public Long getCollaborateId() {
		return collaborateId;
	}

	public void setCollaborateId(Long collaborateId) {
		this.collaborateId = collaborateId;
	}

	@Column( name = "chinese_code")
	public String getChineseCode() {
		return chineseCode;
	}

	public void setChineseCode(String chineseCode) {
		this.chineseCode = chineseCode;
	}

	@Column( name = "user_type")
	public Integer getUserType() {
		return userType;
	}

	public void setUserType(Integer userType) {
		this.userType = userType;
	}
}

