package com.ptteng.learn.course.service;

import java.util.List;
import java.util.Map;

import com.ptteng.learn.course.model.Book;
import org.osoa.sca.annotations.Remotable;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface BookService extends BaseDaoService {

	



   		   
		
		public Long insert(Book book)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Book> insertList(List<Book> bookList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Book book)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Book> bookList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Book getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Book> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countBookIdsByGradeOrderBySort(Integer grade)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getBookIdsByGradeOrderBySort(Integer grade,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 * @Description 根据教材科目id获取教材id
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/4/5 12:23
	 */
	public List<Long>  getBookIdsBySidBySort(Long sid,Integer start,Integer limit)throws ServiceException, ServiceDaoException;

	/**
	 * @Description 根据版本id获取教材id
	 * @param vid 教材id
	 * @Author: PeiyuFeng
	 * @Time 2017/4/5 12:28
	 */
	public List<Long>  getBookIdsByVersion(Long vid,Integer start,Integer limit)throws ServiceException, ServiceDaoException;

	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getBookIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countBookIds() throws ServiceException, ServiceDaoException;
	

}

