package com.ptteng.learn.course.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "user")
public class User implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 6138135676064095232L;

    public static final Integer allGrade = 7;
    public static final Integer preGrade = 0;


    public static final Integer status_normal = 1;
    public static final Integer status_freeze = 2;

    public static final Integer spend = 1;
    public static final Integer no_spend = 2;

    /**
     * 是否
     * 0--否
     * 1--是
     */
    public static final int IS_NOT_MEMBER = 0;
    public static final int IS_MEMBER = 1;


    private Long id;

    private String pwd;

    private String mobile;

    private String name;

    private String img;

    //年级
    private Integer grade;

    //学期
    private Integer term;

    //学习天数
    private Integer learnTime = 0;

    //完成课时数
    private Integer learnScore = 0;

    //购买资料数
    private Integer learnBuy = 0;

    //获得星星数
    private Integer score = 0;

    public static final Integer SIGN = 1;
    public static final Integer NO_SIGN = 2;
    //当天是否签到
    private Integer sign = 2;

    private Long registerAt;

    private Long lastLoginAt;

    public static final Integer STATUS_ON = 1;
    public static final Integer STATUS_OFF = 2;
    //账号状态
    private Integer status = User.status_normal;

    //输错密码次数
    private Integer wrongCount = 0;

    private Long createBy;

    private Long updateBy;

    private Long updateAt;

    private Long createAt;

    private String mail;

    private String nick;

    private Integer unRead;
    private String deviceToken;
    private String platform;

    private float defeat;
    private String token;

    private String userId;
    private Integer member;
    private Integer recommendFlag;
    private String invitationCode;
    private Long recommendId;
    private Long recommendAt;

    private Integer spendStatus = no_spend;
    private BigDecimal iosAmount = BigDecimal.ZERO;
    private BigDecimal androidAmount = BigDecimal.ZERO;
    private String registerMail;
    private String areaCode;

    /**
     * 当前连续签到次数
     */
    private  Integer consecutive = 0;

    /**
     * 历史最高连续签到次数
     */
    private  Integer signHighest = 0;

    /**
     * 总签到次数
     */
    private  Integer signTotal = 0;

    //用户系统
    private String os;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "recommend_at")
    public Long getRecommendAt() {
        return recommendAt;
    }

    public void setRecommendAt(Long recommendAt) {
        this.recommendAt = recommendAt;
    }

    @Column(name = "recommend_id")
    public Long getRecommendId() {
        return recommendId;
    }

    public void setRecommendId(Long recommendId) {
        this.recommendId = recommendId;
    }

    @Column(name = "recommend_flag")
    public Integer getRecommendFlag() {
        return recommendFlag;
    }

    public void setRecommendFlag(Integer recommendFlag) {
        this.recommendFlag = recommendFlag;
    }


    @Column(name = "invitation_code")
    public String getInvitationCode() {
        return invitationCode;
    }

    public void setInvitationCode(String invitationCode) {
        this.invitationCode = invitationCode;
    }

    @Transient
    public Integer getMember() {
        return member;
    }

    public void setMember(Integer member) {
        this.member = member;
    }


    @Column(name = "token")
    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Column(name = "platform")
    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Column(name = "device_token")
    public String getDeviceToken() {
        return deviceToken;
    }

    public void setDeviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
    }

    @Column(name = "pwd")
    public String getPwd() {
        return pwd;
    }


    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }


    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "img")
    public String getImg() {
        return img;
    }


    public void setImg(String img) {
        this.img = img;
    }

    @Column(name = "grade")
    public Integer getGrade() {
        return grade;
    }


    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    @Column(name = "term")
    public Integer getTerm() {
        return term;
    }


    public void setTerm(Integer term) {
        this.term = term;
    }

    @Column(name = "learn_time")
    public Integer getLearnTime() {
        return learnTime;
    }


    public void setLearnTime(Integer learnTime) {
        this.learnTime = learnTime;
    }

    @Column(name = "learn_score")
    public Integer getLearnScore() {
        return learnScore;
    }


    public void setLearnScore(Integer learnScore) {
        this.learnScore = learnScore;
    }

    @Column(name = "learn_buy")
    public Integer getLearnBuy() {
        return learnBuy;
    }


    public void setLearnBuy(Integer learnBuy) {
        this.learnBuy = learnBuy;
    }

    @Column(name = "score")
    public Integer getScore() {
        return score;
    }


    public void setScore(Integer score) {
        this.score = score;
    }

    @Column(name = "sign")
    public Integer getSign() {
        return sign;
    }

    public void setSign(Integer sign) {
        this.sign = sign;
    }

    @Column(name = "register_at")
    public Long getRegisterAt() {
        return registerAt;
    }


    public void setRegisterAt(Long registerAt) {
        this.registerAt = registerAt;
    }

    @Column(name = "last_login_at")
    public Long getLastLoginAt() {
        return lastLoginAt;
    }


    public void setLastLoginAt(Long lastLoginAt) {
        this.lastLoginAt = lastLoginAt;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "wrong_count")
    public Integer getWrongCount() {
        return wrongCount;
    }


    public void setWrongCount(Integer wrongCount) {
        this.wrongCount = wrongCount;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "mail")
    public String getMail() {
        return mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }


    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

    @Column(name = "nick")
    public String getNick() {
        return nick;
    }

    public void setNick(String nick) {
        this.nick = nick;
    }

    @Column(name = "spend_status")
    public Integer getSpendStatus() {
        return spendStatus;
    }

    public void setSpendStatus(Integer spendStatus) {
        this.spendStatus = spendStatus;
    }

    @Column(name = "ios_amount")
    public BigDecimal getIosAmount() {
        return iosAmount;
    }

    public void setIosAmount(BigDecimal iosAmount) {
        this.iosAmount = iosAmount;
    }

    @Column(name = "android_amount")
    public BigDecimal getAndroidAmount() {
        return androidAmount;
    }

    public void setAndroidAmount(BigDecimal androidAmount) {
        this.androidAmount = androidAmount;
    }

    @Column(name = "register_mail")
    public String getRegisterMail() {
        return registerMail;
    }

    public void setRegisterMail(String registerMail) {
        this.registerMail = registerMail;
    }

    @Column(name = "area_code")
    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    @Transient
    public Integer getUnRead() {
        return unRead;
    }

    public void setUnRead(Integer unRead) {
        this.unRead = unRead;
    }

    @Transient
    public float getDefeat() {
        return defeat;
    }

    public void setDefeat(float defeat) {
        this.defeat = defeat;
    }


    @Column(name = "user_id")

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Column(name = "consecutive")
    public Integer getConsecutive() {
        return consecutive;
    }

    public void setConsecutive(Integer consecutive) {
        this.consecutive = consecutive;
    }

    @Column(name = "sign_highest")
    public Integer getSignHighest() {
        return signHighest;
    }

    public void setSignHighest(Integer signHighest) {
        this.signHighest = signHighest;
    }

    @Column(name = "sign_total")
    public Integer getSignTotal() {
        return signTotal;
    }

    public void setSignTotal(Integer signTotal) {
        this.signTotal = signTotal;
    }

    @Transient
    public String getOs() {
        return os;
    }

    public void setOs(String os) {
        this.os = os;
    }
}

