package com.ptteng.learn.course.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.learn.course.model.DictationNote;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface DictationNoteService extends BaseDaoService {

	



   		   
		
		public Long insert(DictationNote dictationNote)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<DictationNote> insertList(List<DictationNote> dictationNoteList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(DictationNote dictationNote)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<DictationNote> dictationNoteList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public DictationNote getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<DictationNote> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;




	/**
	 * @Description 根据用户id与科目id获取听写分组
	 * @Author: PeiyuFeng
	 * @param
	 * @Time 2017/5/22 11:59
	 */
	public List<Long> getDictationNoteIdsByUidAndSid(Long uid, Long sid) throws ServiceException, ServiceDaoException;



	/**
	 * @Description 根据用户id、科目id、名称获取分组
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/23 10:56
	 */
	public Long getDictationNoteIdsByUidAndSidAndName(Long uid, Long sid, String name) throws ServiceException, ServiceDaoException;



	/**
	 * @Description 获取用户默认分组
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/23 14:33
	 */
	public Long getDefaultDictationNoteIdByUidAndSid(Long uid, Long sid) throws ServiceException, ServiceDaoException;
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getDictationNoteIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countDictationNoteIds() throws ServiceException, ServiceDaoException;
	

}

