/**
 * 
 */
package com.ptteng.sca.learn.course.client;

import java.util.List;
import java.util.Map;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.learn.course.model.Book;
import com.ptteng.learn.course.service.BookService;

public class BookSCAClient implements BookService {

    private BookService bookService;

	public BookService getBookService() {
		return bookService;
	}
	
	
	public void setBookService(BookService bookService) {
		this.bookService =bookService;
	}
	
	
			   
		@Override
		public Long insert(Book book)throws ServiceException, ServiceDaoException{
		
		return bookService.insert(book);
		          
		
		}	
		  
    	   
		@Override
		public List<Book> insertList(List<Book> bookList)throws ServiceException, ServiceDaoException{
		
		return bookService.insertList(bookList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return bookService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Book book)throws ServiceException, ServiceDaoException{
		
		return bookService.update(book);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Book> bookList)throws ServiceException, ServiceDaoException{
		
		return bookService.updateList(bookList);
		          
		
		}	
		  
    	   
		@Override
		public Book getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return bookService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Book> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return bookService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getBookIdsByGradeOrderBySort(Integer grade,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return bookService.getBookIdsByGradeOrderBySort(grade,start,limit);
	
	
	}

	@Override
	public List<Long> getBookIdsBySidBySort(Long sid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return bookService.getBookIdsBySidBySort(sid, start, limit);
	}

	@Override
	public List<Long> getBookIdsByVersion(Long vid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return bookService.getBookIdsByVersion(vid, start, limit);
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countBookIdsByGradeOrderBySort(Integer grade)throws ServiceException, ServiceDaoException{
		
		return bookService.countBookIdsByGradeOrderBySort(grade);
	
	
	}
	
		
	
		@Override
	public List<Long> getBookIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return bookService.getBookIds(start, limit);
	}

	@Override
	public Integer countBookIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return bookService.countBookIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return bookService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return bookService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   bookService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.bookService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

