package com.ptteng.learn.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.learn.course.model.UserDsubjectRelation;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface UserDsubjectRelationService extends BaseDaoService {

	



   		   
		
		public Long insert(UserDsubjectRelation userDsubjectRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<UserDsubjectRelation> insertList(List<UserDsubjectRelation> userDsubjectRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(UserDsubjectRelation userDsubjectRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<UserDsubjectRelation> userDsubjectRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public UserDsubjectRelation getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<UserDsubjectRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;




	/**
	 * @Description 根据用户id与科目id获取关系id
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/27 14:02
	 */
	public Long getUserDsubjectRelationIdsByUidAndSid(Long uid, Long sid) throws ServiceException, ServiceDaoException;



	/**
	 * @Description 根据用户id获取所有关系id
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/6/2 11:10
	 */
	public List<Long> getUserDsubjectRelationIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getUserDsubjectRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countUserDsubjectRelationIds() throws ServiceException, ServiceDaoException;
	

}

