package com.ptteng.learn.course.service;

import java.util.List;
import java.util.Map;

import com.ptteng.learn.course.model.Paper;
import org.osoa.sca.annotations.Remotable;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface PaperService extends BaseDaoService {

	



   		   
		
		public Long insert(Paper paper)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Paper> insertList(List<Paper> paperList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Paper paper)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Paper> paperList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Paper getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Paper> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


				
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getPaperIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long getPaperIdByPeriodId(Long periodId) throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public String getPaperPriceByPeriodId(Long periodId) throws ServiceException, ServiceDaoException;


	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countPaperIds() throws ServiceException, ServiceDaoException;
	

}

